#!/bin/sh
# file: nios2_sdk_shell_bashrc
#
# 2004.03.15 dvb
#
# +------------------------------------------------
# | This is the Nios II Kit SDK Shell rc file
# |
# | It calls the standard SOPC Builder rc file, first, and
# | then patches a few things up to do with replicated
# | scripts and revisions, so that the ones provided
# | with Nios II take precedence.
# |

# |
# | call the SOPC Builder standard script
# |

. $QUARTUS_ROOTDIR/sopc_builder/bin/nios_bash

# |
# | Alias things we like very much
# |

alias nb=nios2-build
alias nios-build=nios2-build
alias nr=nios2-run
alias nios-run=nios2-run
alias nd=nios2-debug
alias nios-debug=nios2-debug
alias nc=nios2-console
alias nios-console=nios2-console

$(QUARTUS)/bin/perl/bin/perl -I$sopc_builder/bin -I$sopc_builder/bin/perl_lib -I$sopc_builder/bin/europa $sopc_builder/bin/ptf_update.pl nios2_cpu.ptf 

$(QUARTUS)/bin/perl/bin/perl -I$sopc_builder/bin -I$sopc_builder/bin/perl_lib -I$sopc_builder/bin/europa $sopc_builder/bin/mk_systembus.pl --sopc_directory=$sopc_builder --sopc_perl=$(QUARTUS)/bin/perl --sopc_lib_path="$(WORKING_FOLDER)+$(NIOS2_KIT)/components+$(NIOS2_KIT)+$(QUARTUS)/sopc_builder/components+$(NIOS2_KIT)/components" --target_module_name=nios2_cpu --system_directory=$(WORKING_FOLDER) --system_name=nios2_cpu --project_name= --sopc_quartus_dir=$(QUARTUS) $1

# End of file
