-------------------------------------------------------------------------------
-- microblaze_0_wrapper.vhd
-------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

library microblaze_v4_00_a;                                                     -- Remove If EDK 9.1 or Higher
use microblaze_v4_00_a.all;                                                     -- Remove If EDK 9.1 or Higher

library microblaze_v6_00_b;                                                     -- Remove If EDK 7.1
use microblaze_v6_00_b.All;                                                     -- Remove If EDK 7.1

entity microblaze_0_wrapper is
  port (
    CLK : in std_logic;
    RESET : in std_logic;
    INTERRUPT : in std_logic;
    DEBUG_RST : in std_logic;
    EXT_BRK : in std_logic;
    EXT_NM_BRK : in std_logic;
    DBG_STOP : in std_logic;
    MB_Halted : out std_logic;                                                  -- Remove If EDK 7.1
    INSTR : in std_logic_vector(0 to 31);
    I_ADDRTAG : out std_logic_vector(0 to 3);
    IREADY : in std_logic;
    IWAIT : in std_logic;
    INSTR_ADDR : out std_logic_vector(0 to 31);
    IFETCH : out std_logic;
    I_AS : out std_logic;
    DATA_READ : in std_logic_vector(0 to 31);
    DREADY : in std_logic;
    DWAIT : in std_logic;
    DATA_WRITE : out std_logic_vector(0 to 31);
    DATA_ADDR : out std_logic_vector(0 to 31);
    D_ADDRTAG : out std_logic_vector(0 to 3);
    D_AS : out std_logic;
    READ_STROBE : out std_logic;
    WRITE_STROBE : out std_logic;
    BYTE_ENABLE : out std_logic_vector(0 to 3);
    DM_ABUS : out std_logic_vector(0 to 31);
    DM_BE : out std_logic_vector(0 to 3);
    DM_BUSLOCK : out std_logic;
    DM_DBUS : out std_logic_vector(0 to 31);
    DM_REQUEST : out std_logic;
    DM_RNW : out std_logic;
    DM_SELECT : out std_logic;
    DM_SEQADDR : out std_logic;
    DOPB_DBUS : in std_logic_vector(0 to 31);
    DOPB_ERRACK : in std_logic;
    DOPB_MGRANT : in std_logic;
    DOPB_RETRY : in std_logic;
    DOPB_TIMEOUT : in std_logic;
    DOPB_XFERACK : in std_logic;
    IM_ABUS : out std_logic_vector(0 to 31);
    IM_BE : out std_logic_vector(0 to 3);
    IM_BUSLOCK : out std_logic;
    IM_DBUS : out std_logic_vector(0 to 31);
    IM_REQUEST : out std_logic;
    IM_RNW : out std_logic;
    IM_SELECT : out std_logic;
    IM_SEQADDR : out std_logic;
    IOPB_DBUS : in std_logic_vector(0 to 31);
    IOPB_ERRACK : in std_logic;
    IOPB_MGRANT : in std_logic;
    IOPB_RETRY : in std_logic;
    IOPB_TIMEOUT : in std_logic;
    IOPB_XFERACK : in std_logic;
    DBG_CLK : in std_logic;
    DBG_TDI : in std_logic;
    DBG_TDO : out std_logic;
    DBG_REG_EN : in std_logic_vector(0 to 4);
    DBG_CAPTURE : in std_logic;
    DBG_UPDATE : in std_logic;
    VALID_INSTR : out std_logic;                                                -- Remove If EDK 9.1 or Higher
    PC_EX : out std_logic_vector(0 to 31);                                      -- Remove If EDK 9.1 or Higher
    REG_WRITE : out std_logic;                                                  -- Remove If EDK 9.1 or Higher
    REG_ADDR : out std_logic_vector(0 to 4);                                    -- Remove If EDK 9.1 or Higher
    MSR_REG : out std_logic_vector(0 to 9);                                     -- Remove If EDK 9.1 or Higher
    NEW_REG_VALUE : out std_logic_vector(0 to 31);                              -- Remove If EDK 9.1 or Higher
    PIPE_RUNNING : out std_logic;                                               -- Remove If EDK 9.1 or Higher
    INTERRUPT_TAKEN : out std_logic;                                            -- Remove If EDK 9.1 or Higher
    JUMP_TAKEN : out std_logic;                                                 -- Remove If EDK 9.1 or Higher
    PREFETCH_ADDR : out std_logic_vector(0 to 3);                               -- Remove If EDK 9.1 or Higher
    MB_Halted : out std_logic;                                                  -- Remove If EDK 9.1 or Higher
    Trace_Branch_Instr : out std_logic;                                         -- Remove If EDK 9.1 or Higher
    Trace_Valid_Instr : out std_logic;                                          -- Remove If EDK 7.1
    Trace_Instruction : out std_logic_vector(0 to 31);                          -- Remove If EDK 7.1
    Trace_PC : out std_logic_vector(0 to 31);                                   -- Remove If EDK 7.1
    Trace_Reg_Write : out std_logic;                                            -- Remove If EDK 7.1
    Trace_Reg_Addr : out std_logic_vector(0 to 4);                              -- Remove If EDK 7.1
    Trace_MSR_Reg : out std_logic_vector(0 to 10);                              -- Remove If EDK 7.1
    Trace_New_Reg_Value : out std_logic_vector(0 to 31);                        -- Remove If EDK 7.1
    Trace_Exception_Taken : out std_logic;                                      -- Remove If EDK 7.1
    Trace_Exception_Kind : out std_logic_vector(0 to 3);                        -- Remove If EDK 7.1
    Trace_Jump_Taken : out std_logic;                                           -- Remove If EDK 7.1
    Trace_Delay_Slot : out std_logic;
    Trace_Data_Address : out std_logic_vector(0 to 31);
    Trace_AS : out std_logic;                                                   -- Remove If EDK 9.1 or Higher
    Trace_Data_Access : out std_logic;                                          -- Remove If EDK 7.1
    Trace_Data_Read : out std_logic;
    Trace_Data_Write : out std_logic;
    Trace_Data_Write_Value : out std_logic_vector(0 to 31);                     -- Remove If EDK 7.1
    Trace_Data_Byte_Enable : out std_logic_vector(0 to 3);                      -- Remove If EDK 7.1
    Trace_DCache_Req : out std_logic;
    Trace_DCache_Hit : out std_logic;
    Trace_ICache_Req : out std_logic;
    Trace_ICache_Hit : out std_logic;
    Trace_Instr_EX : out std_logic_vector(0 to 31);                             -- Remove If EDK 9.1 or Higher
    Trace_OF_PipeRun : out std_logic;                                           -- Remove If EDK 7.1
    Trace_EX_PipeRun : out std_logic;                                           -- Remove If EDK 7.1
    Trace_MEM_PipeRun : out std_logic;                                          -- Remove If EDK 7.1
    FSL0_S_CLK : out std_logic;
    FSL0_S_READ : out std_logic;
    FSL0_S_DATA : in std_logic_vector(0 to 31);
    FSL0_S_CONTROL : in std_logic;
    FSL0_S_EXISTS : in std_logic;
    FSL0_M_CLK : out std_logic;
    FSL0_M_WRITE : out std_logic;
    FSL0_M_DATA : out std_logic_vector(0 to 31);
    FSL0_M_CONTROL : out std_logic;
    FSL0_M_FULL : in std_logic;
    FSL1_S_CLK : out std_logic;
    FSL1_S_READ : out std_logic;
    FSL1_S_DATA : in std_logic_vector(0 to 31);
    FSL1_S_CONTROL : in std_logic;
    FSL1_S_EXISTS : in std_logic;
    FSL1_M_CLK : out std_logic;
    FSL1_M_WRITE : out std_logic;
    FSL1_M_DATA : out std_logic_vector(0 to 31);
    FSL1_M_CONTROL : out std_logic;
    FSL1_M_FULL : in std_logic;
    FSL2_S_CLK : out std_logic;
    FSL2_S_READ : out std_logic;
    FSL2_S_DATA : in std_logic_vector(0 to 31);
    FSL2_S_CONTROL : in std_logic;
    FSL2_S_EXISTS : in std_logic;
    FSL2_M_CLK : out std_logic;
    FSL2_M_WRITE : out std_logic;
    FSL2_M_DATA : out std_logic_vector(0 to 31);
    FSL2_M_CONTROL : out std_logic;
    FSL2_M_FULL : in std_logic;
    FSL3_S_CLK : out std_logic;
    FSL3_S_READ : out std_logic;
    FSL3_S_DATA : in std_logic_vector(0 to 31);
    FSL3_S_CONTROL : in std_logic;
    FSL3_S_EXISTS : in std_logic;
    FSL3_M_CLK : out std_logic;
    FSL3_M_WRITE : out std_logic;
    FSL3_M_DATA : out std_logic_vector(0 to 31);
    FSL3_M_CONTROL : out std_logic;
    FSL3_M_FULL : in std_logic;
    FSL4_S_CLK : out std_logic;
    FSL4_S_READ : out std_logic;
    FSL4_S_DATA : in std_logic_vector(0 to 31);
    FSL4_S_CONTROL : in std_logic;
    FSL4_S_EXISTS : in std_logic;
    FSL4_M_CLK : out std_logic;
    FSL4_M_WRITE : out std_logic;
    FSL4_M_DATA : out std_logic_vector(0 to 31);
    FSL4_M_CONTROL : out std_logic;
    FSL4_M_FULL : in std_logic;
    FSL5_S_CLK : out std_logic;
    FSL5_S_READ : out std_logic;
    FSL5_S_DATA : in std_logic_vector(0 to 31);
    FSL5_S_CONTROL : in std_logic;
    FSL5_S_EXISTS : in std_logic;
    FSL5_M_CLK : out std_logic;
    FSL5_M_WRITE : out std_logic;
    FSL5_M_DATA : out std_logic_vector(0 to 31);
    FSL5_M_CONTROL : out std_logic;
    FSL5_M_FULL : in std_logic;
    FSL6_S_CLK : out std_logic;
    FSL6_S_READ : out std_logic;
    FSL6_S_DATA : in std_logic_vector(0 to 31);
    FSL6_S_CONTROL : in std_logic;
    FSL6_S_EXISTS : in std_logic;
    FSL6_M_CLK : out std_logic;
    FSL6_M_WRITE : out std_logic;
    FSL6_M_DATA : out std_logic_vector(0 to 31);
    FSL6_M_CONTROL : out std_logic;
    FSL6_M_FULL : in std_logic;
    FSL7_S_CLK : out std_logic;
    FSL7_S_READ : out std_logic;
    FSL7_S_DATA : in std_logic_vector(0 to 31);
    FSL7_S_CONTROL : in std_logic;
    FSL7_S_EXISTS : in std_logic;
    FSL7_M_CLK : out std_logic;
    FSL7_M_WRITE : out std_logic;
    FSL7_M_DATA : out std_logic_vector(0 to 31);
    FSL7_M_CONTROL : out std_logic;
    FSL7_M_FULL : in std_logic;
    ICACHE_FSL_IN_CLK : out std_logic;
    ICACHE_FSL_IN_READ : out std_logic;
    ICACHE_FSL_IN_DATA : in std_logic_vector(0 to 31);
    ICACHE_FSL_IN_CONTROL : in std_logic;
    ICACHE_FSL_IN_EXISTS : in std_logic;
    ICACHE_FSL_OUT_CLK : out std_logic;
    ICACHE_FSL_OUT_WRITE : out std_logic;
    ICACHE_FSL_OUT_DATA : out std_logic_vector(0 to 31);
    ICACHE_FSL_OUT_CONTROL : out std_logic;
    ICACHE_FSL_OUT_FULL : in std_logic;
    DCACHE_FSL_IN_CLK : out std_logic;
    DCACHE_FSL_IN_READ : out std_logic;
    DCACHE_FSL_IN_DATA : in std_logic_vector(0 to 31);
    DCACHE_FSL_IN_CONTROL : in std_logic;
    DCACHE_FSL_IN_EXISTS : in std_logic;
    DCACHE_FSL_OUT_CLK : out std_logic;
    DCACHE_FSL_OUT_WRITE : out std_logic;
    DCACHE_FSL_OUT_DATA : out std_logic_vector(0 to 31);
    DCACHE_FSL_OUT_CONTROL : out std_logic;
    DCACHE_FSL_OUT_FULL : in std_logic
  );

  attribute x_core_info : STRING;                                                        -- Remove If EDK 9.1 or Higher
  attribute x_core_info of microblaze_0_wrapper: entity is "microblaze_v4_00_a";         -- Remove If EDK 9.1 or Higher

end microblaze_0_wrapper;

architecture STRUCTURE of microblaze_0_wrapper is

  component microblaze is
    generic (
      C_SCO : integer;                                                                   -- Remove If EDK 7.1
      C_DATA_SIZE : integer;                                                             -- Remove If EDK 7.1
      C_DYNAMIC_BUS_SIZING : integer;                                                    -- Remove If EDK 7.1
      C_FAMILY : string;
      C_INSTANCE : string;
      C_AREA_OPTIMIZED : integer;                                                        -- Remove If EDK 7.1
      C_D_OPB : integer;
      C_D_LMB : integer;
      C_I_OPB : integer;
      C_I_LMB : integer;
      C_USE_MSR_INSTR : integer;                                                         -- Remove If EDK 7.1
      C_USE_PCMP_INSTR : integer;                                                        -- Remove If EDK 7.1
      C_USE_BARREL : integer;
      C_USE_DIV : integer;
      C_USE_HW_MUL : integer;
      C_USE_FPU : integer;   
      C_USE_MSR_INSTR : integer;                                                         -- Remove If EDK 9.1 or Higher
      C_USE_PCMP_INSTR : integer;                                                        -- Remove If EDK 9.1 or Higher
      C_UNALIGNED_EXCEPTIONS : integer;
      C_ILL_OPCODE_EXCEPTION : integer;
      C_IOPB_BUS_EXCEPTION : integer;
      C_DOPB_BUS_EXCEPTION : integer;
      C_DIV_ZERO_EXCEPTION : integer;
      C_FPU_EXCEPTION : integer;
      C_PVR : integer;                                                                   -- Remove If EDK 7.1
      C_PVR_USER1 : std_logic_vector(0 to 7);                                            -- Remove If EDK 7.1
      C_PVR_USER2 : std_logic_vector(0 to 31);                                           -- Remove If EDK 7.1
      C_DEBUG_ENABLED : integer;
      C_NUMBER_OF_PC_BRK : integer;
      C_NUMBER_OF_RD_ADDR_BRK : integer;
      C_NUMBER_OF_WR_ADDR_BRK : integer;
      C_INTERRUPT_IS_EDGE : integer;
      C_EDGE_IS_POSITIVE : integer;
      C_RESET_MSR : std_logic_vector;                                                    -- Remove If EDK 7.1
      C_OPCODE_0x0_ILLEGAL : integer;                                                    -- Remove If EDK 7.1
      C_FSL_LINKS : integer;
      C_FSL_DATA_SIZE : integer;
      C_ICACHE_BASEADDR : std_logic_vector;
      C_ICACHE_HIGHADDR : std_logic_vector;
      C_USE_ICACHE : integer;
      C_ALLOW_ICACHE_WR : integer;
      C_ADDR_TAG_BITS : integer;
      C_CACHE_BYTE_SIZE : integer;
      C_ICACHE_USE_FSL : integer;
      C_ICACHE_LINE_LEN : integer;                                                       -- Remove If EDK 7.1
      C_DCACHE_BASEADDR : std_logic_vector;
      C_DCACHE_HIGHADDR : std_logic_vector;
      C_USE_DCACHE : integer;
      C_ALLOW_DCACHE_WR : integer;
      C_DCACHE_ADDR_TAG : integer;
      C_DCACHE_BYTE_SIZE : integer;
      C_DCACHE_USE_FSL : integer;                                                        -- Remove If EDK 7.1
      C_DCACHE_USE_FSL : integer                                                         -- Remove If EDK 9.1 or Higher
      C_DCACHE_LINE_LEN : integer                                                        -- Remove If EDK 7.1
    );
    port (
      CLK : in std_logic;
      RESET : in std_logic;
      INTERRUPT : in std_logic;
      DEBUG_RST : in std_logic;
      EXT_BRK : in std_logic;
      EXT_NM_BRK : in std_logic;
      DBG_STOP : in std_logic;
      MB_Halted : out std_logic;                                                         -- Remove If EDK 7.1
      INSTR : in std_logic_vector(0 to 31);
      I_ADDRTAG : out std_logic_vector(0 to 3);
      IREADY : in std_logic;
      IWAIT : in std_logic;
      INSTR_ADDR : out std_logic_vector(0 to 31);
      IFETCH : out std_logic;
      I_AS : out std_logic;
      DATA_READ : in std_logic_vector(0 to 31);
      DREADY : in std_logic;
      DWAIT : in std_logic;
      DATA_WRITE : out std_logic_vector(0 to 31);
      DATA_ADDR : out std_logic_vector(0 to 31);
      D_ADDRTAG : out std_logic_vector(0 to 3);
      D_AS : out std_logic;
      READ_STROBE : out std_logic;
      WRITE_STROBE : out std_logic;
      BYTE_ENABLE : out std_logic_vector(0 to 3);
      DM_ABUS : out std_logic_vector(0 to 31);
      DM_BE : out std_logic_vector(0 to 3);
      DM_BUSLOCK : out std_logic;
      DM_DBUS : out std_logic_vector(0 to 31);
      DM_REQUEST : out std_logic;
      DM_RNW : out std_logic;
      DM_SELECT : out std_logic;
      DM_SEQADDR : out std_logic;
      DOPB_DBUS : in std_logic_vector(0 to 31);
      DOPB_ERRACK : in std_logic;
      DOPB_MGRANT : in std_logic;
      DOPB_RETRY : in std_logic;
      DOPB_TIMEOUT : in std_logic;
      DOPB_XFERACK : in std_logic;
      IM_ABUS : out std_logic_vector(0 to 31);
      IM_BE : out std_logic_vector(0 to 3);
      IM_BUSLOCK : out std_logic;
      IM_DBUS : out std_logic_vector(0 to 31);
      IM_REQUEST : out std_logic;
      IM_RNW : out std_logic;
      IM_SELECT : out std_logic;
      IM_SEQADDR : out std_logic;
      IOPB_DBUS : in std_logic_vector(0 to 31);
      IOPB_ERRACK : in std_logic;
      IOPB_MGRANT : in std_logic;
      IOPB_RETRY : in std_logic;
      IOPB_TIMEOUT : in std_logic;
      IOPB_XFERACK : in std_logic;
      DBG_CLK : in std_logic;
      DBG_TDI : in std_logic;
      DBG_TDO : out std_logic;
      DBG_REG_EN : in std_logic_vector(0 to 4);
      DBG_CAPTURE : in std_logic;
      DBG_UPDATE : in std_logic;
      VALID_INSTR : out std_logic;                                                       -- Remove If EDK 9.1 or Higher
      PC_EX : out std_logic_vector(0 to 31);                                             -- Remove If EDK 9.1 or Higher
      REG_WRITE : out std_logic;                                                         -- Remove If EDK 9.1 or Higher
      REG_ADDR : out std_logic_vector(0 to 4);                                           -- Remove If EDK 9.1 or Higher
      MSR_REG : out std_logic_vector(0 to 9);                                            -- Remove If EDK 9.1 or Higher
      NEW_REG_VALUE : out std_logic_vector(0 to 31);                                     -- Remove If EDK 9.1 or Higher
      PIPE_RUNNING : out std_logic;                                                      -- Remove If EDK 9.1 or Higher
      INTERRUPT_TAKEN : out std_logic;                                                   -- Remove If EDK 9.1 or Higher
      JUMP_TAKEN : out std_logic;                                                        -- Remove If EDK 9.1 or Higher
      PREFETCH_ADDR : out std_logic_vector(0 to 3);                                      -- Remove If EDK 9.1 or Higher
      MB_Halted : out std_logic;                                                         -- Remove If EDK 9.1 or Higher
      Trace_Branch_Instr : out std_logic;                                                -- Remove If EDK 9.1 or Higher
      Trace_Instruction : out std_logic_vector(0 to 31);                                 -- Remove If EDK 7.1
      Trace_Valid_Instr : out std_logic;                                                 -- Remove If EDK 7.1
      Trace_PC : out std_logic_vector(0 to 31);                                          -- Remove If EDK 7.1
      Trace_Reg_Write : out std_logic;                                                   -- Remove If EDK 7.1
      Trace_Reg_Addr : out std_logic_vector(0 to 4);                                     -- Remove If EDK 7.1
      Trace_MSR_Reg : out std_logic_vector(0 to 10);                                     -- Remove If EDK 7.1
      Trace_New_Reg_Value : out std_logic_vector(0 to 31);                               -- Remove If EDK 7.1
      Trace_Exception_Taken : out std_logic;                                             -- Remove If EDK 7.1
      Trace_Exception_Kind : out std_logic_vector(0 to 3);                               -- Remove If EDK 7.1
      Trace_Jump_Taken : out std_logic;                                                  -- Remove If EDK 7.1
      Trace_Delay_Slot : out std_logic;
      Trace_Data_Address : out std_logic_vector(0 to 31);
      Trace_AS : out std_logic;                                                          -- Remove If EDK 9.1 or Higher
      Trace_Data_Access : out std_logic;                                                 -- Remove If EDK 7.1
      Trace_Data_Read : out std_logic;
      Trace_Data_Write : out std_logic;
      Trace_Data_Write_Value : out std_logic_vector(0 to 31);                            -- Remove If EDK 7.1
      Trace_Data_Byte_Enable : out std_logic_vector(0 to 3);                             -- Remove If EDK 7.1
      Trace_DCache_Req : out std_logic;
      Trace_DCache_Hit : out std_logic;
      Trace_ICache_Req : out std_logic;
      Trace_ICache_Hit : out std_logic;
      Trace_Instr_EX : out std_logic_vector(0 to 31);                                    -- Remove If EDK 9.1 or Higher
      Trace_OF_PipeRun : out std_logic;                                                  -- Remove If EDK 7.1
      Trace_EX_PipeRun : out std_logic;                                                  -- Remove If EDK 7.1
      Trace_MEM_PipeRun : out std_logic;                                                 -- Remove If EDK 7.1
      FSL0_S_CLK : out std_logic;
      FSL0_S_READ : out std_logic;
      FSL0_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL0_S_CONTROL : in std_logic;
      FSL0_S_EXISTS : in std_logic;
      FSL0_M_CLK : out std_logic;
      FSL0_M_WRITE : out std_logic;
      FSL0_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL0_M_CONTROL : out std_logic;
      FSL0_M_FULL : in std_logic;
      FSL1_S_CLK : out std_logic;
      FSL1_S_READ : out std_logic;
      FSL1_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL1_S_CONTROL : in std_logic;
      FSL1_S_EXISTS : in std_logic;
      FSL1_M_CLK : out std_logic;
      FSL1_M_WRITE : out std_logic;
      FSL1_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL1_M_CONTROL : out std_logic;
      FSL1_M_FULL : in std_logic;
      FSL2_S_CLK : out std_logic;
      FSL2_S_READ : out std_logic;
      FSL2_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL2_S_CONTROL : in std_logic;
      FSL2_S_EXISTS : in std_logic;
      FSL2_M_CLK : out std_logic;
      FSL2_M_WRITE : out std_logic;
      FSL2_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL2_M_CONTROL : out std_logic;
      FSL2_M_FULL : in std_logic;
      FSL3_S_CLK : out std_logic;
      FSL3_S_READ : out std_logic;
      FSL3_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL3_S_CONTROL : in std_logic;
      FSL3_S_EXISTS : in std_logic;
      FSL3_M_CLK : out std_logic;
      FSL3_M_WRITE : out std_logic;
      FSL3_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL3_M_CONTROL : out std_logic;
      FSL3_M_FULL : in std_logic;
      FSL4_S_CLK : out std_logic;
      FSL4_S_READ : out std_logic;
      FSL4_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL4_S_CONTROL : in std_logic;
      FSL4_S_EXISTS : in std_logic;
      FSL4_M_CLK : out std_logic;
      FSL4_M_WRITE : out std_logic;
      FSL4_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL4_M_CONTROL : out std_logic;
      FSL4_M_FULL : in std_logic;
      FSL5_S_CLK : out std_logic;
      FSL5_S_READ : out std_logic;
      FSL5_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL5_S_CONTROL : in std_logic;
      FSL5_S_EXISTS : in std_logic;
      FSL5_M_CLK : out std_logic;
      FSL5_M_WRITE : out std_logic;
      FSL5_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL5_M_CONTROL : out std_logic;
      FSL5_M_FULL : in std_logic;
      FSL6_S_CLK : out std_logic;
      FSL6_S_READ : out std_logic;
      FSL6_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL6_S_CONTROL : in std_logic;
      FSL6_S_EXISTS : in std_logic;
      FSL6_M_CLK : out std_logic;
      FSL6_M_WRITE : out std_logic;
      FSL6_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL6_M_CONTROL : out std_logic;
      FSL6_M_FULL : in std_logic;
      FSL7_S_CLK : out std_logic;
      FSL7_S_READ : out std_logic;
      FSL7_S_DATA : in std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL7_S_CONTROL : in std_logic;
      FSL7_S_EXISTS : in std_logic;
      FSL7_M_CLK : out std_logic;
      FSL7_M_WRITE : out std_logic;
      FSL7_M_DATA : out std_logic_vector(0 to C_FSL_DATA_SIZE-1);
      FSL7_M_CONTROL : out std_logic;
      FSL7_M_FULL : in std_logic;
      ICACHE_FSL_IN_CLK : out std_logic;
      ICACHE_FSL_IN_READ : out std_logic;
      ICACHE_FSL_IN_DATA : in std_logic_vector(0 to 31);
      ICACHE_FSL_IN_CONTROL : in std_logic;
      ICACHE_FSL_IN_EXISTS : in std_logic;
      ICACHE_FSL_OUT_CLK : out std_logic;
      ICACHE_FSL_OUT_WRITE : out std_logic;
      ICACHE_FSL_OUT_DATA : out std_logic_vector(0 to 31);
      ICACHE_FSL_OUT_CONTROL : out std_logic;
      ICACHE_FSL_OUT_FULL : in std_logic;
      DCACHE_FSL_IN_CLK : out std_logic;
      DCACHE_FSL_IN_READ : out std_logic;
      DCACHE_FSL_IN_DATA : in std_logic_vector(0 to 31);
      DCACHE_FSL_IN_CONTROL : in std_logic;
      DCACHE_FSL_IN_EXISTS : in std_logic;
      DCACHE_FSL_OUT_CLK : out std_logic;
      DCACHE_FSL_OUT_WRITE : out std_logic;
      DCACHE_FSL_OUT_DATA : out std_logic_vector(0 to 31);
      DCACHE_FSL_OUT_CONTROL : out std_logic;
      DCACHE_FSL_OUT_FULL : in std_logic
    );
  end component;

  attribute x_core_info : STRING;                                                        -- Remove If EDK 7.1
  attribute x_core_info of microblaze : component is "microblaze_v6_00_b";               -- Remove If EDK 7.1

begin

  microblaze_0 : microblaze
    generic map (
      C_SCO => 0,                                                                        -- Remove If EDK 7.1
      C_DATA_SIZE => 32,                                                                 -- Remove If EDK 7.1
      C_DYNAMIC_BUS_SIZING => 1,                                                         -- Remove If EDK 7.1
      C_FAMILY => "$(FAMILY)",
      C_INSTANCE => "microblaze_0",
      C_AREA_OPTIMIZED => 1,                                                             -- Remove If EDK 7.1
      C_D_OPB => 1,
      C_D_LMB => 1,
      C_I_OPB => 1,
      C_I_LMB => 1,
      C_USE_BARREL => $(USE_BARREL),
      C_USE_DIV => $(USE_DIV),
      C_USE_HW_MUL => $(USE_HW_MUL),
      C_USE_FPU => $(USE_FPU),
      C_USE_MSR_INSTR => $(MSR_INSTR),
      C_USE_PCMP_INSTR => $(USE_PCMP_INSTR),
      C_UNALIGNED_EXCEPTIONS => 0,
      C_ILL_OPCODE_EXCEPTION => 0,
      C_IOPB_BUS_EXCEPTION => 0,
      C_DOPB_BUS_EXCEPTION => 0,
      C_DIV_ZERO_EXCEPTION => 0,
      C_FPU_EXCEPTION => 0,
      C_PVR => 0,                                                                        -- Remove If EDK 7.1
      C_PVR_USER1 => X"00",                                                              -- Remove If EDK 7.1
      C_PVR_USER2 => X"00000000",                                                        -- Remove If EDK 7.1
      C_DEBUG_ENABLED => 1,
      C_NUMBER_OF_PC_BRK => 2,
      C_NUMBER_OF_RD_ADDR_BRK => 1,
      C_NUMBER_OF_WR_ADDR_BRK => 1,
      C_INTERRUPT_IS_EDGE => 0,
      C_EDGE_IS_POSITIVE => 1,
      C_RESET_MSR => X"00000000",                                                        -- Remove If EDK 7.1
      C_OPCODE_0x0_ILLEGAL => 0,                                                         -- Remove If EDK 7.1
      C_FSL_LINKS => 1,
      C_FSL_DATA_SIZE => 32,
      C_ICACHE_BASEADDR => X"$(ICACHE_BASEADDR)",
      C_ICACHE_HIGHADDR => X"$(ICACHE_HIGHADDR)",
      C_USE_ICACHE => $(USE_ICACHE),
      C_ALLOW_ICACHE_WR => 1,
      C_ADDR_TAG_BITS => 0,
      C_CACHE_BYTE_SIZE => $(CACHE_BYTE_SIZE),
      C_ICACHE_USE_FSL => 0,
      C_ICACHE_LINE_LEN => 4,                                                            -- Remove If EDK 7.1
      C_DCACHE_BASEADDR => X"$(DCACHE_BASEADDR)",
      C_DCACHE_HIGHADDR => X"$(DCACHE_HIGHADDR)",
      C_USE_DCACHE => $(USE_DCACHE),
      C_ALLOW_DCACHE_WR => 1,
      C_DCACHE_ADDR_TAG => 0,
      C_DCACHE_BYTE_SIZE => $(DCACHE_BYTE_SIZE),
      C_DCACHE_USE_FSL => 0,                                                             -- Remove If EDK 7.1
      C_DCACHE_USE_FSL => 0                                                              -- Remove If EDK 9.1 or Higher
      C_DCACHE_LINE_LEN => 4                                                             -- Remove If EDK 7.1
    )
    port map (
      CLK => CLK,
      RESET => RESET,
      INTERRUPT => INTERRUPT,
      DEBUG_RST => DEBUG_RST,
      EXT_BRK => EXT_BRK,
      EXT_NM_BRK => EXT_NM_BRK,
      DBG_STOP => DBG_STOP,
      MB_Halted => MB_Halted,                                                            -- Remove If EDK 7.1
      INSTR => INSTR,
      I_ADDRTAG => I_ADDRTAG,
      IREADY => IREADY,
      IWAIT => IWAIT,
      INSTR_ADDR => INSTR_ADDR,
      IFETCH => IFETCH,
      I_AS => I_AS,
      DATA_READ => DATA_READ,
      DREADY => DREADY,
      DWAIT => DWAIT,
      DATA_WRITE => DATA_WRITE,
      DATA_ADDR => DATA_ADDR,
      D_ADDRTAG => D_ADDRTAG,
      D_AS => D_AS,
      READ_STROBE => READ_STROBE,
      WRITE_STROBE => WRITE_STROBE,
      BYTE_ENABLE => BYTE_ENABLE,
      DM_ABUS => DM_ABUS,
      DM_BE => DM_BE,
      DM_BUSLOCK => DM_BUSLOCK,
      DM_DBUS => DM_DBUS,
      DM_REQUEST => DM_REQUEST,
      DM_RNW => DM_RNW,
      DM_SELECT => DM_SELECT,
      DM_SEQADDR => DM_SEQADDR,
      DOPB_DBUS => DOPB_DBUS,
      DOPB_ERRACK => DOPB_ERRACK,
      DOPB_MGRANT => DOPB_MGRANT,
      DOPB_RETRY => DOPB_RETRY,
      DOPB_TIMEOUT => DOPB_TIMEOUT,
      DOPB_XFERACK => DOPB_XFERACK,
      IM_ABUS => IM_ABUS,
      IM_BE => IM_BE,
      IM_BUSLOCK => IM_BUSLOCK,
      IM_DBUS => IM_DBUS,
      IM_REQUEST => IM_REQUEST,
      IM_RNW => IM_RNW,
      IM_SELECT => IM_SELECT,
      IM_SEQADDR => IM_SEQADDR,
      IOPB_DBUS => IOPB_DBUS,
      IOPB_ERRACK => IOPB_ERRACK,
      IOPB_MGRANT => IOPB_MGRANT,
      IOPB_RETRY => IOPB_RETRY,
      IOPB_TIMEOUT => IOPB_TIMEOUT,
      IOPB_XFERACK => IOPB_XFERACK,
      DBG_CLK => DBG_CLK,
      DBG_TDI => DBG_TDI,
      DBG_TDO => DBG_TDO,
      DBG_REG_EN => DBG_REG_EN,
      DBG_CAPTURE => DBG_CAPTURE,
      DBG_UPDATE => DBG_UPDATE,
      VALID_INSTR => VALID_INSTR,                                                        -- Remove If EDK 9.1 or Higher
      PC_EX => PC_EX,                                                                    -- Remove If EDK 9.1 or Higher
      REG_WRITE => REG_WRITE,                                                            -- Remove If EDK 9.1 or Higher
      REG_ADDR => REG_ADDR,                                                              -- Remove If EDK 9.1 or Higher
      MSR_REG => MSR_REG,                                                                -- Remove If EDK 9.1 or Higher
      NEW_REG_VALUE => NEW_REG_VALUE,                                                    -- Remove If EDK 9.1 or Higher
      PIPE_RUNNING => PIPE_RUNNING,                                                      -- Remove If EDK 9.1 or Higher
      INTERRUPT_TAKEN => INTERRUPT_TAKEN,                                                -- Remove If EDK 9.1 or Higher
      JUMP_TAKEN => JUMP_TAKEN,                                                          -- Remove If EDK 9.1 or Higher
      PREFETCH_ADDR => PREFETCH_ADDR,                                                    -- Remove If EDK 9.1 or Higher
      MB_Halted => MB_Halted,                                                            -- Remove If EDK 9.1 or Higher
      Trace_Branch_Instr => Trace_Branch_Instr,                                          -- Remove If EDK 9.1 or Higher
      Trace_Instruction => Trace_Instruction,                                            -- Remove If EDK 7.1
      Trace_Valid_Instr => Trace_Valid_Instr,                                            -- Remove If EDK 7.1
      Trace_PC => Trace_PC,                                                              -- Remove If EDK 7.1
      Trace_Reg_Write => Trace_Reg_Write,                                                -- Remove If EDK 7.1
      Trace_Reg_Addr => Trace_Reg_Addr,                                                  -- Remove If EDK 7.1
      Trace_MSR_Reg => Trace_MSR_Reg,                                                    -- Remove If EDK 7.1
      Trace_New_Reg_Value => Trace_New_Reg_Value,                                        -- Remove If EDK 7.1
      Trace_Exception_Taken => Trace_Exception_Taken,                                    -- Remove If EDK 7.1
      Trace_Exception_Kind => Trace_Exception_Kind,                                      -- Remove If EDK 7.1
      Trace_Jump_Taken => Trace_Jump_Taken,                                              -- Remove If EDK 7.1
      Trace_Delay_Slot => Trace_Delay_Slot,
      Trace_Data_Address => Trace_Data_Address,
      Trace_AS => Trace_AS,                                                              -- Remove If EDK 9.1 or Higher
      Trace_Data_Access => Trace_Data_Access,                                            -- Remove If EDK 7.1
      Trace_Data_Read => Trace_Data_Read,
      Trace_Data_Write => Trace_Data_Write,
      Trace_Data_Write_Value => Trace_Data_Write_Value,                                  -- Remove If EDK 7.1
      Trace_Data_Byte_Enable => Trace_Data_Byte_Enable,                                  -- Remove If EDK 7.1
      Trace_DCache_Req => Trace_DCache_Req,
      Trace_DCache_Hit => Trace_DCache_Hit,
      Trace_ICache_Req => Trace_ICache_Req,
      Trace_ICache_Hit => Trace_ICache_Hit,
      Trace_Instr_EX => Trace_Instr_EX,                                                  -- Remove If EDK 9.1 or Higher
      Trace_OF_PipeRun => Trace_OF_PipeRun,                                              -- Remove If EDK 7.1
      Trace_EX_PipeRun => Trace_EX_PipeRun,                                              -- Remove If EDK 7.1
      Trace_MEM_PipeRun => Trace_MEM_PipeRun,                                            -- Remove If EDK 7.1
      FSL0_S_CLK => FSL0_S_CLK,
      FSL0_S_READ => FSL0_S_READ,
      FSL0_S_DATA => FSL0_S_DATA,
      FSL0_S_CONTROL => FSL0_S_CONTROL,
      FSL0_S_EXISTS => FSL0_S_EXISTS,
      FSL0_M_CLK => FSL0_M_CLK,
      FSL0_M_WRITE => FSL0_M_WRITE,
      FSL0_M_DATA => FSL0_M_DATA,
      FSL0_M_CONTROL => FSL0_M_CONTROL,
      FSL0_M_FULL => FSL0_M_FULL,
      FSL1_S_CLK => FSL1_S_CLK,
      FSL1_S_READ => FSL1_S_READ,
      FSL1_S_DATA => FSL1_S_DATA,
      FSL1_S_CONTROL => FSL1_S_CONTROL,
      FSL1_S_EXISTS => FSL1_S_EXISTS,
      FSL1_M_CLK => FSL1_M_CLK,
      FSL1_M_WRITE => FSL1_M_WRITE,
      FSL1_M_DATA => FSL1_M_DATA,
      FSL1_M_CONTROL => FSL1_M_CONTROL,
      FSL1_M_FULL => FSL1_M_FULL,
      FSL2_S_CLK => FSL2_S_CLK,
      FSL2_S_READ => FSL2_S_READ,
      FSL2_S_DATA => FSL2_S_DATA,
      FSL2_S_CONTROL => FSL2_S_CONTROL,
      FSL2_S_EXISTS => FSL2_S_EXISTS,
      FSL2_M_CLK => FSL2_M_CLK,
      FSL2_M_WRITE => FSL2_M_WRITE,
      FSL2_M_DATA => FSL2_M_DATA,
      FSL2_M_CONTROL => FSL2_M_CONTROL,
      FSL2_M_FULL => FSL2_M_FULL,
      FSL3_S_CLK => FSL3_S_CLK,
      FSL3_S_READ => FSL3_S_READ,
      FSL3_S_DATA => FSL3_S_DATA,
      FSL3_S_CONTROL => FSL3_S_CONTROL,
      FSL3_S_EXISTS => FSL3_S_EXISTS,
      FSL3_M_CLK => FSL3_M_CLK,
      FSL3_M_WRITE => FSL3_M_WRITE,
      FSL3_M_DATA => FSL3_M_DATA,
      FSL3_M_CONTROL => FSL3_M_CONTROL,
      FSL3_M_FULL => FSL3_M_FULL,
      FSL4_S_CLK => FSL4_S_CLK,
      FSL4_S_READ => FSL4_S_READ,
      FSL4_S_DATA => FSL4_S_DATA,
      FSL4_S_CONTROL => FSL4_S_CONTROL,
      FSL4_S_EXISTS => FSL4_S_EXISTS,
      FSL4_M_CLK => FSL4_M_CLK,
      FSL4_M_WRITE => FSL4_M_WRITE,
      FSL4_M_DATA => FSL4_M_DATA,
      FSL4_M_CONTROL => FSL4_M_CONTROL,
      FSL4_M_FULL => FSL4_M_FULL,
      FSL5_S_CLK => FSL5_S_CLK,
      FSL5_S_READ => FSL5_S_READ,
      FSL5_S_DATA => FSL5_S_DATA,
      FSL5_S_CONTROL => FSL5_S_CONTROL,
      FSL5_S_EXISTS => FSL5_S_EXISTS,
      FSL5_M_CLK => FSL5_M_CLK,
      FSL5_M_WRITE => FSL5_M_WRITE,
      FSL5_M_DATA => FSL5_M_DATA,
      FSL5_M_CONTROL => FSL5_M_CONTROL,
      FSL5_M_FULL => FSL5_M_FULL,
      FSL6_S_CLK => FSL6_S_CLK,
      FSL6_S_READ => FSL6_S_READ,
      FSL6_S_DATA => FSL6_S_DATA,
      FSL6_S_CONTROL => FSL6_S_CONTROL,
      FSL6_S_EXISTS => FSL6_S_EXISTS,
      FSL6_M_CLK => FSL6_M_CLK,
      FSL6_M_WRITE => FSL6_M_WRITE,
      FSL6_M_DATA => FSL6_M_DATA,
      FSL6_M_CONTROL => FSL6_M_CONTROL,
      FSL6_M_FULL => FSL6_M_FULL,
      FSL7_S_CLK => FSL7_S_CLK,
      FSL7_S_READ => FSL7_S_READ,
      FSL7_S_DATA => FSL7_S_DATA,
      FSL7_S_CONTROL => FSL7_S_CONTROL,
      FSL7_S_EXISTS => FSL7_S_EXISTS,
      FSL7_M_CLK => FSL7_M_CLK,
      FSL7_M_WRITE => FSL7_M_WRITE,
      FSL7_M_DATA => FSL7_M_DATA,
      FSL7_M_CONTROL => FSL7_M_CONTROL,
      FSL7_M_FULL => FSL7_M_FULL,
      ICACHE_FSL_IN_CLK => ICACHE_FSL_IN_CLK,
      ICACHE_FSL_IN_READ => ICACHE_FSL_IN_READ,
      ICACHE_FSL_IN_DATA => ICACHE_FSL_IN_DATA,
      ICACHE_FSL_IN_CONTROL => ICACHE_FSL_IN_CONTROL,
      ICACHE_FSL_IN_EXISTS => ICACHE_FSL_IN_EXISTS,
      ICACHE_FSL_OUT_CLK => ICACHE_FSL_OUT_CLK,
      ICACHE_FSL_OUT_WRITE => ICACHE_FSL_OUT_WRITE,
      ICACHE_FSL_OUT_DATA => ICACHE_FSL_OUT_DATA,
      ICACHE_FSL_OUT_CONTROL => ICACHE_FSL_OUT_CONTROL,
      ICACHE_FSL_OUT_FULL => ICACHE_FSL_OUT_FULL,
      DCACHE_FSL_IN_CLK => DCACHE_FSL_IN_CLK,
      DCACHE_FSL_IN_READ => DCACHE_FSL_IN_READ,
      DCACHE_FSL_IN_DATA => DCACHE_FSL_IN_DATA,
      DCACHE_FSL_IN_CONTROL => DCACHE_FSL_IN_CONTROL,
      DCACHE_FSL_IN_EXISTS => DCACHE_FSL_IN_EXISTS,
      DCACHE_FSL_OUT_CLK => DCACHE_FSL_OUT_CLK,
      DCACHE_FSL_OUT_WRITE => DCACHE_FSL_OUT_WRITE,
      DCACHE_FSL_OUT_DATA => DCACHE_FSL_OUT_DATA,
      DCACHE_FSL_OUT_CONTROL => DCACHE_FSL_OUT_CONTROL,
      DCACHE_FSL_OUT_FULL => DCACHE_FSL_OUT_FULL
    );

end architecture STRUCTURE;

