--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
  Port(
        -- Slave Signals
        STB_O      : Out   Std_Logic;
        CYC_O      : Out   Std_Logic;
        ACK_I      : In    Std_Logic;
        ADR_O      : Out   Std_Logic_Vector(ReplaceWith_AddressWidth-1 DownTo 0); --IncludeIf_Adr_Bus
        ADR_O      : Out   Std_Logic;                                             --IncludeIf_Adr_Bit
        DAT_I      : In    Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        DAT_O      : Out   Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        SEL_O      : Out   Std_Logic_Vector( 3 DownTo 0);
        WE_O       : Out   Std_Logic;
        CLK_O      : Out   Std_Logic;
        RST_O      : Out   Std_Logic;

        -- Master-0 Signals
        m0_STB_I   : In    Std_Logic;
        m0_CYC_I   : In    Std_Logic;
        m0_ACK_O   : Out   Std_Logic;
        m0_ADR_I   : In    Std_Logic_Vector(ReplaceWith_AddressWidth-1 DownTo 0); --IncludeIf_Adr_Bus
        m0_ADR_I   : In    Std_Logic;                                             --IncludeIf_Adr_Bit
        m0_DAT_O   : Out   Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        m0_DAT_I   : In    Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        m0_SEL_I   : In    Std_Logic_Vector( 3 DownTo 0);
        m0_WE_I    : In    Std_Logic;
        m0_CLK_I   : In    Std_Logic;
        m0_RST_I   : In    Std_Logic;

        -- Master-1 Signals
        m1_STB_I   : In    Std_Logic;
        m1_CYC_I   : In    Std_Logic;
        m1_ACK_O   : Out   Std_Logic;
        m1_ADR_I   : In    Std_Logic_Vector(ReplaceWith_AddressWidth-1 DownTo 0); --IncludeIf_Adr_Bus
        m1_ADR_I   : In    Std_Logic;                                             --IncludeIf_Adr_Bit
        m1_DAT_O   : Out   Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        m1_DAT_I   : In    Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        m1_SEL_I   : In    Std_Logic_Vector( 3 DownTo 0);
        m1_WE_I    : In    Std_Logic;
        m1_CLK_I   : In    Std_Logic;
        m1_RST_I   : In    Std_Logic
      );
End Configurable_ReplaceWith_Designator;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture RTL Of Configurable_ReplaceWith_Designator Is
    Signal Request0   : Std_Logic;
    Signal Request1   : Std_Logic;
    Signal Grant1     : Std_Logic;
    Signal Grant0     : Std_Logic;
    Signal LastMaster : Std_Logic;
    ----------------------------------------------------------------------------
    Type   TState Is (State_Idle,
                      State_BusyMaster0,
                      State_BusyMaster1
                      );
    Signal State      : TState;
    Signal State_Next : TState;
    ----------------------------------------------------------------------------
Begin
    ----------------------------------------------------------------------------
    Request0 <= (m0_CYC_I And m0_STB_I);
    Request1 <= (m1_CYC_I And m1_STB_I);

    FSM_Combinational:
    Process(LastMaster,
            State,
            Request0,
            Request1,
            ACK_I)
    Begin
        Grant0     <= '0';
        Grant1     <= '0';
        State_Next <= State;

        Case State Is
           When State_Idle =>                                 -- No one owns the bus currently
                If (Request0 = '1') And (Request1 = '1') Then -- Both want the slave
                   If LastMaster = '0' Then                   -- Master1 gets priority
                      State_Next <= State_BusyMaster1;
                   Else
                      State_Next <= State_BusyMaster0;        -- Master0 gets priority
                   End If;
                ElsIf Request0 = '1' Then
                      State_Next <= State_BusyMaster0;
                Elsif Request1 = '1' Then
                      State_Next <= State_BusyMaster1;
                End If;

           When State_BusyMaster0 =>
                Grant0 <= '1';
                If ACK_I = '1' Then                    -- Master0 finished
                   State_Next <= State_Idle;
                End If;

           When State_BusyMaster1 =>
                Grant1 <= '1';
                If ACK_I = '1' Then                    -- Master1 finished
                   State_Next <= State_Idle;
                End If;

           When Others =>
                State_Next <= State_Idle;

        End Case;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    FSM_Sequencer:
    Process(m0_CLK_I)
    Begin
        If Rising_Edge(m0_CLK_I) Then
           If m0_RST_I = '1' Then
              State      <= State_Idle;
              LastMaster <= '0';
           Else
              State <= State_Next;
              If Grant0 = '1' Then
                 LastMaster <= '0';
              ElsIf Grant1 = '1' Then
                 LastMaster <= '1';
              End If;
           End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Multiplexers:
    Process(Grant0,
            Grant1,
            ACK_I,

            m0_ADR_I, --IncludeIf_AnyAdr
            m0_STB_I,
            m0_CYC_I,
            m0_DAT_I,
            m0_SEL_I,
            m0_WE_I,

            m1_ADR_I, --IncludeIf_AnyAdr
            m1_STB_I,
            m1_CYC_I,
            m1_DAT_I,
            m1_SEL_I,
            m1_WE_I)
    Begin
        ADR_O    <= (Others => '0'); --IncludeIf_Adr_Bus
        ADR_O    <= '0';             --IncludeIf_Adr_Bit
        STB_O    <= '0';
        CYC_O    <= '0';
        DAT_O    <= (Others => '0');
        SEL_O    <= (Others => '0');
        WE_O     <= '0';
        m0_ACK_O <= '0';
        m1_ACK_O <= '0';

        If Grant0 = '1' Then
           ADR_O    <= m0_ADR_I;  --IncludeIf_AnyAdr
           STB_O    <= m0_STB_I;
           CYC_O    <= m0_CYC_I;
           DAT_O    <= m0_DAT_I;
           SEL_O    <= m0_SEL_I;
           WE_O     <= m0_WE_I;
           m0_ACK_O <= ACK_I;

        ElsIf Grant1 = '1' Then
           ADR_O    <= m1_ADR_I; --IncludeIf_AnyAdr
           STB_O    <= m1_STB_I;
           CYC_O    <= m1_CYC_I;
           DAT_O    <= m1_DAT_I;
           SEL_O    <= m1_SEL_I;
           WE_O     <= m1_WE_I;
           m1_ACK_O <= ACK_I;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    CLK_O    <= m0_CLK_I;
    RST_O    <= m0_RST_I;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    m0_DAT_O <= DAT_I;
    m1_DAT_O <= DAT_I;
    ----------------------------------------------------------------------------
End RTL;
--------------------------------------------------------------------------------

