--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
  Port(
        -- Slave Signals
        STB_O      : Out   Std_Logic;
        CYC_O      : Out   Std_Logic;
        ACK_I      : In    Std_Logic;
        ADR_O      : Out   Std_Logic_Vector(ReplaceWith_AddressWidth-1 DownTo 0); --IncludeIf_Adr_Bus
        ADR_O      : Out   Std_Logic;                                             --IncludeIf_Adr_Bit
        DAT_I      : In    Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        DAT_O      : Out   Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        SEL_O      : Out   Std_Logic_Vector( 3 DownTo 0);
        WE_O       : Out   Std_Logic;
        CLK_O      : Out   Std_Logic;
        RST_O      : Out   Std_Logic;

        -- Master-0 Signals
        ReplaceWith_MasterLowerPriority_STB_I   : In    Std_Logic;
        ReplaceWith_MasterLowerPriority_CYC_I   : In    Std_Logic;
        ReplaceWith_MasterLowerPriority_ACK_O   : Out   Std_Logic;
        ReplaceWith_MasterLowerPriority_ADR_I   : In    Std_Logic_Vector(ReplaceWith_AddressWidth-1 DownTo 0); --IncludeIf_Adr_Bus
        ReplaceWith_MasterLowerPriority_ADR_I   : In    Std_Logic;                                             --IncludeIf_Adr_Bit
        ReplaceWith_MasterLowerPriority_DAT_O   : Out   Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        ReplaceWith_MasterLowerPriority_DAT_I   : In    Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        ReplaceWith_MasterLowerPriority_SEL_I   : In    Std_Logic_Vector( 3 DownTo 0);
        ReplaceWith_MasterLowerPriority_WE_I    : In    Std_Logic;
        ReplaceWith_MasterLowerPriority_CLK_I   : In    Std_Logic;
        ReplaceWith_MasterLowerPriority_RST_I   : In    Std_Logic;

        -- Master-1 Signals
        ReplaceWith_MasterHigherPriority_STB_I   : In    Std_Logic;
        ReplaceWith_MasterHigherPriority_CYC_I   : In    Std_Logic;
        ReplaceWith_MasterHigherPriority_ACK_O   : Out   Std_Logic;
        ReplaceWith_MasterHigherPriority_ADR_I   : In    Std_Logic_Vector(ReplaceWith_AddressWidth-1 DownTo 0); --IncludeIf_Adr_Bus
        ReplaceWith_MasterHigherPriority_ADR_I   : In    Std_Logic;                                             --IncludeIf_Adr_Bit
        ReplaceWith_MasterHigherPriority_DAT_O   : Out   Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        ReplaceWith_MasterHigherPriority_DAT_I   : In    Std_Logic_Vector(ReplaceWith_DataWidth-1    DownTo 0);
        ReplaceWith_MasterHigherPriority_SEL_I   : In    Std_Logic_Vector( 3 DownTo 0);
        ReplaceWith_MasterHigherPriority_WE_I    : In    Std_Logic;
        ReplaceWith_MasterHigherPriority_CLK_I   : In    Std_Logic;
        ReplaceWith_MasterHigherPriority_RST_I   : In    Std_Logic
      );
End Configurable_ReplaceWith_Designator;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture RTL Of Configurable_ReplaceWith_Designator Is
   SubType TFsmState is Std_Logic_Vector(1 downto 0) ;

   Constant Idle_State                                            : TFsmState := "00" ;
   Constant ReplaceWith_MasterHigherPriority_AccessGranted_State  : TFsmState := "01" ;
   Constant ReplaceWith_MasterLowerPriority_AccessGranted_State   : TFsmState := "10" ;

   Signal State      : TFsmState ;
   Signal Next_State : TFsmState ;

   Signal ReplaceWith_MasterHigherPriority_AccessRequest : Std_Logic ;
   Signal ReplaceWith_MasterLowerPriority_AccessRequest  : Std_Logic ;

Begin
--------------------------------------------------------------------------------
   CLK_O <= ReplaceWith_MasterLowerPriority_CLK_I ;
   RST_O <= ReplaceWith_MasterLowerPriority_RST_I ;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
   ReplaceWith_MasterLowerPriority_AccessRequest  <= ReplaceWith_MasterLowerPriority_STB_I And ReplaceWith_MasterLowerPriority_CYC_I ;
   ReplaceWith_MasterHigherPriority_AccessRequest <= ReplaceWith_MasterHigherPriority_STB_I And ReplaceWith_MasterHigherPriority_CYC_I ;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
   Process (   State                   ,
               ReplaceWith_MasterLowerPriority_AccessRequest   ,
               ReplaceWith_MasterHigherPriority_AccessRequest   ,
               ReplaceWith_MasterLowerPriority_CYC_I                ,
               ReplaceWith_MasterLowerPriority_STB_I                ,
               ReplaceWith_MasterLowerPriority_ADR_I                ,  --IncludeIf_AnyAdr
               ReplaceWith_MasterLowerPriority_DAT_I                ,
               ReplaceWith_MasterLowerPriority_SEL_I                ,
               ReplaceWith_MasterLowerPriority_WE_I                 ,
               ReplaceWith_MasterHigherPriority_CYC_I                ,
               ReplaceWith_MasterHigherPriority_STB_I                ,
               ReplaceWith_MasterHigherPriority_ADR_I                ,  --IncludeIf_AnyAdr
               ReplaceWith_MasterHigherPriority_DAT_I                ,
               ReplaceWith_MasterHigherPriority_SEL_I                ,
               ReplaceWith_MasterHigherPriority_WE_I                 ,
               ACK_I                   ,
               DAT_I                   )
   Begin

      Next_State  <= State ;
      ReplaceWith_MasterLowerPriority_ACK_O    <= '0' ;
      ReplaceWith_MasterLowerPriority_DAT_O    <= DAT_I ;
      ReplaceWith_MasterHigherPriority_ACK_O    <= '0' ;
      ReplaceWith_MasterHigherPriority_DAT_O    <= DAT_I ;

      CYC_O <= '0' ;
      STB_O <= '0' ;
      ADR_O <= (Others=>'0') ;  --IncludeIf_Adr_Bus
      ADR_O <= '0' ;            --IncludeIf_Adr_Bit
      DAT_O <= (Others=>'0') ;
      SEL_O <= (Others=>'0') ;
      WE_O  <= '0' ;

      Case State is

         When Idle_State =>

            If    ReplaceWith_MasterHigherPriority_AccessRequest='1' Then
               Next_State <= ReplaceWith_MasterHigherPriority_AccessGranted_State ;
            ElsIf ReplaceWith_MasterLowerPriority_AccessRequest='1' Then
               Next_State <= ReplaceWith_MasterLowerPriority_AccessGranted_State ;
            End If ;

         When ReplaceWith_MasterLowerPriority_AccessGranted_State =>


              If  ReplaceWith_MasterLowerPriority_STB_I='0' Then
               If ReplaceWith_MasterHigherPriority_AccessRequest='1' Then
                  Next_State <= ReplaceWith_MasterHigherPriority_AccessGranted_State ;
                  CYC_O <= ReplaceWith_MasterHigherPriority_CYC_I ;
                  STB_O <= ReplaceWith_MasterHigherPriority_STB_I ;
               Else
                  Next_State <= Idle_State ;
               End If ;
            End If ;

            CYC_O <= ReplaceWith_MasterLowerPriority_CYC_I ;
            STB_O <= ReplaceWith_MasterLowerPriority_STB_I ;
            ADR_O <= ReplaceWith_MasterLowerPriority_ADR_I ;  --IncludeIf_AnyAdr
            DAT_O <= ReplaceWith_MasterLowerPriority_DAT_I ;
            SEL_O <= ReplaceWith_MasterLowerPriority_SEL_I ;
            WE_O  <= ReplaceWith_MasterLowerPriority_WE_I ;

            ReplaceWith_MasterLowerPriority_ACK_O <= ACK_I ;
            ReplaceWith_MasterLowerPriority_DAT_O <= DAT_I ;


         When ReplaceWith_MasterHigherPriority_AccessGranted_State =>

            If ReplaceWith_MasterHigherPriority_AccessRequest='1' Then
               Next_State <= ReplaceWith_MasterHigherPriority_AccessGranted_State ;
               CYC_O <= '0' ;
               STB_O <= '0' ;
            Else
               Next_State <= Idle_State ;
            End If ;

            CYC_O <= ReplaceWith_MasterHigherPriority_CYC_I ;
            STB_O <= ReplaceWith_MasterHigherPriority_STB_I ;
            ADR_O <= ReplaceWith_MasterHigherPriority_ADR_I ;  --IncludeIf_AnyAdr
            DAT_O <= ReplaceWith_MasterHigherPriority_DAT_I ;
            SEL_O <= ReplaceWith_MasterHigherPriority_SEL_I ;
            WE_O  <= ReplaceWith_MasterHigherPriority_WE_I  ;

            ReplaceWith_MasterHigherPriority_ACK_O <= ACK_I ;
            ReplaceWith_MasterHigherPriority_DAT_O <= DAT_I ;


         When Others =>
            Next_State <= Idle_State ;

      End Case ;

   End Process ;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
   Process (ReplaceWith_MasterHigherPriority_CLK_I)
   Begin
      If Rising_Edge(ReplaceWith_MasterHigherPriority_CLK_I) Then
         If ReplaceWith_MasterHigherPriority_RST_I='1' Then
            State <= Idle_State ;
         Else
            State <= Next_State ;
         End If ;
      End If ;
   End Process ;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
End RTL;
--------------------------------------------------------------------------------

