--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.all;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Template for construction of the top level of a PPC405A implementation.
--
-- The things that will be changed by the component configurator are:
--   1. The size of the boot memory. This will simply vary the address width.
--------------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
  Port
  (
    ----------------------------------------------------------------------------
    CLK_I          : In    Std_Logic;
    RST_I          : In    Std_Logic;
    INT_I          : In    Std_Logic_Vector(31 DownTo 0);
  --INT_NMI_I      : In    Std_Logic;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    -- Leave these Out if not including OCDS Unit
    TCK            : In    Std_Logic;                         -- IncludeIf_OCDS
    TDI            : In    Std_Logic;                         -- IncludeIf_OCDS
    TDO            : Out   Std_Logic;                         -- IncludeIf_OCDS
    TMS            : In    Std_Logic;                         -- IncludeIf_OCDS
    TRST           : In    Std_Logic;                         -- IncludeIf_OCDS
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    IO_ACK_I       : In    Std_Logic;
    IO_ADR_O       : Out   Std_Logic_Vector(23 DownTo 0);
    IO_CYC_O       : Out   Std_Logic;
    IO_DAT_I       : In    Std_Logic_Vector(31 DownTo 0);
    IO_DAT_O       : Out   Std_Logic_Vector(31 DownTo 0);
    IO_SEL_O       : Out   Std_Logic_Vector( 3 DownTo 0);
    IO_STB_O       : Out   Std_Logic;
    IO_WE_O        : Out   Std_Logic;
    IO_CLK_O       : Out   Std_Logic;
    IO_RST_O       : Out   Std_Logic;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    ME_ACK_I       : In    Std_Logic;
    ME_ADR_O       : Out   Std_Logic_Vector(31 DownTo 0);
    ME_CYC_O       : Out   Std_Logic;
    ME_DAT_I       : In    Std_Logic_Vector(31 DownTo 0);
    ME_DAT_O       : Out   Std_Logic_Vector(31 DownTo 0);
    ME_SEL_O       : Out   Std_Logic_Vector( 3 DownTo 0);
    ME_STB_O       : Out   Std_Logic;
    ME_WE_O        : Out   Std_Logic;
    ME_CLK_O       : Out   Std_Logic;
    ME_RST_O       : Out   Std_Logic
    ----------------------------------------------------------------------------

  );
End Configurable_ReplaceWith_Designator;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture Structure Of Configurable_ReplaceWith_Designator Is
--Constant ReplaceWith_BootAddressWidth : Integer := 10;
   -----------------------------------------------------------------------------
   Component ReplaceWith_MCU
      Port
      (
        CLK_I              : In  Std_Logic;
        RST_I              : In  Std_Logic;
        INT_I              : In  Std_Logic_Vector(31 Downto 0);
        INT_NMI_I          : In  Std_Logic;

        TCK                : In  Std_Logic;
        TDI                : In  Std_Logic;
        TDO                : Out Std_Logic;
        TMS                : In  Std_Logic;
        TRST               : In  Std_Logic;

        INT_STB_O          : Out Std_Logic;
        INT_CYC_O          : Out Std_Logic;
        INT_ADR_O          : Out Std_Logic_Vector(15 DownTo 0);
        INT_ACK_I          : In  Std_Logic;
        INT_DAT_O          : Out Std_Logic_Vector(31 DownTo 0);
        INT_DAT_I          : In  Std_Logic_Vector(31 DownTo 0);
        INT_SEL_O          : Out Std_Logic_Vector( 3 DownTo 0);
        INT_RST_O          : Out Std_Logic;
        INT_CLK_O          : Out Std_Logic;
        INT_WE_O           : Out Std_Logic;

        DBoot_ADR_O        : Out Std_Logic_Vector(21 DownTo 0);
        DBoot_DAT_I        : In  Std_Logic_Vector(63 DownTo 0);
        DBoot_DAT_O        : Out Std_Logic_Vector(63 DownTo 0);
        DBoot_SEL_O        : Out Std_Logic_Vector( 7 DownTo 0);
        DBoot_STB_O        : Out Std_Logic;

        IBoot_ADR_O        : Out Std_Logic_Vector(21 DownTo 0);
        IBoot_DAT_I        : In  Std_Logic_Vector(63 DownTo 0);
        IBoot_DAT_O        : Out Std_Logic_Vector(63 DownTo 0);
        IBoot_SEL_O        : Out Std_Logic_Vector( 7 DownTo 0);
        IBoot_STB_O        : Out Std_Logic;

        IO_ACK_I           : In  Std_Logic;
        IO_ADR_O           : Out Std_Logic_Vector(23 DownTo 0);
        IO_CYC_O           : Out Std_Logic;
        IO_DAT_I           : In  Std_Logic_Vector(31 DownTo 0);
        IO_DAT_O           : Out Std_Logic_Vector(31 DownTo 0);
        IO_SEL_O           : Out Std_Logic_Vector( 3 DownTo 0);
        IO_STB_O           : Out Std_Logic;
        IO_WE_O            : Out Std_Logic;

        ME_ACK_I           : In  Std_Logic;
        ME_ADR_O           : Out Std_Logic_Vector(31 DownTo 0);
        ME_CYC_O           : Out Std_Logic;
        ME_DAT_I           : In  Std_Logic_Vector(31 DownTo 0);
        ME_DAT_O           : Out Std_Logic_Vector(31 DownTo 0);
        ME_SEL_O           : Out Std_Logic_Vector( 3 DownTo 0);
        ME_STB_O           : Out Std_Logic;
        ME_WE_O            : Out Std_Logic;

        TRCC405TRACEDISABLE        : in  STD_LOGIC;
        TRCC405TRIGGEREVENTIN      : in  STD_LOGIC;

        C405TRCCYCLE               : out STD_LOGIC;
        C405TRCEVENEXECUTIONSTATUS : out STD_LOGIC_VECTOR(1 downto 0);
        C405TRCODDEXECUTIONSTATUS  : out STD_LOGIC_VECTOR(1 downto 0);
        C405TRCTRACESTATUS         : out STD_LOGIC_VECTOR(3 downto 0);
        C405TRCTRIGGEREVENTOUT     : out STD_LOGIC;
        C405TRCTRIGGEREVENTTYPE    : out STD_LOGIC_VECTOR(10 downto 0)

      );
   End Component;
   -----------------------------------------------------------------------------

   -----------------------------------------------------------------------------
   Constant  BootAddressWidth : Integer := ReplaceWith_BootAddressWidth;
   Component MemoryLow_ReplaceWith_Designator
      Port
      (
        ADDRA   : In  Std_Logic_Vector(BootAddressWidth-1 DownTo 0);
        ADDRB   : In  Std_Logic_Vector(BootAddressWidth-1 DownTo 0);
        ByteWEA : In  Std_Logic_Vector(3 DownTo 0);
        ByteWEB : In  Std_Logic_Vector(3 DownTo 0);
        CLKA    : In  Std_Logic;
        CLKB    : In  Std_Logic;
        DINA    : In  Std_Logic_Vector(31 DownTo 0);
        DINB    : In  Std_Logic_Vector(31 DownTo 0);
        DOUTA   : Out Std_Logic_Vector(31 DownTo 0);
        DOUTB   : Out Std_Logic_Vector(31 DownTo 0);
        ENA     : In  Std_Logic;
        ENB     : In  Std_Logic;
        WEA     : In  Std_Logic;
        WEB     : In  Std_Logic
      );
   End Component;
   Component MemoryHigh_ReplaceWith_Designator
      Port
      (
        ADDRA   : In  Std_Logic_Vector(BootAddressWidth-1 DownTo 0);
        ADDRB   : In  Std_Logic_Vector(BootAddressWidth-1 DownTo 0);
        ByteWEA : In  Std_Logic_Vector(3 DownTo 0);
        ByteWEB : In  Std_Logic_Vector(3 DownTo 0);
        CLKA    : In  Std_Logic;
        CLKB    : In  Std_Logic;
        DINA    : In  Std_Logic_Vector(31 DownTo 0);
        DINB    : In  Std_Logic_Vector(31 DownTo 0);
        DOUTA   : Out Std_Logic_Vector(31 DownTo 0);
        DOUTB   : Out Std_Logic_Vector(31 DownTo 0);
        ENA     : In  Std_Logic;
        ENB     : In  Std_Logic;
        WEA     : In  Std_Logic;
        WEB     : In  Std_Logic
      );
   End Component;
   -----------------------------------------------------------------------------

   -----------------------------------------------------------------------------
   Signal Signal_INT_STB_O          : Std_Logic;
   Signal Signal_INT_CYC_O          : Std_Logic;
   Signal Signal_INT_ADR_O          : Std_Logic_Vector(15 DownTo 0);
   Signal Signal_INT_ACK_I          : Std_Logic;
   Signal Signal_INT_DAT_O          : Std_Logic_Vector(31 DownTo 0);
   Signal Signal_INT_DAT_I          : Std_Logic_Vector(31 DownTo 0);
   Signal Signal_INT_SEL_O          : Std_Logic_Vector( 3 DownTo 0);
   Signal Signal_INT_RST_O          : Std_Logic;
   Signal Signal_INT_CLK_O          : Std_Logic;
   Signal Signal_INT_WE_O           : Std_Logic;
   -----------------------------------------------------------------------------

   -----------------------------------------------------------------------------
   Signal Signal_DBoot_ADR_O        : Std_Logic_Vector(21 DownTo 0);
   Signal Signal_DBoot_DAT_O        : Std_Logic_Vector(63 DownTo 0);
   Signal Signal_DBoot_DAT_I        : Std_Logic_Vector(63 DownTo 0);
   Signal Signal_DBoot_SEL_O        : Std_Logic_Vector( 7 DownTo 0);
   Signal Signal_DBoot_STB_O        : Std_Logic;

   Signal Signal_IBoot_ADR_O        : Std_Logic_Vector(21 DownTo 0);
   Signal Signal_IBoot_DAT_O        : Std_Logic_Vector(63 DownTo 0);
   Signal Signal_IBoot_DAT_I        : Std_Logic_Vector(63 DownTo 0);
   Signal Signal_IBoot_SEL_O        : Std_Logic_Vector( 7 DownTo 0);
   Signal Signal_IBoot_STB_O        : Std_Logic;

   Signal Signal_Interrupts         : Std_Logic_Vector(31 DownTo 0);
   Signal Signal_INT_NMI_I          : Std_Logic;

   Signal Signal_DBoot_WE_High      : Std_Logic;
   Signal Signal_DBoot_WE_Low       : Std_Logic;
   Signal Signal_IBoot_WE_High      : Std_Logic;
   Signal Signal_IBoot_WE_Low       : Std_Logic;

   Signal TRCC405TRACEDISABLE       : Std_Logic;
   Signal TRCC405TRIGGEREVENTIN     : Std_Logic;
   Signal C405TRCCYCLE              : Std_Logic;

   Signal C405TRCEVENEXECUTIONSTATUS : Std_Logic_Vector(1 downto 0);
   Signal C405TRCODDEXECUTIONSTATUS  : Std_Logic_Vector(1 downto 0);
   Signal C405TRCTRACESTATUS         : Std_Logic_Vector(3 downto 0);
   Signal C405TRCTRIGGEREVENTOUT     : Std_Logic;
   Signal C405TRCTRIGGEREVENTTYPE    : Std_Logic_Vector(10 downto 0);
Begin
    ----------------------------------------------------------------------------
    SubPart_MCU : ReplaceWith_MCU
    Port Map
    (
        CLK_I              => CLK_I,
        RST_I              => RST_I,
        INT_NMI_I          => Signal_INT_NMI_I,
        INT_I              => Signal_Interrupts,

        TCK                => TCK,
        TDI                => TDI,
        TDO                => TDO,
        TMS                => TMS,
        TRST               => TRST,

        DBoot_ADR_O        => Signal_DBoot_ADR_O,
        DBoot_DAT_I        => Signal_DBoot_DAT_I,
        DBoot_DAT_O        => Signal_DBoot_DAT_O,
        DBoot_SEL_O        => Signal_DBoot_SEL_O,
        DBoot_STB_O        => Signal_DBoot_STB_O,

        IBoot_ADR_O        => Signal_IBoot_ADR_O,
        IBoot_DAT_I        => Signal_IBoot_DAT_I,
        IBoot_DAT_O        => Signal_IBoot_DAT_O,
        IBoot_SEL_O        => Signal_IBoot_SEL_O,
        IBoot_STB_O        => Signal_IBoot_STB_O,

        INT_STB_O          => Signal_INT_STB_O,
        INT_CYC_O          => Signal_INT_CYC_O,
        INT_ADR_O          => Signal_INT_ADR_O,
        INT_ACK_I          => Signal_INT_ACK_I,
        INT_DAT_O          => Signal_INT_DAT_O,
        INT_DAT_I          => Signal_INT_DAT_I,
        INT_SEL_O          => Signal_INT_SEL_O,
        INT_RST_O          => Signal_INT_RST_O,
        INT_CLK_O          => Signal_INT_CLK_O,
        INT_WE_O           => Signal_INT_WE_O ,

        IO_ACK_I           => IO_ACK_I,
        IO_ADR_O           => IO_ADR_O,
        IO_CYC_O           => IO_CYC_O,
        IO_DAT_I           => IO_DAT_I,
        IO_DAT_O           => IO_DAT_O,
        IO_SEL_O           => IO_SEL_O,
        IO_STB_O           => IO_STB_O,
        IO_WE_O            => IO_WE_O ,

        ME_ACK_I           => ME_ACK_I,
        ME_ADR_O           => ME_ADR_O,
        ME_CYC_O           => ME_CYC_O,
        ME_DAT_I           => ME_DAT_I,
        ME_DAT_O           => ME_DAT_O,
        ME_SEL_O           => ME_SEL_O,
        ME_STB_O           => ME_STB_O,
        ME_WE_O            => ME_WE_O,

        TRCC405TRACEDISABLE   => TRCC405TRACEDISABLE,
        TRCC405TRIGGEREVENTIN => TRCC405TRIGGEREVENTIN,
        C405TRCCYCLE               => C405TRCCYCLE,
        C405TRCEVENEXECUTIONSTATUS => C405TRCEVENEXECUTIONSTATUS,
        C405TRCODDEXECUTIONSTATUS  => C405TRCODDEXECUTIONSTATUS,
        C405TRCTRACESTATUS         => C405TRCTRACESTATUS,
        C405TRCTRIGGEREVENTOUT     => C405TRCTRIGGEREVENTOUT,
        C405TRCTRIGGEREVENTTYPE    => C405TRCTRIGGEREVENTTYPE
    );
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    SubPart_BootMemory_Low : MemoryLow_ReplaceWith_Designator
    Port Map
    (
        ADDRA   => Signal_IBOOT_ADR_O(BootAddressWidth+2 DownTo 3),
        ADDRB   => Signal_DBOOT_ADR_O(BootAddressWidth+2 DownTo 3),

        ByteWEA => Signal_IBoot_SEL_O(3 DownTo 0),
        ByteWEB => Signal_DBoot_SEL_O(3 DownTo 0),

        CLKA    => CLK_I,
        CLKB    => CLK_I,

        DINA    => Signal_IBoot_DAT_O(31 DownTo 0),
        DINB    => Signal_DBoot_DAT_O(31 DownTo 0),

        DOUTA   => Signal_IBoot_DAT_I(31 DownTo 0),
        DOUTB   => Signal_DBoot_DAT_I(31 DownTo 0),

        ENA     => Signal_IBoot_STB_O,
        ENB     => Signal_DBoot_STB_O,
        WEA     => Signal_IBoot_WE_Low,
        WEB     => Signal_DBoot_WE_Low
    );
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    SubPart_BootMemory_High : MemoryHigh_ReplaceWith_Designator
    Port Map
    (
        ADDRA   => Signal_IBOOT_ADR_O(BootAddressWidth+2 DownTo 3),
        ADDRB   => Signal_DBOOT_ADR_O(BootAddressWidth+2 DownTo 3),

        ByteWEA => Signal_IBoot_SEL_O(7 DownTo 4),
        ByteWEB => Signal_DBoot_SEL_O(7 DownTo 4),

        CLKA    => CLK_I,
        CLKB    => CLK_I,

        DINA    => Signal_IBoot_DAT_O(63 DownTo 32),
        DINB    => Signal_DBoot_DAT_O(63 DownTo 32),

        DOUTA   => Signal_IBoot_DAT_I(63 DownTo 32),
        DOUTB   => Signal_DBoot_DAT_I(63 DownTo 32),

        ENA     => Signal_IBoot_STB_O,
        ENB     => Signal_DBoot_STB_O,

        WEA     => Signal_IBoot_WE_High,
        WEB     => Signal_DBoot_WE_High
    );
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Signal_DBoot_WE_High  <= Signal_DBoot_SEL_O(7) or Signal_DBoot_SEL_O(6) or Signal_DBoot_SEL_O(5) or Signal_DBoot_SEL_O(4);
    Signal_DBoot_WE_Low   <= Signal_DBoot_SEL_O(3) or Signal_DBoot_SEL_O(2) or Signal_DBoot_SEL_O(1) or Signal_DBoot_SEL_O(0);

    Signal_IBoot_WE_High  <= Signal_IBoot_SEL_O(7) or Signal_IBoot_SEL_O(6) or Signal_IBoot_SEL_O(5) or Signal_IBoot_SEL_O(4);
    Signal_IBoot_WE_Low   <= Signal_IBoot_SEL_O(3) or Signal_IBoot_SEL_O(2) or Signal_IBoot_SEL_O(1) or Signal_IBoot_SEL_O(0);
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    ME_CLK_O             <= CLK_I;
    IO_CLK_O             <= CLK_I;

    ME_RST_O             <= RST_I;
    IO_RST_O             <= RST_I;
    ----------------------------------------------------------------------------
    -- Trace interface
    ----------------------------------------------------------------------------
       -- Trace input signals
       TRCC405TRACEDISABLE <= '0';
       TRCC405TRIGGEREVENTIN <= '0';

       -- Trace output signals
       --C405TRCCYCLE               : STD_LOGIC;
       --C405TRCEVENEXECUTIONSTATUS : STD_LOGIC_VECTOR(1 downto 0);
       --C405TRCODDEXECUTIONSTATUS  : STD_LOGIC_VECTOR(1 downto 0);
       --C405TRCTRACESTATUS         : STD_LOGIC_VECTOR(3 downto 0);
       --C405TRCTRIGGEREVENTOUT     : STD_LOGIC;
       --C405TRCTRIGGEREVENTTYPE    : STD_LOGIC_VECTOR(10 downto 0)

    ----------------------------------------------------------------------------
    --Signal_INT_STB_O
    --Signal_INT_CYC_O
    --Signal_INT_ADR_O
    --Signal_INT_DAT_O
    --Signal_INT_SEL_O
    --Signal_INT_RST_O
    --Signal_INT_CLK_O
    --Signal_INT_WE_O
    Signal_INT_ACK_I <=  Signal_INT_STB_O;
    process (CLK_I)
    begin
         if rising_edge(CLK_I) then
            if signal_INT_STB_O = '1' and signal_INT_WE_O = '1' then
                Signal_INT_DAT_I <= Signal_INT_DAT_O;
            end if;
         end if;
    end process;

    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Signal_Interrupts   <= INT_I;
    Signal_INT_NMI_I    <= '0';
    ----------------------------------------------------------------------------
End Structure;
--------------------------------------------------------------------------------







