-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_Nios2DebugWrapperEntityName Is
Port (

    BREAK_READREG                             : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
    CLK                                       : In    STD_LOGIC;
    CLRN                                      : In    STD_LOGIC;
    DBRK_HIT0_LATCH                           : In    STD_LOGIC;
    DBRK_HIT1_LATCH                           : In    STD_LOGIC;
    DBRK_HIT2_LATCH                           : In    STD_LOGIC;
    DBRK_HIT3_LATCH                           : In    STD_LOGIC;
    DEBUGACK                                  : In    STD_LOGIC;
    ENA                                       : In    STD_LOGIC;
    IR_IN                                     : In    STD_LOGIC_VECTOR(7 DOWNTO 0);
    IR_OUT                                    : Out   STD_LOGIC_VECTOR(7 DOWNTO 0);
    IRQ                                       : Out   STD_LOGIC;
    JDO                                       : Out   STD_LOGIC_VECTOR(37 DOWNTO 0);
    JRST_N                                    : Out   STD_LOGIC;
    JTAG_STATE_UDR                            : In    STD_LOGIC;                            --IncludeIf_Nios2KitNot51
    MONDREG                                   : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
    MONITOR_ERROR                             : In    STD_LOGIC;
    MONITOR_READY                             : In    STD_LOGIC;
    RAW_TCK                                   : In    STD_LOGIC;
    RESET_N                                   : In    STD_LOGIC;
    RESETLATCH                                : In    STD_LOGIC;
    RTI                                       : In    STD_LOGIC;
    SHIFT                                     : In    STD_LOGIC;
    ST_READY_TEST_IDLE                        : Out   STD_LOGIC;
    TAKE_ACTION_BREAK_A                       : Out   STD_LOGIC;
    TAKE_ACTION_BREAK_B                       : Out   STD_LOGIC;
    TAKE_ACTION_BREAK_C                       : Out   STD_LOGIC;
    TAKE_ACTION_OCIMEM_A                      : Out   STD_LOGIC;
    TAKE_ACTION_OCIMEM_B                      : Out   STD_LOGIC;
    TAKE_ACTION_TRACECTRL                     : Out   STD_LOGIC;
    TAKE_ACTION_TRACEMEM_A                    : Out   STD_LOGIC;
    TAKE_ACTION_TRACEMEM_B                    : Out   STD_LOGIC;
    TAKE_NO_ACTION_BREAK_A                    : Out   STD_LOGIC;
    TAKE_NO_ACTION_BREAK_B                    : Out   STD_LOGIC;
    TAKE_NO_ACTION_BREAK_C                    : Out   STD_LOGIC;
    TAKE_NO_ACTION_OCIMEM_A                   : Out   STD_LOGIC;
    TAKE_NO_ACTION_TRACEMEM_A                 : Out   STD_LOGIC;
    TDI                                       : In    STD_LOGIC;
    TDO                                       : Out   STD_LOGIC;
    TRACEMEM_ON                               : In    STD_LOGIC;
    TRACEMEM_TRCDATA                          : In    STD_LOGIC_VECTOR(35 DOWNTO 0);
    TRACEMEM_TW                               : In    STD_LOGIC;
    TRC_IM_ADDR                               : In    STD_LOGIC_VECTOR(6 DOWNTO 0);
    TRC_ON                                    : In    STD_LOGIC; 
    TRC_WRAP                                  : In    STD_LOGIC; 
    TRIGBRKTYPE                               : In    STD_LOGIC; 
    TRIGGER_STATE_1                           : In    STD_LOGIC; 
    UPDATE                                    : In    STD_LOGIC; 
    USR1                                      : In    STD_LOGIC  
);
End;
-- ----------------------------------------------------------------------------


-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_Nios2DebugWrapperEntityName Is
-- ----------------------------------------------------------------------------
    Component Cpu_Jtag_Debug_Module_Wrapper Is
    Port (
        BREAK_READREG                             : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
        CLK                                       : In    STD_LOGIC;
        CLRN                                      : In    STD_LOGIC;
        DBRK_HIT0_LATCH                           : In    STD_LOGIC;
        DBRK_HIT1_LATCH                           : In    STD_LOGIC;
        DBRK_HIT2_LATCH                           : In    STD_LOGIC;
        DBRK_HIT3_LATCH                           : In    STD_LOGIC;
        DEBUGACK                                  : In    STD_LOGIC;
        ENA                                       : In    STD_LOGIC;
        IR_IN                                     : In    STD_LOGIC_VECTOR(7 DOWNTO 0);
        IR_OUT                                    : Out   STD_LOGIC_VECTOR(7 DOWNTO 0);
        IRQ                                       : Out   STD_LOGIC;
        JDO                                       : Out   STD_LOGIC_VECTOR(37 DOWNTO 0);
        JRST_N                                    : Out   STD_LOGIC;
        JTAG_STATE_UDR                            : In    STD_LOGIC;                       --IncludeIf_Nios2KitNot51
        LAX_DEBUGMODULE_JDO                       : Out   STD_LOGIC_VECTOR(37 DOWNTO 0);
        LAX_DEBUGMODULE_SR                        : Out   STD_LOGIC_VECTOR(37 DOWNTO 0);
        LAX_DEBUGMODULE_TAKE_ACTION_BREAK_A       : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_BREAK_B       : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_BREAK_C       : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_OCIMEM_A      : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_OCIMEM_B      : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_TRACECTRL     : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_TRACEMEM_A    : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_ACTION_TRACEMEM_B    : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_NO_ACTION_BREAK_A    : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_NO_ACTION_BREAK_B    : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_NO_ACTION_BREAK_C    : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_NO_ACTION_OCIMEM_A   : Out   STD_LOGIC;
        LAX_DEBUGMODULE_TAKE_NO_ACTION_TRACEMEM_A : Out   STD_LOGIC;
        MONDREG                                   : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
        MONITOR_ERROR                             : In    STD_LOGIC;
        MONITOR_READY                             : In    STD_LOGIC;
        RAW_TCK                                   : In    STD_LOGIC;
        RESET_N                                   : In    STD_LOGIC;
        RESETLATCH                                : In    STD_LOGIC;
        RTI                                       : In    STD_LOGIC;
        SHIFT                                     : In    STD_LOGIC;
        ST_READY_TEST_IDLE                        : Out   STD_LOGIC;
        TAKE_ACTION_BREAK_A                       : Out   STD_LOGIC;
        TAKE_ACTION_BREAK_B                       : Out   STD_LOGIC;
        TAKE_ACTION_BREAK_C                       : Out   STD_LOGIC;
        TAKE_ACTION_OCIMEM_A                      : Out   STD_LOGIC;
        TAKE_ACTION_OCIMEM_B                      : Out   STD_LOGIC;
        TAKE_ACTION_TRACECTRL                     : Out   STD_LOGIC;
        TAKE_ACTION_TRACEMEM_A                    : Out   STD_LOGIC;
        TAKE_ACTION_TRACEMEM_B                    : Out   STD_LOGIC;
        TAKE_NO_ACTION_BREAK_A                    : Out   STD_LOGIC;
        TAKE_NO_ACTION_BREAK_B                    : Out   STD_LOGIC;
        TAKE_NO_ACTION_BREAK_C                    : Out   STD_LOGIC;
        TAKE_NO_ACTION_OCIMEM_A                   : Out   STD_LOGIC;
        TAKE_NO_ACTION_TRACEMEM_A                 : Out   STD_LOGIC;
        TDI                                       : In    STD_LOGIC;
        TDO                                       : Out   STD_LOGIC;
        TRACEMEM_ON                               : In    STD_LOGIC;
        TRACEMEM_TRCDATA                          : In    STD_LOGIC_VECTOR(35 DOWNTO 0);
        TRACEMEM_TW                               : In    STD_LOGIC;
        TRC_IM_ADDR                               : In    STD_LOGIC_VECTOR(6 DOWNTO 0);
        TRC_ON                                    : In    STD_LOGIC; 
        TRC_WRAP                                  : In    STD_LOGIC; 
        TRIGBRKTYPE                               : In    STD_LOGIC; 
        TRIGGER_STATE_1                           : In    STD_LOGIC; 
        UPDATE                                    : In    STD_LOGIC; 
        USR1                                      : In    STD_LOGIC  
    );
    End Component;
    
    
    Signal JTAG_STATE_UDR : Std_Logic;                                              --ExcludeIf_Nios2KitNot51
-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

    JTAG_STATE_UDR <= '0';                                                          --ExcludeIf_Nios2KitNot51

DEBUG_MODULE_WRAPPER_INST : Cpu_Jtag_Debug_Module_Wrapper Port Map (
    BREAK_READREG                             => BREAK_READREG,
    CLK                                       => CLK,
    CLRN                                      => CLRN,
    DBRK_HIT0_LATCH                           => DBRK_HIT0_LATCH,
    DBRK_HIT1_LATCH                           => DBRK_HIT1_LATCH,
    DBRK_HIT2_LATCH                           => DBRK_HIT2_LATCH,
    DBRK_HIT3_LATCH                           => DBRK_HIT3_LATCH,
    DEBUGACK                                  => DEBUGACK,
    ENA                                       => ENA,
    IR_IN                                     => IR_IN,
    IR_OUT                                    => IR_OUT,
    IRQ                                       => IRQ,
    JDO                                       => JDO,
    JRST_N                                    => JRST_N,
    JTAG_STATE_UDR                            => JTAG_STATE_UDR,                    --IncludeIf_Nios2KitNot51
    LAX_DEBUGMODULE_JDO                       => Open,
    LAX_DEBUGMODULE_SR                        => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_BREAK_A       => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_BREAK_B       => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_BREAK_C       => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_OCIMEM_A      => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_OCIMEM_B      => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_TRACECTRL     => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_TRACEMEM_A    => Open,
    LAX_DEBUGMODULE_TAKE_ACTION_TRACEMEM_B    => Open,
    LAX_DEBUGMODULE_TAKE_NO_ACTION_BREAK_A    => Open,
    LAX_DEBUGMODULE_TAKE_NO_ACTION_BREAK_B    => Open,
    LAX_DEBUGMODULE_TAKE_NO_ACTION_BREAK_C    => Open,
    LAX_DEBUGMODULE_TAKE_NO_ACTION_OCIMEM_A   => Open,
    LAX_DEBUGMODULE_TAKE_NO_ACTION_TRACEMEM_A => Open,
    MONDREG                                   => MONDREG,
    MONITOR_ERROR                             => MONITOR_ERROR,
    MONITOR_READY                             => MONITOR_READY,
    RAW_TCK                                   => RAW_TCK,
    RESET_N                                   => RESET_N,
    RESETLATCH                                => RESETLATCH,
    RTI                                       => RTI,
    SHIFT                                     => SHIFT,
    ST_READY_TEST_IDLE                        => ST_READY_TEST_IDLE,
    TAKE_ACTION_BREAK_A                       => TAKE_ACTION_BREAK_A,
    TAKE_ACTION_BREAK_B                       => TAKE_ACTION_BREAK_B,
    TAKE_ACTION_BREAK_C                       => TAKE_ACTION_BREAK_C,
    TAKE_ACTION_OCIMEM_A                      => TAKE_ACTION_OCIMEM_A,
    TAKE_ACTION_OCIMEM_B                      => TAKE_ACTION_OCIMEM_B,
    TAKE_ACTION_TRACECTRL                     => TAKE_ACTION_TRACECTRL,
    TAKE_ACTION_TRACEMEM_A                    => TAKE_ACTION_TRACEMEM_A,
    TAKE_ACTION_TRACEMEM_B                    => TAKE_ACTION_TRACEMEM_B,
    TAKE_NO_ACTION_BREAK_A                    => TAKE_NO_ACTION_BREAK_A,
    TAKE_NO_ACTION_BREAK_B                    => TAKE_NO_ACTION_BREAK_B,
    TAKE_NO_ACTION_BREAK_C                    => TAKE_NO_ACTION_BREAK_C,
    TAKE_NO_ACTION_OCIMEM_A                   => TAKE_NO_ACTION_OCIMEM_A,
    TAKE_NO_ACTION_TRACEMEM_A                 => TAKE_NO_ACTION_TRACEMEM_A,
    TDI                                       => TDI,
    TDO                                       => TDO,
    TRACEMEM_ON                               => TRACEMEM_ON,
    TRACEMEM_TRCDATA                          => TRACEMEM_TRCDATA,
    TRACEMEM_TW                               => TRACEMEM_TW,
    TRC_IM_ADDR                               => TRC_IM_ADDR,
    TRC_ON                                    => TRC_ON,
    TRC_WRAP                                  => TRC_WRAP,
    TRIGBRKTYPE                               => TRIGBRKTYPE,
    TRIGGER_STATE_1                           => TRIGGER_STATE_1,
    UPDATE                                    => UPDATE,
    USR1                                      => USR1
);

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------
