-- -----------------------------------------------------------------------------
-- Template for construction of the top level of a MicroBlaze implementation.
--    MicroBlaze version: 4.00a
--
-- The things that will be changed by the component configurator are:
--    1. The size of the boot memory. This will simply vary the address width.
-- -----------------------------------------------------------------------------

Library IEEE ;
Use     IEEE.Std_Logic_1164.All ;
Use     IEEE.Std_Logic_Unsigned.All ;
-- -----------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
   Port
   (
      -----------------------------------------------------------------------------
      CLK_I    : In  Std_Logic ;
      RST_I    : In  Std_Logic ;
--      INT_I    : In  Std_Logic ;                                                       -- IncludeIf_Interrupts_One
      INT_I    : In  Std_Logic_Vector(31 Downto 0) ;
      -- RAF-> MicroBlaze has single interrupt pin so we need interrupt controller
      -- There are 2 possibilites, first one is that we do it in hardware and
      -- and second one is that we do it in software. Would be nice to have both
      -- solutions as option.
      -----------------------------------------------------------------------------

      -----------------------------------------------------------------------------
      -- Leave these our if not including OCDS Unit
      TCK      : In  Std_Logic ;                                                          -- IncludeIf_OCDS
      TDI      : In  Std_Logic ;                                                          -- IncludeIf_OCDS
      TDO      : Out Std_Logic ;                                                          -- IncludeIf_OCDS
      TMS      : In  Std_Logic ;                                                          -- IncludeIf_OCDS
      TRST     : In  Std_Logic ;                                                          -- IncludeIf_OCDS
      -----------------------------------------------------------------------------

      -----------------------------------------------------------------------------
      IO_STB_O : Out Std_Logic ;
      IO_CYC_O : Out Std_Logic ;
      IO_ACK_I : In  Std_Logic ;
      IO_ADR_O : Out Std_Logic_Vector(23 Downto 0) ;
      IO_DAT_I : In  Std_Logic_Vector(31 Downto 0) ;
      IO_DAT_O : Out Std_Logic_Vector(31 Downto 0) ;
      IO_SEL_O : Out Std_Logic_Vector( 3 Downto 0) ;
      IO_WE_O  : Out Std_Logic ;
      IO_CLK_O : Out Std_Logic ;
      IO_RST_O : Out Std_Logic ;
      -----------------------------------------------------------------------------

      -----------------------------------------------------------------------------
      ME_STB_O : Out Std_Logic ;
      ME_CYC_O : Out Std_Logic ;
      ME_ACK_I : In  Std_Logic ;
      ME_ADR_O : Out Std_Logic_Vector(31 Downto 0) ;
      ME_DAT_I : In  Std_Logic_Vector(31 Downto 0) ;
      ME_DAT_O : Out Std_Logic_Vector(31 Downto 0) ;
      ME_SEL_O : Out Std_Logic_Vector( 3 Downto 0) ;
      ME_WE_O  : Out Std_Logic ;
      ME_CLK_O : Out Std_Logic ;
      ME_RST_O : Out Std_Logic
      -----------------------------------------------------------------------------
   ) ;
End Configurable_ReplaceWith_Designator ;
-- -----------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
Architecture Structure Of Configurable_ReplaceWith_Designator Is
   -----------------------------------------------------------------------------
   -- MicroBlaze Processor
   -----------------------------------------------------------------------------
   Component microblaze_0_wrapper
      Port
      (
         --------------------------------------------------------------------------
         -- System Interface
         --------------------------------------------------------------------------
         CLK                  : In  Std_Logic ;
         RESET                : In  Std_Logic ;
         DEBUG_RST            : In  Std_Logic ;

         INTERRUPT            : In  Std_logic ;
         EXT_BRK              : In  Std_Logic ;
         EXT_NM_BRK           : In  Std_Logic ;
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- OCDS Interface
         --------------------------------------------------------------------------
         DBG_CLK              : In  Std_Logic ;
         DBG_TDI              : In  Std_Logic ;
         DBG_TDO              : Out Std_Logic ;
         DBG_REG_EN           : In  Std_Logic_Vector(0 To  4) ;
         DBG_CAPTURE          : In  Std_Logic ;
         DBG_UPDATE           : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Instruction Interface
         -- Used to connect to Block RAM memory (Internal memory)
         --------------------------------------------------------------------------
         INSTR                : In  Std_Logic_Vector(0 To 31) ;
         IREADY               : In  Std_Logic ;
         IWAIT                : In  Std_Logic ;
         INSTR_ADDR           : Out Std_Logic_Vector(0 To 31) ;
         IFETCH               : Out Std_Logic ;
         I_AS                 : Out Std_Logic ;
         I_ADDRTAG            : Out Std_Logic_Vector(0 To  3) ;                        -- Undocumented
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Data Interface
         -- Used to connect to Block RAM memory (Internal memory)
         --------------------------------------------------------------------------
         DATA_READ            : In  Std_Logic_Vector(0 To 31) ;
         DREADY               : In  Std_Logic ;
         DWAIT                : In  Std_Logic ;
         DATA_WRITE           : Out Std_Logic_Vector(0 To 31) ;
         DATA_ADDR            : Out Std_Logic_Vector(0 To 31) ;
         D_AS                 : Out Std_Logic ;
         READ_STROBE          : Out Std_Logic ;
         WRITE_STROBE         : Out Std_Logic ;
         BYTE_ENABLE          : Out Std_Logic_Vector(0 To  3) ;
         D_ADDRTAG            : Out Std_Logic_Vector(0 To  3) ;                        -- Undocumented
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Instruction Interface
         -- Used to connect to external memory, goes through Wishbone Memory side
         --------------------------------------------------------------------------
         IM_ABUS              : Out Std_Logic_Vector(0 To 31) ;
         IM_BE                : Out Std_Logic_Vector(0 To  3) ;
         IM_BUSLOCK           : Out Std_Logic ;
         IM_DBUS              : Out Std_Logic_Vector(0 To 31) ;
         IM_REQUEST           : Out Std_Logic ;
         IM_RNW               : Out Std_Logic ;
         IM_SELECT            : Out Std_Logic ;
         IM_SEQADDR           : Out Std_Logic ;
         IOPB_DBUS            : In  Std_Logic_Vector(0 To 31) ;
         IOPB_ERRACK          : In  Std_Logic ;
         IOPB_MGRANT          : In  Std_Logic ;
         IOPB_RETRY           : In  Std_Logic ;
         IOPB_TIMEOUT         : In  Std_Logic ;
         IOPB_XFERACK         : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Data Interface
         -- Used to connect to external memory/peripheral,
         -- goes through Wishobone Memory Or Wishbone Peripheral side depending 
         -- on address
         --------------------------------------------------------------------------
         DM_ABUS              : Out Std_Logic_Vector(0 To 31) ;
         DM_BE                : Out Std_Logic_Vector(0 To  3) ;
         DM_BUSLOCK           : Out Std_Logic ;
         DM_DBUS              : Out Std_Logic_Vector(0 To 31) ;
         DM_REQUEST           : Out Std_Logic ;
         DM_RNW               : Out Std_Logic ;
         DM_SELECT            : Out Std_Logic ;
         DM_SEQADDR           : Out Std_Logic ;
         DOPB_DBUS            : In  Std_Logic_Vector(0 To 31) ;
         DOPB_ERRACK          : In  Std_Logic ;
         DOPB_MGRANT          : In  Std_Logic ;
         DOPB_RETRY           : In  Std_Logic ;
         DOPB_TIMEOUT         : In  Std_Logic ;
         DOPB_XFERACK         : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Trace And Analyse Interface
         -- These pins are exposed on MicroBlaze version 4.00a interface.
         -- They purpose is solely to debug the processor.
         -- Xilinx recomendation is to not use these pins and they might be removed
         -- from the processor without any notice.
         -- Description for each signal is from Xilinx documentation: 
         -- mb_ref_guide.pdf
         --------------------------------------------------------------------------
         DBG_STOP             : In  Std_Logic ;                                        -- Undocumented
         VALID_INSTR          : Out Std_Logic ;                                        -- Valid instruction in EX stage                    -- Remove If EDK 9.1 or Higher
         PC_EX                : Out Std_Logic_Vector(0 To 31) ;                        -- Address for EX stage instruction                 -- Remove If EDK 9.1 or Higher
         REG_WRITE            : Out Std_Logic ;                                        -- EX stage instruction writes to the register file -- Remove If EDK 9.1 or Higher
         REG_ADDR             : Out Std_Logic_Vector(0 To  4) ;                        -- Destination register                             -- Remove If EDK 9.1 or Higher
         MSR_REG              : Out Std_Logic_Vector(0 To  9) ;                        -- Current MSR register value                       -- Remove If EDK 9.1 or Higher
         NEW_REG_VALUE        : Out Std_Logic_Vector(0 To 31) ;                        -- Destination register write data                  -- Remove If EDK 9.1 or Higher
         PIPE_RUNNING         : Out Std_Logic ;                                        -- Processor pipeline to advance                    -- Remove If EDK 9.1 or Higher
         INTERRUPT_TAKEN      : Out Std_Logic ;                                        -- Unmasked interrupt has occured                   -- Remove If EDK 9.1 or Higher
         JUMP_TAKEN           : Out Std_Logic ;                                        -- Branch instruction evaluated true                -- Remove If EDK 9.1 or Higher
         PREFETCH_ADDR        : Out Std_Logic_Vector(0 To  3) ;                        -- OF stage pointer into prefetch buffer            -- Remove If EDK 9.1 or Higher
         Trace_Valid_Instr    : Out Std_Logic ;                                        -- Valid instruction in EX stage                    -- Remove If EDK 7.1
         MB_HALTED            : Out Std_Logic ;                                        -- Pipeline is halted
         
         -- Trace signals for real time hardware debugging
         Trace_Branch_Instr   : Out Std_Logic ;                                                                                            -- Remove If EDK 9.1 or Higher
         Trace_Delay_Slot       : Out Std_Logic ;
         Trace_Data_Address     : Out Std_Logic_Vector(0 To 31) ;
         Trace_AS             : Out Std_Logic ;                                                                                            -- Remove If EDK 9.1 or Higher
         Trace_Data_Read        : Out Std_Logic ;
         Trace_Data_Write       : Out Std_Logic ;
         Trace_DCache_Req       : Out Std_Logic ;
         Trace_DCache_Hit       : Out Std_Logic ;
         Trace_ICache_Req       : Out Std_Logic ;
         Trace_ICache_Hit       : Out Std_Logic ;
         Trace_Instr_EX       : Out Std_Logic_Vector(0 To 31) ;                                                                            -- Remove If EDK 9.1 or Higher
         Trace_Instruction      : Out Std_Logic_Vector(0 To 31) ;                                                                          -- Remove If EDK 7.1
         Trace_PC               : Out Std_Logic_Vector(0 To 31) ;                                                                          -- Remove If EDK 7.1
         Trace_Reg_Write        : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         Trace_Reg_Addr         : Out Std_Logic_Vector(0 To 4)  ;                                                                          -- Remove If EDK 7.1
         Trace_MSR_Reg          : Out Std_Logic_Vector(0 To 10) ;                                                                          -- Remove If EDK 7.1
         Trace_New_Reg_Value    : Out Std_Logic_Vector(0 To 31) ;                                                                          -- Remove If EDK 7.1
         Trace_Exception_Taken  : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         Trace_Exception_Kind   : Out Std_Logic_Vector(0 To 3)  ;                                                                          -- Remove If EDK 7.1
         Trace_Jump_Taken       : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         Trace_Data_Access      : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         Trace_Data_Write_Value : Out Std_Logic_Vector(0 To 31) ;                                                                          -- Remove If EDK 7.1
         Trace_Data_Byte_Enable : Out Std_Logic_Vector(0 To 3)  ;                                                                          -- Remove If EDK 7.1
         Trace_OF_PipeRun       : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         Trace_EX_PipeRun       : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         Trace_MEM_PipeRun      : Out Std_Logic ;                                                                                          -- Remove If EDK 7.1
         --------------------------------------------------------------------------
   
         --------------------------------------------------------------------------
         -- Fast Simplex Link 0 (Used)
         --------------------------------------------------------------------------
         FSL0_S_CLK           : Out Std_Logic ;
         FSL0_S_READ          : Out Std_Logic ;
         FSL0_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL0_S_CONTROL       : In  Std_Logic ;
         FSL0_S_EXISTS        : In  Std_Logic ;
         FSL0_M_CLK           : Out Std_Logic ;
         FSL0_M_WRITE         : Out Std_Logic ;
         FSL0_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL0_M_CONTROL       : Out Std_Logic ;
         FSL0_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- Fast Simplex Link 1 (Not Used)
         --------------------------------------------------------------------------
         FSL1_S_CLK           : Out Std_Logic ;
         FSL1_S_READ          : Out Std_Logic ;
         FSL1_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL1_S_CONTROL       : In  Std_Logic ;
         FSL1_S_EXISTS        : In  Std_Logic ;
         FSL1_M_CLK           : Out Std_Logic ;
         FSL1_M_WRITE         : Out Std_Logic ;
         FSL1_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL1_M_CONTROL       : Out Std_Logic ;
         FSL1_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 2 (Not Used)
         --------------------------------------------------------------------------
         FSL2_S_CLK           : Out Std_Logic ;
         FSL2_S_READ          : Out Std_Logic ;
         FSL2_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL2_S_CONTROL       : In  Std_Logic ;
         FSL2_S_EXISTS        : In  Std_Logic ;
         FSL2_M_CLK           : Out Std_Logic ;
         FSL2_M_WRITE         : Out Std_Logic ;
         FSL2_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL2_M_CONTROL       : Out Std_Logic ;
         FSL2_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 3 (Not Used)
         --------------------------------------------------------------------------
         FSL3_S_CLK           : Out Std_Logic ;
         FSL3_S_READ          : Out Std_Logic ;
         FSL3_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL3_S_CONTROL       : In  Std_Logic ;
         FSL3_S_EXISTS        : In  Std_Logic ;
         FSL3_M_CLK           : Out Std_Logic ;
         FSL3_M_WRITE         : Out Std_Logic ;
         FSL3_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL3_M_CONTROL       : Out Std_Logic ;
         FSL3_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 4 (Not Used)
         --------------------------------------------------------------------------
         FSL4_S_CLK           : Out Std_Logic ;
         FSL4_S_READ          : Out Std_Logic ;
         FSL4_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL4_S_CONTROL       : In  Std_Logic ;
         FSL4_S_EXISTS        : In  Std_Logic ;
         FSL4_M_CLK           : Out Std_Logic ;
         FSL4_M_WRITE         : Out Std_Logic ;
         FSL4_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL4_M_CONTROL       : Out Std_Logic ;
         FSL4_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 5 (Not Used)
         --------------------------------------------------------------------------
         FSL5_S_CLK           : Out Std_Logic ;
         FSL5_S_READ          : Out Std_Logic ;
         FSL5_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL5_S_CONTROL       : In  Std_Logic ;
         FSL5_S_EXISTS        : In  Std_Logic ;
         FSL5_M_CLK           : Out Std_Logic ;
         FSL5_M_WRITE         : Out Std_Logic ;
         FSL5_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL5_M_CONTROL       : Out Std_Logic ;
         FSL5_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 6 (Not Used)
         --------------------------------------------------------------------------
         FSL6_S_CLK           : Out Std_Logic ;
         FSL6_S_READ          : Out Std_Logic ;
         FSL6_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL6_S_CONTROL       : In  Std_Logic ;
         FSL6_S_EXISTS        : In  Std_Logic ;
         FSL6_M_CLK           : Out Std_Logic ;
         FSL6_M_WRITE         : Out Std_Logic ;
         FSL6_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL6_M_CONTROL       : Out Std_Logic ;
         FSL6_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 7 (Not Used)
         --------------------------------------------------------------------------
         FSL7_S_CLK           : Out Std_Logic ;
         FSL7_S_READ          : Out Std_Logic ;
         FSL7_S_DATA          : In  Std_Logic_Vector(0 To 31) ;
         FSL7_S_CONTROL       : In  Std_Logic ;
         FSL7_S_EXISTS        : In  Std_Logic ;
         FSL7_M_CLK           : Out Std_Logic ;
         FSL7_M_WRITE         : Out Std_Logic ;
         FSL7_M_DATA          : Out Std_Logic_Vector(0 To 31) ;
         FSL7_M_CONTROL       : Out Std_Logic ;
         FSL7_M_FULL          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link Instruction Cache (Not Used)
         --------------------------------------------------------------------------
         ICACHE_FSL_IN_CLK       : Out Std_Logic ;
         ICACHE_FSL_IN_READ      : Out Std_Logic ;
         ICACHE_FSL_IN_DATA      : In  Std_Logic_Vector(0 To 31) ;
         ICACHE_FSL_IN_CONTROL   : In  Std_Logic ;
         ICACHE_FSL_IN_EXISTS    : In  Std_Logic ;
         ICACHE_FSL_OUT_CLK      : Out Std_Logic ;
         ICACHE_FSL_OUT_WRITE    : Out Std_Logic ;
         ICACHE_FSL_OUT_DATA     : Out Std_Logic_Vector(0 To 31) ;
         ICACHE_FSL_OUT_CONTROL  : Out Std_Logic ;
         ICACHE_FSL_OUT_FULL     : In  Std_Logic ;
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- Fast Simplex Link Data Cache (Not Used)
         --------------------------------------------------------------------------
         DCACHE_FSL_IN_CLK       : Out Std_Logic ;
         DCACHE_FSL_IN_READ      : Out Std_Logic ;
         DCACHE_FSL_IN_DATA      : In  Std_Logic_Vector(0 To 31) ;
         DCACHE_FSL_IN_CONTROL   : In  Std_Logic ;
         DCACHE_FSL_IN_EXISTS    : In  Std_Logic ;
         DCACHE_FSL_OUT_CLK      : Out Std_Logic ;
         DCACHE_FSL_OUT_WRITE    : Out Std_Logic ;
         DCACHE_FSL_OUT_DATA     : Out Std_Logic_Vector(0 To 31) ;
         DCACHE_FSL_OUT_CONTROL  : Out Std_Logic ;
         DCACHE_FSL_OUT_FULL     : In  Std_Logic
         --------------------------------------------------------------------------
      ) ;
   End Component ;
   -----------------------------------------------------------------------------

   -----------------------------------------------------------------------------
   -- MicroBlaze OCDS Unit
   -----------------------------------------------------------------------------
   Component ReplaceWith_OCDS
      Port 
      (
         --------------------------------------------------------------------------
         -- System interface
         --------------------------------------------------------------------------
         CLK_I          : In  Std_Logic ;
         RST_I          : In  Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Nexus interface
         --------------------------------------------------------------------------
         TCK            : In  Std_Logic ;
         TDI            : In  Std_Logic ;
         TDO            : Out Std_Logic ;
         TMS            : In  Std_Logic ;
         TRST           : In  Std_Logic ;
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- MicroBlaze Interface
         --------------------------------------------------------------------------
         Dbg_Clk        : Out Std_Logic ;
         Dbg_TDI        : Out Std_Logic ;
         Dbg_TDO        : In  Std_Logic ;
         Dbg_Reg_En     : Out Std_Logic_Vector(0 To  4) ;
         Dbg_Capture    : Out Std_Logic ;
         Dbg_Update     : Out Std_Logic ;
   
         Debug_Sys_Rst  : Out Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- MicroBlaze debug signals from JTAG_UART, will be gone in final version
         --------------------------------------------------------------------------
         Debug_Rst      : Out Std_Logic ;
         Ext_BRK        : Out Std_Logic ;
         Ext_NM_BRK     : Out Std_Logic ;
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- MicroBlaze Busses, will be gone in final version
         --------------------------------------------------------------------------
         OPB_Clk        : In  Std_Logic ;
         OPB_Rst        : In  Std_Logic ;
   
         OPB_ABus       : In  Std_Logic_Vector(0 To 31) ;
         OPB_BE         : In  Std_Logic_Vector(0 To  3) ;
         OPB_DBus       : In  Std_Logic_Vector(0 To 31) ;
         OPB_RNW        : In  Std_Logic ;
         OPB_Select     : In  Std_Logic ;
         
         MDM_DBus       : Out Std_Logic_Vector(0 To 31) ;
         MDM_errAck     : Out Std_Logic ;
         MDM_retry      : Out Std_Logic ;
         MDM_ToutSup    : Out Std_Logic ;
         MDM_xferAck    : Out Std_Logic
         -----------------------------------------------------------------------
      ) ;
   End Component ;
   -----------------------------------------------------------------------------


   -----------------------------------------------------------------------------
   -- Internal Memory, implemented as Block RAM
   -----------------------------------------------------------------------------
   Constant  BootAddressWidth : Integer := ReplaceWith_BootAddressWidth;
   Component Memory_ReplaceWith_Designator
      Port
      (
         -----------------------------------------------------------------------
         ADDRA        : In  Std_Logic_Vector(BootAddressWidth-1 DownTo 0);
         ADDRB        : In  Std_Logic_Vector(BootAddressWidth-1 DownTo 0);
         ByteWEA      : In  Std_Logic_Vector(3  DownTo 0);
         ByteWEB      : In  Std_Logic_Vector(3  DownTo 0);
         CLKA         : In  Std_Logic;
         CLKB         : In  Std_Logic;
         DINA         : In  Std_Logic_Vector(31 DownTo 0);
         DINB         : In  Std_Logic_Vector(31 DownTo 0);
         DOUTA        : Out Std_Logic_Vector(31 DownTo 0);
         DOUTB        : Out Std_Logic_Vector(31 DownTo 0);
         ENA          : In  Std_Logic;
         ENB          : In  Std_Logic;
         WEA          : In  Std_Logic;
         WEB          : In  Std_Logic
         -----------------------------------------------------------------------
      );
   End Component;
   -----------------------------------------------------------------------------


   -----------------------------------------------------------------------------
   -- MicroBlaze Memory Controller
   -----------------------------------------------------------------------------
   Component MicroBlaze_BusController
      Port
      (
         -----------------------------------------------------------------------------
         -----------------------------------------------------------------------------
         CLK_I             : In  Std_Logic ;
         RST_I             : In  Std_Logic ;
         -----------------------------------------------------------------------------
         
         IntIn             : In  Std_Logic_Vector(31 Downto 0) ; 
         IntOut            : Out Std_Logic ;                                                    
         
         -----------------------------------------------------------------------------
         -- Wishbone Interface
         -----------------------------------------------------------------------------
         IO_STB_O          : Out Std_Logic ;
         IO_CYC_O          : Out Std_Logic ;
         IO_ACK_I          : In  Std_Logic ;
         IO_ADR_O          : Out Std_Logic_Vector(23 Downto 0) ;
         IO_DAT_I          : In  Std_Logic_Vector(31 Downto 0) ;
         IO_DAT_O          : Out Std_Logic_Vector(31 Downto 0) ;
         IO_SEL_O          : Out Std_Logic_Vector( 3 Downto 0) ;
         IO_WE_O           : Out Std_Logic ;
         -----------------------------------------------------------------------------
         
         -----------------------------------------------------------------------------
         ME_STB_O          : Out Std_Logic ;
         ME_CYC_O          : Out Std_Logic ;
         ME_ACK_I          : In  Std_Logic ;
         ME_ADR_O          : Out Std_Logic_Vector(31 Downto 0) ;
         ME_DAT_I          : In  Std_Logic_Vector(31 Downto 0) ;
         ME_DAT_O          : Out Std_Logic_Vector(31 Downto 0) ;
         ME_SEL_O          : Out Std_Logic_Vector( 3 Downto 0) ;
         ME_WE_O           : Out Std_Logic ;
         -----------------------------------------------------------------------------
      
         --------------------------------------------------------------------------
         -- Internal Memory Interface
         --------------------------------------------------------------------------
         DBoot_DAT_I       : In  Std_Logic_Vector(31 DownTo 0) ;
         DBoot_ADR_O       : Out Std_Logic_Vector(21 DownTo 0) ;
         DBoot_DAT_O       : Out Std_Logic_Vector(31 DownTo 0) ;
         DBoot_SEL_O       : Out Std_Logic_Vector( 3 DownTo 0) ;
         DBoot_STB_O       : Out Std_Logic ;
         DBoot_WE_O        : Out Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         IBoot_DAT_I       : In  Std_Logic_Vector(31 DownTo 0) ;
         IBoot_ADR_O       : Out Std_Logic_Vector(21 DownTo 0) ;
         IBoot_STB_O       : Out Std_Logic ;
         --------------------------------------------------------------------------         

         --------------------------------------------------------------------------         
         -- MicroBlaze Interface
         -- LIM - Local Instrucion Memory
         -- LDM - Local Data Memory
         -- EIM - External Instruction Memory
         -- EDM - External Data Memory
         --------------------------------------------------------------------------         
         MB_LIM_INSTR         : Out Std_Logic_Vector(0 To 31) ;
         MB_LIM_IREADY        : Out Std_Logic ;
         MB_LIM_IWAIT         : Out Std_Logic ;
         MB_LIM_INSTR_ADDR    : In  Std_Logic_Vector(0 To 31) ;
         MB_LIM_IFETCH        : In  Std_Logic ;
         MB_LIM_I_AS          : In  Std_Logic ;
         MB_LIM_I_ADDRTAG     : In  Std_Logic_Vector(0 To 3 ) ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         MB_LDM_DATA_READ     : Out Std_Logic_Vector(0 To 31) ;
         MB_LDM_DREADY        : Out Std_Logic ;
         MB_LDM_DWAIT         : Out Std_Logic ;
         MB_LDM_DATA_WRITE    : In  Std_Logic_Vector(0 To 31) ;
         MB_LDM_DATA_ADDR     : In  Std_Logic_Vector(0 To 31) ;
         MB_LDM_D_AS          : In  Std_Logic ;
         MB_LDM_READ_STROBE   : In  Std_Logic ;
         MB_LDM_WRITE_STROBE  : In  Std_Logic ;
         MB_LDM_BYTE_ENABLE   : In  Std_Logic_Vector(0 To  3) ;
         MB_LDM_D_ADDRTAG     : In  Std_Logic_Vector(0 To  3) ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         MB_EIM_IM_ABUS       : In  Std_Logic_Vector(0 To 31) ;
         MB_EIM_IM_BE         : In  Std_Logic_Vector(0 To  3) ;
         MB_EIM_IM_BUSLOCK    : In  Std_Logic ;
         MB_EIM_IM_DBUS       : In  Std_Logic_Vector(0 To 31) ;
         MB_EIM_IM_REQUEST    : In  Std_Logic ;
         MB_EIM_IM_RNW        : In  Std_Logic ;
         MB_EIM_IM_SELECT     : In  Std_Logic ;
         MB_EIM_IM_SEQADDR    : In  Std_Logic ;
         
         MB_EIM_IOPB_DBUS     : Out Std_Logic_Vector(0 To 31) ;
         MB_EIM_IOPB_ERRACK   : Out Std_Logic ;
         MB_EIM_IOPB_MGRANT   : Out Std_Logic ;
         MB_EIM_IOPB_RETRY    : Out Std_Logic ;
         MB_EIM_IOPB_TIMEOUT  : Out Std_Logic ;
         MB_EIM_IOPB_XFERACK  : Out Std_Logic ;
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         MB_EDM_DM_ABUS       : In  Std_Logic_Vector(0 To 31) ;
         MB_EDM_DM_BE         : In  Std_Logic_Vector(0 To  3) ;
         MB_EDM_DM_BUSLOCK    : In  Std_Logic ;
         MB_EDM_DM_DBUS       : In  Std_Logic_Vector(0 To 31) ;
         MB_EDM_DM_REQUEST    : In  Std_Logic ;
         MB_EDM_DM_RNW        : In  Std_Logic ;
         MB_EDM_DM_SELECT     : In  Std_Logic ;
         MB_EDM_DM_SEQADDR    : In  Std_Logic ;
         
         MB_EDM_DOPB_DBUS     : Out Std_Logic_Vector(0 To 31) ;
         MB_EDM_DOPB_ERRACK   : Out Std_Logic ;
         MB_EDM_DOPB_MGRANT   : Out Std_Logic ;
         MB_EDM_DOPB_RETRY    : Out Std_Logic ;
         MB_EDM_DOPB_TIMEOUT  : Out Std_Logic ;
         MB_EDM_DOPB_XFERACK  : Out Std_Logic
         --------------------------------------------------------------------------
      ) ;
   End Component ;

   Component MicroBlase_TimeBase
   Port
   (
        Clk   : In Std_Logic;
        Reset : In Std_Logic;

        FSL_S_Clk     : In  Std_Logic;
        FSL_S_Read    : In  Std_Logic;
        FSL_S_Data    : Out Std_Logic_Vector(0 to 31);
        FSL_S_Control : Out Std_Logic;
        FSL_S_Exists  : Out Std_Logic;

        FSL_M_Clk     : In  Std_Logic;
        FSL_M_Write   : In  Std_Logic;
        FSL_M_Data    : In  Std_Logic_Vector(0 to 31);
        FSL_M_Control : In  Std_Logic;
        FSL_M_Full    : Out Std_Logic
    );
    End Component;

   Signal Net_GND   : Std_Logic ;
   Signal Net_GND4  : Std_Logic_Vector(3  Downto 0) ;
   Signal Net_GND5  : Std_Logic_Vector(4  Downto 0) ;
   Signal Net_GND32 : Std_Logic_Vector(31 Downto 0) ;


   Signal System_Reset           : Std_Logic ;
   Signal System_Reset_Counter   : Std_Logic_Vector(3 Downto 0) ;


   Signal OCDS_Dbg_Clk           : Std_Logic ;
   Signal OCDS_Dbg_TDI           : Std_Logic ;
   Signal OCDS_Dbg_TDO           : Std_Logic ;
   Signal OCDS_Dbg_Reg_EN        : Std_Logic_Vector(0 To 4) ;
   Signal OCDS_Dbg_Capture       : Std_Logic ;
   Signal OCDS_Dbg_Update        : Std_Logic ;
   Signal OCDS_Debug_Rst         : Std_Logic ;
   Signal OCDS_Debug_Sys_Rst     : Std_Logic ;
   Signal OCDS_Debug_Sys_Rst_Sig : Std_Logic ;
   Signal OCDS_Ext_Brk           : Std_Logic ;
   Signal OCDS_Ext_NM_Brk        : Std_Logic ;
   
   Signal BusController_Instr          : Std_Logic_Vector(0 To 31) ;
   Signal BusController_IReady         : Std_Logic ;
   Signal BusController_IWait          : Std_Logic ;
   Signal BusController_InstrAddr      : Std_Logic_Vector(0 To 31) ;
   Signal BusController_IFetch         : Std_Logic ;
   Signal BusController_I_AS           : Std_Logic ;
   Signal BusController_I_AddrTag      : Std_Logic_Vector(0 To  3) ;
   
   Signal BusController_DataRead       : Std_Logic_Vector(0 To 31) ;
   Signal BusController_DReady         : Std_Logic ;
   Signal BusController_DWait          : Std_Logic ;
   Signal BusController_DataWrite      : Std_Logic_Vector(0 To 31) ;
   Signal BusController_DataAddr       : Std_Logic_Vector(0 To 31) ;
   Signal BusController_D_AS           : Std_Logic ;
   Signal BusController_ReadStrobe     : Std_Logic ;
   Signal BusController_WriteStrobe    : Std_Logic ;
   Signal BusController_ByteEnable     : Std_Logic_Vector(0 To  3) ;
   Signal BusController_D_AddrTag      : Std_Logic_Vector(0 To  3) ;
   
   Signal BusController_IM_ABus        : Std_Logic_Vector(0 To 31) ;
   Signal BusController_IM_BE          : Std_Logic_Vector(0 To  3) ;
   Signal BusController_IM_BusLock     : Std_Logic ;
   Signal BusController_IM_DBus        : Std_Logic_Vector(0 To 31) ;
   Signal BusController_IM_Request     : Std_Logic ;
   Signal BusController_IM_Rnw         : Std_Logic ;
   Signal BusController_IM_Select      : Std_Logic ;
   Signal BusController_IM_seqAddr     : Std_Logic ;
   Signal BusController_IOPB_DBus      : Std_Logic_Vector(0 To 31) ;
   Signal BusController_IOPB_errAck    : Std_Logic ;
   Signal BusController_IOPB_MGrant    : Std_Logic ;
   Signal BusController_IOPB_Retry     : Std_Logic ;
   Signal BusController_IOPB_TimeOut   : Std_Logic ;
   Signal BusController_IOPB_xferAck   : Std_Logic ;
   
   Signal BusController_DM_ABus        : Std_Logic_Vector(0 To 31) ;
   Signal BusController_DM_BE          : Std_Logic_Vector(0 To  3) ;
   Signal BusController_DM_BusLock     : Std_Logic ;
   Signal BusController_DM_DBus        : Std_Logic_Vector(0 To 31) ;
   Signal BusController_DM_Request     : Std_Logic ;
   Signal BusController_DM_Rnw         : Std_Logic ;
   Signal BusController_DM_Select      : Std_Logic ;
   Signal BusController_DM_seqAddr     : Std_Logic ;
   Signal BusController_DOPB_DBus      : Std_Logic_Vector(0 To 31) ;
   Signal BusController_DOPB_errAck    : Std_Logic ;
   Signal BusController_DOPB_MGrant    : Std_Logic ;
   Signal BusController_DOPB_Retry     : Std_Logic ;
   Signal BusController_DOPB_TimeOut   : Std_Logic ;
   Signal BusController_DOPB_xferAck   : Std_Logic ;
   
   Signal BusController_DBoot_Dat_I    : Std_Logic_Vector(31 Downto 0) ;
   Signal BusController_DBoot_Adr_O    : Std_Logic_Vector(21 Downto 0) ;
   Signal BusController_DBoot_Dat_O    : Std_Logic_Vector(31 Downto 0) ;
   Signal BusController_DBoot_Sel_O    : Std_Logic_Vector(3  Downto 0) ;
   Signal BusController_DBoot_Stb_O    : Std_Logic ;
   Signal BusController_DBoot_We_O     : Std_Logic ;
   Signal BusController_IBoot_Dat_I    : Std_Logic_Vector(31 Downto 0) ;
   Signal BusController_IBoot_Adr_O    : Std_Logic_Vector(21 Downto 0) ;
   Signal BusController_IBoot_Stb_O    : Std_Logic ;
   
   Signal Interrupt_Signal             : Std_Logic ;

   Signal FSL_Reset_Signal          : Std_Logic;

   Signal FSL_M_Clk_TimeBase_Signal     : Std_Logic;
   Signal FSL_M_Data_TimeBase_Signal    : Std_Logic_Vector(0 to 31);
   Signal FSL_M_Control_TimeBase_Signal : Std_Logic;
   Signal FSL_M_Write_TimeBase_Signal   : Std_Logic;
   Signal FSL_M_Full_TimeBase_Signal    : Std_Logic;

   Signal FSL_S_CLK_TimeBase_Signal     : Std_Logic ;
   Signal FSL_S_READ_TimeBase_Signal    : Std_Logic ;
   Signal FSL_S_DATA_TimeBase_Signal    : Std_Logic_Vector(0 To 31) ;
   Signal FSL_S_CONTROL_TimeBase_Signal : Std_Logic ;
   Signal FSL_S_EXISTS_TimeBase_Signal  : Std_Logic ;
-- -----------------------------------------------------------------------------
-- -----------------------------------------------------------------------------






-- -----------------------------------------------------------------------------
Begin
-- -----------------------------------------------------------------------------

   IO_CLK_O <= CLK_I ;
   IO_RST_O <= RST_I ;
   ME_CLK_O <= CLK_I ;
   ME_RST_O <= RST_I ;

   -----------------------------------------------------------------------------
   Net_GND   <= '0' ;
   Net_GND4  <= (Others=>'0') ;
   Net_GND5  <= (Others=>'0') ;
   Net_GND32 <= (Others=>'0') ;
   -----------------------------------------------------------------------------

   -----------------------------------------------------------------------------
   -----------------------------------------------------------------------------

   SubPart_MCU : microblaze_0_wrapper
   Port Map
   (

         --------------------------------------------------------------------------
         -- System Interface
         --------------------------------------------------------------------------
         CLK                  => CLK_I                     ,
         RESET                => System_Reset              ,

--         INTERRUPT            => INT_I(0)                  , -- TODO: change it when interrupt controller is ready
         INTERRUPT            => Interrupt_Signal          ,

         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- OCDS Interface
         --------------------------------------------------------------------------
         -- Connections to OCDS if it is included
         DBG_CLK              => OCDS_Dbg_Clk              ,   -- IncludeIf_OCDS
         DBG_TDI              => OCDS_Dbg_TDI              ,   -- IncludeIf_OCDS
         DBG_TDO              => OCDS_Dbg_TDO              ,   -- IncludeIf_OCDS
         DBG_REG_EN           => OCDS_Dbg_Reg_EN           ,   -- IncludeIf_OCDS
         DBG_CAPTURE          => OCDS_Dbg_Capture          ,   -- IncludeIf_OCDS
         DBG_UPDATE           => OCDS_Dbg_Update           ,   -- IncludeIf_OCDS
         DEBUG_RST            => OCDS_Debug_Rst            ,   -- IncludeIf_OCDS
         EXT_BRK              => OCDS_Ext_Brk              ,   -- IncludeIf_OCDS
         EXT_NM_BRK           => OCDS_Ext_NM_Brk           ,   -- IncludeIf_OCDS


         -- Connections to OCDS if it is excluded
         DBG_CLK              => Net_GND                   ,   -- ExcludeIf_OCDS
         DBG_TDI              => Net_GND                   ,   -- ExcludeIf_OCDS
         DBG_TDO              => Open                      ,   -- ExcludeIf_OCDS
         DBG_REG_EN           => Net_GND5                  ,   -- ExcludeIf_OCDS
         DBG_CAPTURE          => Net_GND                   ,   -- ExcludeIf_OCDS
         DBG_UPDATE           => Net_GND                   ,   -- ExcludeIf_OCDS
         DEBUG_RST            => Net_GND                   ,   -- ExcludeIf_OCDS
         EXT_BRK              => Net_GND                   ,   -- ExcludeIf_OCDS
         EXT_NM_BRK           => Net_GND                   ,   -- ExcludeIf_OCDS
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- Internal Memory Instruction Interface
         --------------------------------------------------------------------------
         INSTR                => BusController_Instr       ,
         IREADY               => BusController_IReady      ,
         IWAIT                => BusController_IWait       ,
         INSTR_ADDR           => BusController_InstrAddr   ,
         IFETCH               => BusController_IFetch      ,
         I_AS                 => BusController_I_AS        ,
         I_ADDRTAG            => BusController_I_AddrTag   ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Internal Memory Data Interface
         --------------------------------------------------------------------------
         DATA_READ            => BusController_DataRead     ,
         DREADY               => BusController_DReady       ,
         DWAIT                => BusController_DWait        ,
         DATA_WRITE           => BusController_DataWrite    ,
         DATA_ADDR            => BusController_DataAddr     ,
         D_AS                 => BusController_D_AS         ,
         READ_STROBE          => BusController_ReadStrobe   ,
         WRITE_STROBE         => BusController_WriteStrobe  ,
         BYTE_ENABLE          => BusController_ByteEnable   ,
         D_ADDRTAG            => BusController_D_AddrTag    ,
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- External Memory Instruction Interface
         --------------------------------------------------------------------------
         IM_ABUS              => BusController_IM_ABus      ,
         IM_BE                => BusController_IM_BE        ,
         IM_BUSLOCK           => BusController_IM_BusLock   ,
         IM_DBUS              => BusController_IM_DBus      ,
         IM_REQUEST           => BusController_IM_Request   ,
         IM_RNW               => BusController_IM_Rnw       ,
         IM_SELECT            => BusController_IM_Select    ,
         IM_SEQADDR           => BusController_IM_seqAddr   ,
         IOPB_DBUS            => BusController_IOPB_DBus    ,
         IOPB_ERRACK          => BusController_IOPB_errAck  ,
         IOPB_MGRANT          => BusController_IOPB_MGrant  ,
         IOPB_RETRY           => BusController_IOPB_Retry   ,
         IOPB_TIMEOUT         => BusController_IOPB_TimeOut ,
         IOPB_XFERACK         => BusController_IOPB_xferAck ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- External Memory Data Interface
         --------------------------------------------------------------------------
         DM_ABUS              => BusController_DM_ABus      ,
         DM_BE                => BusController_DM_BE        ,
         DM_BUSLOCK           => BusController_DM_BusLock   ,
         DM_DBUS              => BusController_DM_DBus      ,
         DM_REQUEST           => BusController_DM_Request   ,
         DM_RNW               => BusController_DM_Rnw       ,
         DM_SELECT            => BusController_DM_Select    ,
         DM_SEQADDR           => BusController_DM_seqAddr   ,
         DOPB_DBUS            => BusController_DOPB_DBus    ,
         DOPB_ERRACK          => BusController_DOPB_errAck  ,
         DOPB_MGRANT          => BusController_DOPB_MGrant  ,
         DOPB_RETRY           => BusController_DOPB_Retry   ,
         DOPB_TIMEOUT         => BusController_DOPB_TimeOut ,
         DOPB_XFERACK         => BusController_DOPB_xferAck ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Trace And Analyse Interface
         --------------------------------------------------------------------------
         DBG_STOP             => Net_GND,
         VALID_INSTR          => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         PC_EX                => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         REG_WRITE            => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         REG_ADDR             => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         MSR_REG              => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         NEW_REG_VALUE        => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         PIPE_RUNNING         => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         INTERRUPT_TAKEN      => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         JUMP_TAKEN           => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         PREFETCH_ADDR        => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         Trace_Valid_Instr    => Open,                                                                                                     -- Remove If EDK 7.1
         MB_HALTED            => Open,

         -- Trace signals for real time hardware debugging
         Trace_Branch_Instr   => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         Trace_Delay_Slot       => Open,
         Trace_Data_Address     => Open,
         Trace_AS             => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         Trace_Data_Read        => Open,
         Trace_Data_Write       => Open,
         Trace_DCache_Req       => Open,
         Trace_DCache_Hit       => Open,
         Trace_ICache_Req       => Open,
         Trace_ICache_Hit       => Open,
         Trace_Instr_EX       => Open,                                                                                                     -- Remove If EDK 9.1 or Higher
         Trace_Instruction      => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_PC               => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Reg_Write        => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Reg_Addr         => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_MSR_Reg          => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_New_Reg_Value    => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Exception_Taken  => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Exception_Kind   => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Jump_Taken       => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Data_Access      => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Data_Write_Value => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_Data_Byte_Enable => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_OF_PipeRun       => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_EX_PipeRun       => Open,                                                                                                   -- Remove If EDK 7.1
         Trace_MEM_PipeRun      => Open,                                                                                                   -- Remove If EDK 7.1
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- Fast Simplex Link 0 (Not Used)
         --------------------------------------------------------------------------
         FSL0_S_CLK           => FSL_S_CLK_TimeBase_Signal    ,
         FSL0_S_READ          => FSL_S_READ_TimeBase_Signal   ,
         FSL0_S_DATA          => FSL_S_DATA_TimeBase_Signal   ,
         FSL0_S_CONTROL       => FSL_S_CONTROL_TimeBase_Signal,
         FSL0_S_EXISTS        => FSL_S_EXISTS_TimeBase_Signal ,

         FSL0_M_CLK           => FSL_M_CLK_TimeBase_Signal    ,
         FSL0_M_WRITE         => FSL_M_WRITE_TimeBase_Signal   ,
         FSL0_M_DATA          => FSL_M_DATA_TimeBase_Signal   ,
         FSL0_M_CONTROL       => FSL_M_CONTROL_TimeBase_Signal,
         FSL0_M_FULL          => FSL_M_FULL_TimeBase_Signal ,
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- Fast Simplex Link 1 (Not Used)
         --------------------------------------------------------------------------
         FSL1_S_CLK           => Open,
         FSL1_S_READ          => Open,
         FSL1_S_DATA          => Net_GND32,
         FSL1_S_CONTROL       => Net_GND,
         FSL1_S_EXISTS        => Net_GND,
         FSL1_M_CLK           => Open,
         FSL1_M_WRITE         => Open,
         FSL1_M_DATA          => Open,
         FSL1_M_CONTROL       => Open,
         FSL1_M_FULL          => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 2 (Not Used)
         --------------------------------------------------------------------------
         FSL2_S_CLK           => Open,
         FSL2_S_READ          => Open,
         FSL2_S_DATA          => Net_GND32,
         FSL2_S_CONTROL       => Net_GND,
         FSL2_S_EXISTS        => Net_GND,
         FSL2_M_CLK           => Open,
         FSL2_M_WRITE         => Open,
         FSL2_M_DATA          => Open,
         FSL2_M_CONTROL       => Open,
         FSL2_M_FULL          => Net_GND,
         --------------------------------------------------------------------------

         --------------------------------------------------------------------------
         -- Fast Simplex Link 3 (Not Used)
         --------------------------------------------------------------------------
         FSL3_S_CLK           => Open,
         FSL3_S_READ          => Open,
         FSL3_S_DATA          => Net_GND32,
         FSL3_S_CONTROL       => Net_GND,
         FSL3_S_EXISTS        => Net_GND,
         FSL3_M_CLK           => Open,
         FSL3_M_WRITE         => Open,
         FSL3_M_DATA          => Open,
         FSL3_M_CONTROL       => Open,
         FSL3_M_FULL          => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 4 (Not Used)
         --------------------------------------------------------------------------
         FSL4_S_CLK           => Open,
         FSL4_S_READ          => Open,
         FSL4_S_DATA          => Net_GND32,
         FSL4_S_CONTROL       => Net_GND,
         FSL4_S_EXISTS        => Net_GND,
         FSL4_M_CLK           => Open,
         FSL4_M_WRITE         => Open,
         FSL4_M_DATA          => Open,
         FSL4_M_CONTROL       => Open,
         FSL4_M_FULL          => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 5 (Not Used)
         --------------------------------------------------------------------------
         FSL5_S_CLK           => Open,
         FSL5_S_READ          => Open,
         FSL5_S_DATA          => Net_GND32,
         FSL5_S_CONTROL       => Net_GND,
         FSL5_S_EXISTS        => Net_GND,
         FSL5_M_CLK           => Open,
         FSL5_M_WRITE         => Open,
         FSL5_M_DATA          => Open,
         FSL5_M_CONTROL       => Open,
         FSL5_M_FULL          => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 6 (Not Used)
         --------------------------------------------------------------------------
         FSL6_S_CLK           => Open,
         FSL6_S_READ          => Open,
         FSL6_S_DATA          => Net_GND32,
         FSL6_S_CONTROL       => Net_GND,
         FSL6_S_EXISTS        => Net_GND,
         FSL6_M_CLK           => Open,
         FSL6_M_WRITE         => Open,
         FSL6_M_DATA          => Open,
         FSL6_M_CONTROL       => Open,
         FSL6_M_FULL          => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link 7 (Not Used)
         --------------------------------------------------------------------------
         FSL7_S_CLK           => Open,
         FSL7_S_READ          => Open,
         FSL7_S_DATA          => Net_GND32,
         FSL7_S_CONTROL       => Net_GND,
         FSL7_S_EXISTS        => Net_GND,
         FSL7_M_CLK           => Open,
         FSL7_M_WRITE         => Open,
         FSL7_M_DATA          => Open,
         FSL7_M_CONTROL       => Open,
         FSL7_M_FULL          => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link Instruction Cache (Not Used)
         --------------------------------------------------------------------------
         ICACHE_FSL_IN_CLK       => Open,
         ICACHE_FSL_IN_READ      => Open,
         ICACHE_FSL_IN_DATA      => Net_GND32,
         ICACHE_FSL_IN_CONTROL   => Net_GND,
         ICACHE_FSL_IN_EXISTS    => Net_GND,
         ICACHE_FSL_OUT_CLK      => Open,
         ICACHE_FSL_OUT_WRITE    => Open,
         ICACHE_FSL_OUT_DATA     => Open,
         ICACHE_FSL_OUT_CONTROL  => Open,
         ICACHE_FSL_OUT_FULL     => Net_GND,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         -- Fast Simplex Link Data Cache (Not Used)
         --------------------------------------------------------------------------
         DCACHE_FSL_IN_CLK       => Open,
         DCACHE_FSL_IN_READ      => Open,
         DCACHE_FSL_IN_DATA      => Net_GND32,
         DCACHE_FSL_IN_CONTROL   => Net_GND,
         DCACHE_FSL_IN_EXISTS    => Net_GND,
         DCACHE_FSL_OUT_CLK      => Open,
         DCACHE_FSL_OUT_WRITE    => Open,
         DCACHE_FSL_OUT_DATA     => Open,
         DCACHE_FSL_OUT_CONTROL  => Open,
         DCACHE_FSL_OUT_FULL     => Net_GND
         --------------------------------------------------------------------------
   ) ;
   -- -----------------------------------------------------------------------------

   -- -----------------------------------------------------------------------------
   -- TimeBase FSL Extension
   -- -----------------------------------------------------------------------------
   U_MicroBlase_TimeBase : MicroBlase_TimeBase
   Port Map
   (
     Clk         => CLK_I                ,
     Reset       => RST_I                ,

     FSL_S_Clk     => FSL_S_Clk_TimeBase_Signal           ,
     FSL_S_Read    => FSL_S_Read_TimeBase_Signal          ,
     FSL_S_Data    => FSL_S_Data_TimeBase_Signal          ,
     FSL_S_Control => FSL_S_Control_TimeBase_Signal       ,
     FSL_S_Exists  => FSL_S_Exists_TimeBase_Signal        ,

     FSL_M_Clk     => FSL_M_Clk_TimeBase_Signal           ,
     FSL_M_Data    => FSL_M_Data_TimeBase_Signal          ,
     FSL_M_Control => FSL_M_Control_TimeBase_Signal       ,
     FSL_M_Write   => FSL_M_Write_TimeBase_Signal         ,
     FSL_M_Full    => FSL_M_Full_TimeBase_Signal
   );
   -- -----------------------------------------------------------------------------


   -- -----------------------------------------------------------------------------    -- IncludeIf_OCDS
   SubPart_OCDS : ReplaceWith_OCDS                                                     -- IncludeIf_OCDS
   Port Map                                                                            -- IncludeIf_OCDS
   (                                                                                   -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         -- System interface                                                           -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         CLK_I          => CLK_I                ,                                      -- IncludeIf_OCDS
         RST_I          => RST_I                ,                                      -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         -- Nexus interface                                                            -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         TCK            => TCK                  ,                                      -- IncludeIf_OCDS
         TDI            => TDI                  ,                                      -- IncludeIf_OCDS
         TDO            => TDO                  ,                                      -- IncludeIf_OCDS
         TMS            => TMS                  ,                                      -- IncludeIf_OCDS
         TRST           => TRST                 ,                                      -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         -- MicroBlaze Interface                                                       -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         Dbg_Clk        => OCDS_Dbg_Clk         ,                                      -- IncludeIf_OCDS
         Dbg_TDI        => OCDS_Dbg_TDI         ,                                      -- IncludeIf_OCDS
         Dbg_TDO        => OCDS_Dbg_TDO         ,                                      -- IncludeIf_OCDS
         Dbg_Reg_En     => OCDS_Dbg_Reg_En      ,                                      -- IncludeIf_OCDS
         Dbg_Capture    => OCDS_Dbg_Capture     ,                                      -- IncludeIf_OCDS
         Dbg_Update     => OCDS_Dbg_Update      ,                                      -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         Debug_Sys_Rst  => OCDS_Debug_Sys_Rst_Sig ,                                    -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         -- MicroBlaze debug signals from JTAG_UART, will be gone in final version     -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         Debug_Rst      => OCDS_Debug_Rst       ,                                      -- IncludeIf_OCDS
         Ext_BRK        => OCDS_Ext_Brk         ,                                      -- IncludeIf_OCDS
         Ext_NM_BRK     => OCDS_Ext_NM_Brk      ,                                      -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         -- MicroBlaze Busses, will be gone in final version                           -- IncludeIf_OCDS
         --------------------------------------------------------------------------    -- IncludeIf_OCDS
         OPB_Clk        => CLK_I                ,                                      -- IncludeIf_OCDS
         OPB_Rst        => System_Reset         ,                                      -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         OPB_ABus       => Net_GND32            ,                                      -- IncludeIf_OCDS
         OPB_BE         => Net_GND4             ,                                      -- IncludeIf_OCDS
         OPB_DBus       => Net_GND32            ,                                      -- IncludeIf_OCDS
         OPB_RNW        => Net_GND              ,                                      -- IncludeIf_OCDS
         OPB_Select     => Net_GND              ,                                      -- IncludeIf_OCDS
                                                                                       -- IncludeIf_OCDS
         MDM_DBus       => Open                 ,                                      -- IncludeIf_OCDS
         MDM_errAck     => Open                 ,                                      -- IncludeIf_OCDS
         MDM_retry      => Open                 ,                                      -- IncludeIf_OCDS
         MDM_ToutSup    => Open                 ,                                      -- IncludeIf_OCDS
         MDM_xferAck    => Open                                                        -- IncludeIf_OCDS
         -----------------------------------------------------------------------       -- IncludeIf_OCDS
   ) ;                                                                                 -- IncludeIf_OCDS
   -- -----------------------------------------------------------------------------
   OCDS_Debug_Sys_Rst_Sig <= '0' ;                                                     -- ExcludeIf_OCDS
   -- -----------------------------------------------------------------------------    -- IncludeIf_OCDS
   Process(CLK_I)                                                                      -- IncludeIf_OCDS
   Begin                                                                               -- IncludeIf_OCDS
      If Rising_Edge(CLK_I) Then                                                       -- IncludeIf_OCDS
         If (RST_I='1') Then                                                           -- IncludeIf_OCDS
            OCDS_Debug_Sys_Rst <= '0' ;                                                -- IncludeIf_OCDS
         Else                                                                          -- IncludeIf_OCDS
            OCDS_Debug_Sys_Rst <= OCDS_Debug_Sys_Rst_Sig ;                             -- IncludeIf_OCDS
         End If ;                                                                      -- IncludeIf_OCDS
      End If ;                                                                         -- IncludeIf_OCDS
   End Process ;                                                                       -- IncludeIf_OCDS
   -- -----------------------------------------------------------------------------    -- IncludeIf_OCDS
   
   -- -----------------------------------------------------------------------------
   Process(CLK_I)
   Begin
      If Rising_Edge(CLK_I) Then
         If (RST_I='1') Or (OCDS_Debug_Sys_Rst='1') Then
            System_Reset_Counter <= "1111" ;
            System_Reset         <= '1' ;
         Else
            If System_Reset_Counter="0000" Then
               System_Reset         <= '0' ;
               System_Reset_Counter <= (Others=>'0') ;
            Else
               System_Reset_Counter <= System_Reset_Counter - 1 ;
               System_Reset         <= '1' ;
            End If ;
         End If ;
      End If ;
   End Process ;
   -- -----------------------------------------------------------------------------
   
   -- -----------------------------------------------------------------------------
   SubPart_BusController : MicroBlaze_BusController
   Port Map 
   (
         -----------------------------------------------------------------------------
         -----------------------------------------------------------------------------
         CLK_I             => CLK_I ,
         RST_I             => RST_I ,
         -----------------------------------------------------------------------------
         
         IntIn             => INT_I(31 Downto 0),
         IntOut            => Interrupt_Signal ,                                    
         
         -----------------------------------------------------------------------------
         -- Wishbone Interface
         -----------------------------------------------------------------------------
         IO_STB_O          => IO_STB_O ,
         IO_CYC_O          => IO_CYC_O ,
         IO_ACK_I          => IO_ACK_I ,
         IO_ADR_O          => IO_ADR_O ,
         IO_DAT_I          => IO_DAT_I ,
         IO_DAT_O          => IO_DAT_O ,
         IO_SEL_O          => IO_SEL_O ,
         IO_WE_O           => IO_WE_O  ,
         -----------------------------------------------------------------------------
         
         -----------------------------------------------------------------------------
         ME_STB_O          => ME_STB_O ,
         ME_CYC_O          => ME_CYC_O ,
         ME_ACK_I          => ME_ACK_I ,
         ME_ADR_O          => ME_ADR_O ,
         ME_DAT_I          => ME_DAT_I ,
         ME_DAT_O          => ME_DAT_O ,
         ME_SEL_O          => ME_SEL_O ,
         ME_WE_O           => ME_WE_O  ,
         -----------------------------------------------------------------------------
      
         --------------------------------------------------------------------------
         -- Internal Memory Interface
         --------------------------------------------------------------------------
         DBoot_DAT_I       => BusController_DBoot_Dat_I ,
         DBoot_ADR_O       => BusController_DBoot_Adr_O ,
         DBoot_DAT_O       => BusController_DBoot_Dat_O ,
         DBoot_SEL_O       => BusController_DBoot_Sel_O ,
         DBoot_STB_O       => BusController_DBoot_Stb_O ,
         DBoot_WE_O        => BusController_DBoot_We_O  ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         IBoot_DAT_I       => BusController_IBoot_Dat_I ,
         IBoot_ADR_O       => BusController_IBoot_Adr_O ,
         IBoot_STB_O       => BusController_IBoot_Stb_O ,
         --------------------------------------------------------------------------         

         --------------------------------------------------------------------------         
         -- MicroBlaze Interface
         --------------------------------------------------------------------------         
         MB_LIM_INSTR         => BusController_Instr        ,
         MB_LIM_IREADY        => BusController_IReady       ,
         MB_LIM_IWAIT         => BusController_IWait        ,
         MB_LIM_INSTR_ADDR    => BusController_InstrAddr    ,
         MB_LIM_IFETCH        => BusController_IFetch       ,
         MB_LIM_I_AS          => BusController_I_AS         ,
         MB_LIM_I_ADDRTAG     => BusController_I_AddrTag    ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         MB_LDM_DATA_READ     => BusController_DataRead     ,
         MB_LDM_DREADY        => BusController_DReady       ,
         MB_LDM_DWAIT         => BusController_DWait        ,
         MB_LDM_DATA_WRITE    => BusController_DataWrite    ,
         MB_LDM_DATA_ADDR     => BusController_DataAddr     ,
         MB_LDM_D_AS          => BusController_D_AS         ,
         MB_LDM_READ_STROBE   => BusController_ReadStrobe   ,
         MB_LDM_WRITE_STROBE  => BusController_WriteStrobe  ,
         MB_LDM_BYTE_ENABLE   => BusController_ByteEnable   ,
         MB_LDM_D_ADDRTAG     => BusController_D_AddrTag    ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         MB_EIM_IM_ABUS       => BusController_IM_ABus      ,
         MB_EIM_IM_BE         => BusController_IM_BE        ,
         MB_EIM_IM_BUSLOCK    => BusController_IM_BusLock   ,
         MB_EIM_IM_DBUS       => BusController_IM_DBus      ,
         MB_EIM_IM_REQUEST    => BusController_IM_Request   ,
         MB_EIM_IM_RNW        => BusController_IM_Rnw       ,
         MB_EIM_IM_SELECT     => BusController_IM_Select    ,
         MB_EIM_IM_SEQADDR    => BusController_IM_seqAddr   ,
         MB_EIM_IOPB_DBUS     => BusController_IOPB_DBus    ,
         MB_EIM_IOPB_ERRACK   => BusController_IOPB_errAck  ,
         MB_EIM_IOPB_MGRANT   => BusController_IOPB_MGrant  ,
         MB_EIM_IOPB_RETRY    => BusController_IOPB_Retry   ,
         MB_EIM_IOPB_TIMEOUT  => BusController_IOPB_TimeOut ,
         MB_EIM_IOPB_XFERACK  => BusController_IOPB_xferAck ,
         --------------------------------------------------------------------------
         
         --------------------------------------------------------------------------
         MB_EDM_DM_ABUS       => BusController_DM_ABus      , 
         MB_EDM_DM_BE         => BusController_DM_BE        , 
         MB_EDM_DM_BUSLOCK    => BusController_DM_BusLock   , 
         MB_EDM_DM_DBUS       => BusController_DM_DBus      , 
         MB_EDM_DM_REQUEST    => BusController_DM_Request   , 
         MB_EDM_DM_RNW        => BusController_DM_Rnw       , 
         MB_EDM_DM_SELECT     => BusController_DM_Select    , 
         MB_EDM_DM_SEQADDR    => BusController_DM_seqAddr   , 
         MB_EDM_DOPB_DBUS     => BusController_DOPB_DBus    , 
         MB_EDM_DOPB_ERRACK   => BusController_DOPB_errAck  , 
         MB_EDM_DOPB_MGRANT   => BusController_DOPB_MGrant  , 
         MB_EDM_DOPB_RETRY    => BusController_DOPB_Retry   ,
         MB_EDM_DOPB_TIMEOUT  => BusController_DOPB_TimeOut , 
         MB_EDM_DOPB_XFERACK  => BusController_DOPB_xferAck 
         --------------------------------------------------------------------------
   ) ;
   -- -----------------------------------------------------------------------------
   
   -- -----------------------------------------------------------------------------
   SubPart_BootMemory : Memory_ReplaceWith_Designator
   Port Map
   (
         -----------------------------------------------------------------------
         ADDRA        => BusController_IBoot_Adr_O(BootAddressWidth-1 Downto 0) ,
         ByteWEA      => Net_GND4                  ,
         CLKA         => CLK_I                     ,
         DINA         => Net_GND32                 ,
         DOUTA        => BusController_IBoot_Dat_I ,
         ENA          => BusController_IBoot_Stb_O ,
         WEA          => Net_GND                   ,

         ADDRB        => BusController_DBoot_Adr_O(BootAddressWidth-1 Downto 0) ,
         ByteWEB      => BusController_DBoot_Sel_O ,
         CLKB         => CLK_I                     ,
         DINB         => BusController_DBoot_Dat_O ,
         DOUTB        => BusController_DBoot_Dat_I ,
         ENB          => BusController_DBoot_Stb_O ,
         WEB          => BusController_DBoot_We_O
         -----------------------------------------------------------------------
   ) ;
   -- -----------------------------------------------------------------------------
   
   
-- -----------------------------------------------------------------------------
-- -----------------------------------------------------------------------------
-- -----------------------------------------------------------------------------
-- -----------------------------------------------------------------------------
-- -----------------------------------------------------------------------------
End Structure ;
-- -----------------------------------------------------------------------------











-- -----------------------------------------------------------------------------
-- Microblaze is Big-Endian, bit-reversed so data/address representation is
-- Bit Label         0 ............................... 31
-- Bit significance  Msb ............................ Lsb
-- -----------------------------------------------------------------------------
Library IEEE ;
Use     IEEE.Std_Logic_1164.All ;
Use     IEEE.Std_Logic_Unsigned.All ;
-- -----------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
Entity MicroBlaze_BusController Is
   Port 
   (
      -----------------------------------------------------------------------------
      -----------------------------------------------------------------------------
      CLK_I             : In  Std_Logic ;
      RST_I             : In  Std_Logic ;
      -----------------------------------------------------------------------------
      
      IntIn             : In  Std_Logic_Vector(31 Downto 0) ; 
      IntOut            : Out Std_Logic ;                                                    
      
      -----------------------------------------------------------------------------
      -- Wishbone Interface
      -----------------------------------------------------------------------------
      IO_STB_O          : Out Std_Logic ;
      IO_CYC_O          : Out Std_Logic ;
      IO_ACK_I          : In  Std_Logic ;
      IO_ADR_O          : Out Std_Logic_Vector(23 Downto 0) ;
      IO_DAT_I          : In  Std_Logic_Vector(31 Downto 0) ;
      IO_DAT_O          : Out Std_Logic_Vector(31 Downto 0) ;
      IO_SEL_O          : Out Std_Logic_Vector( 3 Downto 0) ;
      IO_WE_O           : Out Std_Logic ;
      -----------------------------------------------------------------------------
      
      -----------------------------------------------------------------------------
      ME_STB_O          : Out Std_Logic ;
      ME_CYC_O          : Out Std_Logic ;
      ME_ACK_I          : In  Std_Logic ;
      ME_ADR_O          : Out Std_Logic_Vector(31 Downto 0) ;
      ME_DAT_I          : In  Std_Logic_Vector(31 Downto 0) ;
      ME_DAT_O          : Out Std_Logic_Vector(31 Downto 0) ;
      ME_SEL_O          : Out Std_Logic_Vector( 3 Downto 0) ;
      ME_WE_O           : Out Std_Logic ;
      -----------------------------------------------------------------------------
   
      --------------------------------------------------------------------------
      -- Internal Memory Interface
      --------------------------------------------------------------------------
      DBoot_DAT_I       : In  Std_Logic_Vector(31 DownTo 0) ;
      DBoot_ADR_O       : Out Std_Logic_Vector(21 DownTo 0) ;
      DBoot_DAT_O       : Out Std_Logic_Vector(31 DownTo 0) ;
      DBoot_SEL_O       : Out Std_Logic_Vector( 3 DownTo 0) ;
      DBoot_STB_O       : Out Std_Logic ;
      DBoot_WE_O        : Out Std_Logic ;
      --------------------------------------------------------------------------
      
      --------------------------------------------------------------------------
      IBoot_DAT_I       : In  Std_Logic_Vector(31 DownTo 0) ;
      IBoot_ADR_O       : Out Std_Logic_Vector(21 DownTo 0) ;
      IBoot_STB_O       : Out Std_Logic ;
      --------------------------------------------------------------------------         

      --------------------------------------------------------------------------         
      -- MicroBlaze Interface
      -- LIM - Local Instrucion Memory
      -- LDM - Local Data Memory
      -- EIM - External Instruction Memory
      -- EDM - External Data Memory
      --------------------------------------------------------------------------         
      MB_LIM_INSTR         : Out Std_Logic_Vector(0 To 31) ;
      MB_LIM_IREADY        : Out Std_Logic ;
      MB_LIM_IWAIT         : Out Std_Logic ;
      MB_LIM_INSTR_ADDR    : In  Std_Logic_Vector(0 To 31) ;
      MB_LIM_IFETCH        : In  Std_Logic ;
      MB_LIM_I_AS          : In  Std_Logic ;
      MB_LIM_I_ADDRTAG     : In  Std_Logic_Vector(0 To 3 ) ;
      --------------------------------------------------------------------------
      
      --------------------------------------------------------------------------
      MB_LDM_DATA_READ     : Out Std_Logic_Vector(0 To 31) ;
      MB_LDM_DREADY        : Out Std_Logic ;
      MB_LDM_DWAIT         : Out Std_Logic ;
      MB_LDM_DATA_WRITE    : In  Std_Logic_Vector(0 To 31) ;
      MB_LDM_DATA_ADDR     : In  Std_Logic_Vector(0 To 31) ;
      MB_LDM_D_AS          : In  Std_Logic ;
      MB_LDM_READ_STROBE   : In  Std_Logic ;
      MB_LDM_WRITE_STROBE  : In  Std_Logic ;
      MB_LDM_BYTE_ENABLE   : In  Std_Logic_Vector(0 To  3) ;
      MB_LDM_D_ADDRTAG     : In  Std_Logic_Vector(0 To  3) ;
      --------------------------------------------------------------------------

      --------------------------------------------------------------------------
      MB_EIM_IM_ABUS       : In  Std_Logic_Vector(0 To 31) ;
      MB_EIM_IM_BE         : In  Std_Logic_Vector(0 To  3) ;
      MB_EIM_IM_BUSLOCK    : In  Std_Logic ;
      MB_EIM_IM_DBUS       : In  Std_Logic_Vector(0 To 31) ;
      MB_EIM_IM_REQUEST    : In  Std_Logic ;
      MB_EIM_IM_RNW        : In  Std_Logic ;
      MB_EIM_IM_SELECT     : In  Std_Logic ;
      MB_EIM_IM_SEQADDR    : In  Std_Logic ;
      
      MB_EIM_IOPB_DBUS     : Out Std_Logic_Vector(0 To 31) ;
      MB_EIM_IOPB_ERRACK   : Out Std_Logic ;
      MB_EIM_IOPB_MGRANT   : Out Std_Logic ;
      MB_EIM_IOPB_RETRY    : Out Std_Logic ;
      MB_EIM_IOPB_TIMEOUT  : Out Std_Logic ;
      MB_EIM_IOPB_XFERACK  : Out Std_Logic ;
      --------------------------------------------------------------------------
      
      --------------------------------------------------------------------------
      MB_EDM_DM_ABUS       : In  Std_Logic_Vector(0 To 31) ;
      MB_EDM_DM_BE         : In  Std_Logic_Vector(0 To  3) ;
      MB_EDM_DM_BUSLOCK    : In  Std_Logic ;
      MB_EDM_DM_DBUS       : In  Std_Logic_Vector(0 To 31) ;
      MB_EDM_DM_REQUEST    : In  Std_Logic ;
      MB_EDM_DM_RNW        : In  Std_Logic ;
      MB_EDM_DM_SELECT     : In  Std_Logic ;
      MB_EDM_DM_SEQADDR    : In  Std_Logic ;
      
      MB_EDM_DOPB_DBUS     : Out Std_Logic_Vector(0 To 31) ;
      MB_EDM_DOPB_ERRACK   : Out Std_Logic ;
      MB_EDM_DOPB_MGRANT   : Out Std_Logic ;
      MB_EDM_DOPB_RETRY    : Out Std_Logic ;
      MB_EDM_DOPB_TIMEOUT  : Out Std_Logic ;
      MB_EDM_DOPB_XFERACK  : Out Std_Logic
      --------------------------------------------------------------------------

   ) ;
End MicroBlaze_BusController ;
-- -----------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
Architecture RTL Of MicroBlaze_BusController Is

   Component opb_intc_0_wrapper
      Port
      (
         OPB_Clk        : In  Std_Logic ;
         Intr           : In  Std_Logic_Vector(31 Downto 0) ;
         OPB_Rst        : In  Std_Logic ;
         OPB_ABus       : In  Std_Logic_Vector(0 To 31) ;
         OPB_BE         : In  Std_Logic_Vector(0 To 3) ;
         OPB_RNW        : In  Std_Logic ;
         OPB_Select     : In  Std_Logic ;
         OPB_seqAddr    : In  Std_Logic ;
         OPB_DBus       : In  Std_Logic_Vector(0 To 31) ;
         IntC_DBus      : Out Std_Logic_Vector(0 To 31) ;
         IntC_errAck    : Out Std_Logic ;
         IntC_retry     : Out Std_Logic ;
         IntC_toutSup   : Out Std_Logic ;
         IntC_xferAck   : Out Std_Logic ;
         Irq            : Out Std_Logic
      ) ;
   End Component ;

   Component opb_timer_1_wrapper
   Port
   (
      OPB_Clk      : In  Std_Logic;
      OPB_Rst      : In  Std_Logic;                   
      OPB_ABus     : In  Std_Logic_Vector(0 To 31);   
      OPB_BE       : In  Std_Logic_Vector(0 To 3);    
      OPB_DBus     : In  Std_Logic_Vector(0 To 31);   
      OPB_RNW      : In  Std_Logic;                   
      OPB_Select   : In  Std_Logic;                   
      OPB_seqAddr  : In  Std_Logic;                   
      TC_DBus      : Out Std_Logic_Vector(0 To 31);   
      TC_errAck    : Out Std_Logic;                   
      TC_retry     : Out Std_Logic;                   
      TC_toutSup   : Out Std_Logic;                   
      TC_xferAck   : Out Std_Logic;                   
      CaptureTrig0 : In  Std_Logic;                   
      CaptureTrig1 : In  Std_Logic;                   
      GenerateOut0 : Out Std_Logic;                   
      GenerateOut1 : Out Std_Logic;                   
      PWM0         : Out Std_Logic;                   
      Interrupt    : Out Std_Logic;                   
      Freeze       : In  Std_Logic
   );                                                 
   End Component ;

   Type TStateIO Is    ( IO_Idle,
                         IO_WaitForAck
                       ) ;
   Signal StateIO      : TStateIO ;
   Signal StateIO_Next : TStateIO ;
   
   
   Type TStateME Is    ( ME_Idle ,
                         ME_WaitForDMemACK ,
                         ME_WaitForIMemACK
                       ) ;
   Signal StateME      : TStateME ;
   Signal StateME_Next : TStateME ;



   -- Block RAM interface
   Signal IsInternalInstrMemory     : Std_Logic ;
   Signal IsInternalDataMemory      : Std_Logic ;
   Signal InternalMemory_DataStrobe : Std_Logic ;
   Signal InternalMemory_InstStrobe : Std_Logic ;
   
   -- Wishbone interface
   Signal IsOpbDataInternalMemory   : Std_Logic ;
   Signal IsOpbDataPeripheralMemory : Std_Logic ;
   Signal IsOpbInstInternalMemory   : Std_Logic ;
   Signal IsOpbInstPeripheralMemory : Std_Logic ;
   Signal IsPeripheral              : Std_Logic ;
   Signal IsDataMemory              : Std_Logic ;
   Signal IsInstMemory              : Std_Logic ;
   
   Signal Start_IO                  : Std_Logic ;
   Signal Peripheral_ACK            : Std_Logic ;
   
   Signal Start_ME_Data             : Std_Logic ;
   Signal Start_ME_Inst             : Std_Logic ;
   Signal Start_ME                  : Std_Logic ;
   Signal WishboneDone_Main         : Std_Logic ;
   Signal MainMemoryIsData          : Std_Logic ;
   Signal MainMemory_DAck           : Std_Logic ;
   Signal MainMemory_IAck           : Std_Logic ;
   
   Signal TimeOut_IO                : Std_Logic ;
   Signal TimeOut_IO_Counter        : Std_Logic_Vector(12 Downto 0) ;
   Signal WishboneIO_Running        : Std_Logic ;
   Signal TimeOut_ME                : Std_Logic ;
   Signal TimeOut_ME_Counter        : Std_Logic_Vector(12 Downto 0) ;
   Signal WishboneME_Running        : Std_Logic ;
   
   Signal IsIntController           : Std_Logic ;
   Signal IsTimer                   : Std_Logic ;
   
   Signal OPB_ABus_Signal           : Std_Logic_Vector(0 To 31) ;
   Signal OPB_BE_Signal             : Std_Logic_Vector(0 To 3) ;
   Signal OPB_RNW_Signal               : Std_Logic ;
   Signal OPB_seqAddr_Signal        : Std_Logic ;
   Signal OPB_DBus_Signal           : Std_Logic_Vector(0 To 31) ;
   Signal OPB_Select_Signal         : Std_Logic ;
   Signal OPB_Select_Timer_Signal     : Std_Logic ;
                                    
   Signal IntC_DBus_Signal          : Std_Logic_Vector(0 To 31) ;
   Signal IntC_errAck_Signal        : Std_Logic ;
   Signal IntC_retry_Signal         : Std_Logic ;
   Signal IntC_toutSup_Signal       : Std_Logic ;
   Signal IntC_xferAck_Signal       : Std_Logic ;
   Signal IntC_Acknowledge_Signal   : Std_Logic ;
   
   Signal TC_DBus_Signal            : Std_Logic_Vector(0 To 31);
   Signal TC_errAck_Signal          : Std_Logic;
   Signal TC_retry_Signal           : Std_Logic;
   Signal TC_toutSup_Signal         : Std_Logic;
   Signal TC_xferAck_Signal         : Std_Logic;
   Signal TC_Acknowledge_Signal     : Std_Logic;
   Signal PWM0_Signal               : Std_Logic;
   Signal TC_Interrupt_Signal       : Std_Logic;
   Signal Freeze_Signal             : Std_Logic;
   
   Signal CaptureTrig0_Signal       : Std_Logic;
   Signal CaptureTrig1_Signal       : Std_Logic;
   Signal GenerateOut0_Signal       : Std_Logic;
   Signal GenerateOut1_Signal       : Std_Logic;

   Signal Intr_Signal               : Std_Logic_Vector(31 Downto 0);
-- -----------------------------------------------------------------------------
Begin

   -- -----------------------------------------------------------------------------
   -- Xilinx Interrupt Controller
   -- -----------------------------------------------------------------------------
   
   OPB_ABus_Signal      <= MB_EDM_DM_ABUS    ;
   OPB_BE_Signal        <= MB_EDM_DM_BE      ;
   OPB_RNW_Signal       <= MB_EDM_DM_RNW     ;
   OPB_Select_Signal    <= MB_EDM_DM_SELECT When IsIntController='1' Else '0' ;
   OPB_SeqAddr_Signal   <= MB_EDM_DM_SEQADDR ;
   OPB_DBus_Signal      <= MB_EDM_DM_DBUS    ;
   
   IntC_Acknowledge_Signal <= IntC_xferAck_Signal When IsIntController='1' Else '0' ; 
   
   Intr_Signal <= IntIn(31 Downto 1) & TC_Interrupt_Signal ;
   U_InterruptController : opb_intc_0_wrapper      
   Port Map                                        
   (                                               
      OPB_Clk        => CLK_I                ,
      Intr           => Intr_Signal          ,     
      OPB_Rst        => RST_I                ,     
      OPB_ABus       => OPB_ABus_Signal      ,     
      OPB_BE         => OPB_BE_Signal        ,     
      OPB_RNW        => OPB_RNW_Signal       ,     
      OPB_Select     => OPB_Select_Signal    ,     
      OPB_seqAddr    => OPB_SeqAddr_Signal   ,     
      OPB_DBus       => OPB_DBus_Signal      ,     
         
      IntC_DBus      => IntC_DBus_Signal     ,     
      IntC_errAck    => IntC_errAck_Signal   ,     
      IntC_retry     => IntC_retry_Signal    ,     
      IntC_toutSup   => IntC_toutSup_Signal  ,     
      IntC_xferAck   => IntC_xferAck_Signal  ,     
      Irq            => IntOut                     
   ) ;                                             
   -- -----------------------------------------------------------------------------   

   -- -----------------------------------------------------------------------------   
   -- Xilinx Timer
   -- -----------------------------------------------------------------------------   

   OPB_Select_Timer_Signal <= MB_EDM_DM_SELECT  When IsTimer='1' Else '0'; 
   TC_Acknowledge_Signal   <= TC_xferAck_Signal When IsTimer='1' Else '0'; 
   

   U_Timer : opb_timer_1_wrapper                   
   Port Map                                        
   (                                               
      OPB_Clk      => CLK_I,                       
      OPB_Rst      => RST_I,                       
      OPB_ABus     => OPB_ABus_Signal,             
      OPB_BE       => OPB_BE_Signal,               
      OPB_DBus     => OPB_DBus_Signal,             
      OPB_RNW      => OPB_RNW_Signal,              
      OPB_Select   => OPB_Select_Timer_Signal,     
      OPB_seqAddr  => OPB_SeqAddr_Signal,          
      TC_DBus      => TC_DBus_Signal,              
      TC_errAck    => TC_errAck_Signal,            
      TC_retry     => TC_retry_Signal,             
      TC_toutSup   => TC_toutSup_Signal,           
      TC_xferAck   => TC_xferAck_Signal,
      CaptureTrig0 => CaptureTrig0_Signal,         
      CaptureTrig1 => CaptureTrig1_Signal,         
      GenerateOut0 => GenerateOut0_Signal,         
      GenerateOut1 => GenerateOut1_Signal,         
      PWM0         => PWM0_Signal,                 
      Interrupt    => TC_Interrupt_Signal,         
      Freeze       => Freeze_Signal                
   );                                              

   Freeze_Signal       <= '0';
   CaptureTrig0_Signal <= '0';
   CaptureTrig1_Signal <= '0';

   -- -----------------------------------------------------------------------------
   IsInternalInstrMemory <= '1' When MB_LIM_INSTR_ADDR(0 To 7) = x"00" Else '0' ;
   IsInternalDataMemory  <= '1' When MB_LDM_DATA_ADDR(0 To 7)  = x"00" Else '0' ;
   -- -----------------------------------------------------------------------------
   -- Internal memory interface.
   -- At this point we follow Xilinx implementation as safe option.
   -- We need to check if we could implement this interface to run at full speed
   -- as pure single clock operation
   -- -----------------------------------------------------------------------------

   InternalMemory_DataStrobe <= IsInternalDataMemory  And ( MB_LDM_READ_STROBE Or MB_LDM_WRITE_STROBE ) ;
   InternalMemory_InstStrobe <= IsInternalInstrMemory And   MB_LIM_IFETCH ;

   DBoot_ADR_O <= MB_LDM_DATA_ADDR(8 To 29)  ;
   DBoot_DAT_O <= MB_LDM_DATA_WRITE          ;
   DBoot_SEL_O <= MB_LDM_BYTE_ENABLE         ;
   DBoot_STB_O <= InternalMemory_DataStrobe  ;
   DBoot_WE_O  <= MB_LDM_WRITE_STROBE        ;
   
   IBoot_ADR_O <= MB_LIM_INSTR_ADDR(8 To 29) ;
   IBoot_STB_O <= InternalMemory_InstStrobe  ;

   -- -----------------------------------------------------------------------------
   -- Acknowledge to MicroBlaze
   -- -----------------------------------------------------------------------------
   Process(CLK_I)
   Begin
      If Rising_Edge(CLK_I) Then
         If (RST_I='1') Then
            MB_LDM_DREADY <= '0' ;
            MB_LIM_IREADY <= '0' ;
         Else
            MB_LDM_DREADY <= IsInternalDataMemory  And MB_LDM_D_AS ;
            MB_LIM_IREADY <= IsInternalInstrMemory And MB_LIM_I_AS ;
         End If ;
      End If ;
   End Process ;
   
   MB_LIM_IWAIT     <= '0' ;
   MB_LIM_INSTR     <= IBoot_DAT_I ;
   MB_LDM_DWAIT     <= '0' ;
   MB_LDM_DATA_READ <= DBoot_DAT_I ;
   -- -----------------------------------------------------------------------------

   -- -----------------------------------------------------------------------------
   -- Wishbone Bus Part
   --    Peripheral side.
   --       Only Data interface can drive Peripheral side so we need to decode 
   --       when the address is in range 0xFF00_0000 to 0xFFFF_FFFF and redirect 
   --       transfer to Wishbone IO bus
   --    Memory side.
   --       Both Data and Instruction interfaces can access Wishbone ME bus
   --       When Both are trying to access external memory, Data is first and
   --       Instruction second.
   --       
   --    Instruction Memory: 0x0100_0000 up to 0xFEFF_FFFF
   --    Data Memory       : 0x0100_0000 up to 0xFEFF_FFFF
   --    Peripheral        : 0xFF00_0000 up to 0xFFFF_FFFF
   --
   -- -----------------------------------------------------------------------------
   IsOpbDataInternalMemory   <= '1' When (MB_EDM_DM_ABUS(0 To 7)=x"00") Else '0' ;
   IsOpbDataPeripheralMemory <= '1' When (MB_EDM_DM_ABUS(0 To 7)=x"FF") Else '0' ;
   IsOpbInstInternalMemory   <= '1' When (MB_EIM_IM_ABUS(0 To 7)=x"00") Else '0' ;
   IsOpbInstPeripheralMemory <= '1' When (MB_EIM_IM_ABUS(0 To 7)=x"FF") Else '0' ;
   
   IsIntController <= '1' When (MB_EDM_DM_ABUS(0 To 23)=x"FFFFFF") Else '0' ; 
   IsTimer         <= '1' When (MB_EDM_DM_ABUS(0 To 23)=x"FFFFFE") Else '0' ; 


   IsPeripheral <= Not (IsIntController Or IsTimer)        And     IsOpbDataPeripheralMemory ;
   IsDataMemory <= Not IsOpbDataInternalMemory And Not IsOpbDataPeripheralMemory ;
   IsInstMemory <= Not IsOpbInstInternalMemory And Not isOpbInstPeripheralMemory ;



   -- -----------------------------------------------------------------------------
   -- Wishbone IO controller FSM
   -- -----------------------------------------------------------------------------
   IO_ADR_O <= MB_EDM_DM_ABUS(8 To 31)    ;
   IO_DAT_O <= MB_EDM_DM_DBUS    ;
   IO_SEL_O <= MB_EDM_DM_BE      ;
   IO_WE_O  <= Not MB_EDM_DM_RNW ;
   -- -----------------------------------------------------------------------------

   -- -----------------------------------------------------------------------------
   Start_IO     <= IsPeripheral And MB_EDM_DM_SELECT ;
   -- -----------------------------------------------------------------------------
   WishboneFSM_IO_Combinatorial:
   Process( StateIO     ,
            Start_IO    ,
            TimeOut_IO  ,
            IO_ACK_I )
   Begin
      -- Defaults
      IO_STB_O           <= '0' ;
      IO_CYC_O           <= '0' ;
      StateIO_Next       <= StateIO ;
      Peripheral_ACK     <= '0' ;
      WishboneIO_Running <= '0' ;

      Case StateIO Is
         When  IO_Idle =>
               If Start_IO='1' Then
                  IO_STB_O     <= '1' ;
                  IO_CYC_O     <= '1' ;
                  StateIO_Next <= IO_WaitForACK ;
               End If ;
               
         When  IO_WaitForACK =>
               IO_STB_O <= '1' ;
               IO_CYC_O <= '1' ;
               WishboneIO_Running <= '1' ;
               If (IO_ACK_I='1' Or TimeOut_IO='1' )Then
                  StateIO_Next   <= IO_Idle ;
                  Peripheral_ACK <= '1' ;
               Else
                  IO_STB_O <= '1' ;
                  IO_CYC_O <= '1' ;                  
               End If ;
               
         When  Others =>
               StateIO_Next <= IO_Idle ;
      End Case ;
   End Process ;
   -- -----------------------------------------------------------------------------
   
   -- -----------------------------------------------------------------------------
   WishboneFSM_IO_Registered:
   Process(CLK_I)
   Begin
      If Rising_Edge(CLK_I) Then
         If RST_I='1' Then
            StateIO <= IO_Idle ;
         Else
            StateIO <= StateIO_Next ;
         End If ;
      End If ;
   End Process ;
   -- -----------------------------------------------------------------------------

   -- -----------------------------------------------------------------------------
   -- Wishbone ME controller FSM
   -- -----------------------------------------------------------------------------
   Start_ME_Data <= IsDataMemory  And MB_EDM_DM_SELECT ;
   Start_ME_Inst <= IsInstMemory  And MB_EIM_IM_SELECT ;
   Start_ME      <= Start_ME_Data Or  Start_ME_Inst    ;
   
   -- -----------------------------------------------------------------------------
   SetupME_Outputs:
   Process( Start_ME          ,
            WishboneDone_Main ,
            MB_EDM_DM_DBUS    ,
            MainMemoryIsData  ,
            MB_EDM_DM_ABUS    ,
            MB_EDM_DM_BE      ,
            MB_EDM_DM_RNW     ,
            MB_EIM_IM_ABUS
            )
   Begin
      ME_STB_O <= Start_ME And (Not WishboneDone_Main) ;
      ME_CYC_O <= Start_ME And (Not WishboneDone_Main) ;
      ME_DAT_O <= MB_EDM_DM_DBUS ;
      
      If MainMemoryIsData='1' Then
         ME_ADR_O <=     MB_EDM_DM_ABUS ;
         ME_SEL_O <=     MB_EDM_DM_BE   ;
         ME_WE_O  <= Not MB_EDM_DM_RNW  ;
      Else
         ME_ADR_O <=     MB_EIM_IM_ABUS ;
         ME_SEL_O <=     "1111"         ;
         ME_WE_O  <=     '0'            ;
      End If ;
   End Process ;
   -- -----------------------------------------------------------------------------
   
   -- -----------------------------------------------------------------------------
   WishboneFSM_ME_Combinatorial:
   Process ( StateME       ,
             Start_ME      ,
             TimeOut_ME    ,
             Start_ME_Inst ,
             Start_ME_Data ,
             ME_ACK_I
           )
   Begin
      -- Defaults
      MainMemoryIsData   <= '0' ;
      StateME_Next       <= StateME ;
      MainMemory_DAck    <= '0' ;
      MainMemory_IAck    <= '0' ;
      WishboneDone_Main  <= '0' ;
      WishboneME_Running <= '0' ;
      
      Case StateME Is
         When  ME_Idle =>
               If    Start_ME_Data='1' Then
                  MainMemoryIsData <= '1' ;
                  StateME_Next     <= ME_WaitForDMemAck ;
               ElsIf Start_ME_Inst='1' Then
                  StateME_Next     <= ME_WaitForIMemAck ;
               End If ;
               
         When  ME_WaitForDMemACK =>
               MainMemoryIsData <= '1' ;
               WishboneME_Running <= '1' ;
               If (ME_ACK_I='1') Or (TimeOut_ME='1') Then
                  MainMemory_DAck <= '1' ;
                  If Start_ME_Inst='1' Then
                     StateME_Next <= ME_WaitForIMemAck ;
                     WishboneME_Running <= '0' ;
                  Else
                     WishboneDone_Main <= '1' ;
                     StateME_Next <= ME_Idle ;
                  End If ;
               End If ;
         
         When  ME_WaitForIMemACK =>
               WishboneME_Running <= '1' ;
               If (ME_ACK_I='1') Or (TimeOut_ME='1') Then
                  MainMemory_IAck <= '1' ;
                  StateME_Next   <= ME_Idle ;
                  WishboneDone_Main <= '1' ;
               End If ;
         
         When  Others =>
               StateME_Next <= ME_Idle ;
      End Case ;
   End Process ;
   -- -----------------------------------------------------------------------------

   -- -----------------------------------------------------------------------------
   WishboneFSM_ME_Registered:
   Process (CLK_I)
   Begin
      If Rising_Edge(CLK_I) Then
         If (RST_I='1') Then
            StateME <= ME_Idle ;
         Else
            StateME <= StateME_Next ;
         End If ;
      End If ;
   End Process ;
   -- -----------------------------------------------------------------------------


   -- -----------------------------------------------------------------------------
   MB_EIM_IOPB_DBUS    <=  ME_DAT_I When MainMemory_IAck='1' Else (Others=>'0') ;
   MB_EIM_IOPB_ERRACK  <=  '0' ;
   MB_EIM_IOPB_MGRANT  <=  '1' ;
   MB_EIM_IOPB_RETRY   <=  '0' ;
   MB_EIM_IOPB_TIMEOUT <=  '0' ;
   MB_EIM_IOPB_XFERACK <=  MainMemory_IAck ;
   -- -----------------------------------------------------------------------------

   -- -----------------------------------------------------------------------------
   MB_EDM_DOPB_DBUS    <=  ME_DAT_I         When MainMemory_DAck  ='1' Else 
                           IO_DAT_I         When Peripheral_Ack   ='1' Else
                           IntC_DBus_Signal When IsIntController  ='1' Else   
                           TC_DBus_Signal   When IsTimer          ='1' Else
                           (Others=>'0') ;
   MB_EDM_DOPB_ERRACK  <= '0' ;
   MB_EDM_DOPB_MGRANT  <= '1' ;
   MB_EDM_DOPB_RETRY   <= '0' ;
   MB_EDM_DOPB_TIMEOUT <= '0' ;
   MB_EDM_DOPB_XFERACK <= MainMemory_DAck Or Peripheral_Ack Or IntC_Acknowledge_Signal Or TC_Acknowledge_Signal;
   -- -----------------------------------------------------------------------------


   -- -----------------------------------------------------------------------------
   TimeOutCounter_IO:
   Process(CLK_I, TimeOut_IO_Counter)
   Begin
      If Rising_Edge(CLK_I) Then
         If (RST_I='1') Or (WishboneIO_Running='0') Then
            TimeOut_IO_Counter <= (Others=>'0') ;
         Else
            TimeOut_IO_Counter <= TimeOut_IO_Counter + 1 ;
         End If ;
      End if ;
      
      TimeOut_IO <= TimeOut_IO_Counter(12) ;
   End Process ;
   -- -----------------------------------------------------------------------------


   -- -----------------------------------------------------------------------------
   TimeOutCounter_ME:
   Process(CLK_I, TimeOut_ME_Counter)
   Begin
      If Rising_Edge(CLK_I) Then
         If (RST_I='1') Or (WishboneME_Running='0') Then
            TimeOut_ME_Counter <= (Others=>'0') ;
         Else
            TimeOut_ME_Counter <= TimeOut_ME_Counter + 1 ;
         End If ;
      End if ;
      
      TimeOut_ME <= TimeOut_ME_Counter(12) ;
   End Process ;
   
   -- -----------------------------------------------------------------------------


-- -----------------------------------------------------------------------------
End RTL ;
-- -----------------------------------------------------------------------------



--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.all;
Use IEEE.Std_Logic_Unsigned.All;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity MicroBlase_TimeBase Is Port
    (
        -- Global signals
        Clk   : In Std_Logic;
        Reset : In Std_Logic;

        -- Slave FSL Signals
        FSL_S_Clk     : In Std_Logic;
        FSL_S_Read    : In Std_Logic;
        FSL_S_Data    : Out Std_Logic_Vector(0 to 31);
        FSL_S_Control : Out Std_Logic;
        FSL_S_Exists  : Out Std_Logic;

        -- Master FSL Signals
        FSL_M_Clk     : In  Std_Logic;
        FSL_M_Write   : In  Std_Logic;
        FSL_M_Data    : In  Std_Logic_Vector(0 to 31);
        FSL_M_Control : In  Std_Logic;
        FSL_M_Full    : Out Std_Logic
    );
End MicroBlase_TimeBase;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture RTL Of MicroBlase_TimeBase Is
   Signal    TimerRegister_Count             : Std_Logic_Vector(63 DownTo 0);   -- Generic clock counter
   Signal    TimerRegister_Lo                : Std_Logic_Vector(31 DownTo 0);
   Signal    TimerRegister_Transfer          : Std_Logic_Vector(31 DownTo 0);
Begin
    ----------------------------------------------------------------------------
    -- 64-bit counter - always counts on every clock.
    Process(Clk)
    Begin
        If Rising_Edge(Clk) Then
           If Reset = '1' Then
              TimerRegister_Count    <= (Others => '0');
           Else
              TimerRegister_Count <= TimerRegister_Count + 1;
           End If;
       End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process (CLK)
    Begin
        If Rising_Edge(CLK) Then
           If Reset = '1' Then
              TimerRegister_Lo       <= (Others => '0');
              TimerRegister_Transfer <= (Others => '0');
           Else
               If (FSL_M_Write = '1') Then
                    If (FSL_M_Control='1') Then
                        TimerRegister_Lo       <= TimerRegister_Count(31 Downto 0);
                        TimerRegister_Transfer <= TimerRegister_Count(63 Downto 32);
                    Else
                        TimerRegister_Transfer <= TimerRegister_Lo;
                    End If;
               End If;
           End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    FSL_S_Data <= TimerRegister_Transfer; --We read this using get Rx, FSL0

    FSL_M_Full    <= '0';
    FSL_S_Exists  <= '1';
    FSL_S_Control <= '0';
End RTL;
--------------------------------------------------------------------------------




