--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
    Port
    (
        WBS_STB_I       : in    std_logic;
        WBS_CYC_I       : in    std_logic;
        WBS_ACK_O       : out   std_logic;
        WBS_ADR_I       : in    std_logic_vector(4 downto 0);
        WBS_DAT_O       : out   std_logic_vector(31 downto 0);
        WBS_DAT_I       : in    std_logic_vector(31 downto 0);
        WBS_WE_I        : in    std_logic;
        WBS_CLK_I       : in    std_logic;
        WBS_RST_I       : in    std_logic;
        WBS_INT_O       : out   std_logic;

        WBM_STB_O       : out   std_logic;
        WBM_CYC_O       : out   std_logic;
        WBM_ACK_I       : in    std_logic;
        WBM_ADR_O       : out   std_logic_vector(ReplaceWith_AddressWidth-1 downto 0);
        WBM_DAT_I       : in    std_logic_vector(31 downto 0);
        WBM_DAT_O       : out   std_logic_vector(31 downto 0);
        WBM_SEL_O       : out   std_logic_vector(3 downto 0);
        WBM_WE_O        : out   std_logic;

        PHY_TXD         : out   std_logic_vector(3 downto 0);
        PHY_TXEN        : out   std_logic;
        PHY_TXC         : in    std_logic;
        PHY_RXD         : in    std_logic_vector(3 downto 0);
        PHY_RXDV        : in    std_logic;
        PHY_RXER        : in    std_logic;
        PHY_RXC         : in    std_logic;
        PHY_COL         : in    std_logic;
        PHY_CRS         : in    std_logic;
        PHY_RESETB      : out   std_logic;
        PHY_MDC         : out   std_logic;
        PHY_MDOE        : out   std_logic;
        PHY_MDO         : out   std_logic;
        PHY_MDI         : in    std_logic;
        CLK_MD          : in    std_logic
    );
End Configurable_ReplaceWith_Designator;

Architecture RTL Of Configurable_ReplaceWith_Designator Is
    Component ReplaceWith_EMAC32_TYPE Is
        port
        (
            WBS_STB_I       : in    std_logic;
            WBS_CYC_I       : in    std_logic;
            WBS_ACK_O       : out   std_logic;
            WBS_ADR_I       : in    std_logic_vector(4 downto 0);
            WBS_DAT_O       : out   std_logic_vector(31 downto 0);
            WBS_DAT_I       : in    std_logic_vector(31 downto 0);
            WBS_WE_I        : in    std_logic;
            WBS_CLK_I       : in    std_logic;
            WBS_RST_I       : in    std_logic;
            WBS_INT_O       : out   std_logic;
    
            WBM_STB_O       : out   std_logic;
            WBM_CYC_O       : out   std_logic;
            WBM_ACK_I       : in    std_logic;
            WBM_ADR_O       : out   std_logic_vector(31 downto 0);
            WBM_DAT_I       : in    std_logic_vector(31 downto 0);
            WBM_DAT_O       : out   std_logic_vector(31 downto 0);
            WBM_SEL_O       : out   std_logic_vector(3 downto 0);
            WBM_WE_O        : out   std_logic;
    
            PHY_TXD         : out   std_logic_vector(3 downto 0);
            PHY_TXEN        : out   std_logic;
            PHY_TXC         : in    std_logic;
            PHY_RXD         : in    std_logic_vector(3 downto 0);
            PHY_RXDV        : in    std_logic;
            PHY_RXER        : in    std_logic;
            PHY_RXC         : in    std_logic;
            PHY_COL         : in    std_logic;
            PHY_CRS         : in    std_logic;
            PHY_RESETB      : out   std_logic;
            PHY_MDC         : out   std_logic;
            PHY_MDOE        : out   std_logic;
            PHY_MDO         : out   std_logic;
            PHY_MDI         : in    std_logic;
            CLK_MD          : in    std_logic
        );
    End Component;

    Signal WBM_ADR_O_Signal : Std_Logic_Vector(31 Downto 0);

Begin
    SubPart_EMAC32 : ReplaceWith_EMAC32_TYPE
    Port Map
    (
        WBS_STB_I  =>  WBS_STB_I, 
        WBS_CYC_I  =>  WBS_CYC_I, 
        WBS_ACK_O  =>  WBS_ACK_O, 
        WBS_ADR_I  =>  WBS_ADR_I, 
        WBS_DAT_O  =>  WBS_DAT_O, 
        WBS_DAT_I  =>  WBS_DAT_I, 
        WBS_WE_I   =>  WBS_WE_I,
        WBS_CLK_I  =>  WBS_CLK_I,
        WBS_RST_I  =>  WBS_RST_I, 
        WBS_INT_O  =>  WBS_INT_O, 

        WBM_STB_O  =>  WBM_STB_O, 
        WBM_CYC_O  =>  WBM_CYC_O, 
        WBM_ACK_I  =>  WBM_ACK_I, 
        WBM_ADR_O  =>  WBM_ADR_O_Signal, 
        WBM_DAT_I  =>  WBM_DAT_I, 
        WBM_DAT_O  =>  WBM_DAT_O, 
        WBM_SEL_O  =>  WBM_SEL_O, 
        WBM_WE_O   =>  WBM_WE_O,  

        PHY_TXD    =>  PHY_TXD,   
        PHY_TXEN   =>  PHY_TXEN,  
        PHY_TXC    =>  PHY_TXC,   
        PHY_RXD    =>  PHY_RXD,   
        PHY_RXDV   =>  PHY_RXDV,  
        PHY_RXER   =>  PHY_RXER,  
        PHY_RXC    =>  PHY_RXC,   
        PHY_COL    =>  PHY_COL,   
        PHY_CRS    =>  PHY_CRS,   
        PHY_RESETB =>  PHY_RESETB,
        PHY_MDC    =>  PHY_MDC,   
        PHY_MDOE   =>  PHY_MDOE,  
        PHY_MDO    =>  PHY_MDO,   
        PHY_MDI    =>  PHY_MDI,   
        CLK_MD     =>  CLK_MD    
    );

    WBM_ADR_O <= WBM_ADR_O_Signal(ReplaceWith_AddressWidth-1 Downto 0);

End RTL;
