----------------------------------------------------------------
--Memory Core Generated By "Altium Core Generator" Version 1.0.0
--TimeStamp %TimeStamp%
----------------------------------------------------------------

----------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
Use IEEE.Std_Logic_Unsigned.All;
Library Fusion;
----------------------------------------------------------------

----------------------------------------------------------------
Entity %ComponentName% Is
    Port
    (
        CLK  : In  Std_Logic;
        RST  : In  Std_Logic;
        ADDR : In  Std_Logic_Vector ( %AddrWidth%-1 DownTo 0 );
        BUSY : Out Std_Logic;
        DOUT : Out Std_Logic_Vector (  7 DownTo 0 )
     );
end %ComponentName%;
----------------------------------------------------------------

----------------------------------------------------------------
Architecture Structure Of %ComponentName% Is

    ------------------------------------------------------------
    Component NVM
        Generic(
            MEMORYFILE     : String  := "";
            FAST_SIM       : Integer := 1;
            WR_THR         : Integer := 1024;
            TimingChecksOn : Boolean := True;
            InstancePath   : String  := "*";
            XOn            : Boolean := False;
            MsgOn          : Boolean := True
            );
        Port(
            -- input port declarations
            ADDR             : In Std_Logic_Vector ( 17 DownTo 0 );    -- input address for read or write
            WD               : In Std_Logic_Vector ( 31 DownTo 0 );    -- write data
            DATAWIDTH        : In Std_Logic_Vector (  1 DownTo 0 );    -- read/write data width select
            REN              : In Std_Logic;                           -- read control signal
            READNEXT         : In Std_Logic;                           -- burst for successive read/writes
            PAGESTATUS       : In Std_Logic;                           -- status of page will be output on RD
            WEN              : In Std_Logic;                           -- write control signal
            ERASEPAGE        : In Std_Logic;                           -- erase contents of page In AB
            PROGRAM          : In Std_Logic;                           -- copy contents In page buffer to CA (program)
            SPAREPAGE        : In Std_Logic;                           -- spare page access
            AUXBLOCK         : In Std_Logic;                           -- auxiliary block access
            UNPROTECTPAGE    : In Std_Logic;                           -- unprotect page command
            OVERWRITEPAGE    : In Std_Logic;                           -- overwrite page In CA with that In AB
            DISCARDPAGE      : In Std_Logic;                           -- discard page In AB
            OVERWRITEPROTECT : In Std_Logic;                           -- set overwrite protect bit In aux block In CA
            PAGELOSSPROTECT  : In Std_Logic;                           -- protect page contents In AB
            PIPE             : In Std_Logic;                           -- pipelined read 6 clks read latency
            LOCKREQUEST      : In Std_Logic;                           -- locks out NVM from pc_access
            CLK              : In Std_Logic;                           -- clock, rising edge triggered
            RESET            : In Std_Logic;                           -- active low reset
            -- output port declarations
            RD               : Out Std_Logic_Vector ( 31 DownTo 0 );   -- read data from NVM
            BUSY             : Out Std_Logic;                          -- when asserted, nvm cannot handle a new command
            STATUS           : Out Std_Logic_Vector (  1 DownTo 0 )    -- status of command executed
            );
    End Component;
    ------------------------------------------------------------

    ------------------------------------------------------------
    Signal RST_Int  : Std_Logic;
    Signal ADDR_Int : Std_Logic_Vector( 17 DownTo 0 );
    Signal DOUT_Int : Std_Logic_Vector( 31 DownTo 0 );
    Signal BUSY_Int : Std_Logic;
    ------------------------------------------------------------

----------------------------------------------------------------
Begin

    ------------------------------------------------------------
    NVM_Inst : NVM
        Port Map(
            ADDR             => ADDR_Int,
            WD               => "00000000000000000000000000000000",
            DATAWIDTH        => "00",
            REN              => '1',
            READNEXT         => '1',
            PAGESTATUS       => '0',
            WEN              => '0',
            ERASEPAGE        => '0',
            PROGRAM          => '0',
            SPAREPAGE        => '0',
            AUXBLOCK         => '0',
            UNPROTECTPAGE    => '0',
            OVERWRITEPAGE    => '0',
            DISCARDPAGE      => '0',
            OVERWRITEPROTECT => '0',
            PAGELOSSPROTECT  => '0',
            PIPE             => '0',
            LOCKREQUEST      => '0',
            CLK              => CLK,
            RESET            => RST_Int,
            RD               => DOUT_Int,
            BUSY             => BUSY_Int,
            STATUS           => OPEN
            );
    ------------------------------------------------------------

    ------------------------------------------------------------
    RST_Int <= Not RST;
    ADDR_Int( %AddrWidth%-1 DownTo 0 ) <= ADDR;
    ADDR_Int( 17 DownTo %AddrWidth% ) <= (Others => '0');
    DOUT <= DOUT_Int( 7 DownTo 0);
    BUSY <= BUSY_Int When RST_Int = '1' Else '1';
    ------------------------------------------------------------

End Structure;
----------------------------------------------------------------
