/**************************************************************************
**                                                                        *
**  FILE        :  wctrans.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wctrans routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <string.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wctype.h>

/*
 * Construct a value with type wctrans_t that describes a mapping between
 * wide characters identified by the string argument property.  Return 0 on
 * failure.
 */
wctrans_t
wctrans( const char* property )
{
        if ( strcmp( property, "tolower" ) == 0 )
        {
                return _to_lower;
        }
        else if ( strcmp( property, "toupper" ) == 0 )
        {
                return _to_upper;
        }
        return 0;
}

#endif
