/**************************************************************************
**                                                                        *
**  FILE        :  tanh.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for tanh() routine                         *
**                 Computes the 'hyperbolic tangent' for the given angle  *
**                 (in radians)                                           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias   tanhl   = _tanh_spf
#pragma alias   tanh            = _tanh_spf
#endif
#pragma alias   tanhf   = _tanh_spf


static
float
_tanh_spf( float arg )
{
        float sign;

        sign = 1.0f;
        if( arg < 0.0f )
        {
                arg = -arg;
                sign = -1.0f;
        }

        if( arg > 37.0f )
                return( sign );

        return( sign * sinhf( arg ) / coshf( arg ) );
}


