/**************************************************************************
**                                                                        *
**  FILE        :  tanh.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for tanh() routine                         *
**                 Computes the 'hyperbolic tangent' for the given angle  *
**                 (in radians)                                           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias   tanhl   = _tanh_dpf
#pragma alias   tanh            = _tanh_dpf


static
double
_tanh_dpf( double arg )
{
        double sign;

        sign = 1.0;
        if( arg < 0.0 )
        {
                arg = -arg;
                sign = -1.0;
        }

        if( arg > 37.0 )
                return( sign );

        return( sign * sinh( arg ) / cosh( arg ) );
}

#endif

