/**************************************************************************
**                                                                        *
**  FILE        :  strncpy.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for strncpy() routine                      *
**                 Copies two strings to eachother. If the string copied  *
**                 is too short, it will be NULL padded.                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>


char *
strncpy( register char * restrict s1, register const char * restrict s2,
         register size_t n )
{
        register char *os1      = s1;

        for ( ; n>0 && *s2; --n )
        {
                *os1++ = *s2++;
        }

        for ( ; n > 0; n-- )
        {
                *os1++ = '\0';
        }

        return s1;
}
