/**************************************************************************
**                                                                        *
**  FILE        :  runtime-error.c                                        *
**                                                                        *
**  DESCRIPTION :  Default error function for run-time checks.            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include "runtime-error.h"

static  __codeptr       first_caller;

/*
 * Save the return address of the first call to a run-time checking function.
 */
extern  void    __runtime_save_caller ( __codeptr caller )
{
        if      ( ! first_caller )
        {
                first_caller = caller;
        }
}

/*
 * Clear the return address of the first call to a run-time checking function.
 */
extern  void    __runtime_clear_caller ( __codeptr caller )
{
        if      ( caller == first_caller )
        {
                first_caller = NULL;
        }
}

/*
 * This function is used to report various run-time errors.
 * It writes the error message to stderr.
 */
extern  void    __runtime_error ( const char* message )
{
        fprintf( stderr, "error at %0*lx: %s\n",
                 2 * (int) sizeof(first_caller), (long) first_caller, message );
}
