
        .section .text.libc

        .global __save_r30
        .global __save_r23
        .global __save_r22
        .global __save_r21
        .global __save_r20
        .global __save_r19
        .global __save_r18
        .global __save_r17
        .global __save_r16

        ;; called during function prolog to save the registers.
        ;; since $31 is overwritten by the jal to this function,
        ;; $31 must be saved separately. Furthermore this function
        ;; assumes that no argument build area is present. If it is,
        ;; this build area must be created after this function was called.
        
__save_r30:
        sw      $30,36($sp)
__save_r23:
        sw      $23,32($sp)
__save_r22:
        sw      $22,28($sp)
__save_r21:
        sw      $21,24($sp)
__save_r20:
        sw      $20,20($sp)
__save_r19:
        sw      $19,16($sp)
__save_r18:
        sw      $18,12($sp)
__save_r17:
        sw      $17,8($sp)
__save_r16:
        jr      $31
        sw      $16,4($sp)

        .global __restore_r30
        .global __restore_r23
        .global __restore_r22
        .global __restore_r21
        .global __restore_r20
        .global __restore_r19
        .global __restore_r18
        .global __restore_r17
        .global __restore_r16

        ;; called during function epilog to restore the general purpose registers.
        ;; It assumes that no argument build area is present. The stack amount to
        ;; free should be passed in $4.
        
__restore_r30:
        lw      $30,36($sp)
__restore_r23:
        lw      $23,32($sp)
__restore_r22:
        lw      $22,28($sp)
__restore_r21:
        lw      $21,24($sp)
__restore_r20:
        lw      $20,20($sp)
__restore_r19:
        lw      $19,16($sp)
__restore_r18:
        lw      $18,12($sp)
__restore_r17:
        lw      $17,8($sp)
__restore_r16:
        lw      $16,4($sp)
        lw      $31,0($sp)
        jr      $31
        addu    $sp,$sp,$4

        .endsec

        .end
        
