/**************************************************************************
**                                                                        *
**  FILE        :  mbsinit.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for mbsinit routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * If ps is not a null pointer, determine whether the pointed-to mbstate_t
 * object describes an initial conversion state.
 * 
 * Return non-zero if ps is a null pointer or if the pointed-to object 
 * describes an initial conversion state; otherwise, return zero.
 */
int mbsinit(const mbstate_t *ps)
{
        if (ps == NULL || IS_INITIAL_MBSTATE(*ps))
        {
                return 1;
        }

        return 0;
}

#endif
