/**************************************************************************
**                                                                        *
**  FILE        :  iswblank.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for iswblank() routine                     *
**                 Returns non zero if given wide character is a blank    *
**                 wide character.                                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#undef  iswblank

int
iswblank( wint_t wc )
{
        return iswctype( wc, _blank );
}

#endif
