/**************************************************************************
**                                                                        *
**  FILE        :  imaxdiv.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for imaxdiv() routine                      *
**                 Returns a structure with the quotient an remainder of  *
**                 num divided by denom.                                  *
**      NOTE       Cannot be shared code, using static data for           *
**                 structure result.                                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <inttypes.h>

imaxdiv_t
imaxdiv( intmax_t num, intmax_t denom )
{
        imaxdiv_t result;

        result.quot = num / denom;
        result.rem  = num % denom;
        return( result );
}
