/**************************************************************************
**                                                                        *
**  FILE        :  divmod62.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for __udiv64() and __div64()               *
**                 as well as __umod64() and __mod64()routines.           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/


/* unsigned div64 */
unsigned long long __udiv64( unsigned long long dividend, unsigned long long divisor )
{
        unsigned int            count;
        unsigned long long      factor    = 0x1;
        unsigned long long      remainder = dividend;
        unsigned long long      quotient  = 0;
        
        /* strip leading zeros, while divisor is still smaller than dividend */
        /* count starts at 1 because we count back one step further than we count up */
        for     ( count = 1; divisor < dividend && count < 65 && (signed long)(divisor >> 32) >= 0; count++ )
        {
                divisor <<= 1;
                factor  <<= 1;
        }

        /* substract ever smaller multiples of divisor, until factor is 0 */
        do
        {
                if( remainder >= divisor )
                {
                        remainder -= divisor;
                        quotient  |= factor;
                }
                
                divisor >>= 1;
                factor  >>= 1;
        } while (--count);

        return quotient;
}

/* signed div64, calls unsigned variant */
long long __div64( long long dividend, long long divisor )
{
        long long       result;
        unsigned int    sign = (unsigned int)(dividend>>32) ^ (unsigned int)(divisor>>32);
        
        if( (signed long)((unsigned long long)dividend>>32) < 0 ) dividend = -dividend;
        if( (signed long)((unsigned long long)divisor>>32) < 0  ) divisor  = -divisor;

        result = __udiv64( dividend, divisor );

        if( sign & 0x80000000 ) 
        {
                result = -result;
        }
        
        return result;
}


/* unsigned mod64 */
unsigned long long __umod64( unsigned long long dividend, unsigned long long divisor )
{
        unsigned int            count;
        unsigned long long      factor    = 0x1;
        unsigned long long      remainder = dividend;
        
        /* strip leading zeros, while divisor is still smaller than dividend */
        /* count starts at 1 because we count back one step further than we count up */
        for     ( count = 1; divisor < dividend && count < 65 && (signed long)(divisor >> 32) >= 0; count++ )
        {
                divisor <<= 1;
                factor  <<= 1;
        }

        /* substract ever smaller multiples of divisor, until factor is 0 */
        do
        {
                if( remainder >= divisor )
                {
                        remainder -= divisor;
                }
                
                divisor >>= 1;
                factor  >>= 1;
        } while (--count);

        return remainder;
}

/* signed mod64, calls unsigned variant */
long long __mod64( long long dividend, long long divisor )
{
        long long       result;
        unsigned int    sign = (signed long)((unsigned long long)dividend>>32) < 0;
        
        if( (signed long)((unsigned long long)dividend>>32) < 0 ) dividend = -dividend;
        if( (signed long)((unsigned long long)divisor>>32) < 0  ) divisor  = -divisor;

        result = __umod64( dividend, divisor );

        if( sign ) 
        {
                result = -result;
        }
        
        return result;
}


