/**************************************************************************
**                                                                        *
**  FILE        :  divmod32.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for __udiv32() and __div32()               *
**                 as well as __umod32() and __mod32()routines.           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/


/* unsigned div32 */
unsigned int __udiv32( unsigned int dividend, unsigned int divisor )
{
        unsigned int    factor    = 0x1;
        unsigned int    remainder = dividend;
        unsigned int    quotient  = 0;

        /* strip leading zeros, while divisor is still smaller than dividend */
        while( divisor < dividend && (int)divisor > 0 )
        {
                divisor <<= 1;
                factor  <<= 1;
        }

        /* substract ever smaller multiples of divisor, until factor is 0 */
        while( factor )
        {
                if( remainder >= divisor )
                {
                        remainder -= divisor;
                        quotient  |= factor;
                }
                
                divisor >>= 1;
                factor  >>= 1;
        }

        return quotient;
}

/* signed div32, calls unsigned variant */
int __div32( int dividend, int divisor )
{
        int     result;
        int     sign = dividend ^ divisor;
        
        if( dividend < 0 ) dividend = -dividend;
        if( divisor < 0  ) divisor  = -divisor;

        result = __udiv32( dividend, divisor );

        if( sign & 0x80000000 ) 
        {
                result = -result;
        }
        
        return result;
}


/* unsigned mod32 */
unsigned int __umod32( unsigned int dividend, unsigned int divisor )
{
        unsigned int    factor    = 0x1;
        unsigned int    remainder = dividend;

        /* strip leading zeros, while divisor is still smaller than dividend */
        while( divisor < dividend && (int)divisor > 0 )
        {
                divisor <<= 1;
                factor  <<= 1;
        }

        /* substract ever smaller multiples of divisor, until factor is 0 */
        while( factor )
        {
                if( remainder >= divisor )
                {
                        remainder -= divisor;
                }
                
                divisor >>= 1;
                factor  >>= 1;
        }

        return remainder;
}

/* signed mod32, calls unsigned variant */
int __mod32( int dividend, int divisor )
{
        int     result;
        int     sign = dividend < 0;
        
        if( dividend < 0 ) dividend = -dividend;
        if( divisor < 0  ) divisor  = -divisor;

        result = __umod32( dividend, divisor );

        if( sign ) 
        {
                result = -result;
        }
        
        return result;
}


