/**************************************************************************
**                                                                        *
**  FILE        :  atanhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The atanh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * atanh(x)
 *
 * Edwards
 *
 * ISO F.9.2.3 defines exceptions. These should be handled here,
 * but for now we rely on log and divide to do the right thing.
 */
extern  long double             atanhl(long double x)
{
        if (x == 0.0l)
        {
                return x;
        }
#if 0
        // x == 1 -> return infinity, raise divide-by-zero exception.
        // x == -1 -> return -infinity, raise divide-by-zero exception.
        // |x| > 1 -> return NaN, raise invalid FP exception.
#endif
        return logl((1.0l+x)/(1.0l-x))/2.0l;
}
