/**************************************************************************
**                                                                        *
**  FILE        :  _sbrk.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for _sbrk()                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

extern  char    _lc_ub_heap[ 0x10001 ];
extern  char    _lc_ue_heap[ 0x10001 ];

static  char*   _end = _lc_ub_heap;

void*   _sbrk ( long incr )
{
        char*   old;
        char*   new;

        old = _end;
        new = old + incr;
        if      ( new < _lc_ub_heap || new > _lc_ue_heap )
        {
                return (void*) -1;
        }
        _end = new;
        return old;
}
