////////////////////////////////////////////////////////////////////////////
//
//  File        :  3000.lsl
//
//  Version     :  @(#)3000.lsl 1.40    10/06/18
//
//  Description :  Linker script file for the TSK3000 architecture  
//
//  Copyright 2003 Altium BV
//
////////////////////////////////////////////////////////////////////////////

#ifndef __STACK
#  define __STACK       32k
#endif
#ifndef __HEAP
#  define __HEAP        32k
#endif
#ifndef __START
#  define __START               0x00000000  // a jump to __CSTART and a nop
#endif
#ifndef __EXCEPTION_BASE
#define __EXCEPTION_BASE    0x0100
#endif

#define BOUNDS_GROUP_NAME   grp_bounds
#define BOUNDS_GROUP_SELECT "bounds"

#define SDA_GROUP_NAME      sda
#define SDA_GROUP_SELECT    "(.sdata*|.sbss*)"


architecture TSK3000
{
    endianness
    {
        big;
    }

    space main
    {
        id = 1;
        mau = 8;

        map (size=4G, dest=bus:addr_bus);
    
        copytable
        (
            align = 4,
            copy_unit = 1
        );

        stack "stack" 
        (
#ifdef __STACK_FIXED
            fixed,
#endif
            align = 4,
            min_size = __STACK, 
            grows = high_to_low
        );

        heap "heap" 
        (
#ifdef __HEAP_FIXED
            fixed,
#endif
            align = 4,
            min_size = __HEAP
        );

        start_address
        (
            run_addr = __START,
            symbol = "_START"
        );

#ifdef __FULL_VECTOR
#  ifndef __NR_OF_VECTORS
#    define __NR_OF_VECTORS             32
#  endif

                    // vector table with branch instructions to handlers
                    vector_table "vector_table" ( vector_size = 8, size = __NR_OF_VECTORS, run_addr = __EXCEPTION_BASE,
                                                    template = ".text.vector",
                                                    template_symbol = "_lc_vector_handler",
                                                    vector_prefix = "_vector_",
                                                    fill = loop
                                                    )
                    {
                    }
#endif

        section_layout
        {
                        // define labels for bounds begin and end as used in C library
#ifndef BOUNDS_GROUP_REDEFINED
                        group BOUNDS_GROUP_NAME (ordered, contiguous)
                        {
                                select BOUNDS_GROUP_SELECT;
                        }
#endif
                        "_lc_ub_bounds" := addressof(group:BOUNDS_GROUP_NAME);
                        "_lc_ue_bounds" := addressof(group:BOUNDS_GROUP_NAME) + sizeof(group:BOUNDS_GROUP_NAME);

                        // quasi address space (relative to address in $GP register)
            // note: linker has a problem when this space wraps around 4G!
#ifndef SDA_GROUP_REDEFINED
#ifdef SDA_BASE
                        group SDA_GROUP_NAME (ordered, contiguous, run_addr = SDA_BASE - 32k)
#else
                        group SDA_GROUP_NAME (ordered, contiguous)
#endif
                        {
                                select SDA_GROUP_SELECT;
                        }
#endif
                        "_SDA_BASE_" = sizeof(group:SDA_GROUP_NAME) > 0 ? addressof(group:SDA_GROUP_NAME) + 32k : 0;
#ifdef __HEAPADDR
                        group ( ordered, run_addr=__HEAPADDR )
                        {
                                select "heap";
                        }
#endif
#ifdef __STACKADDR
                        group ( ordered, run_addr=__STACKADDR )
                        {
                                select "stack";
                        }
#endif

#ifdef __CSTART
                        group ( ordered, run_addr=__CSTART )
                        {
                                select ".text.cstart";
                        }
#endif

            // interrupt vector (may be empty) and exception base addess
            "_EXCEPTION_BASE_" = __EXCEPTION_BASE;

#ifndef __FULL_VECTOR
            group intvec (ordered)
            {
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0000)
                {
                    select ".text.intvec_0000";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0008)
                {
                    select ".text.intvec_0008";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0010)
                {
                    select ".text.intvec_0010";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0018)
                {
                    select ".text.intvec_0018";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0020)
                {
                    select ".text.intvec_0020";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0028)
                {
                    select ".text.intvec_0028";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0030)
                {
                    select ".text.intvec_0030";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0038)
                {
                    select ".text.intvec_0038";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0040)
                {
                    select ".text.intvec_0040";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0048)
                {
                    select ".text.intvec_0048";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0050)
                {
                    select ".text.intvec_0050";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0058)
                {
                    select ".text.intvec_0058";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0060)
                {
                    select ".text.intvec_0060";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0068)
                {
                    select ".text.intvec_0068";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0070)
                {
                    select ".text.intvec_0070";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0078)
                {
                    select ".text.intvec_0078";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0080)
                {
                    select ".text.intvec_0080";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0088)
                {
                    select ".text.intvec_0088";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0090)
                {
                    select ".text.intvec_0090";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x0098)
                {
                    select ".text.intvec_0098";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00a0)
                {
                    select ".text.intvec_00a0";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00a8)
                {
                    select ".text.intvec_00a8";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00b0)
                {
                    select ".text.intvec_00b0";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00b8)
                {
                    select ".text.intvec_00b8";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00c0)
                {
                    select ".text.intvec_00c0";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00c8)
                {
                    select ".text.intvec_00c8";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00d0)
                {
                    select ".text.intvec_00d0";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00d8)
                {
                    select ".text.intvec_00d8";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00e0)
                {
                    select ".text.intvec_00e0";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00e8)
                {
                    select ".text.intvec_00e8";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00f0)
                {
                    select ".text.intvec_00f0";
                }
                group (ordered, run_addr = __EXCEPTION_BASE + 0x00f8)
                {
                    select ".text.intvec_00f8";
                }
            }

            // symbol to automatically set the VIE-bit in the status register
            "_VECTORED_INTERRUPTS_" = "_lc_ge_intvec" > (__EXCEPTION_BASE + 0x0008) ? 0x200 : 0;
#else

            "_VECTORED_INTERRUPTS_" = 0x200;
#endif
        }
    }

    bus addr_bus
    {
        mau = 8;
        width = 32;
    }
}

////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY

#ifndef __IROMSTART
#  define __IROMSTART   0
#endif
#ifndef __IROMSIZE
#  define __IROMSIZE    64k
#endif
#ifndef __IRAMSTART
#  define __IRAMSTART   (__IROMSTART + __IROMSIZE)
#endif
#ifndef __IRAMSIZE
#  define __IRAMSIZE    512k
#endif
#ifndef __XROMSTART
#  define __XROMSTART   (__IRAMSTART + __IRAMSIZE)
#endif
#ifndef __XROMSIZE
#  define __XROMSIZE    512k
#endif

memory irom
{
    mau = 8;
    type = rom;
    size = __IROMSIZE;
    map ( size = __IROMSIZE, dest_offset = __IROMSTART, dest = bus:TSK3000:addr_bus );
}

memory iram
{
    mau = 8;
    type = ram;
    size = __IRAMSIZE;
    map ( size = __IRAMSIZE, dest_offset = __IRAMSTART, dest = bus:TSK3000:addr_bus );
}

memory xrom
{
    mau = 8;
    type = rom;
    size = __XROMSIZE;
    map ( size = __XROMSIZE, dest_offset = __XROMSTART, dest = bus:TSK3000:addr_bus );
}

#endif /* __MEMORY */

