

    UsbControl_InternalDataWidth <= '0';

    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If Usb_RST_I='1' Then
                UsbControl_AccessRequest <= '0';
                EnableUsbOE <= '0';
            Else
                If UsbControl_RequestTransfer='1' Then
                    UsbControl_AccessRequest <= '1';
                ElsIf UsbControl_TransferDone='1' Then
                    UsbControl_AccessRequest <= '0';
                End If;

                If UsbControl_AccessRequest='1' And UsbControl_UsbAccessGranted='1' Then
                    EnableUsbOE <= '1';
                ElsIf UsbControl_TransferFinished='1' Then
                    EnableUsbOE <= '0';
                End If;
            End If;
        End If;
    End Process;


    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If Usb_RST_I='1' Then
                UsbTimer <= (Others=>'0');
                UsbLatchedData <= (Others=>'0');
                UsbWishbone_AcknowledgeSync <= '0';
                UsbRequestRead              <= '0';
                UsbRequestWrite             <= '0';
                UsbControl_TransferDone <= '0';
                UsbState <= UsbState_AddressSetup;

            Else
                   If UsbLoadAddressDelay='1'    Then UsbTimer <= cCONFIG_Usb_ADDRESS_SETUP;
                ElsIf UsbLoadWritePulseDelay='1' Then UsbTimer <= cCONFIG_Usb_WRITE_PULSE;
                ElsIf UsbLoadWriteHoldDelay='1'  Then UsbTimer <= cCONFIG_Usb_WRITE_HOLD;
                ElsIf UsbTimerIsZero='0'         Then UsbTimer <= UsbTimer - 1;
                End If;

                If UsbState=UsbState_Read_Cycle0_Latch Then
                    UsbLatchedData <= UsbPort_MemoryDataInput(15 Downto 0);
                End If;

                UsbRequestRead  <= UsbControl_AccessRequest And UsbWishbone_RequestRead And UsbControl_UsbAccessGranted;
                UsbRequestWrite <= UsbControl_AccessRequest And UsbWishbone_RequestWrite And UsbControl_UsbAccessGranted;

                If UsbAcknowledge='1' Then
                    UsbControl_TransferDone <= '1';
                ElsIf UsbControl_WishboneAcknowledge='1' Then
                    UsbControl_TransferDone <= '0';
                End If;
               UsbState <= UsbState_Next;

            End If;
        End If;
    End Process;
    UsbTimerIsZero       <= '1' When UsbTimer=cUsbTimerIsZero Else '0';
    ----------------------------------------------------------------------------
    UsbPort_MemoryWrite        <= UsbWE;
    UsbPort_MemoryOutputEnable <= UsbOE;

    Process(UsbOutBits,
            UsbControl_InternalDataWidth,
            UsbWishbone_Address,
            UsbPort_MemoryDataInput,
            UsbCycle_Number,
            UsbLatchedData,
            UsbWishbone_DataInput)
    Begin
        If UsbControl_InternalDataWidth='1' Then
            UsbPort_MemoryByteEnable(3 Downto 2) <= "00";
            If UsbCycle_Number='0' Then
                UsbPort_MemoryByteEnable(1 Downto 0) <= UsbOutBits(4) & UsbOutBits(3);
            Else
                UsbPort_MemoryByteEnable(1 Downto 0) <= UsbOutBits(2) & UsbOutBits(1);
            End If;
            UsbPort_MemoryAddress(23 Downto 2) <= UsbWishbone_Address(22 Downto 1);
            UsbPort_MemoryAddress(1) <= UsbCycle_Number;
            UsbPort_MemoryAddress(0) <= '0';
            UsbWishbone_DataOutput <= UsbLatchedData & UsbPort_MemoryDataInput(15 Downto 0);
            UsbPort_MemoryDataOutput(31 Downto 16) <= (Others=>'0');
            If UsbCycle_Number='0' Then
                UsbPort_MemoryDataOutput(15 Downto 0) <= UsbWishbone_DataInput(31 Downto 16);
            Else
                UsbPort_MemoryDataOutput(15 Downto 0) <= UsbWishbone_DataInput(15 Downto 0);
            End If;
        Else
            UsbPort_MemoryByteEnable <= UsbOutBits(4) & UsbOutBits(3) & UsbOutBits(2) & UsbOutBits(1);
            UsbPort_MemoryAddress <= UsbWishbone_Address(24 Downto 2) & '0';
            UsbWishbone_DataOutput <= UsbPort_MemoryDataInput;
            UsbPort_MemoryDataOutput <= UsbWishbone_DataInput;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------

    UsbOE <= '0' When (EnableUsbOe='1' And USB_WE_I='0') Else '1';

    UsbMemory_OuptutControls:
    Process(UsbWishbone_ByteSelect,
            UsbOutBits_Write,
            UsbWriteActive_Cycle)
    Begin
        If UsbWriteActive_Cycle = '1' Then
           UsbOutBits   <= UsbOutBits_Write;
           UsbPort_MemoryDataEnable <= (Others=>'0');
        Else
           UsbOutBits   <= cUsbOutBits_Read;
           UsbPort_MemoryDataEnable <= (Others=>'1');
        End If;

        Case UsbWishbone_ByteSelect Is
           When cUsbWrite_Word     => UsbOutBits_Write <= cUsbOutBits_Write_Word;
           When cUsbWrite_LoHalf   => UsbOutBits_Write <= cUsbOutBits_Write_LoHalf;
           When cUsbWrite_HiHalf   => UsbOutBits_Write <= cUsbOutBits_Write_HiHalf;
           When cUsbWrite_Byte0    => UsbOutBits_Write <= cUsbOutBits_Write_Byte0;
           When cUsbWrite_Byte1    => UsbOutBits_Write <= cUsbOutBits_Write_Byte1;
           When cUsbWrite_Byte2    => UsbOutBits_Write <= cUsbOutBits_Write_Byte2;
           When cUsbWrite_Byte3    => UsbOutBits_Write <= cUsbOutBits_Write_Byte3;
           When cUsbWrite_Bytes012 => UsbOutBits_Write <= cUsbOutBits_Write_Bytes012;
           When cUsbWrite_Bytes123 => UsbOutBits_Write <= cUsbOutBits_Write_Bytes123;
           When cUsbWrite_Bytes12  => UsbOutBits_Write <= cUsbOutBits_Write_Bytes12;
           When Others              => UsbOutBits_Write <= cUsbOutBits_None;
        End Case;
    End Process;
    ----------------------------------------------------------------------------
    UsbFSM_Combinational_Single:
    Process(UsbRequestRead,
            UsbRequestWrite,
            UsbState,
            UsbTimerIsZero,
            UsbControl_WishboneAcknowledge,
            UsbControl_InternalDataWidth)
    Begin
        ------------------------------------------------------------------------
        -- Default outputs
        UsbWriteActive_Cycle        <= '0';
        UsbWE                       <= '1';
        UsbState_Next               <= UsbState;
        UsbLoadAddressDelay         <= '0';
        UsbLoadWritePulseDelay      <= '0';
        UsbLoadWriteHoldDelay       <= '0';
        UsbControl_Transfer         <= '0';
        UsbControl_TransferFinished     <= '0';
        UsbAcknowledge              <= '0';
        UsbCycle_Number             <= '0';

        ------------------------------------------------------------------------

        ------------------------------------------------------------------------
        Case UsbState Is
           ---------------------------------------------------------------------
           When UsbState_AddressSetup =>
                If UsbRequestWrite = '1' Then                --Address is being setup in this phases
                    UsbWriteActive_Cycle <= '1';
                    UsbLoadWritePulseDelay <= '1';
                    UsbControl_Transfer <= '1';
                    If UsbControl_InternalDataWidth='1' Then
                        UsbState_Next <= UsbState_Write_Cycle0_Pulse;
                    Else
                        UsbState_Next <= UsbState_Write_Pulse;
                    End If;
                ElsIf UsbRequestRead = '1' Then
                    UsbLoadAddressDelay <= '1';
                    UsbControl_Transfer <= '1';
                    If UsbControl_InternalDataWidth='1' Then
                        UsbState_Next <= UsbState_Read_Cycle0_Latch;
                    Else
                        UsbState_Next <= UsbState_Read_ACK;
                    End If;
                End If;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When UsbState_Write_Cycle0_Pulse =>
                UsbControl_Transfer <= '1';
                UsbWriteActive_Cycle <= '1';
                UsbWE <= '0';
                If UsbTimerIsZero='1' Then
                    UsbState_Next <= UsbState_Write_Cycle0_Wait;
                    UsbLoadWriteHoldDelay <= '1';
                End If;

           When UsbState_Write_Cycle0_Wait =>
                UsbControl_Transfer <= '1';
                UsbWriteActive_Cycle <= '1';
                If UsbTimerIsZero='1' Then
                    UsbState_Next <= UsbState_Write_Cycle1_Setup;
                    UsbLoadAddressDelay <= '1';
                End If;

           When UsbState_Write_Cycle1_Setup =>
                UsbControl_Transfer <= '1';
                UsbWriteActive_Cycle <= '1';
                UsbCycle_Number      <= '1';
                If UsbTImerIsZero='1' Then
                    UsbState_Next        <= UsbState_Write_cycle1_Pulse;
                    UsbLoadWritePulseDelay <= '1';
                End If;

           When UsbState_Write_Cycle1_Pulse =>
                UsbControl_Transfer <= '1';
                UsbWriteActive_Cycle <= '1';
                UsbWE                <= '0';
                UsbCycle_Number      <= '1';
                If UsbTimerIsZero='1' Then
                    UsbState_Next        <= UsbState_Write_ACK;
                    UsbLoadWriteHoldDelay <= '1';
                End If;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When UsbState_Write_Pulse =>
                UsbControl_Transfer <= '1';
                UsbWriteActive_Cycle <= '1';
                UsbWE                <= '0';
                If UsbTimerIsZero='1' Then
                    UsbState_Next        <= UsbState_Write_ACK;
                    UsbLoadWriteHoldDelay <= '1';
                End If;

           When UsbState_Write_ACK =>
                UsbControl_Transfer <= '1';
                UsbWriteActive_Cycle <= '1';
                If UsbTimerIsZero='1' Then
                    UsbAcknowledge <= '1';
                    UsbState_Next  <= UsbState_WaitForAck;
                End if;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When UsbState_Read_Cycle0_Latch =>
                UsbControl_Transfer <= '1';
                If UsbTimerIsZero='1' Then
                    UsbState_Next    <= UsbState_Read_Cycle1_Setup;
                    UsbLoadAddressDelay <= '1';
                End If;

           When UsbState_Read_Cycle1_Setup =>
                UsbControl_Transfer <= '1';
                UsbCycle_Number  <= '1';
                If UsbTimerIsZero='1' Then
                    UsbState_Next    <= UsbState_Read_ACK;
                End If;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When UsbState_Read_ACK =>
                UsbControl_Transfer <= '1';
                UsbCycle_Number  <= '1';
                If UsbTimerIsZero='1' Then
                    UsbAcknowledge <= '1';
                    UsbState_Next    <= UsbState_WaitForAck;
                End If;
           ---------------------------------------------------------------------

            When UsbState_WaitForAck =>
                UsbControl_Transfer <= '1';
                UsbCycle_Number  <= '1';
                If UsbControl_WishboneAcknowledge='1' Then
                    UsbState_Next <= UsbState_AddressSetup;
                    UsbControl_TransferFinished <= '1';
                End If;

           When Others =>
                UsbState_Next <= UsbState_AddressSetup;

        End Case;
    End Process;
    ----------------------------------------------------------------------------
