

    SramControl_InternalDataWidth <= '0';


    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If SRAM_RST_I='1' Then
                SramControl_AccessRequest <= '0';
            Else
                If SramControl_RequestTransfer='1' Then
                    SramControl_AccessRequest <= '1';
                ElsIf SRAMControl_TransferDone='1' Then
                    SramControl_AccessRequest <= '0';
                End If;

            End If;
        End If;
    End Process;

    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If SRAM_RST_I='1' Then
                SramTimer <= (Others=>'0');
                SramLatchedData <= (Others=>'0');
                SramWishbone_AcknowledgeSync <= '0';
                SramRequestRead              <= '0';
                SramRequestWrite             <= '0';
                SramControl_TransferDone <= '0';
                SramState <= SramState_AddressSetup;

            Else
                   If SramLoadAddressDelay='1'    Then SramTimer <= cCONFIG_SRAM_ADDRESS_SETUP;
                ElsIf SramLoadWritePulseDelay='1' Then SramTimer <= cCONFIG_SRAM_WRITE_PULSE;
                ElsIf SramLoadWriteHoldDelay='1'  Then SramTimer <= cCONFIG_SRAM_WRITE_HOLD;
                ElsIf SramTimerIsZero='0'         Then SramTimer <= SramTimer - 1;
                End If;

                If SramState=SramState_Read_Cycle0_Latch Then
                    SramLatchedData <= SramPort_MemoryDataInput(15 Downto 0);
                End If;

                SramRequestRead  <= SramControl_AccessRequest And SramWishbone_RequestRead And SramControl_SramAccessGranted;
                SramRequestWrite <= SramControl_AccessRequest And SramWishbone_RequestWrite And SramControl_SramAccessGranted;

                If SramAcknowledge='1' Then
                    SramControl_TransferDone <= '1';
                ElsIf SramControl_WishboneAcknowledge='1' Then
                    SramControl_TransferDone <= '0';
                End If;
               SramState <= SramState_Next;

            End If;
        End If;
    End Process;
    SramTimerIsZero       <= '1' When SramTimer=cSramTimerIsZero Else '0';
    ----------------------------------------------------------------------------
    SramPort_MemoryWrite        <= SramWE;
    SramPort_MemoryOutputEnable <= SramOE;

    Process(SramOutBits,
            SramControl_InternalDataWidth,
            SramWishbone_Address,
            SramPort_MemoryDataInput,
            SramCycle_Number,
            SramLatchedData,
            SramWishbone_DataInput)
    Begin
        If SramControl_InternalDataWidth='1' Then
            SramPort_MemoryByteEnable(3 Downto 2) <= "00";
            If SramCycle_Number='0' Then
                SramPort_MemoryByteEnable(1 Downto 0) <= SramOutBits(4) & SramOutBits(3);
            Else
                SramPort_MemoryByteEnable(1 Downto 0) <= SramOutBits(2) & SramOutBits(1);
            End If;
            SramPort_MemoryAddress(23 Downto 2) <= SramWishbone_Address(22 Downto 1);
            SramPort_MemoryAddress(1) <= SramCycle_Number;
            SramPort_MemoryAddress(0) <= '0';
            SramWishbone_DataOutput <= SramLatchedData & SramPort_MemoryDataInput(15 Downto 0);
            SramPort_MemoryDataOutput(31 Downto 16) <= (Others=>'0');
            If SramCycle_Number='0' Then
                SramPort_MemoryDataOutput(15 Downto 0) <= SramWishbone_DataInput(31 Downto 16);
            Else
                SramPort_MemoryDataOutput(15 Downto 0) <= SramWishbone_DataInput(15 Downto 0);
            End If;
        Else
            SramPort_MemoryByteEnable <= SramOutBits(4) & SramOutBits(3) & SramOutBits(2) & SramOutBits(1);
            SramPort_MemoryAddress <= SramWishbone_Address(24 Downto 2) & '0';
            SramWishbone_DataOutput <= SramPort_MemoryDataInput;
            SramPort_MemoryDataOutput <= SramWishbone_DataInput;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    SramMemory_OuptutControls:
    Process(SramWishbone_ByteSelect,
            SramOutBits_Write,
            SramWriteActive_Cycle)
    Begin
        If SramWriteActive_Cycle = '1' Then
           SramOutBits   <= SramOutBits_Write;
           SramOE        <= '1';
           SramPort_MemoryDataEnable <= (Others=>'0');
        Else
           SramOutBits   <= cSramOutBits_Read;
           SramOE        <= '0';
           SramPort_MemoryDataEnable <= (Others=>'1');
        End If;

        Case SramWishbone_ByteSelect Is
           When cSramWrite_Word     => SramOutBits_Write <= cSramOutBits_Write_Word;
           When cSramWrite_LoHalf   => SramOutBits_Write <= cSramOutBits_Write_LoHalf;
           When cSramWrite_HiHalf   => SramOutBits_Write <= cSramOutBits_Write_HiHalf;
           When cSramWrite_Byte0    => SramOutBits_Write <= cSramOutBits_Write_Byte0;
           When cSramWrite_Byte1    => SramOutBits_Write <= cSramOutBits_Write_Byte1;
           When cSramWrite_Byte2    => SramOutBits_Write <= cSramOutBits_Write_Byte2;
           When cSramWrite_Byte3    => SramOutBits_Write <= cSramOutBits_Write_Byte3;
           When cSramWrite_Bytes012 => SramOutBits_Write <= cSramOutBits_Write_Bytes012;
           When cSramWrite_Bytes123 => SramOutBits_Write <= cSramOutBits_Write_Bytes123;
           When cSramWrite_Bytes12  => SramOutBits_Write <= cSramOutBits_Write_Bytes12;
           When Others              => SramOutBits_Write <= cSramOutBits_None;
        End Case;
    End Process;
    ----------------------------------------------------------------------------
    SramFSM_Combinational_Single:
    Process(SramRequestRead,
            SramRequestWrite,
            SramState,
            SramTimerIsZero,
            SramControl_WishboneAcknowledge,
            SramControl_InternalDataWidth)
    Begin
        ------------------------------------------------------------------------
        -- Default outputs
        SramWriteActive_Cycle        <= '0';
        SramWE                       <= '1';
        SramState_Next               <= SramState;
        SramLoadAddressDelay         <= '0';
        SramLoadWritePulseDelay      <= '0';
        SramLoadWriteHoldDelay       <= '0';
        SramControl_Transfer         <= '0';
        SramControl_TransferFinished     <= '0';
        SramAcknowledge              <= '0';
        SramCycle_Number             <= '0';

        ------------------------------------------------------------------------

        ------------------------------------------------------------------------
        Case SramState Is
           ---------------------------------------------------------------------
           When SramState_AddressSetup =>
                If SramRequestWrite = '1' Then                --Address is being setup in this phases
                    SramWriteActive_Cycle <= '1';
                    SramLoadWritePulseDelay <= '1';
                    SramControl_Transfer <= '1';
                    If SramControl_InternalDataWidth='1' Then
                        SramState_Next <= SramState_Write_Cycle0_Pulse;
                    Else
                        SramState_Next <= SramState_Write_Pulse;
                    End If;
                ElsIf SramRequestRead = '1' Then
                    SramLoadAddressDelay <= '1';
                    SramControl_Transfer <= '1';
                    If SramControl_InternalDataWidth='1' Then
                        SramState_Next <= SramState_Read_Cycle0_Latch;
                    Else
                        SramState_Next <= SramState_Read_ACK;
                    End If;
                End If;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When SramState_Write_Cycle0_Pulse =>
                SramControl_Transfer <= '1';
                SramWriteActive_Cycle <= '1';
                SramWE <= '0';
                If SramTimerIsZero='1' Then
                    SramState_Next <= SramState_Write_Cycle0_Wait;
                    SramLoadWriteHoldDelay <= '1';
                End If;

           When SramState_Write_Cycle0_Wait =>
                SramControl_Transfer <= '1';
                SramWriteActive_Cycle <= '1';
                If SramTimerIsZero='1' Then
                    SramState_Next <= SramState_Write_Cycle1_Setup;
                    SramLoadAddressDelay <= '1';
                End If;

           When SramState_Write_Cycle1_Setup =>
                SramControl_Transfer <= '1';
                SramWriteActive_Cycle <= '1';
                SramCycle_Number      <= '1';
                If SramTImerIsZero='1' Then
                    SramState_Next        <= SramState_Write_cycle1_Pulse;
                    SramLoadWritePulseDelay <= '1';
                End If;

           When SramState_Write_Cycle1_Pulse =>
                SramControl_Transfer <= '1';
                SramWriteActive_Cycle <= '1';
                SramWE                <= '0';
                SramCycle_Number      <= '1';
                If SramTimerIsZero='1' Then
                    SramState_Next        <= SramState_Write_ACK;
                    SramLoadWriteHoldDelay <= '1';
                End If;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When SramState_Write_Pulse =>
                SramControl_Transfer <= '1';
                SramWriteActive_Cycle <= '1';
                SramWE                <= '0';
                If SramTimerIsZero='1' Then
                    SramState_Next        <= SramState_Write_ACK;
                    SramLoadWriteHoldDelay <= '1';
                End If;

           When SramState_Write_ACK =>
                SramControl_Transfer <= '1';
                SramWriteActive_Cycle <= '1';
                If SramTimerIsZero='1' Then
                    SramAcknowledge <= '1';
                    SramState_Next  <= SramState_WaitForAck;
                End if;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When SramState_Read_Cycle0_Latch =>
                SramControl_Transfer <= '1';
                If SramTimerIsZero='1' Then
                    SramState_Next    <= SramState_Read_Cycle1_Setup;
                    SramLoadAddressDelay <= '1';
                End If;

           When SramState_Read_Cycle1_Setup =>
                SramControl_Transfer <= '1';
                SramCycle_Number  <= '1';
                If SramTimerIsZero='1' Then
                    SramState_Next    <= SramState_Read_ACK;
                End If;
           ---------------------------------------------------------------------

           ---------------------------------------------------------------------
           When SramState_Read_ACK =>
                SramControl_Transfer <= '1';
                SramCycle_Number  <= '1';
                If SramTimerIsZero='1' Then
                    SramAcknowledge <= '1';
                    SramState_Next    <= SramState_WaitForAck;
                End If;
           ---------------------------------------------------------------------

            When SramState_WaitForAck =>
                SramControl_Transfer <= '1';
                SramCycle_Number  <= '1';
                If SramControl_WishboneAcknowledge='1' Then
                    SramState_Next <= SramState_AddressSetup;
                    SramControl_TransferFinished <= '1';
                End If;

           When Others =>
                SramState_Next <= SramState_AddressSetup;

        End Case;
    End Process;
    ----------------------------------------------------------------------------
