    FlashPort_MemoryByteEnable <= (Others=>'1');
    ----------------------------------------------------------------------------
    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If FLASH_RST_I='1' Then
                FlashPort_MemoryAddress <= (Others=>'0');
            Else
                FlashPort_MemoryAddress(0) <= FlashCycle;
                FlashPort_MemoryAddress(23 Downto 1) <= FlashWishbone_Address(24 Downto 2);
            End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------
    ----------------------------------------------------------------------------
    FlashFlashDriveMemoryDataAndByteEnable:
    Process(FlashCycle, FlashIsWriting, FlashWishbone_DataInput)
    Begin
        FlashPort_MemoryDataEnable <= (Others=>'1');
        FlashPort_MemoryDataOutput <= (Others=>'0');
        If FlashIsWriting = '1' Then
            If FlashCycle = '0' Then
                FlashPort_MemoryDataOutput(15 Downto 0)  <= FlashWishbone_DataInput(31 Downto 16);
                FlashPort_MemoryDataOutput(31 Downto 16) <= (Others=>'0');
            Else
                FlashPort_MemoryDataOutput(15 Downto 0)  <= FlashWishbone_DataInput(15 Downto 0);
                FlashPort_MemoryDataOutput(31 Downto 16) <= (Others=>'0');
            End If;
            FlashPort_MemoryDataEnable <= (Others=>'0');
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    FlashDriveMemoryControl:
    Process(FlashIsWEActive, FlashIsOEActive, FLASH_RST_I)
    Begin
        FlashPort_MemoryWrite         <= Not FlashIsWEActive;
        FlashPort_MemoryOutputEnable  <= Not FlashIsOEActive;
        FlashPort_MemoryReset         <= Not FLASH_RST_I;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    FlashDriveWishboneSignals:
    Process(FlashReadDataLoWord_Reg,
            FlashPort_MemoryDataInput,
            FlashWishboneAck,
            FlashSkipCycle_1)
    Begin
         If FlashSkipCycle_1='1' Then
             FlashWishbone_DataOutput(31 Downto 16) <= FlashPort_MemoryDataInput(15 Downto 0);
             FlashWishbone_DataOutput(15 Downto  0) <= FlashReadDataLoWord_Reg;
         Else
             FlashWishbone_DataOutput(31 Downto 16) <= FlashReadDataLoWord_Reg;
             FlashWishbone_DataOutput(15 Downto 0) <= FlashPort_MemoryDataInput(15 Downto 0);
         End If;
    End Process;
    ----------------------------------------------------------------------------


    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If FLASH_RST_I='1' Then
                FlashControl_AccessRequest  <= '0';
                FlashAccessRequest_ff0 <= '0';
                FlashAccessRequest_ff1 <= '0';
                FlashAccessRequest_ff2 <= '0';
                FlashWishbone_AcknowledgeSync  <= '0';
            Else
                FlashAccessRequest_ff0 <= FlashWishbone_RequestTransfer;
                FlashAccessRequest_ff1 <= FlashAccessRequest_ff0;
                FlashAccessRequest_ff2 <= FlashAccessRequest_ff1;
                FlashWishbone_AcknowledgeSync   <= FlashWishbone_TransferFinished;

                If FlashAccessRequestEdge='1' Then
                    FlashControl_AccessRequest <= '1';
                ElsIf FlashAcknowledge='1' Then
                    FlashControl_AccessRequest <= '0';
                End If;
            End If;
        End If;
    End Process;

    FlashAccessRequestEdge <= '1' When FlashAccessRequest_ff2='0' And FlashAccessRequest_ff1='1' And FlashAccessRequest_ff0='1' Else '0';

    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If FLASH_RST_I='1' Then
                FlashControl_TransferDone <= '0';
            Else
                If FlashAcknowledge='1' Then
                    FlashControl_TransferDone <= '1';
                ElsIf FlashControl_WishboneAcknowledge='1' Then
                    FlashControl_TransferDone <= '0';
                End If;
            End If;
        End If;
    End Process;


    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            FlashRequest              <= (FlashWishbone_RequestRead Or FlashWishbone_RequestWrite) And FlashControl_FlashAccessGranted;
            FlashRequestRead          <= FlashRequest And FlashWishbone_RequestRead;
            FlashRequestWrite         <= FlashRequest And FlashWishbone_RequestWrite;
            FlashSkipCycle_0          <= Not (FlashWishbone_ByteSelect(2) Or FlashWishbone_ByteSelect(3));
            FlashSkipCycle_1          <= Not (FlashWishbone_ByteSelect(0) Or FlashWishbone_ByteSelect(1));
        End If;
    End Process;

    ----------------------------------------------------------------------------
    FlashCycleControl:
    Process(MEM_CLK,
            FLASH_RST_I,
            FlashCycle,
            FlashSkipCycle_0,
            FlashSkipCycle_1)
    Begin
        If FlashCycle = '0' And FlashSkipCycle_1 = '0' Then
            FlashIsLastCycle <= '0';
        Else
            FlashIsLastCycle <= '1';
        End If;

        If FLASH_RST_I = '1' Then
            FlashCycle <= '0';
        ElsIf Rising_Edge(MEM_CLK) Then
            If FlashResetCycle = '1' Then
                If FlashSkipCycle_0 = '1' Then
                    FlashCycle <= '1';
                Else
                    FlashCycle <= '0';
                End If;
            ElsIf FlashIncrementCycle = '1' Then
                FlashCycle <= '1';
            End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    FlashRegisterWishboneData:
    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
           If FlashLoadReadData = '1' Then
               FlashReadDataLoWord_Reg <= FlashPort_MemoryDataInput(15 Downto 0);
           End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If FLASH_RST_I='1' Then
                FlashTimer <= (Others=>'0');
            Else
                   If FlashLoadTimerAddressSetup ='1' Then FlashTimer <= cCONFIG_FLASH_ADDRESS_SETUP;
                ElsIf FlashLoadTimerReadPulse    ='1' Then FlashTimer <= cCONFIG_FLASH_ADDRESS_SETUP;
                ElsIf FlashLoadTimerWritePulse   ='1' Then FlashTimer <= cCONFIG_FLASH_WRITE_PULSE;
                ElsIf FlashLoadTimerWriteHold    ='1' Then FlashTimer <= cCONFIG_FLASH_WRITE_HOLD;
                ElsIf FlashTimerIsZero           ='0' Then FlashTimer <= FlashTimer - 1;
                End If;
            End If;
        End If;
    End Process;
    ----------------------------------------------------------------------------
    FlashTimerIsZero <= '1' When FlashTimer=cFlashTimerIsZero Else '0';
    ----------------------------------------------------------------------------
    FlashFsm_Combinational:
    Process(FlashState,
            FlashRequestRead,
            FlashRequestWrite,
            FlashIsLastcycle,
            FlashTimerIsZero,
            FlashControl_WishboneAcknowledge,
            FlashWishbone_AcknowledgeSync)
    Begin
        ------------------------------------------------------------------------
        FlashIsMemActive              <= '1';
        FlashIsCSActive               <= '0';
        FlashIsWEActive               <= '0';
        FlashIsOEActive               <= '0';
        FlashIsWriting                <= '0';
        FlashLoadReadData             <= '0';
        FlashWishboneAck              <= '0';
        FlashResetCycle               <= '0';
        FlashIncrementCycle           <= '0';
        FlashState_Next               <= FlashState;
        FlashLoadTimerAddressSetup    <= '0';
        FlashLoadTimerReadPulse       <= '0';
        FlashLoadTimerWritePulse      <= '0';
        FlashLoadTimerWriteHold       <= '0';
        FlashControl_Transfer         <= '1';
        FlashAcknowledge              <= '0';
        FlashControl_TransferFinished <= '0';
        ------------------------------------------------------------------------

        ------------------------------------------------------------------------
        Case FlashState Is
            --------------------------------------------------------------------
            When FlashState_Idle =>
                FlashControl_Transfer <= '0';
                If FlashRequestRead = '1' Then
                    FlashLoadTimerAddressSetup <= '1';
                    FlashResetCycle            <= '1';
                    FlashState_Next            <= FlashState_Read_AddressSetup;
                ElsIf FlashRequestWrite = '1' Then
                    FlashIsWriting             <= '1';
                    FlashResetCycle            <= '1';
                    FlashState_Next            <= FlashState_Write_AddressSetup;
                    FlashLoadTimerAddressSetup <= '1';
                Else
                    FlashIsMemActive           <= '0';
                End If;
            --------------------------------------------------------------------

            --------------------------------------------------------------------
            When FlashState_Read_AddressSetup =>
                FlashIsCSActive <= '1';
                If FlashTimerIsZero = '1' Then
                    FlashLoadTimerReadPulse    <= '1';
                    FlashIsCSActive <= '1';
                    FlashState_Next            <= FlashState_Read_OEActive;
                End If;

            When FlashState_Read_OEActive =>
                FlashIsCSActive <= '1';
                FlashIsOEActive <= '1';
                If FlashTimerIsZero = '1' Then
                    If FlashIsLastCycle = '1' Then
                        FlashAcknowledge <= '1';
                        FlashState_Next   <= FlashState_WaitForAck;
                    Else
                        FlashLoadReadData <= '1';
                        FlashState_Next   <= FlashState_Read_Hold;
                    End If;
                End If;

            When FlashState_Read_Hold =>
                FlashIsCSActive <= '1';
                If FlashTimerIsZero = '1' Then
                    FlashIncrementCycle        <= '1';
                    FlashState_Next            <= FlashState_Read_AddressSetup;
                    FlashLoadTimerAddressSetup <= '1';
                End If;

            When FlashState_Read_HoldLast =>
                FlashIsCSActive <= '1';
                If FlashTimerIsZero = '1' Then
                    FlashState_Next            <= FlashState_Idle;
                End If;
            --------------------------------------------------------------------

            --------------------------------------------------------------------
            When FlashState_Write_AddressSetup =>
                FlashIsWriting <= '1';
                FlashIsCSActive <= '1';
                If FlashTimerIsZero = '1' Then
                    FlashLoadTimerWritePulse <= '1';
                    FlashState_Next            <= FlashState_Write_WEActive;
                End If;

            When FlashState_Write_WEActive =>
                FlashIsWriting  <= '1';
                FlashIsCSActive <= '1';
                FlashIsWEActive <= '1';
                If FlashTimerIsZero = '1' Then
                    If FlashIsLastCycle = '0' Then
                        FlashLoadTimerWriteHold <= '1';
                        FlashState_Next            <= FlashState_Write_WEInactive;
                    Else
                        FlashLoadTimerWriteHold <= '1';
                        FlashState_Next            <= FlashState_Write_Hold;
                    End If;
                End If;

            When FlashState_Write_Ack =>
                FlashIsWriting             <= '1';
                FlashIsCSActive            <= '1';
                FlashAcknowledge     <= '1';
                FlashState_Next            <= FlashState_WaitForAck;

            When FlashState_Write_WEInactive =>
                FlashIsWriting  <= '1';
                FlashIsCSActive <= '1';
                If FlashTimerIsZero = '1' Then
                    FlashIncrementCycle <= '1';
                    FlashLoadTimerAddressSetup <= '1';
                    FlashState_Next            <= FlashState_Write_AddressSetup;
                End If;

            When FlashState_Write_Hold =>
                FlashIsCSActive <= '1';
                FlashIsWriting <= '1';
                If FlashTimerIsZero = '1' Then
                    FlashState_Next            <= FlashState_Write_Ack;
                End If;

            When FlashState_WaitForAck =>
                FlashIsCSActive <= '1';
                If FlashControl_WishboneAcknowledge='1' Then
--                If FlashWishbone_AcknowledgeSync='1' Then
                    FlashControl_TransferFinished <= '1';
                    FlashState_Next <= FlashState_Idle;
                End If;
            --------------------------------------------------------------------
            When Others =>
                FlashState_Next <= FlashState_Idle;
            --------------------------------------------------------------------

        End Case;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    FlashFsm_Synchronous:
    Process(MEM_CLK)
    Begin
        If Rising_Edge(MEM_CLK) Then
            If FLASH_RST_I='1' Then
                FlashState <= FlashState_Idle;
            Else
                FlashState  <= FlashState_Next;
            End If;
        End If;
    End Process;
