Library IEEE;
Use     IEEE.Std_Logic_1164.All;

Entity Configurable_ReplaceWith_Designator Is
Port (

    MEM_D           : InOut Std_Logic_Vector(31 Downto 0);
    MEM_A           : Out   Std_Logic_Vector(23 Downto 0);
    MEM_OE          : Out   Std_Logic;
    MEM_W           : Out   Std_Logic;
    MEM_BE          : Out   Std_Logic_Vector(3 Downto 0);
    MEM_FLASH_E     : Out   Std_Logic;
    MEM_FLASH_BUSY  : In    Std_Logic;
    MEM_FLASH_RESET : Out   Std_Logic;
    MEM_SRAM_E      : Out   Std_Logic;
    MEM_SDRAM_CKE   : Out   Std_Logic;
    MEM_SDRAM_RAS   : Out   Std_Logic;
    MEM_SDRAM_CAS   : Out   Std_Logic;
    MEM_SDRAM_E     : Out   Std_Logic;
    MEM_USB_E       : Out   Std_Logic;
    MEM_USB_RESET   : Out   Std_Logic;

    ---------------------------------------------------------------------------
    -- Wishbone Slave Ports
    ---------------------------------------------------------------------------
    FLASH_CLK_I      : In    Std_Logic;
    FLASH_RST_I      : In    Std_Logic;
    FLASH_CYC_I      : In    Std_Logic;
    FLASH_STB_I      : In    Std_Logic;
    FLASH_ACK_O      : Out   Std_Logic;
    FLASH_ADR_I      : In    Std_Logic_Vector(ReplaceWith_FlashInputAddressWidth - 1 DownTo 0);
    FLASH_DAT_I      : In    Std_Logic_Vector(31 DownTo 0);
    FLASH_DAT_O      : Out   Std_Logic_Vector(31 DownTo 0);
    FLASH_WE_I       : In    Std_Logic;
    FLASH_SEL_I      : In    Std_Logic_Vector( 3 DownTo 0);

    SRAM_CLK_I      : In    Std_Logic;
    SRAM_RST_I      : In    Std_Logic;
    SRAM_CYC_I      : In    Std_Logic;
    SRAM_STB_I      : In    Std_Logic;
    SRAM_ACK_O      : Out   Std_Logic;
    SRAM_ADR_I      : In    Std_Logic_Vector(ReplaceWith_SramInputAddressWidth-1 DownTo 0);
    SRAM_DAT_I      : In    Std_Logic_Vector(31 DownTo 0);
    SRAM_DAT_O      : Out   Std_Logic_Vector(31 DownTo 0);
    SRAM_WE_I       : In    Std_Logic;
    SRAM_SEL_I      : In    Std_Logic_Vector(3 DownTo 0)
);
End Configurable_ReplaceWith_Designator;

Architecture RTL Of Configurable_ReplaceWith_Designator Is

    ----------------------------------------------------------------------------
    Component Configurable_ReplaceWith_Designator_Sram
    Port (
         MEM_D_O         : Out   Std_Logic_Vector(31 Downto 0);
         MEM_D_I         : In    Std_Logic_Vector(31 Downto 0);
         MEM_D_E         : Out   Std_Logic;
         MEM_A           : Out   Std_Logic_Vector(23 DownTo 0);
         MEM_OE          : Out   Std_Logic;
         MEM_W           : Out   Std_Logic;
         MEM_SRAM_E      : Out   Std_Logic;
         MEM_BE          : Out   Std_Logic_Vector(3 Downto 0);
         ---------------------------------------------------------------------------
         MEM_SDRAM_CKE   : Out   Std_Logic;
         MEM_SDRAM_RAS   : Out   Std_Logic;
         MEM_SDRAM_CAS   : Out   Std_Logic;
         MEM_SDRAM_E     : Out   Std_Logic;
         MEM_FLASH_E     : Out   Std_Logic;
         MEM_FLASH_BUSY  : In    Std_Logic;
         MEM_FLASH_RESET : Out   Std_Logic;
         MEM_USB_E       : Out   Std_Logic;
         MEM_USB_RESET   : Out   Std_Logic;
         ---------------------------------------------------------------------------
         SRAM_CLK_I      : In    Std_Logic;
         SRAM_RST_I      : In    Std_Logic;
         SRAM_CYC_I      : In    Std_Logic;
         SRAM_STB_I      : In    Std_Logic;
         SRAM_ACK_O      : Out   Std_Logic;
         SRAM_ADR_I      : In    Std_Logic_Vector(ReplaceWith_SramInputAddressWidth-1 DownTo 0);
         SRAM_DAT_I      : In    Std_Logic_Vector(31 DownTo 0);
         SRAM_DAT_O      : Out   Std_Logic_Vector(31 DownTo 0);
         SRAM_WE_I       : In    Std_Logic;
         SRAM_SEL_I      : In    Std_Logic_Vector(3 DownTo 0)
    );
    End Component;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Component Configurable_ReplaceWith_Designator_Flash
    Port (
         -----------------------------------------------------------------------------
         MEM_D_O         : Out   Std_Logic_Vector(31 Downto 0);
         MEM_D_I         : In    Std_Logic_Vector(31 Downto 0);
         MEM_D_E         : Out   Std_Logic;
         MEM_A           : Out    Std_Logic_Vector(23 DownTo 0);
         MEM_OE          : Out    Std_Logic;
         MEM_W           : Out    Std_Logic;
         MEM_FLASH_E     : Out    Std_Logic;
         MEM_FLASH_BUSY  : In     Std_Logic;
         MEM_FLASH_RESET : Out    Std_Logic;
         -----------------------------------------------------------------------------
         MEM_SDRAM_CKE   : Out    Std_Logic;
         MEM_SDRAM_RAS   : Out    Std_Logic;
         MEM_SDRAM_CAS   : Out    Std_Logic;
         MEM_SDRAM_E     : Out    Std_Logic;
         MEM_SRAM_E      : Out    Std_Logic;
         MEM_BE          : Out    Std_Logic_Vector(3 Downto 0);
         MEM_USB_E       : Out    Std_Logic;
         MEM_USB_RESET   : Out    Std_Logic;
         ---------------------------------------------------------------------------
         FLASH_CLK_I      : In    Std_Logic;
         FLASH_RST_I      : In    Std_Logic;
         FLASH_CYC_I      : In    Std_Logic;
         FLASH_STB_I      : In    Std_Logic;
         FLASH_ACK_O      : Out   Std_Logic;
         FLASH_ADR_I      : In    Std_Logic_Vector(ReplaceWith_FlashInputAddressWidth - 1 DownTo 0);
         FLASH_DAT_I      : In    Std_Logic_Vector(31 DownTo 0);
         FLASH_DAT_O      : Out   Std_Logic_Vector(31 DownTo 0);
         FLASH_WE_I       : In    Std_Logic;
         FLASH_SEL_I      : In    Std_Logic_Vector( 3 DownTo 0)
    );
    End Component;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Signal MEM_D_O_FromSram          : Std_Logic_Vector(31 Downto 0);
    Signal MEM_D_E_FromSram          : Std_Logic;

    Signal MEM_A_FromSram            : Std_Logic_Vector(23 Downto 0);
    Signal MEM_OE_FromSram           : Std_Logic;
    Signal MEM_W_FromSram            : Std_Logic;
    Signal MEM_SRAM_E_FromSram       : Std_Logic;
    Signal MEM_BE_FromSram           : Std_Logic_Vector(3 Downto 0);
    Signal MEM_SDRAM_CKE_FromSram    : Std_Logic;
    Signal MEM_SDRAM_RAS_FromSram    : Std_Logic;
    Signal MEM_SDRAM_CAS_FromSram    : Std_Logic;
    Signal MEM_SDRAM_E_FromSram      : Std_Logic;
    Signal MEM_FLASH_E_FromSram      : Std_Logic;
    Signal MEM_FLASH_RESET_FromSram  : Std_Logic;
    Signal MEM_D_O_FromFlash         : Std_Logic_Vector(31 Downto 0);
    Signal MEM_D_E_FromFlash         : Std_Logic;
    Signal MEM_A_FromFlash           : Std_Logic_Vector(23 Downto 0);
    Signal MEM_OE_FromFlash          : Std_Logic;
    Signal MEM_W_FromFlash           : Std_Logic;
    Signal MEM_FLASH_E_FromFlash     : Std_Logic;
    Signal MEM_FLASH_RESET_FromFlash : Std_Logic;
    Signal MEM_SDRAM_CKE_FromFlash   : Std_Logic;
    Signal MEM_SDRAM_RAS_FromFlash   : Std_Logic;
    Signal MEM_SDRAM_CAS_FromFlash   : Std_Logic;
    Signal MEM_SDRAM_E_FromFlash     : Std_Logic;
    Signal MEM_SRAM_E_FromFlash      : Std_Logic;
    Signal MEM_BE_FromFlash          : Std_Logic_Vector(3 Downto 0);

    Signal MEM_USB_E_FromSram        : Std_Logic;
    Signal MEM_USB_RESET_FromSram    : Std_Logic;
    Signal MEM_USB_E_FromFlash       : Std_Logic;
    Signal MEM_USB_RESET_FromFlash   : Std_Logic;

    Signal Resolved_FLASH_CYC_I  : Std_Logic;
    Signal Resolved_FLASH_STB_I  : Std_Logic;
    Signal Resolved_SRAM_CYC_I   : Std_Logic;
    Signal Resolved_SRAM_STB_I   : Std_Logic;
    Signal FlashAcknowledge      : Std_Logic;
    Signal SramAcknowledge       : Std_Logic;


    Type TArbiterState Is (sAccess_Sram, sAccess_Flash);
    Signal ArbiterState      : TArbiterState;
    Signal NextArbiterState  : TArbiterState;
    Signal PossibleNextState : TArbiterState;

    Signal SramAccessRequest  : Std_Logic;
    Signal FlashAccessRequest : Std_Logic;

    ----------------------------------------------------------------------------
Begin

    ----------------------------------------------------------------------------
SubPart_Sram  : Configurable_ReplaceWith_Designator_Sram Port Map (
     MEM_D_O         => MEM_D_O_FromSram,
     MEM_D_I         => MEM_D,
     MEM_D_E         => MEM_D_E_FromSram,
     MEM_A           => MEM_A_FromSram,
     MEM_OE          => MEM_OE_FromSram,
     MEM_W           => MEM_W_FromSram,
     MEM_SRAM_E      => MEM_SRAM_E_FromSram,
     MEM_BE          => MEM_BE_FromSram,
     MEM_USB_E       => MEM_USB_E_FromSram,
     MEM_USB_RESET   => MEM_USB_RESET_FromSram,
     ---------------------------------------------------------------------------
     MEM_SDRAM_CKE   => MEM_SDRAM_CKE_FromSram,
     MEM_SDRAM_RAS   => MEM_SDRAM_RAS_FromSram,
     MEM_SDRAM_CAS   => MEM_SDRAM_CAS_FromSram,
     MEM_SDRAM_E     => MEM_SDRAM_E_FromSram,
     MEM_FLASH_E     => MEM_FLASH_E_FromSram,
     MEM_FLASH_BUSY  => MEM_FLASH_BUSY,
     MEM_FLASH_RESET => MEM_FLASH_RESET_FromSram,
     ---------------------------------------------------------------------------
     SRAM_CLK_I      => SRAM_CLK_I,
     SRAM_RST_I      => SRAM_RST_I,
     SRAM_CYC_I      => Resolved_SRAM_CYC_I,
     SRAM_STB_I      => Resolved_SRAM_STB_I,
     SRAM_ACK_O      => SramAcknowledge,
     SRAM_ADR_I      => SRAM_ADR_I,
     SRAM_DAT_I      => SRAM_DAT_I,
     SRAM_DAT_O      => SRAM_DAT_O,
     SRAM_WE_I       => SRAM_WE_I,
     SRAM_SEL_I      => SRAM_SEL_I
);
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
SubPart_Flash : Configurable_ReplaceWith_Designator_Flash Port Map (
     MEM_D_O         => MEM_D_O_FromFlash,
     MEM_D_I         => MEM_D,
     MEM_D_E         => MEM_D_E_FromFlash,
     MEM_A           => MEM_A_FromFlash,
     MEM_OE          => MEM_OE_FromFlash,
     MEM_W           => MEM_W_FromFlash,
     MEM_FLASH_E     => MEM_FLASH_E_FromFlash,
     MEM_FLASH_BUSY  => MEM_FLASH_BUSY,
     MEM_FLASH_RESET => MEM_FLASH_RESET_FromFlash,
     MEM_USB_E       => MEM_USB_E_FromFlash,
     MEM_USB_RESET   => MEM_USB_RESET_FromFlash,
     ---------------------------------------------------------------------------
     MEM_SDRAM_CKE   => MEM_SDRAM_CKE_FromFlash,
     MEM_SDRAM_RAS   => MEM_SDRAM_RAS_FromFlash,
     MEM_SDRAM_CAS   => MEM_SDRAM_CAS_FromFlash,
     MEM_SDRAM_E     => MEM_SDRAM_E_FromFlash,
     MEM_SRAM_E      => MEM_SRAM_E_FromFlash,
     MEM_BE          => MEM_BE_FromFlash,
     ---------------------------------------------------------------------------
     FLASH_CLK_I     => FLASH_CLK_I,
     FLASH_RST_I     => FLASH_RST_I,
     FLASH_CYC_I     => Resolved_FLASH_CYC_I,
     FLASH_STB_I     => Resolved_FLASH_STB_I,
     FLASH_ACK_O     => FlashAcknowledge,
     FLASH_ADR_I     => FLASH_ADR_I,
     FLASH_DAT_I     => FLASH_DAT_I,
     FLASH_DAT_O     => FLASH_DAT_O,
     FLASH_WE_I      => FLASH_WE_I,
     FLASH_SEL_I     => FLASH_SEL_I
);
    ----------------------------------------------------------------------------

    --RAF: New
    ----------------------------------------------------------------------------
    MEM_A              <= MEM_A_FromSram           When MEM_SRAM_E_FromSram='0' Else MEM_A_FromFlash;
    MEM_OE             <= MEM_OE_FromSram          When MEM_SRAM_E_FromSram='0' Else MEM_OE_FromFlash;
    MEM_W              <= MEM_W_FromSram           When MEM_SRAM_E_FromSram='0' Else MEM_W_FromFlash;
    MEM_SDRAM_CKE      <= MEM_SDRAM_CKE_FromSram   When MEM_SRAM_E_FromSram='0' Else MEM_SDRAM_CKE_FromFlash;
    MEM_SDRAM_RAS      <= MEM_SDRAM_RAS_FromSram   When MEM_SRAM_E_FromSram='0' Else MEM_SDRAM_RAS_FromFlash;
    MEM_SDRAM_CAS      <= MEM_SDRAM_CAS_FromSram   When MEM_SRAM_E_FromSram='0' Else MEM_SDRAM_CAS_FromFlash;
    MEM_SDRAM_E        <= MEM_SDRAM_E_FromSram     When MEM_SRAM_E_FromSram='0' Else MEM_SDRAM_E_FromFlash;
    MEM_FLASH_E        <= MEM_FLASH_E_FromSram     When MEM_SRAM_E_FromSram='0' Else MEM_FLASH_E_FromFlash;
    MEM_FLASH_RESET    <= MEM_FLASH_RESET_FromSram When MEM_SRAM_E_FromSram='0' Else MEM_FLASH_RESET_FromFlash;
    MEM_SRAM_E         <= MEM_SRAM_E_FromSram      When MEM_SRAM_E_FromSram='0' Else MEM_SRAM_E_FromFlash;
    MEM_BE             <= MEM_BE_FromSram          When MEM_SRAM_E_FromSram='0' Else MEM_BE_FromFlash;
    MEM_USB_E          <= MEM_USB_E_FromSram       When MEM_SRAM_E_FromSram='0' Else MEM_USB_E_FromFlash;
    MEM_USB_RESET      <= MEM_USB_RESET_FromSram   When MEM_SRAM_E_FromSram='0' Else MEM_USB_RESET_FromFlash;

    MEM_D              <= MEM_D_O_FromSram           When MEM_D_E_FromSram='1' Else
                          MEM_D_O_FromFlash          When MEM_D_E_FromFlash='1' Else
                          (Others=>'Z');


    SramAccessRequest   <= SRAM_CYC_I And SRAM_STB_I;
    FlashAccessRequest  <= FLASH_CYC_I  And FLASH_STB_I;
    ----------------------------------------------------------------------------
    Process(SramAccessRequest)
    Begin
         If SramAccessRequest='1' Then PossibleNextState <= sAccess_Sram;
                                  Else PossibleNextState <= sAccess_Flash;
         End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
    Process(ArbiterState, SRAM_STB_I, SramAcknowledge, SRAM_CYC_I, FLASH_STB_I, FLASH_CYC_I, FlashAcknowledge, SramAccessRequest, PossibleNextState)
    Begin
         NextArbiterState <= ArbiterState;
         Resolved_SRAM_STB_I <= '0';
         Resolved_SRAM_CYC_I <= '0';
         Resolved_FLASH_STB_I  <= '0';
         Resolved_FLASH_CYC_I  <= '0';
         SRAM_ACK_O          <= '0';
         FLASH_ACK_O           <= '0';

         Case ArbiterState Is
              When sAccess_Sram =>
                   If SRAM_STB_I='0' Then
                      NextArbiterState <= PossibleNextState;
                   ElsIf SramAcknowledge='1' Then
                   End If;
                   Resolved_SRAM_STB_I <= SRAM_STB_I;
                   Resolved_SRAM_CYC_I <= SRAM_CYC_I;
                   SRAM_ACK_O          <= SramAcknowledge;

              When sAccess_Flash  =>
                   If FLASH_STB_I='0' Then
                      NextArbiterState <= PossibleNextState;
                   ElsIf FlashAcknowledge='1' Then
                         If SramAccessRequest='1' Then
                            NextArbiterState <= PossibleNextState;
                         End If;
                   End If;
                   Resolved_FLASH_STB_I <= FLASH_STB_I;
                   Resolved_FLASH_CYC_I <= FLASH_CYC_I;
                   FLASH_ACK_O          <= FlashAcknowledge;

              When Others       =>
                   NextArbiterState <= sAccess_Sram;
         End Case;
    End Process;
    ----------------------------------------------------------------------------


    ----------------------------------------------------------------------------
    Process(SRAM_CLK_I)
    Begin
         If Rising_Edge(SRAM_CLK_I) Then
            If SRAM_RST_I='1' Then
                ArbiterState <= sAccess_Sram;
            Else
                ArbiterState <= NextArbiterState;
            End If;
         End If;
    End Process;
    ----------------------------------------------------------------------------

    ----------------------------------------------------------------------------
End RTL;
