Library IEEE;
Use     IEEE.Std_Logic_1164.All;

Entity Configurable_ReplaceWith_Designator Is
Port (
    SDRAM_STB_I : In  Std_Logic;                                                        -- IncludeIf_Sdram
    SDRAM_CYC_I : In  Std_Logic;                                                        -- IncludeIf_Sdram
    SDRAM_ACK_O : Out Std_Logic;                                                        -- IncludeIf_Sdram
    SDRAM_ADR_I : In  Std_Logic_Vector(ReplaceWith_SdramInputAddressWidth-1 Downto 0);  -- IncludeIf_Sdram
    SDRAM_DAT_O : Out Std_Logic_Vector(31 Downto 0);                                    -- IncludeIf_Sdram
    SDRAM_DAT_I : In  Std_Logic_Vector(31 Downto 0);                                    -- IncludeIf_Sdram
    SDRAM_SEL_I : In  Std_Logic_Vector( 3 Downto 0);                                    -- IncludeIf_Sdram
    SDRAM_WE_I  : In  Std_Logic;                                                        -- IncludeIf_Sdram
    SDRAM_CLK_I : In  Std_Logic;                                                        -- IncludeIf_Sdram
    SDRAM_RST_I : In  Std_Logic;                                                        -- IncludeIf_Sdram


    SRAM_STB_I : In  Std_Logic;                                                         -- IncludeIf_Sram
    SRAM_CYC_I : In  Std_Logic;                                                         -- IncludeIf_Sram
    SRAM_ACK_O : Out Std_Logic;                                                         -- IncludeIf_Sram
    SRAM_ADR_I : In  Std_Logic_Vector(ReplaceWith_SRamInputAddressWidth-1 Downto 0);    -- IncludeIf_Sram
    SRAM_DAT_O : Out Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_Sram
    SRAM_DAT_I : In  Std_Logic_Vector(31 Downto 0);                                     -- IncludeIf_Sram
    SRAM_SEL_I : In  Std_Logic_Vector( 3 Downto 0);                                     -- IncludeIf_Sram
    SRAM_WE_I  : In  Std_Logic;                                                         -- IncludeIf_Sram
    SRAM_CLK_I : In  Std_Logic;                                                         -- IncludeIf_Sram
    SRAM_RST_I : In  Std_Logic;                                                         -- IncludeIf_Sram

    MEM_CLK : In Std_Logic;

        DebugData      : Out Std_Logic_Vector(31 Downto 0); -- IncludeIf_MemCtrlDebug
        DEBUG_ADDRESS  : Out Std_Logic_Vector(23 Downto 0); -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_ACCESS_REQUEST     : Out Std_Logic; -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_TRANSFER_FINISHED     : Out Std_Logic; -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_ACCESS_GRANTED     : Out Std_Logic; -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_TRANSFER_DONE     : Out Std_Logic; -- IncludeIf_MemCtrlDebug

    MEM_D           : InOut Std_Logic_Vector(31 Downto 0);
    MEM_A           : Out   Std_Logic_Vector(23 Downto 0);
    MEM_OE          : Out   Std_Logic;
    MEM_BE          : Out   Std_Logic_Vector(3 Downto 0);
    MEM_W           : Out   Std_Logic;
    MEM_SDRAM_CKE   : Out   Std_Logic;
    MEM_SDRAM_RAS   : Out   Std_Logic;
    MEM_SDRAM_CAS   : Out   Std_Logic;
    MEM_SDRAM_E     : Out   Std_Logic;
    MEM_FLASH_BUSY  : In    Std_Logic;
    MEM_FLASH_RESET : Out   Std_Logic;
    MEM_FLASH_E     : Out   Std_Logic;
    MEM_SRAM_E      : Out   Std_Logic


);
End Configurable_ReplaceWith_Designator;

Architecture RTL Of Configurable_ReplaceWith_Designator Is
    Component WB_SHARED_SDRAM_SRAM Is
    Port (
        STB_I                       : In    STD_LOGIC;
        CYC_I                       : In    STD_LOGIC;
        ACK_O                       : Out   STD_LOGIC;
        ADR_I                       : In    STD_LOGIC_VECTOR(26 DOWNTO 0);
        DAT_O                       : Out   STD_LOGIC_VECTOR(31 DOWNTO 0);
        DAT_I                       : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
        SEL_I                       : In    STD_LOGIC_VECTOR(3 DOWNTO 0);
        WE_I                        : In    STD_LOGIC;
        CLK_I                       : In    STD_LOGIC;
        RST_I                       : In    STD_LOGIC;

        S_STB_I                     : In    STD_LOGIC;
        S_CYC_I                     : In    STD_LOGIC;
        S_ACK_O                     : Out   STD_LOGIC;
        S_ADR_I                     : In    STD_LOGIC_VECTOR(23 DOWNTO 0);
        S_DAT_O                     : Out   STD_LOGIC_VECTOR(31 DOWNTO 0);
        S_DAT_I                     : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
        S_SEL_I                     : In    STD_LOGIC_VECTOR(3 DOWNTO 0);
        S_WE_I                      : In    STD_LOGIC;
        S_CLK_I                     : In    STD_LOGIC;
        S_RST_I                     : In    STD_LOGIC;

        MEM_D_EN                    : Out   STD_LOGIC_VECTOR(31 DOWNTO 0);
        MEM_D_OUT                   : Out   STD_LOGIC_VECTOR(31 DOWNTO 0);
        MEM_D_IN                    : In    STD_LOGIC_VECTOR(31 DOWNTO 0);
        MEM_A                       : Out   STD_LOGIC_VECTOR(23 DOWNTO 0);
        MEM_W                       : Out   STD_LOGIC;
        MEM_OE                      : Out   STD_LOGIC;
        MEM_BE                      : Out   STD_LOGIC_VECTOR(3 DOWNTO 0);
        MEM_SDRAM_CKE               : Out   STD_LOGIC;
        MEM_SDRAM_RAS               : Out   STD_LOGIC;
        MEM_SDRAM_CAS               : Out   STD_LOGIC;
        MEM_SDRAM_E                 : Out   STD_LOGIC;
        MEM_FLASH_BUSY              : In    STD_LOGIC;
        MEM_FLASH_RESET             : Out   STD_LOGIC;
        MEM_FLASH_E                 : Out   STD_LOGIC;
        MEM_SRAM_E                  : Out   STD_LOGIC;

	MEM_CLK : In Std_Logic;

        DebugData      : Out Std_Logic_Vector(31 Downto 0); -- IncludeIf_MemCtrlDebug
        DEBUG_ADDRESS  : Out Std_Logic_Vector(23 Downto 0); -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_ACCESS_REQUEST     : Out Std_Logic; -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_TRANSFER_FINISHED     : Out Std_Logic; -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_ACCESS_GRANTED     : Out Std_Logic; -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_TRANSFER_DONE     : Out Std_Logic; -- IncludeIf_MemCtrlDebug

	CONFIG_SRAM_1x16            : In    STD_LOGIC;
        CONFIG_BURST_LENGTH         : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_BURST_MODE           : In    STD_LOGIC;
        CONFIG_BURST_TYPE           : In    STD_LOGIC;
        CONFIG_BUSWIDTH             : In    STD_LOGIC_VECTOR(1 DOWNTO 0);
        CONFIG_MEMSIZE              : In    STD_LOGIC_VECTOR(1 DOWNTO 0);
        CONFIG_SRAM_ADDRESS_SETUP   : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_SRAM_WRITE_PULSE     : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_SRAM_WRITE_HOLD      : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_TIMING_TCL           : In    STD_LOGIC_VECTOR(1 DOWNTO 0);
        CONFIG_TIMING_TMRD          : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_TIMING_TRCD          : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_TIMING_TRFC          : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_TIMING_TRP           : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        CONFIG_TIMING_TWR           : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        REFRESH_INTERVAL            : In    STD_LOGIC_VECTOR(2 DOWNTO 0);
        REFRESH_PRESCALER           : In    STD_LOGIC_VECTOR(7 DOWNTO 0)

    );
    End Component;

    Constant cCONFIG_BURST_LENGTH         : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_BURST_LENGTH;
    Constant cCONFIG_BURST_MODE           : STD_LOGIC                    := ReplaceWith_cCONFIG_BURST_MODE;
    Constant cCONFIG_BURST_TYPE           : STD_LOGIC                    := ReplaceWith_cCONFIG_BURST_TYPE;
    Constant cCONFIG_BUSWIDTH             : STD_LOGIC_VECTOR(1 DOWNTO 0) := ReplaceWith_cCONFIG_BUSWIDTH;
    Constant cCONFIG_MEMSIZE              : STD_LOGIC_VECTOR(1 DOWNTO 0) := ReplaceWith_cCONFIG_MEMSIZE;
    Constant cCONFIG_SRAM_ADDRESS_SETUP   : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_SRAM_ADDRESS_SETUP;
    Constant cCONFIG_SRAM_WRITE_PULSE     : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_SRAM_WRITE_PULSE;
    Constant cCONFIG_SRAM_WRITE_HOLD      : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_SRAM_WRITE_HOLD;
    Constant cCONFIG_TIMING_TCL           : STD_LOGIC_VECTOR(1 DOWNTO 0) := ReplaceWith_cCONFIG_TIMING_TCL;
    Constant cCONFIG_TIMING_TMRD          : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_TIMING_TMRD;
    Constant cCONFIG_TIMING_TRCD          : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_TIMING_TRCD;
    Constant cCONFIG_TIMING_TRFC          : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_TIMING_TRFC;
    Constant cCONFIG_TIMING_TRP           : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_TIMING_TRP;
    Constant cCONFIG_TIMING_TWR           : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cCONFIG_TIMING_TWR;
    Constant cREFRESH_INTERVAL            : STD_LOGIC_VECTOR(2 DOWNTO 0) := ReplaceWith_cREFRESH_INTERVAL;
    Constant cREFRESH_PRESCALER           : STD_LOGIC_VECTOR(7 DOWNTO 0) := ReplaceWith_cREFRESH_PRESCALER;
    Constant cCONFIG_SRAM_1x16            : STD_LOGIC                    := ReplaceWith_cCONFIG_SRAM_1x16;

    Signal CONFIG_BURST_LENGTH         : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_BURST_MODE           : STD_LOGIC;
    Signal CONFIG_BURST_TYPE           : STD_LOGIC;
    Signal CONFIG_BUSWIDTH             : STD_LOGIC_VECTOR(1 DOWNTO 0);
    Signal CONFIG_MEMSIZE              : STD_LOGIC_VECTOR(1 DOWNTO 0);
    Signal CONFIG_SRAM_ADDRESS_SETUP   : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_SRAM_WRITE_PULSE     : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_SRAM_WRITE_HOLD      : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_TIMING_TCL           : STD_LOGIC_VECTOR(1 DOWNTO 0);
    Signal CONFIG_TIMING_TMRD          : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_TIMING_TRCD          : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_TIMING_TRFC          : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_TIMING_TRP           : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal CONFIG_TIMING_TWR           : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal REFRESH_INTERVAL            : STD_LOGIC_VECTOR(2 DOWNTO 0);
    Signal REFRESH_PRESCALER           : STD_LOGIC_VECTOR(7 DOWNTO 0);
    Signal CONFIG_SRAM_1x16            : STD_LOGIC;
    Signal MEM_SRAM_E_Signal        : Std_Logic;
    Signal MEM_D_EN_Signal          : Std_Logic_Vector(31 Downto 0);
    Signal MEM_D_OUT_Signal         : Std_Logic_Vector(31 Downto 0);
    Signal MEM_D_IN_Signal          : Std_Logic_Vector(31 Downto 0);

    Signal SDRAM_ADR_I_Signal : Std_Logic_Vector(26 Downto 0);
    Signal SRAM_ADR_I_Signal  : Std_Logic_Vector(23 Downto 0);

Begin


    CONFIG_BURST_LENGTH          <= cCONFIG_BURST_LENGTH;
    CONFIG_BURST_MODE            <= cCONFIG_BURST_MODE;
    CONFIG_BURST_TYPE            <= cCONFIG_BURST_TYPE;
    CONFIG_BUSWIDTH              <= cCONFIG_BUSWIDTH;
    CONFIG_MEMSIZE               <= cCONFIG_MEMSIZE;
    CONFIG_SRAM_ADDRESS_SETUP    <= cCONFIG_SRAM_ADDRESS_SETUP;
    CONFIG_SRAM_WRITE_PULSE      <= cCONFIG_SRAM_WRITE_PULSE;
    CONFIG_SRAM_WRITE_HOLD       <= cCONFIG_SRAM_WRITE_HOLD;
    CONFIG_TIMING_TCL            <= cCONFIG_TIMING_TCL;
    CONFIG_TIMING_TMRD           <= cCONFIG_TIMING_TMRD;
    CONFIG_TIMING_TRCD           <= cCONFIG_TIMING_TRCD;
    CONFIG_TIMING_TRFC           <= cCONFIG_TIMING_TRFC;
    CONFIG_TIMING_TRP            <= cCONFIG_TIMING_TRP;
    CONFIG_TIMING_TWR            <= cCONFIG_TIMING_TWR;
    REFRESH_INTERVAL             <= cREFRESH_INTERVAL;
    REFRESH_PRESCALER            <= cREFRESH_PRESCALER;
    CONFIG_SRAM_1x16             <= cCONFIG_SRAM_1x16;

    SubPart_SharedMemoryController : WB_SHARED_SDRAM_SRAM Port Map (
        STB_I                       =>  SDRAM_STB_I,                                    -- IncludeIf_Sdram
        CYC_I                       =>  SDRAM_CYC_I,                                    -- IncludeIf_Sdram
        ACK_O                       =>  SDRAM_ACK_O,                                    -- IncludeIf_Sdram
        ADR_I                       =>  SDRAM_ADR_I_Signal,                             -- IncludeIf_Sdram
        DAT_O                       =>  SDRAM_DAT_O,                                    -- IncludeIf_Sdram
        DAT_I                       =>  SDRAM_DAT_I,                                    -- IncludeIf_Sdram
        SEL_I                       =>  SDRAM_SEL_I,                                    -- IncludeIf_Sdram
        WE_I                        =>  SDRAM_WE_I,                                     -- IncludeIf_Sdram
        CLK_I                       =>  SDRAM_CLK_I,                                    -- IncludeIf_Sdram
        RST_I                       =>  SDRAM_RST_I,                                    -- IncludeIf_Sdram

        S_STB_I                     => SRAM_STB_I,                                        -- IncludeIf_Sram
        S_CYC_I                     => SRAM_CYC_I,                                        -- IncludeIf_Sram
        S_ACK_O                     => SRAM_ACK_O,                                        -- IncludeIf_Sram
        S_ADR_I                     => SRAM_ADR_I_Signal,                                 -- IncludeIf_Sram
        S_DAT_O                     => SRAM_DAT_O,                                        -- IncludeIf_Sram
        S_DAT_I                     => SRAM_DAT_I,                                        -- IncludeIf_Sram
        S_SEL_I                     => SRAM_SEL_I,                                        -- IncludeIf_Sram
        S_WE_I                      => SRAM_WE_I,                                         -- IncludeIf_Sram
        S_CLK_I                     => SRAM_CLK_I,                                        -- IncludeIf_Sram
        S_RST_I                     => SRAM_RST_I,                                        -- IncludeIf_Sram

        MEM_D_EN                    => MEM_D_EN_Signal,
        MEM_D_OUT                   => MEM_D_OUT_Signal,
        MEM_D_IN                    => MEM_D_IN_Signal,
        MEM_A                       => MEM_A,
        MEM_W                       => MEM_W,
        MEM_OE                      => MEM_OE,
        MEM_BE                      => MEM_BE,
        MEM_SDRAM_CKE               => MEM_SDRAM_CKE,
        MEM_SDRAM_RAS               => MEM_SDRAM_RAS,
        MEM_SDRAM_CAS               => MEM_SDRAM_CAS,
        MEM_SDRAM_E                 => MEM_SDRAM_E,
        MEM_FLASH_BUSY              => MEM_FLASH_BUSY,                              -- ExcludeIf_Flash
        MEM_FLASH_RESET             => MEM_FLASH_RESET,                         -- IncludeIf_Flash
        MEM_FLASH_E                 => MEM_FLASH_E,                             -- IncludeIf_Flash
        MEM_SRAM_E                  => MEM_SRAM_E_Signal,                           -- IncludeIf_Sram

	MEM_CLK => MEM_CLK,

        DebugData     => DebugData,     -- IncludeIf_MemCtrlDebug
        DEBUG_ADDRESS => DEBUG_ADDRESS, -- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_ACCESS_REQUEST    => DEBUG_SRAM_ACCESS_REQUEST,-- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_TRANSFER_FINISHED => DEBUG_SRAM_TRANSFER_FINISHED,-- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_ACCESS_GRANTED    => DEBUG_SRAM_ACCESS_GRANTED,-- IncludeIf_MemCtrlDebug
        DEBUG_SRAM_TRANSFER_DONE     => DEBUG_SRAM_TRANSFER_DONE,-- IncludeIf_MemCtrlDebug


	CONFIG_SRAM_1x16            => CONFIG_SRAM_1x16,
        CONFIG_BURST_LENGTH         => CONFIG_BURST_LENGTH,
        CONFIG_BURST_MODE           => CONFIG_BURST_MODE,
        CONFIG_BURST_TYPE           => CONFIG_BURST_TYPE,
        CONFIG_BUSWIDTH             => CONFIG_BUSWIDTH,
        CONFIG_MEMSIZE              => CONFIG_MEMSIZE,
        CONFIG_SRAM_ADDRESS_SETUP   => CONFIG_SRAM_ADDRESS_SETUP,
        CONFIG_SRAM_WRITE_PULSE     => CONFIG_SRAM_WRITE_PULSE,
        CONFIG_SRAM_WRITE_HOLD      => CONFIG_SRAM_WRITE_HOLD,
        CONFIG_TIMING_TCL           => CONFIG_TIMING_TCL,
        CONFIG_TIMING_TMRD          => CONFIG_TIMING_TMRD,
        CONFIG_TIMING_TRCD          => CONFIG_TIMING_TRCD,
        CONFIG_TIMING_TRFC          => CONFIG_TIMING_TRFC,
        CONFIG_TIMING_TRP           => CONFIG_TIMING_TRP,
        CONFIG_TIMING_TWR           => CONFIG_TIMING_TWR,
        REFRESH_INTERVAL            => REFRESH_INTERVAL,
        REFRESH_PRESCALER           => REFRESH_PRESCALER
    );


    MEM_SRAM_E      <= MEM_SRAM_E_Signal;       -- IncludeIf_Sram

    SDRAM_ADR_I_Signal <= ReplaceWith_PaddedSdramAddress  SDRAM_ADR_I(ReplaceWith_SdramInputAddressWidth-1 Downto 0); -- IncludeIf_Sdram
    SRAM_ADR_I_Signal  <= ReplaceWith_PaddedSramAddress   SRAM_ADR_I(ReplaceWith_SRamInputAddressWidth-1 Downto 0);   -- IncludeIf_Sram

    MEM_D( 0) <= MEM_D_OUT_Signal( 0) When MEM_D_EN_Signal( 0) = '0' Else 'Z';
    MEM_D( 1) <= MEM_D_OUT_Signal( 1) When MEM_D_EN_Signal( 1) = '0' Else 'Z';
    MEM_D( 2) <= MEM_D_OUT_Signal( 2) When MEM_D_EN_Signal( 2) = '0' Else 'Z';
    MEM_D( 3) <= MEM_D_OUT_Signal( 3) When MEM_D_EN_Signal( 3) = '0' Else 'Z';
    MEM_D( 4) <= MEM_D_OUT_Signal( 4) When MEM_D_EN_Signal( 4) = '0' Else 'Z';
    MEM_D( 5) <= MEM_D_OUT_Signal( 5) When MEM_D_EN_Signal( 5) = '0' Else 'Z';
    MEM_D( 6) <= MEM_D_OUT_Signal( 6) When MEM_D_EN_Signal( 6) = '0' Else 'Z';
    MEM_D( 7) <= MEM_D_OUT_Signal( 7) When MEM_D_EN_Signal( 7) = '0' Else 'Z';
    MEM_D( 8) <= MEM_D_OUT_Signal( 8) When MEM_D_EN_Signal( 8) = '0' Else 'Z';
    MEM_D( 9) <= MEM_D_OUT_Signal( 9) When MEM_D_EN_Signal( 9) = '0' Else 'Z';
    MEM_D(10) <= MEM_D_OUT_Signal(10) When MEM_D_EN_Signal(10) = '0' Else 'Z';
    MEM_D(11) <= MEM_D_OUT_Signal(11) When MEM_D_EN_Signal(11) = '0' Else 'Z';
    MEM_D(12) <= MEM_D_OUT_Signal(12) When MEM_D_EN_Signal(12) = '0' Else 'Z';
    MEM_D(13) <= MEM_D_OUT_Signal(13) When MEM_D_EN_Signal(13) = '0' Else 'Z';
    MEM_D(14) <= MEM_D_OUT_Signal(14) When MEM_D_EN_Signal(14) = '0' Else 'Z';
    MEM_D(15) <= MEM_D_OUT_Signal(15) When MEM_D_EN_Signal(15) = '0' Else 'Z';
    MEM_D(16) <= MEM_D_OUT_Signal(16) When MEM_D_EN_Signal(16) = '0' Else 'Z';
    MEM_D(17) <= MEM_D_OUT_Signal(17) When MEM_D_EN_Signal(17) = '0' Else 'Z';
    MEM_D(18) <= MEM_D_OUT_Signal(18) When MEM_D_EN_Signal(18) = '0' Else 'Z';
    MEM_D(19) <= MEM_D_OUT_Signal(19) When MEM_D_EN_Signal(19) = '0' Else 'Z';
    MEM_D(20) <= MEM_D_OUT_Signal(20) When MEM_D_EN_Signal(20) = '0' Else 'Z';
    MEM_D(21) <= MEM_D_OUT_Signal(21) When MEM_D_EN_Signal(21) = '0' Else 'Z';
    MEM_D(22) <= MEM_D_OUT_Signal(22) When MEM_D_EN_Signal(22) = '0' Else 'Z';
    MEM_D(23) <= MEM_D_OUT_Signal(23) When MEM_D_EN_Signal(23) = '0' Else 'Z';
    MEM_D(24) <= MEM_D_OUT_Signal(24) When MEM_D_EN_Signal(24) = '0' Else 'Z';
    MEM_D(25) <= MEM_D_OUT_Signal(25) When MEM_D_EN_Signal(25) = '0' Else 'Z';
    MEM_D(26) <= MEM_D_OUT_Signal(26) When MEM_D_EN_Signal(26) = '0' Else 'Z';
    MEM_D(27) <= MEM_D_OUT_Signal(27) When MEM_D_EN_Signal(27) = '0' Else 'Z';
    MEM_D(28) <= MEM_D_OUT_Signal(28) When MEM_D_EN_Signal(28) = '0' Else 'Z';
    MEM_D(29) <= MEM_D_OUT_Signal(29) When MEM_D_EN_Signal(29) = '0' Else 'Z';
    MEM_D(30) <= MEM_D_OUT_Signal(30) When MEM_D_EN_Signal(30) = '0' Else 'Z';
    MEM_D(31) <= MEM_D_OUT_Signal(31) When MEM_D_EN_Signal(31) = '0' Else 'Z';

    MEM_D_IN_Signal( 0) <= MEM_D( 0);
    MEM_D_IN_Signal( 1) <= MEM_D( 1);
    MEM_D_IN_Signal( 2) <= MEM_D( 2);
    MEM_D_IN_Signal( 3) <= MEM_D( 3);
    MEM_D_IN_Signal( 4) <= MEM_D( 4);
    MEM_D_IN_Signal( 5) <= MEM_D( 5);
    MEM_D_IN_Signal( 6) <= MEM_D( 6);
    MEM_D_IN_Signal( 7) <= MEM_D( 7);
    MEM_D_IN_Signal( 8) <= MEM_D( 8);
    MEM_D_IN_Signal( 9) <= MEM_D( 9);
    MEM_D_IN_Signal(10) <= MEM_D(10);
    MEM_D_IN_Signal(11) <= MEM_D(11);
    MEM_D_IN_Signal(12) <= MEM_D(12);
    MEM_D_IN_Signal(13) <= MEM_D(13);
    MEM_D_IN_Signal(14) <= MEM_D(14);
    MEM_D_IN_Signal(15) <= MEM_D(15);
    MEM_D_IN_Signal(16) <= MEM_D(16);
    MEM_D_IN_Signal(17) <= MEM_D(17);
    MEM_D_IN_Signal(18) <= MEM_D(18);
    MEM_D_IN_Signal(19) <= MEM_D(19);
    MEM_D_IN_Signal(20) <= MEM_D(20);
    MEM_D_IN_Signal(21) <= MEM_D(21);
    MEM_D_IN_Signal(22) <= MEM_D(22);
    MEM_D_IN_Signal(23) <= MEM_D(23);
    MEM_D_IN_Signal(24) <= MEM_D(24);
    MEM_D_IN_Signal(25) <= MEM_D(25);
    MEM_D_IN_Signal(26) <= MEM_D(26);
    MEM_D_IN_Signal(27) <= MEM_D(27);
    MEM_D_IN_Signal(28) <= MEM_D(28);
    MEM_D_IN_Signal(29) <= MEM_D(29);
    MEM_D_IN_Signal(30) <= MEM_D(30);
    MEM_D_IN_Signal(31) <= MEM_D(31);

End;
