--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
Port(
    
    STB_I       : In    Std_Logic;
    CYC_I       : In    Std_Logic;
    ACK_O       : Out   Std_Logic;
    ADR_I       : In    Std_Logic_Vector(25 Downto 0);
    DAT_O       : Out   Std_Logic_Vector(31 Downto 0);
    DAT_I       : In    Std_Logic_Vector(31 Downto 0);
    SEL_I       : In    Std_Logic_Vector( 3 Downto 0);
    WE_I        : In    Std_Logic;
    CLK_I       : In    Std_Logic;
    RST_I       : In    Std_Logic;
    
    SDRAM_D     : InOut Std_Logic_Vector(31 Downto 0);
    SDRAM_A     : Out   Std_Logic_Vector(14 Downto 0);
    SDRAM_BE    : Out   Std_Logic_Vector( 3 Downto 0);
    SDRAM_RAS   : Out   Std_Logic;
    SDRAM_CAS   : Out   Std_Logic;
    SDRAM_WE    : Out   Std_Logic;
    SDRAM_CS    : Out   Std_Logic;
    SDRAM_CLK   : In    Std_Logic;
    SDRAM_CLKE  : Out   Std_Logic
    
);
End Configurable_ReplaceWith_Designator;

Architecture RTL Of Configurable_ReplaceWith_Designator Is


    Component ReplaceWith_ChildModel Is
    Port (
        WB_SDRAM_STB_I                   : In    Std_Logic;
        WB_SDRAM_CYC_I                   : In    Std_Logic;
        WB_SDRAM_ACK_O                   : Out   Std_Logic;
        WB_SDRAM_ADR_I                   : In    Std_Logic_Vector(ReplaceWith_InputAddressWidth Downto 0);
        WB_SDRAM_DAT_O                   : Out   Std_Logic_Vector(31 Downto 0);
        WB_SDRAM_DAT_I                   : In    Std_Logic_Vector(31 Downto 0);
        WB_SDRAM_SEL_I                   : In    Std_Logic_Vector( 3 Downto 0);
        WB_SDRAM_WE_I                    : In    Std_Logic;
        WB_SDRAM_CLK_I                   : In    Std_Logic;
        WB_SDRAM_RST_I                   : In    Std_Logic;
                    
            
        CONFIG_WRITE_COMPLETION_VALUE    : In    Std_Logic_Vector(1 Downto 0);
        CONFIG_PRECHARGE_PERIOD_VALUE    : In    Std_Logic_Vector(3 Downto 0);
        CONFIG_ACTIVE_TO_READWRITE_VALUE : In    Std_Logic_Vector(2 Downto 0);
        CONFIG_AUTO_REFRESH_PERIOD_VALUE : In    Std_Logic_Vector(3 Downto 0);
        CONFIG_CL_VALUE                  : In    Std_Logic_Vector(1 Downto 0);
        REFRESH_INTERVAL                 : In    Std_Logic_Vector(2 Downto 0);
        REFRESH_PRESCALER                : In    Std_Logic_Vector(7 Downto 0);
        KEEP_ROW_OPEN                    : In    Std_Logic;
        CONFIG_BUS_WIDTH                 : In    Std_Logic_Vector(1 Downto 0);
        CONFIG_MEM_SIZE                  : In    Std_Logic_Vector(1 Downto 0);
                
        BE_DEC                           : Out   Std_Logic_Vector(1 Downto 0);
        
        CS                               : In    Std_Logic_Vector(7 Downto 0);
        CS_LOWER                         : Out   Std_Logic;
        CS_UPPER                         : Out   Std_Logic;
        
        
        SDRAM_DATA_OUT                   : Out   Std_Logic_Vector(31 Downto 0);
        SDRAM_DATA_IN                    : In    Std_Logic_Vector(31 Downto 0);
        SDRAM_DATA_OE                    : Out   Std_Logic;
        SDRAM_ADDRESS                    : Out   Std_Logic_Vector(23 Downto 0);
        SDRAM_BE                         : Out   Std_Logic_Vector( 3 Downto 0);
        SDRAM_RAS                        : Out   Std_Logic;
        SDRAM_CAS                        : Out   Std_Logic;
        SDRAM_WE                         : Out   Std_Logic;
        SDRAM_CS                         : Out   Std_Logic;
        MEM_CLK                          : In    Std_Logic;
        SDRAM_CKE                        : Out   Std_Logic;
        
        
        SDRAM_DATA_OE_B                  : Out   Std_Logic;  
        SDRAM_ADDRESS_B                  : Out   Std_Logic_Vector(23 Downto 0);
        SDRAM_BE_B                       : Out   Std_Logic_Vector( 3 Downto 0);
        SDRAM_RAS_B                      : Out   Std_Logic;
        SDRAM_CAS_B                      : Out   Std_Logic;
        SDRAM_WE_B                       : Out   Std_Logic;
        SDRAM_CS_B                       : Out   Std_Logic
        
    );
    End Component;



	Signal Config_WriteCompletionValue   : Std_Logic_Vector(1 Downto 0);
	Signal Config_PrechargePeriodValue   : Std_Logic_Vector(3 Downto 0);
	Signal Config_ActiveToReadWriteValue : Std_Logic_Vector(2 Downto 0);
	Signal Config_AutoRefreshPeriodValue : Std_Logic_Vector(3 Downto 0);
	Signal Config_CLValue                : Std_Logic_Vector(1 Downto 0);
	Signal Config_RefreshInterval        : Std_Logic_Vector(2 Downto 0);
	Signal Config_RefreshPrescaler       : Std_Logic_Vector(7 Downto 0);
	Signal Config_KeepRowOpen            : Std_Logic;
	Signal Config_BusWidth               : Std_Logic_Vector(1 Downto 0);
	Signal Config_ChipSize               : Std_Logic_Vector(1 Downto 0);
	
	Signal WishboneAddress : Std_Logic_Vector(26 Downto 0);
	Signal SdramDataOut    : Std_Logic_Vector(31 Downto 0);
	Signal SdramAddress    : Std_Logic_Vector(23 Downto 0);
	Signal SdramDataOe     : Std_Logic;

Begin
    SDRAM_A <= SdramAddress(14 Downto 0);
    SDRAM_D <= SdramDataOut When SdramDataOe='1' Else (Others=>'Z');
    
    WishboneAddress <= ReplaceWith_WishboneInputAddress;

    Config_WriteCompletionValue   <= ReplaceWith_WriteCompletionValue;
    Config_PrechargePeriodValue   <= ReplaceWith_PrechargePeriodValue;
    Config_ActiveToReadWriteValue <= ReplaceWith_ActiveToReadWriteValue;
    Config_AutoRefreshPeriodValue <= ReplaceWith_AutoRefreshPeriodValue;
    Config_CLValue                <= ReplaceWith_ClValue;
    Config_RefreshInterval        <= ReplaceWith_RefreshInterval;
    Config_RefreshPrescaler       <= ReplaceWith_RefreshPrescaler;
    Config_KeepRowOpen            <= ReplaceWith_KeepRowOpen;
    Config_BusWidth               <= ReplaceWith_BusWidth;
    Config_ChipSize               <= ReplaceWith_ChipSize;    
    

    SubPart_Port : ReplaceWith_ChildModel
    Port Map
    (
        WB_SDRAM_STB_I                      => STB_I,
        WB_SDRAM_CYC_I                      => CYC_I,
        WB_SDRAM_ACK_O                      => ACK_O,
        WB_SDRAM_ADR_I                      => WishboneAddress,
        WB_SDRAM_DAT_O                      => DAT_O,
        WB_SDRAM_DAT_I                      => DAT_I,
        WB_SDRAM_SEL_I                      => SEL_I,
        WB_SDRAM_WE_I                       => WE_I,
        WB_SDRAM_CLK_I                      => CLK_I,
        WB_SDRAM_RST_I                      => RST_I,
                    
            
        CONFIG_WRITE_COMPLETION_VALUE       => Config_WriteCompletionValue,
        CONFIG_PRECHARGE_PERIOD_VALUE       => Config_PrechargePeriodValue,
        CONFIG_ACTIVE_TO_READWRITE_VALUE    => Config_ActiveToReadWriteValue,
        CONFIG_AUTO_REFRESH_PERIOD_VALUE    => Config_AutoRefreshPeriodValue,
        CONFIG_CL_VALUE                     => Config_CLValue,
        REFRESH_INTERVAL                    => Config_RefreshInterval,
        REFRESH_PRESCALER                   => Config_RefreshPrescaler,
        KEEP_ROW_OPEN                       => Config_KeepRowOpen,
        CONFIG_BUS_WIDTH                    => Config_BusWidth,
        CONFIG_MEM_SIZE                     => Config_ChipSize,
                
        BE_DEC                              => Open,
        
        CS                                  => "11111111",
        CS_LOWER                            => Open, 
        CS_UPPER                            => Open,
        
        
        SDRAM_DATA_OUT                      => SdramDataOut,
        SDRAM_DATA_IN                       => SDRAM_D,
        SDRAM_DATA_OE                       => SdramDataOe,
        
        SDRAM_ADDRESS                       => SdramAddress,
        
        SDRAM_BE                            => SDRAM_BE,
        
        SDRAM_RAS                           => SDRAM_RAS,
        SDRAM_CAS                           => SDRAM_CAS,
        SDRAM_WE                            => SDRAM_WE,
        SDRAM_CS                            => SDRAM_CS,                                   
        MEM_CLK                             => SDRAM_CLK,
        SDRAM_CKE                           => SDRAM_CLKE,
        
        
        SDRAM_DATA_OE_B                     => Open,  
        SDRAM_ADDRESS_B                     => Open,
        SDRAM_BE_B                          => Open,
        SDRAM_RAS_B                         => Open,
        SDRAM_CAS_B                         => Open,
        SDRAM_WE_B                          => Open,
        SDRAM_CS_B                          => Open
    );
    
End RTL;