-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
-- ----------------------------------------------------------------------------
Port (
    STB_I       : In    Std_Logic;
    CYC_I       : In    Std_Logic;
    ACK_O       : Out   Std_Logic;
    ADR_I       : In    Std_Logic_Vector(ReplaceWith_InputAddressWidth-1 Downto 0);
    DAT_O       : Out   Std_Logic_Vector(31 Downto 0);
    DAT_I       : In    Std_Logic_Vector(31 Downto 0);
    SEL_I       : In    Std_Logic_Vector( 3 Downto 0);
    WE_I        : In    Std_Logic;
    CLK_I       : In    Std_Logic;
    RST_I       : In    Std_Logic;

    SDRAM_CLK     : In    Std_Logic;

    -- 1x32 wide device
    SDRAM_A          : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_1_Device_X_32
    SDRAM_BA         : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_32
    SDRAM_BE         : Out   Std_Logic_Vector(3  Downto 0);                         -- IncludeIf_1_Device_X_32
    SDRAM_CAS        : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_CLKE       : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_CS         : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_D          : InOut Std_Logic_Vector(31 Downto 0);                         -- IncludeIf_1_Device_X_32
    SDRAM_RAS        : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_WE         : Out   Std_Logic                                              -- IncludeIf_1_Device_X_32
    -- 1x16 wide device
    SDRAM_A          : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_1_Device_X_16
    SDRAM_BA         : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_16
    SDRAM_BE         : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_16
    SDRAM_CAS        : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_CLKE       : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_CS         : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_D          : InOut Std_Logic_Vector(15 Downto 0);                         -- IncludeIf_1_Device_X_16
    SDRAM_RAS        : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_WE         : Out   Std_Logic                                              -- IncludeIf_1_Device_X_16
    -- 1x8 wide device
    SDRAM_A          : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_1_Device_X_8
    SDRAM_BA         : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_8
    SDRAM_BE         : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_CAS        : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_CLKE       : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_CS         : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_D          : InOut Std_Logic_Vector(7  Downto 0);                         -- IncludeIf_1_Device_X_8
    SDRAM_RAS        : Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_WE         : Out   Std_Logic                                              -- IncludeIf_1_Device_X_8
    -- 2x16 wide device
    SDRAM0_A         : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_2_Device_X_16
    SDRAM0_BA        : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM0_BE        : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM0_CAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_CLKE      : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_CS        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_D         : InOut Std_Logic_Vector(15 Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM0_RAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_WE        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_A         : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_2_Device_X_16
    SDRAM1_BA        : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM1_BE        : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM1_CAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_CLKE      : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_CS        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_D         : InOut Std_Logic_Vector(15 Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM1_RAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_WE        : Out   Std_Logic                                              -- IncludeIf_2_Device_X_16

    SDRAM0_A         : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_2_Device_X_8
    SDRAM0_BA        : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_8
    SDRAM0_BE        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_CAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_CLKE      : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_CS        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_D         : InOut Std_Logic_Vector(7  Downto 0);                         -- IncludeIf_2_Device_X_8
    SDRAM0_RAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_WE        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_A         : Out   Std_Logic_Vector(13-1 Downto 0); -- IncludeIf_2_Device_X_8
    SDRAM1_BA        : Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_8
    SDRAM1_BE        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_CAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_CLKE      : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_CS        : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_D         : InOut Std_Logic_Vector(7  Downto 0);                         -- IncludeIf_2_Device_X_8
    SDRAM1_RAS       : Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_WE        : Out   Std_Logic                                              -- IncludeIf_2_Device_X_8
);
End Configurable_ReplaceWith_Designator;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of Configurable_ReplaceWith_Designator Is
-- ----------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    Component WB_SHARED_SDRAM Is
        Port (
            -- Timing configuration
            CONFIG_BURST_LENGTH                  : In  Std_Logic_Vector( 2 Downto 0);
            CONFIG_TIMING_TCL                    : In  Std_Logic_Vector( 1 Downto 0);
            CONFIG_TIMING_TMRD                   : In  Std_Logic_Vector( 2 Downto 0);
            CONFIG_TIMING_TRCD                   : In  Std_Logic_Vector( 2 Downto 0);
            CONFIG_TIMING_TRFC                   : In  Std_Logic_Vector( 2 Downto 0);
            CONFIG_TIMING_TRP                    : In  Std_Logic_Vector( 2 Downto 0);
            CONFIG_TIMING_TWR                    : In  Std_Logic_Vector( 2 Downto 0);
            REFRESH_INTERVAL                     : In  Std_Logic_Vector( 2 Downto 0);
            REFRESH_PRESCALER                    : In  Std_Logic_Vector( 7 Downto 0);

            --SRAM interface
            CONTROL_WB_SRAM_ACCESS_GRANTED       : Out Std_Logic;
            CONTROL_WB_SRAM_ACCESS_REQUEST       : In  Std_Logic;
            CONTROL_WB_SRAM_ADR                  : In  Std_Logic_Vector(23 Downto 0);
            CONTROL_WB_SRAM_BE                   : In  Std_Logic_Vector( 3 Downto 0);
            CONTROL_WB_SRAM_D_EN                 : In  Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_SRAM_DAT_IN               : In  Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_SRAM_DAT_OUT              : Out Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_SRAM_OE                   : In  Std_Logic;
            CONTROL_WB_SRAM_TRANSFER             : In  Std_Logic;
            CONTROL_WB_SRAM_TRANSFER_DONE        : In  Std_Logic;
            CONTROL_WB_SRAM_W                    : In  Std_Logic;

            -- SDRAM interface
            CONTROL_WB_SDRAM_ACKNOWLEDGE         : In  Std_Logic;
            CONTROL_WB_SDRAM_BANK_ADDRESS        : In  Std_Logic_Vector( 1 Downto 0);
            CONTROL_WB_SDRAM_COLUMN_ADDRESS      : In  Std_Logic_Vector(12 Downto 0);
            CONTROL_WB_SDRAM_DATA_FROM_MEM       : Out Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_SDRAM_DATA_TO_MEM         : In  Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_SDRAM_MEM_BE              : In  Std_Logic_Vector( 3 Downto 0);
            CONTROL_WB_SDRAM_REQUEST_READ        : In  Std_Logic;
            CONTROL_WB_SDRAM_REQUEST_TRANSFER    : In  Std_Logic;
            CONTROL_WB_SDRAM_ROW_ADDRESS         : In  Std_Logic_Vector(12 Downto 0);
            CONTROL_WB_SDRAM_SDRAM_MODE_REGISTER : In  Std_Logic_Vector(12 Downto 0);
            CONTROL_WB_SDRAM_TRANSFER_DONE       : Out Std_Logic;

            -- FLASH interface
            CONTROL_WB_FLASH_ACCESS_GRANTED      : Out Std_Logic;
            CONTROL_WB_FLASH_ACCESS_REQUEST      : In  Std_Logic;
            CONTROL_WB_FLASH_ADR                 : In  Std_Logic_Vector(23 Downto 0);
            CONTROL_WB_FLASH_BE                  : In  Std_Logic_Vector( 3 Downto 0);
            CONTROL_WB_FLASH_BUSY                : Out Std_Logic;
            CONTROL_WB_FLASH_D_EN                : In  Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_FLASH_DAT_IN              : In  Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_FLASH_DAT_OUT             : Out Std_Logic_Vector(31 Downto 0);
            CONTROL_WB_FLASH_OE                  : In  Std_Logic;
            CONTROL_WB_FLASH_RESET               : In  Std_Logic;
            CONTROL_WB_FLASH_TRANSFER            : In  Std_Logic;
            CONTROL_WB_FLASH_TRANSFER_DONE       : In  Std_Logic;
            CONTROL_WB_FLASH_W                   : In  Std_Logic;

            -- External Memory interface
            MEM_A                                : Out Std_Logic_Vector(23 Downto 0);
            MEM_BE                               : Out Std_Logic_Vector( 3 Downto 0);
            MEM_CLK                              : In  Std_Logic;
            MEM_D_EN                             : Out Std_Logic_Vector(31 Downto 0);
            MEM_D_IN                             : In  Std_Logic_Vector(31 Downto 0);
            MEM_D_OUT                            : Out Std_Logic_Vector(31 Downto 0);
            MEM_FLASH_BUSY                       : In  Std_Logic;
            MEM_FLASH_E                          : Out Std_Logic;
            MEM_FLASH_RESET                      : Out Std_Logic;
            MEM_OE                               : Out Std_Logic;
            MEM_RST                              : In  Std_Logic;
            MEM_SDRAM_CAS                        : Out Std_Logic;
            MEM_SDRAM_CKE                        : Out Std_Logic;
            MEM_SDRAM_E                          : Out Std_Logic;
            MEM_SDRAM_RAS                        : Out Std_Logic;
            MEM_SRAM_E                           : Out Std_Logic;
            MEM_W                                : Out Std_Logic
        );
    End Component;
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    Signal Signal_GND            : Std_Logic;
    Signal Signal_GND4           : Std_Logic_Vector( 3 Downto 0);
    Signal Signal_GND24          : Std_Logic_Vector(23 Downto 0);
    Signal Signal_GND32          : Std_Logic_Vector(31 Downto 0);

    Signal Signal_VCC            : Std_Logic;
    Signal Signal_VCC4           : Std_Logic_Vector( 3 Downto 0);
    Signal Signal_VCC24          : Std_Logic_Vector(23 Downto 0);
    Signal Signal_VCC32          : Std_Logic_Vector(31 Downto 0);

    Signal Port_MEM_A            : Std_Logic_Vector(23 Downto 0);
    Signal Port_MEM_BE           : Std_Logic_Vector( 3 Downto 0);
    Signal Port_MEM_Data_Enable  : Std_Logic_Vector(31 Downto 0);
    Signal Port_MEM_Data_Input   : Std_Logic_Vector(31 Downto 0);
    Signal Port_MEM_Data_Output  : Std_Logic_Vector(31 Downto 0);
    Signal Port_MEM_FLASH_Enable : Std_Logic;
    Signal Port_MEM_FLASH_Reset  : Std_Logic;
    Signal Port_MEM_OutputEnable : Std_Logic;
    Signal Port_MEM_SDRAM_CAS    : Std_Logic;
    Signal Port_MEM_SDRAM_CKE    : Std_Logic;
    Signal Port_MEM_SDRAM_E      : Std_Logic;
    Signal Port_MEM_SDRAM_RAS    : Std_Logic;
    Signal Port_MEM_SRAM_E       : Std_Logic;
    Signal Port_MEM_W            : Std_Logic;
    -- ------------------------------------------------------------------------
    -- ------------------------------------------------------------------------
    Signal Config_Active_To_ReadWrite_Value : Std_Logic_Vector(2  Downto 0);
    Signal Config_Auto_Refresh_Period_Value : Std_Logic_Vector(2  Downto 0);
    Signal Config_Burst_Length              : Std_Logic_Vector(2  Downto 0);
    Signal Config_Burst_Mode                : Std_Logic;
    Signal Config_Burst_Type                : Std_Logic;
    Signal Config_Bus_Width                 : Std_Logic_Vector(1  Downto 0);
    Signal Config_Cl_Value                  : Std_Logic_Vector(1  Downto 0);
    Signal Config_Keep_Row_Open             : Std_Logic;
    Signal Config_Mem_Size                  : Std_Logic_Vector(1  Downto 0);
    Signal Config_Precharge_Period_Value    : Std_Logic_Vector(2  Downto 0);
    Signal Config_Refresh_Interval          : Std_Logic_Vector(2  Downto 0);
    Signal Config_Refresh_Prescaler         : Std_Logic_Vector(7  Downto 0);
    Signal Config_Write_Completion_Value    : Std_Logic_Vector(2  Downto 0);
    -- ------------------------------------------------------------------------


    Signal SDRAMWishbone_DataInput                       : Std_Logic_Vector(31 Downto 0);
    Signal SDRAMWishbone_DataOutput                      : Std_Logic_Vector(31 Downto 0);
    Signal SDRAMWishbone_Address                         : Std_Logic_Vector(25 Downto 0);
    Signal SDRAMWishbone_ByteSelect                      : Std_Logic_Vector( 3 Downto 0);
    Signal SDRAMWishbone_RequestRead                     : Std_Logic;
    Signal SDRAMWishbone_RequestWrite                    : Std_Logic;
    Signal SDRAMWishbone_RequestTransfer                 : Std_Logic;
    Signal SDRAMWishbone_Acknowledge                     : Std_Logic;
    Signal SDRAMWishbone_TransferDone                    : Std_Logic;
    Signal SDRAMWishbone_TransferDone_MetaStableFF       : Std_Logic;
    Signal SDRAMWishbone_TransferDone_ResyncFF0          : Std_Logic;
    Signal SDRAMWishbone_TransferDone_ResyncFF1          : Std_Logic;
    Signal SDRAMControl_TransferDone                     : Std_Logic;

    Signal SDRAMControl_RequestTransfer_MetastableFF     : Std_Logic;
    Signal SDRAMControl_RequestTransfer_ResyncFF0        : Std_Logic;
    Signal SDRAMControl_RequestTransfer_ResyncFF1        : Std_Logic;
    Signal SDRAMControl_RequestTransfer                  : Std_Logic;
    Signal SDRAMControl_WishboneAcknowledge              : Std_Logic;
    Signal SDRAMControl_WishboneAcknowledge_MetastableFF : Std_Logic;
    Signal SDRAMControl_WishboneAcknowledge_ResyncFF0    : Std_Logic;
    Signal SDRAMControl_WishboneAcknowledge_ResyncFF1    : Std_Logic;
    Signal SDRAMControl_TransferDone_ResyncFF0           : Std_Logic;
    Signal SdramWishbone_RowAddress                      : Std_Logic_Vector(12 Downto 0);
    Signal SdramWishbone_ColumnAddress                   : Std_Logic_Vector(12 Downto 0);
    Signal SdramWishbone_BankAddress                     : Std_Logic_Vector( 1 Downto 0);
    Signal SdramWishbone_ModeRegister                    : Std_Logic_Vector(12 Downto 0);

-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    Config_Active_To_ReadWrite_Value    <= ReplaceWith_Config_Active_To_ReadWrite_Value;
    Config_Auto_Refresh_Period_Value    <= ReplaceWith_Config_Auto_Refresh_Period_Value;
    Config_Burst_Length                 <= ReplaceWith_Config_Burst_Length;
    Config_Burst_Mode                   <= ReplaceWith_Config_Burst_Mode;
    Config_Burst_Type                   <= ReplaceWith_Config_Burst_Type;
    Config_Bus_Width                    <= ReplaceWith_Config_Bus_Width;
    Config_Cl_Value                     <= ReplaceWith_Config_Cl_Value;
    Config_Keep_Row_Open                <= ReplaceWith_Config_Keep_Row_Open;
    Config_Mem_Size                     <= ReplaceWith_Config_Mem_Size;
    Config_Precharge_Period_Value       <= ReplaceWith_Config_Precharge_Period_Value;
--    Config_Refresh_Interval             <= ReplaceWith_Config_Refresh_Interval;
--    Config_Refresh_Prescaler            <= ReplaceWith_Config_Refresh_Prescaler;
    Config_Refresh_Interval             <= "010";
    Config_Refresh_Prescaler            <= "00110010";
    Config_Write_Completion_Value       <= ReplaceWith_Config_Write_Completion_Value;

    -- ------------------------------------------------------------------------


    -- ------------------------------------------------------------------------
    Signal_GND   <= '0';
    Signal_GND4  <= (Others=>'0');
    Signal_GND24 <= (Others=>'0');
    Signal_GND32 <= (Others=>'0');

    Signal_VCC   <= '1';
    Signal_VCC4  <= (Others=>'1');
    Signal_VCC24 <= (Others=>'1');
    Signal_VCC32 <= (Others=>'1');
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    SubPart_MemoryController : WB_SHARED_SDRAM Port Map (
            -- Timing configuration
            CONFIG_BURST_LENGTH                  => Config_Burst_Length,
            CONFIG_TIMING_TCL                    => Config_Cl_Value,
            CONFIG_TIMING_TMRD                   => Config_Active_To_ReadWrite_Value, -- TODO
            CONFIG_TIMING_TRCD                   => Config_Active_To_ReadWrite_Value,
            CONFIG_TIMING_TRFC                   => Config_Auto_Refresh_Period_Value,
            CONFIG_TIMING_TRP                    => Config_Precharge_Period_Value,
            CONFIG_TIMING_TWR                    => Config_Write_Completion_Value,
            REFRESH_INTERVAL                     => Config_Refresh_Interval,
            REFRESH_PRESCALER                    => Config_Refresh_Prescaler,

            --SRAM interface
            CONTROL_WB_SRAM_ACCESS_GRANTED       => Open,
            CONTROL_WB_SRAM_ACCESS_REQUEST       => Signal_GND,
            CONTROL_WB_SRAM_ADR                  => Signal_GND24,
            CONTROL_WB_SRAM_BE                   => Signal_VCC4,
            CONTROL_WB_SRAM_D_EN                 => Signal_VCC32,
            CONTROL_WB_SRAM_DAT_IN               => Signal_GND32,
            CONTROL_WB_SRAM_DAT_OUT              => Open,
            CONTROL_WB_SRAM_OE                   => Signal_VCC,
            CONTROL_WB_SRAM_TRANSFER             => Signal_GND,
            CONTROL_WB_SRAM_TRANSFER_DONE        => Signal_VCC,
            CONTROL_WB_SRAM_W                    => Signal_VCC,

            -- SDRAM interface
            CONTROL_WB_SDRAM_ACKNOWLEDGE         => SDRAMControl_WishboneAcknowledge,
            CONTROL_WB_SDRAM_BANK_ADDRESS        => SdramWishbone_BankAddress,
            CONTROL_WB_SDRAM_COLUMN_ADDRESS      => SdramWishbone_ColumnAddress,
            CONTROL_WB_SDRAM_DATA_FROM_MEM       => SDRAMWishbone_DataOutput,
            CONTROL_WB_SDRAM_DATA_TO_MEM         => SDRAMWishbone_DataInput,
            CONTROL_WB_SDRAM_MEM_BE              => SDRAMWishbone_ByteSelect,
            CONTROL_WB_SDRAM_REQUEST_READ        => SDRAMWishbone_RequestRead,
            CONTROL_WB_SDRAM_REQUEST_TRANSFER    => SDRAMControl_RequestTransfer,
            CONTROL_WB_SDRAM_ROW_ADDRESS         => SdramWishbone_RowAddress,
            CONTROL_WB_SDRAM_SDRAM_MODE_REGISTER => SdramWishbone_ModeRegister,
            CONTROL_WB_SDRAM_TRANSFER_DONE       => SDRAMControl_TransferDone,

            -- FLASH interface
            CONTROL_WB_FLASH_ACCESS_GRANTED      => Open,
            CONTROL_WB_FLASH_ACCESS_REQUEST      => Signal_GND,
            CONTROL_WB_FLASH_ADR                 => Signal_GND24,
            CONTROL_WB_FLASH_BE                  => Signal_VCC4,
            CONTROL_WB_FLASH_BUSY                => Open,
            CONTROL_WB_FLASH_D_EN                => Signal_VCC32,
            CONTROL_WB_FLASH_DAT_IN              => Signal_GND32,
            CONTROL_WB_FLASH_DAT_OUT             => Open,
            CONTROL_WB_FLASH_OE                  => Signal_VCC,
            CONTROL_WB_FLASH_RESET               => Signal_VCC,
            CONTROL_WB_FLASH_TRANSFER            => Signal_GND,
            CONTROL_WB_FLASH_TRANSFER_DONE       => Signal_VCC,
            CONTROL_WB_FLASH_W                   => Signal_VCC,

            -- External Memory interface
            MEM_A                                => Port_MEM_A,            --: Out Std_Logic_Vector(23 Downto 0);
            MEM_BE                               => Port_MEM_BE,           --: Out Std_Logic_Vector( 3 Downto 0);
            MEM_CLK                              => SDRAM_CLK,
            MEM_D_EN                             => Port_MEM_Data_Enable,  --: Out Std_Logic_Vector(31 Downto 0);
            MEM_D_IN                             => Port_MEM_Data_Input,   --: In  Std_Logic_Vector(31 Downto 0);
            MEM_D_OUT                            => Port_MEM_Data_Output,  --: Out Std_Logic_Vector(31 Downto 0);
            MEM_FLASH_BUSY                       => Signal_VCC,            --: In  Std_Logic;
            MEM_FLASH_E                          => Port_MEM_FLASH_Enable, --: Out Std_Logic;
            MEM_FLASH_RESET                      => Port_MEM_FLASH_Reset,  --: Out Std_Logic;
            MEM_OE                               => Port_MEM_OutputEnable, --: Out Std_Logic;
            MEM_RST                              => RST_I,
            MEM_SDRAM_CAS                        => Port_MEM_SDRAM_CAS,    --: Out Std_Logic;
            MEM_SDRAM_CKE                        => Port_MEM_SDRAM_CKE,    --: Out Std_Logic;
            MEM_SDRAM_E                          => Port_MEM_SDRAM_E,      --: Out Std_Logic;
            MEM_SDRAM_RAS                        => Port_MEM_SDRAM_RAS,    --: Out Std_Logic;
            MEM_SRAM_E                           => Port_MEM_SRAM_E,       --: Out Std_Logic;
            MEM_W                                => Port_MEM_W             --: Out Std_Logic
    );
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    ReplaceWith_SDRAM_Wishbone_Interface
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    ReplaceWith_SDRAM_Controller_Logic
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
--    ReplaceWith_SDRAM_DataPortBinding
    -- ------------------------------------------------------------------------



    -- ------------------------------------------------------------------------
    -- 1x32 wide device
    SDRAM_A          <= Port_MEM_A(13 Downto 1);    --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_1_Device_X_32
    SDRAM_BA         <= Port_MEM_A(15 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_32
    SDRAM_BE         <= Port_MEM_BE;                --: Out   Std_Logic_Vector(3  Downto 0);                         -- IncludeIf_1_Device_X_32
    SDRAM_CAS        <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_CLKE       <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_CS         <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
--    SDRAM_D          : InOut Std_Logic_Vector(31 Downto 0);                                                          -- IncludeIf_1_Device_X_32
    SDRAM_RAS        <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_32
    SDRAM_WE         <= Port_MEM_W;                 --: Out   Std_Logic                                              -- IncludeIf_1_Device_X_32

    -- ------------------------------------------------------------------------
    -- 1x16 wide device
    SDRAM_A          <= Port_MEM_A(13 Downto 1);    --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_1_Device_X_16
    SDRAM_BA         <= Port_MEM_A(15 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_16
    SDRAM_BE         <= Port_MEM_BE(1 Downto 0);    --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_16
    SDRAM_CAS        <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_CLKE       <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_CS         <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
--    SDRAM_D          : InOut Std_Logic_Vector(15 Downto 0);                                                          -- IncludeIf_1_Device_X_16
    SDRAM_RAS        <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_16
    SDRAM_WE         <= Port_MEM_W;                 --: Out   Std_Logic                                              -- IncludeIf_1_Device_X_16

    -- ------------------------------------------------------------------------
    -- 1x8 wide device
    SDRAM_A          <= Port_MEM_A(13 Downto 1);    --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_1_Device_X_8
    SDRAM_BA         <= Port_MEM_A(15 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_1_Device_X_8
    SDRAM_BE         <= Port_MEM_BE(0);             --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_CAS        <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_CLKE       <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_CS         <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
--    SDRAM_D          : InOut Std_Logic_Vector(7  Downto 0);                                                          -- IncludeIf_1_Device_X_8
    SDRAM_RAS        <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_1_Device_X_8
    SDRAM_WE         <= Port_MEM_W;                 --: Out   Std_Logic                                              -- IncludeIf_1_Device_X_8

    -- ------------------------------------------------------------------------
    -- 2x16 wide device
    SDRAM0_A         <= Port_MEM_A(13 Downto  1);   --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_2_Device_X_16
    SDRAM0_BA        <= Port_MEM_A(15 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM0_BE        <= Port_MEM_BE(3 Downto  2);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM0_CAS       <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_CLKE      <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_CS        <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
--    SDRAM0_D         : InOut Std_Logic_Vector(15 Downto 0);                                                          -- IncludeIf_2_Device_X_16
    SDRAM0_RAS       <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM0_WE        <= Port_MEM_W;                 --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_A         <= Port_MEM_A(13 Downto 1);    --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_2_Device_X_16
    SDRAM1_BA        <= Port_MEM_A(15 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM1_BE        <= Port_MEM_BE(1 Downto 0);    --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_16
    SDRAM1_CAS       <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_CLKE      <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_CS        <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
--    SDRAM1_D         : InOut Std_Logic_Vector(15 Downto 0);                                                          -- IncludeIf_2_Device_X_16
    SDRAM1_RAS       <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_16
    SDRAM1_WE        <= Port_MEM_W;                 --: Out   Std_Logic                                              -- IncludeIf_2_Device_X_16

    -- ------------------------------------------------------------------------
    -- 2x8 wide device
    SDRAM0_A         <= Port_MEM_A(13 Downto 1);    --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_2_Device_X_8
    SDRAM0_BA        <= Port_MEM_A(14 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_8
    SDRAM0_BE        <= Port_MEM_BE(1);             --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_CAS       <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_CLKE      <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_CS        <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
--    SDRAM0_D         : InOut Std_Logic_Vector(7  Downto 0);                                                          -- IncludeIf_2_Device_X_8
    SDRAM0_RAS       <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM0_WE        <= Port_MEM_W;                 --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_A         <= Port_MEM_A(13 Downto 1);    --: Out   Std_Logic_Vector(13-1 Downto 0);                       -- IncludeIf_2_Device_X_8
    SDRAM1_BA        <= Port_MEM_A(15 Downto 14);   --: Out   Std_Logic_Vector(1  Downto 0);                         -- IncludeIf_2_Device_X_8
    SDRAM1_BE        <= Port_MEM_BE(0);             --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_CAS       <= Port_MEM_SDRAM_CAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_CLKE      <= Port_MEM_SDRAM_CKE;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_CS        <= Port_MEM_SDRAM_E;           --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
--    SDRAM1_D         : InOut Std_Logic_Vector(7  Downto 0);                                                          -- IncludeIf_2_Device_X_8
    SDRAM1_RAS       <= Port_MEM_SDRAM_RAS;         --: Out   Std_Logic;                                             -- IncludeIf_2_Device_X_8
    SDRAM1_WE        <= Port_MEM_W;                 --: Out   Std_Logic                                              -- IncludeIf_2_Device_X_8



-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------

