<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:TranslationData="http://www.autodesk.com/Inventor/Translation">

	<!-- Autodesk Inventor Translation Report XML data -->
	<TranslationData:data>
	</TranslationData:data>

	<!-- Autodesk Inventor Translation Report XSL -->
	<xsl:template match="xsl:stylesheet">
		<xsl:apply-templates select="TranslationData:data"/>
	</xsl:template>	

	<!-- Global Variables -->
	<xsl:variable name="report-width">900</xsl:variable>
	<xsl:variable name="plus-minus-col-width">7%</xsl:variable>
	
	<xsl:template match="TranslationResults">
		<html>
			<head>
			
				<!-- CSS Formatting -->
				<title use-string-resource="IDS_TU_REPORT_TITLE"/>
				<style type="text/css">
					body 	{	background-color: white; color: black; font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; text-align: left; text-indent: 0pt; margin-bottom: 0pt; margin-left: 12pt; margin-right: 12pt; margin-top: 6pt;	}
					th	{	font-size: 12pt; font-weight: bold; margin-top: 12pt; margin-bottom: 3pt; text-align: left; background-color: #bbbbbb;	}
					td {	font-size: 10pt; font-weight: normal; margin-top: 12pt; margin-bottom: 3pt;	}
					table table th { font-size: 10pt; font-weight: bold; margin-top: 10pt; margin-bottom: 3pt; text-align: left; background-color:#eeeeee; }
					table table td {	font-size: 10pt; font-weight: normal; margin-top: 12pt; margin-bottom: 3pt;	}
					tr.row-style0 {	background-color: #ddddff;	}
					tr.row-style1 {	background-color: #eeeeff;	}
					.title 	{	color: #003399; font-size: 14pt; font-weight: bold;	}
					.header-heading {	font-weight: bold;	}
					.section-heading	{ color: #003399; font-size: 12pt; font-weight: bold; margin-top: 12pt; margin-bottom: 8pt;	}
					.table-description	{ margin-top: 6pt; margin-bottom: 3pt;	}
					.timestamp {	font-size: 9pt; font-weight: normal; color: #003399; text-align: right;	}
					.plus-minus {	text-align: center; font-family: monospace; font-weight: bold; cursor: pointer; cursor: hand; }
					.status-error {	color: CC0000; font-weight: bold;	}
					.status-warning {	color: #999900; font-weight: bold;	}
					.status-message {	color: #003366; font-weight: bold;	}
					.status-unknown {	color: #660066; font-weight: bold;	}
					.status-debug	{	color: #660066; font-weight: bold;	}					
					.status-success {	color: #006600;	}
				</style>
			
				<!-- Javascript -->
				<script language="JavaScript" type="text/javascript">
					function setDisplay(id, displayStyle)
					{
						el = document.getElementById(id)
						if (el != null)
							el.style.display = displayStyle;
					}
	
					function hide(id)
					{
						setDisplay(id, "none");
					}
	
					function show(id)
					{
						setDisplay(id, "");
					}
	
					function Expand(row, prefix)
					{
						hide(prefix + "plus" + row);
						show(prefix + "minus" + row);
						show(prefix + "details" + row);
					}
	
					function Collapse(row, prefix)
					{
						show(prefix + "plus" + row);
						hide(prefix + "minus" + row);
						hide(prefix + "details" + row);
					}

					function ChangeAll(fnChange, prefix)
					{
						row = 1;
						while(document.getElementById(prefix + "row" + row) != null)
							fnChange(row++, prefix);
					}
	
					function ExpandAll(prefix)
					{
						ChangeAll(Expand, prefix);
					}
	
					function CollapseAll(prefix)
					{
						ChangeAll(Collapse, prefix);
					}

				</script>
			</head>

			<body>
			
				<!-- Title & timestamp -->
				<table border="0" width="{$report-width}">
					<tr>
            <td><h1 class="title" use-string-resource="IDS_TU_REPORT_TITLE"/></td>
						<td class="timestamp"><xsl:value-of select="Date"/> (<xsl:value-of select="Time"/>)</td>
					</tr>
				</table>

        <!--<table border="0" height="20"><tr></tr></table>-->

				<!-- Input data -->
				<table border="0" width="{$report-width}">
					<col width="25%"/><col width="25%"/><col width="25%"/><col width="25%"/>
					<tr>
						<td class="header-heading" use-string-resource="IDS_TU_REPORT_SELECTEDFILE"/>
						<td colspan="3"><xsl:value-of select="Input/File/FullPath"/></td>
					</tr>
					<tr>
						<td class="header-heading" use-string-resource="IDS_TU_REPORT_TRANSTYPE"/>
						<td> 
							<xsl:choose>	
								<xsl:when test="Input/File/Type='IGES'" use-string-resource="IDS_TU_REPORT_IGES"/>
								<xsl:when test="Input/File/Type='STEP'" use-string-resource="IDS_TU_REPORT_STEP"/>
                <xsl:otherwise><xsl:value-of  select="Input/File/Type"/></xsl:otherwise>
           			<!--<xsl:otherwise use-string-resource="IDS_TRANSREPORT_UNKNOWN"/>-->
							</xsl:choose>
						</td>
            <td class="header-heading" use-string-resource="IDS_TU_REPORT_SENDINGSYSTEM"/>
            <td>
              <xsl:value-of select="Input/SendingSystem"/>
            </td>
					</tr>
					<tr>
            <td class="header-heading" use-string-resource="IDS_TU_REPORT_AUTHOR"/>
            <td>
              <xsl:value-of select="Input/Author"/>
            </td>
						<td class="header-heading" use-string-resource="IDS_TU_REPORT_TRANSTIME"/>
						<td>
							<xsl:call-template name="format-elapsed-time">
								<xsl:with-param name="milliseconds" select="translate(TranslationTime, ',', '')"/>
							</xsl:call-template>
						</td>
					</tr>
        </table>

        <table border="0" width="{$report-width}">
          <tr ></tr>
        </table>

        <table border ="0" width="{$report-width}">
          <col width="38%"/>
          <col width="62%"/>
          <tr>
            <td>
              <h1 class="title" use-string-resource="IDS_TU_REPORT_OPTIONTABLE"/>
            </td>
          </tr>

          <tr>
            <td class="header-heading" use-string-resource="IDS_TU_REPORT_IMPORTTYPE"/>
            <td>
              <xsl:value-of select="Input/Options/ImportType"/>
            </td>
          </tr>
          
          <tr>
            <td class="header-heading" use-string-resource="IDS_TU_REPORT_ENTITYIMPORT"/>
            <td>
              <!--<xsl:apply-templates select="Input/Options/ImportElements/ImportElement"/>-->
              <xsl:apply-templates select="Input/Options/ImportElements"/>
            </td>
          </tr>

          <tr>
            <td class="header-heading" use-string-resource="IDS_TU_REPORT_IMPORT_ASMASSINGLEPART"/>
            <td>
              <xsl:value-of select="Input/Options/MetaParts"/>
            </td>
          </tr>

          <tr>
            <td class="header-heading" use-string-resource="IDS_TU_REPORT_CREATESURFACEAS"/>
            <td>
              <xsl:value-of select="Input/Options/CreateSurfaceAs"/>
            </td>
          </tr>

          <tr>
            <xsl:choose>
              <xsl:when test="Input/Options/ConstructionGroupMapping/GroupCreationMethod">
                <td class="header-heading" use-string-resource="IDS_TU_REPORT_GROUPS_FROM"/>
                <td>
                  <xsl:variable name="groups-from" select="Input/Options/ConstructionGroupMapping/GroupCreationMethod"/>
                  <xsl:choose>
                    <xsl:when test="$groups-from = 'Levels'" use-string-resource="IDS_TU_REPORT_LEVELS"/>
                    <xsl:when test="$groups-from = 'Groups'" use-string-resource="IDS_TU_REPORT_GROUPS"/>
                  </xsl:choose>
                </td>
              </xsl:when>
              <!--<xsl:otherwise>
                <td><xsl:value-of  select="Input/Options/CreateFrom"/></td>
              </xsl:otherwise>-->
            </xsl:choose>
          </tr>

          <xsl:if test="Input/File/Type='JT'">
            <tr>
              <td class="header-heading" use-string-resource="IDS_TU_REPORT_TESSELLATION_DETAIL"/>
              <td>
                <xsl:value-of select="Input/Options/TessellationDetail"/>
              </td>
            </tr>
          </xsl:if>

          <td class="header-heading" use-string-resource="IDS_TU_REPORT_UNITS"/>
          <td>
            <xsl:value-of select="Input/Units"/>
          </td>
          
          
          <xsl:if test="Input/File/Type='STL'">
            <tr>
              <td class="header-heading" use-string-resource="IDS_TU_REPORT_COLOR_ORDER"/>
              <td>
                <xsl:value-of select="Input/Options/Color"/>
              </td>
            </tr>
          </xsl:if>

          <xsl:if test="Input/File/Type='OBJ'">
          	<tr>
          		<td class="header-heading" use-string-resource="IDS_TU_REPORT_MESH_GROUP"/>
          		<td>
          			<xsl:value-of select="Input/Options/MeshGroup"/>
          		</td>
          	</tr>
          </xsl:if>

          <xsl:if test="(Input/File/Type='OBJ') or (Input/File/Type='STL') or (Input/File/Type='JT') or (Input/File/Type='CATIA V4') or (Input/File/Type='CATIA V5')">
          	<tr>
          		<td class="header-heading" use-string-resource="IDS_TU_REPORT_MESH_TRIANGLE_NUMBER"/>
          		<td>
          			<xsl:value-of select="Input/TriangleNumber"/>
          		</td>
          	</tr>
          </xsl:if>

        </table>

        <table border ="0" width="{$report-width}">
			<xsl:if test="Input/File/Type='Revit'" >
				<xsl:if test="Input/MigrationWarnings/MigrationWarning" >
					<tr>
						<td class="title" use-string-resource="IDS_TU_MIGRATION_WARNINGS" />
					</tr>
				    <xsl:for-each select="Input/MigrationWarnings/MigrationWarning">
						<tr>
							<td>
					        	<xsl:value-of select="." />
							</td>
						</tr>
					</xsl:for-each>
				</xsl:if>
			</xsl:if>
        </table>
					<!--<tr>												
                        <xsl:if test="Input/ProductEdition!='INVLT'">
						    <td class="header-heading" use-string-resource="IDS_TRANSREPORT_CONSTRUCTION_GROUP_MAPPING"/>
						    <td>
							    <xsl:variable name="group-data-placement" select="Input/Options/ConstructionGroupMapping/GroupDataPlacement"/>
							    <xsl:choose>
								    <xsl:when test="$group-data-placement = 'Single'" use-string-resource="IDS_TRANSREPORT_SINGLE"/>
								    <xsl:when test="$group-data-placement = 'Multiple'" use-string-resource="IDS_TRANSREPORT_MULTIPLE"/>
							    </xsl:choose>
						    </td>
                        </xsl:if>
					</tr>
					<tr>
                        <xsl:if test="Input/ProductEdition!='INVLT'">
						    <td class="header-heading" use-string-resource="IDS_TRANSREPORT_DESTINATION"/>
						    <td>
							    <xsl:variable name="destination" select="Input/Options/Destination"/>
							    <xsl:choose>
								    <xsl:when test="$destination = 'Composite'" use-string-resource="IDS_TRANSREPORT_COMPOSITE"/>
								    <xsl:when test="$destination = 'Construction'" use-string-resource="IDS_TRANSREPORT_CONSTRUCTION"/>
							    </xsl:choose>
						    </td>
                        </xsl:if>
					</tr>
					<tr>
						<td colspan="2"/>
						<xsl:choose>
							<xsl:when test="Input/Options/ConstructionGroupMapping/GroupName">
								<td><span class="header-heading" use-string-resource="IDS_TRANSREPORT_GROUP_NAME"/></td>
								<td><xsl:value-of select="Input/Options/ConstructionGroupMapping/GroupName"/></td>
							</xsl:when>
							<xsl:when test="Input/Options/ConstructionGroupMapping/GroupCreationMethod">
								<td><span class="header-heading" use-string-resource="IDS_TRANSREPORT_GROUPS_FROM"/></td>
								<td>
									<xsl:variable name="groups-from" select="Input/Options/ConstructionGroupMapping/GroupCreationMethod"/>
									<xsl:choose>
										<xsl:when test="$groups-from = 'Levels'" use-string-resource="IDS_TRANSREPORT_LEVELS"/>
										<xsl:when test="$groups-from = 'Groups'" use-string-resource="IDS_TRANSREPORT_GROUPS"/>
									</xsl:choose>
								</td>
							</xsl:when>
							<xsl:otherwise><td colspan="2"/></xsl:otherwise>
						</xsl:choose>
					</tr>
					<xsl:if test="Input/Options/ConstructionGroupMapping/GroupNamePrefix">
						<tr>
							<td colspan="2"/>
							<td><span class="header-heading" use-string-resource="IDS_TRANSREPORT_GROUP_NAME_PREFIX"/></td>
							<td><xsl:value-of select="Input/Options/ConstructionGroupMapping/GroupNamePrefix"/></td>
						</tr>
					</xsl:if>-->
				<xsl:apply-templates select="Output"/>
				<p/>
			</body>
		</html>
	</xsl:template>

	<!-- Lists import elements (Solids, Wires, Surfaces) with comma separator -->
	<xsl:template match="TranslationResults/Input/Options/ImportElements/ImportElement">
		<xsl:variable name="import-element" select="."/>
		<xsl:choose>
			<xsl:when test="$import-element = 'Solids'" use-string-resource="IDS_TU_REPORT_SOLIDS"/>
			<xsl:when test="$import-element = 'Wires'" use-string-resource="IDS_TU_REPORT_WIRES"/>
			<xsl:when test="$import-element = 'Surfaces'" use-string-resource="IDS_TU_REPORT_SURFACES"/>
      <xsl:when test="$import-element = 'Points'" use-string-resource="IDS_TU_REPORT_POINTS"/>
      <xsl:when test="$import-element = 'Work Planes'" use-string-resource="IDS_TU_REPORT_WPS"/>
      <xsl:when test="$import-element = 'Work Axes'" use-string-resource="IDS_TU_REPORT_WAEXS"/>
      <xsl:when test="$import-element = 'Work Points'" use-string-resource="IDS_TU_REPORT_WPTS"/>
      <xsl:when test="$import-element = 'Meshes'" use-string-resource="IDS_TU_REPORT_MESHES"/>
      <xsl:when test="$import-element = 'None'" use-string-resource="IDS_TU_REPORT_NONE"/>
    </xsl:choose>
		<xsl:if test="position() != last()">, </xsl:if>
	</xsl:template>
  
	<!-- Output data -->
	<xsl:template match="TranslationResults/Output">
		<xsl:call-template name="component-table"/>
		<xsl:apply-templates select="Miscellaneous"/>
		<xsl:apply-templates select="ValidationProperties"/>
	</xsl:template>
	
	<!-- Generate the "Component" section -->
	<xsl:template name="component-table">
		<xsl:variable name="component-expand-collapse-id" select="'component-'"/>
		<h2 class="section-heading" use-string-resource="IDS_TU_REPORT_COMPONENTHEADER"/>
        <xsl:choose>
            <xsl:when  test="//ProductEdition='INVLT'">
              <p class="table-description" use-string-resource="IDS_TU_REPORT_COMPONENTTABLE_LT"/>
            </xsl:when>
            <xsl:otherwise>
		      <p class="table-description" use-string-resource="IDS_TU_REPORT_COMPONENTTABLE"/>
            </xsl:otherwise>
        </xsl:choose>
		<table border="0" width="{$report-width}">
			<col width="{$plus-minus-col-width}"/>
			<tr>
				<th>
					<xsl:call-template name="plus-minus-all">
						<xsl:with-param name="expand-collapse-id" select="$component-expand-collapse-id"/>
					</xsl:call-template>
				</th>
				<th use-string-resource="IDS_TU_REPORT_NAME"/>
				<th use-string-resource="IDS_TU_REPORT_INVFILE"/>
				<th use-string-resource="IDS_TU_REPORT_STATUS"/>
			</tr>
			<xsl:apply-templates select="File">
				<xsl:with-param name="expand-collapse-id" select="$component-expand-collapse-id"/>
			</xsl:apply-templates>
		</table>
	</xsl:template>

  <!-- Generate a table row for a file -->
  <xsl:template match="File">
    <xsl:param name="expand-collapse-id" select="'expand-collapse-default'"/>
    <xsl:variable name="row" select="position()"/>
    <xsl:variable name="row-odd-even" select="$row mod 2"/>
    <tr id="{$expand-collapse-id}row{$row}" class="row-style{$row-odd-even}">
      <td>
        <xsl:call-template name="plus-minus-item">
          <xsl:with-param name="expand-collapse-id" select="$expand-collapse-id"/>
          <xsl:with-param name="row" select="$row"/>
          <xsl:with-param name="expand-test" select="AsmResults"/>
        </xsl:call-template>
      </td>

            <td><xsl:value-of select="Filename"/></td>

          <td>
            <a>
					<xsl:attribute name="href"><xsl:value-of select="FullPath"/></xsl:attribute>
              <xsl:value-of select="FullPath"/>
            </a>
          </td>

        <td>
        <xsl:call-template name="asm-severity"/>
      </td>
    </tr>

    <xsl:if test="AsmResults">
      <tr id="{$expand-collapse-id}details{$row}" style="display: none">
        <xsl:apply-templates select="AsmResults"/>
      </tr>
    </xsl:if>
  </xsl:template>

  <!-- Generate the "Miscellaneous" section (if there are any miscellaneous items) -->
	<xsl:template match="Miscellaneous">
		<xsl:variable name="misc-expand-collapse-id" select="'misc-'"/>
		<h2 class="section-heading" use-string-resource="IDS_TU_REPORT_MISC_HEADER"/>
		<table border="0" width="{$report-width}">
			<col width="{$plus-minus-col-width}"/>
			<tr>
				<th>
					<xsl:call-template name="plus-minus-all">
						<xsl:with-param name="expand-collapse-id" select="$misc-expand-collapse-id"/>
					</xsl:call-template>
				</th>
				<th use-string-resource="IDS_TU_REPORT_MISC_RESULTS"/>
			</tr>
			<xsl:call-template name="misc-asm-results">
				<xsl:with-param name="expand-collapse-id" select="$misc-expand-collapse-id"/>
			</xsl:call-template>
		</table>
	</xsl:template>
	
	<!-- Generate a table for a collection ASM results under the Miscellaneous heading -->
	<xsl:template name="misc-asm-results">
		<xsl:param name="expand-collapse-id" select="'expand-collapse-default'"/>
		<xsl:variable name="row" select="1"/>
		<xsl:variable name="row-odd-even" select="$row mod 2"/>
		<tr id="{$expand-collapse-id}row{$row}" class="row-style{$row-odd-even}">
			<td>
				<xsl:call-template name="plus-minus-item">
					<xsl:with-param name="expand-collapse-id" select="$expand-collapse-id"/>
					<xsl:with-param name="row" select="$row"/>
					<xsl:with-param name="expand-test" select="AsmResults"/>
				</xsl:call-template>
			</td>
           
           <td use-string-resource="IDS_TU_REPORT_ASM_RESULTS"/>
		</tr>
		
		<xsl:if test="AsmResults">
			<tr id="{$expand-collapse-id}details{$row}" style="display: none">
				<xsl:apply-templates select="AsmResults"/>
			</tr>
		</xsl:if>
	</xsl:template>

	<!-- Generate a table for a collection of ASM results -->
	<xsl:template match="AsmResults">
		<td/>		
		<td colspan="3">
			<table border="1" width="100%">
				<col width="15%"/><col width="10%"/><col width="75%"/>
				<tr>
					<th use-string-resource="IDS_TU_REPORT_SEVERITY"/>
					<th use-string-resource="IDS_TU_REPORT_ENTITYID"/>
					<th use-string-resource="IDS_TU_REPORT_MESSAGE"/>
				</tr>
			
				<xsl:apply-templates select="AsmResult"/>
			</table>
			<p/>
		</td>
	</xsl:template>

	<!-- Generate a single table row for an ASM result -->
	<xsl:template match="AsmResult">
		<tr>
			<td>
				<xsl:call-template name="severity-string">
					<xsl:with-param name="severity" select="@Severity"/>
				</xsl:call-template>
			</td>
			<td><xsl:value-of select="translate(@EntityId, ',', '')"/></td>
			<td><xsl:value-of select="."/></td>
		</tr>
	</xsl:template>

	<!-- Generates top level +/- for "Expand All" and "Collapse All" functionality -->
	<xsl:template name="plus-minus-all">
		<xsl:param name="expand-collapse-id" select="'expand-collapse-default'"/>
		<div class="plus-minus">
			<span onclick="ExpandAll('{$expand-collapse-id}')" use-string-resource="IDS_TU_REPORT_PLUS"/>
			<span use-string-resource="IDS_TU_REPORT_SLASH"/>
			<span onclick="CollapseAll('{$expand-collapse-id}')" use-string-resource="IDS_TU_REPORT_MINUS"/>
		</div>
	</xsl:template>
	
	<!-- Generates [+], [-], or [ ] for expandable rows depending on if the row is collapsed, expanded, or not expandable, respectively -->
	<xsl:template name="plus-minus-item">
		<xsl:param name="expand-collapse-id" select="'expand-collapse-default'"/>
		<xsl:param name="expand-test" select="false()"/>
		<xsl:param name="row" select="1"/>
		<xsl:choose>
			<xsl:when test="$expand-test">
				<div onclick="Expand({$row}, '{$expand-collapse-id}')" id="{$expand-collapse-id}plus{$row}" class="plus-minus" use-string-resource="IDS_TU_REPORT_EXPAND"/>
				<div onclick="Collapse({$row}, '{$expand-collapse-id}')" id="{$expand-collapse-id}minus{$row}" class="plus-minus" style="display: none" use-string-resource="IDS_TU_REPORT_COLLAPSE"/>
			</xsl:when>
			<xsl:otherwise>
				<div class="plus-minus" use-string-resource="IDS_TU_REPORT_NOEXPAND"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	

	 <!-- Gets localized ASM severity string based on XML, or outputs success string if no ASM errors -->
	<xsl:template name="asm-severity">
		<xsl:choose>
			<xsl:when test="AsmResults">
				<xsl:call-template name="severity-string">
					<xsl:with-param name="severity" select="AsmResults/AsmResult/@Severity"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Gets localized severity string based on XML severity string -->
	<xsl:template name="severity-string">
		<xsl:param name="severity" select="'Unknown'"/>
		<xsl:choose>
			<xsl:when test="$severity = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
			<xsl:when test="$severity = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
			<xsl:when test="$severity = 'Message'"><div class="status-message" use-string-resource="IDS_TU_REPORT_MESSAGE"/></xsl:when>
			<xsl:when test="$severity = 'Debug'"><div class="status-debug" use-string-resource="IDS_TU_REPORT_STATUSDBG"/></xsl:when>
			<xsl:otherwise><div class="status-unknown" use-string-resource="IDS_TU_REPORT_UNKNOWN"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Formats time into format H:M:S:ms -->
	<xsl:template name="format-elapsed-time">
		<xsl:param name="milliseconds" select="0.0"/>

		<xsl:variable name="milliseconds-remainder" select="floor($milliseconds mod 1000)"/>
		<xsl:variable name="seconds" select="$milliseconds div 1000"/>
		<xsl:variable name="seconds-remainder" select="floor($seconds mod 60)"/>
		<xsl:variable name="minutes" select="floor($seconds div 60)"/>
		<xsl:variable name="minutes-remainder" select="floor($minutes mod 60)"/>
		<xsl:variable name="hours" select="floor($minutes div 60)"/>

		<xsl:value-of select="format-number($hours, '00')"/>
		<xsl:value-of select="format-number($minutes-remainder, ':00')"/>
		<xsl:value-of select="format-number($seconds-remainder, ':00')"/>
		<!--[MSXML6] xsl:number is not suitable for numbers less than 0.5, although it can get expected result by MSXML3.0, however,
		MSXML6.0 won't. The value expression is evaluated and the resulting object is converted to a number as if by a call to the 
		number function. It is an error if the number is NaN, infinite or less than 0.5; see http://www.w3.org/1999/11/REC-xslt-19991116-errata/ for details.-->
		<!--<xsl:number value="$hours" format="01"/>
		<xsl:number value="$minutes-remainder" format=":01"/>
		<xsl:number value="$seconds-remainder" format=":01"/>-->
		<!--<xsl:number value="$milliseconds-remainder" format=":001"/>-->
	</xsl:template>
	
	<!-- Validation Properties Data -->
	<xsl:template match="ValidationProperties">
		<h2 class="section-heading">Validation Properties</h2>
		<xsl:variable name="row" select="position()"/>
		<xsl:variable name="row-odd-even" select="$row mod 2"/>		
		<table border="0" width="{$report-width}">
		  <tr class="row-style{$row-odd-even}">
			<th>Path</th>
			<th>Type</th>
			<th>Name</th>
			<th>Value</th>
		  </tr>
		  <xsl:for-each select="ValidationProperty">
			  <tr class="row-style{$row-odd-even}">
				<td><xsl:value-of select="Path" /></td>
				<td><xsl:value-of select="Type" /></td>
				<td><xsl:value-of select="Name" /></td>
				<xsl:if test="Name='Centroid'">
				  <td><table width="100%">
					<tr>
							<th width="40%"><center>Imported</center></th>
							<th width="40%"><center>Calculated</center></th>
							<th width="20%"><center>Status</center></th>
					</tr>
					<tr>
						<td width="40%">
							<table width="100%">
								<tr>
									<td><xsl:value-of select="Imported/X" /></td>
								</tr>
								<tr>
									<td><xsl:value-of select="Imported/Y" /></td>
								</tr>
								<tr>
									<td><xsl:value-of select="Imported/Z" /></td>
								</tr>
							</table>
						</td>
						<td width="40%">
							<table width="100%">
								<tr>
									<td><xsl:value-of select="Calculated/X" /></td>
								</tr>
								<tr>
									<td><xsl:value-of select="Calculated/Y" /></td>
								</tr>
								<tr>
									<td><xsl:value-of select="Calculated/Z" /></td>
								</tr>
							</table>
						</td>
						<td width="20%">
							<xsl:choose>
								<xsl:when test="Status = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
								<xsl:when test="Status = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
								<xsl:when test="Status = 'Success'"><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:when>
							</xsl:choose>		
						</td>
					</tr>
				  </table></td>
				</xsl:if>
				<xsl:if test="Name='BoundingBox'">
					<td>
						<table width="100%">
							<tr>
								<th width="40%"><center>Imported</center></th>
								<th width="40%"><center>Calculated</center></th>
								<th width="20%"><center>Status</center></th>
							</tr>
							<tr>
								<td width="40%">
									<table width="100%">
										<tr>
											<th width="50%">MaxPoint</th>
											<th width="50%">MinPoint</th>
										</tr>
										<tr>
											<td width="50%"><xsl:value-of select="Imported/MaxPoint/X"/></td>
											<td width="50%"><xsl:value-of select="Imported/MinPoint/X"/></td>
										</tr>
										<tr>
											<td width="50%"><xsl:value-of select="Imported/MaxPoint/Y"/></td>
											<td width="50%"><xsl:value-of select="Imported/MinPoint/Y"/></td>
										</tr>
										<tr>
											<td width="50%"><xsl:value-of select="Imported/MaxPoint/Z"/></td>
											<td width="50%"><xsl:value-of select="Imported/MinPoint/Z"/></td>
										</tr>
									</table>
								</td>
								<td width="40%">
									<table width="100%">
										<tr>
											<th width="50%">MaxPoint</th>
											<th width="50%">MinPoint</th>
										</tr>
										<tr>
											<td width="50%"><xsl:value-of select="Calculated/MaxPoint/X"/></td>
											<td width="50%"><xsl:value-of select="Calculated/MinPoint/X"/></td>
										</tr>
										<tr>
											<td width="50%"><xsl:value-of select="Calculated/MaxPoint/Y"/></td>
											<td width="50%"><xsl:value-of select="Calculated/MinPoint/Y"/></td>
										</tr>
										<tr>
											<td width="50%"><xsl:value-of select="Calculated/MaxPoint/Z"/></td>
											<td width="50%"><xsl:value-of select="Calculated/MinPoint/Z"/></td>
										</tr>
									</table>
								</td>
								<td width="20%">
									<xsl:choose>
										<xsl:when test="Status = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
										<xsl:when test="Status = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
										<xsl:when test="Status = 'Success'"><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:when>
									</xsl:choose>		
								</td>								
							</tr>
						</table>
					</td>
				</xsl:if>			
				<xsl:if test="Name='Volume'">
					<td><table width="100%">
						<tr>
							<th width="40%"><center>Imported</center></th>
							<th width="40%"><center>Calculated</center></th>
							<th width="20%"><center>Status</center></th>
						</tr>
						<tr>
							<td width="40%"><xsl:value-of select="Imported/Volume"/></td>
							<td width="40%"><xsl:value-of select="Calculated/Volume"/></td>
							<td width="20%">
								<xsl:choose>
									<xsl:when test="Status = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
									<xsl:when test="Status = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
									<xsl:when test="Status = 'Success'"><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:when>
								</xsl:choose>		
							</td>															
						</tr>
					</table></td>
				</xsl:if>			
				<xsl:if test="Name='SurfaceArea'">
					<td><table width="100%">
						<tr>
							<th width="40%"><center>Imported</center></th>
							<th width="40%"><center>Calculated</center></th>
							<th width="20%"><center>Status</center></th>
						</tr>
						<tr>
							<td width="40%"><xsl:value-of select="Imported/Area"/></td>
							<td width="40%"><xsl:value-of select="Calculated/Area"/></td>
							<td width="20%">
								<xsl:choose>
									<xsl:when test="Status = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
									<xsl:when test="Status = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
									<xsl:when test="Status = 'Success'"><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:when>
								</xsl:choose>		
							</td>															
						</tr>
					</table></td>
				</xsl:if>						
				<xsl:if test="Name='CurveLength'">
					<td><table width="100%">
						<tr>
							<th width="40%"><center>Imported</center></th>
							<th width="40%"><center>Calculated</center></th>
							<th width="20%"><center>Status</center></th>
						</tr>
						<tr>
							<td width="40%"><xsl:value-of select="Imported/Length"/></td>
							<td width="40%"><xsl:value-of select="Calculated/Length"/></td>
							<td width="20%">
								<xsl:choose>
									<xsl:when test="Status = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
									<xsl:when test="Status = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
									<xsl:when test="Status = 'Success'"><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:when>
								</xsl:choose>		
							</td>															
						</tr>
					</table></td>
				</xsl:if>						
				<xsl:if test="Name='PointsCount'">
					<td><table width="100%">
						<tr>
							<th width="40%"><center>Imported</center></th>
							<th width="40%"><center>Calculated</center></th>
							<th width="20%"><center>Status</center></th>
						</tr>
						<tr>
							<td width="40%"><xsl:value-of select="Imported/Count"/></td>
							<td width="40%"><xsl:value-of select="Calculated/Count"/></td>
							<td width="20%">
								<xsl:choose>
									<xsl:when test="Status = 'Error'"><div class="status-error" use-string-resource="IDS_TU_REPORT_STATUSERR"/></xsl:when>
									<xsl:when test="Status = 'Warning'"><div class="status-warning" use-string-resource="IDS_TU_REPORT_STATUSWARN"/></xsl:when>
									<xsl:when test="Status = 'Success'"><div class="status-success" use-string-resource="IDS_TU_REPORT_STATUSSUCCESS"/></xsl:when>
								</xsl:choose>		
							</td>															
						</tr>
					</table></td>
				</xsl:if>						
			  </tr>
		  </xsl:for-each>
		</table>
	</xsl:template>
</xsl:stylesheet>

