texture	 g_AOMap;
texture	 g_NormalDepthMap;

#define M_PI 3.14159265f
sampler2D g_AOSamp= sampler_state
{
    Texture = <g_AOMap>;
    MinFilter = Point;
    MipFilter = Point;
    MagFilter = Point;
    AddressU = Wrap;
    AddressV = Wrap;
};

sampler2D g_NormalDepthSamp= sampler_state
{
    Texture = <g_NormalDepthMap>;
    MinFilter = Point;
    MipFilter = Point;
    MagFilter = Point;
    AddressU = Clamp;
    AddressV = Clamp;
};

float2 g_Resolution;
float2 g_InvResolution;
float g_BlurRadius;
float g_BlurFalloff;
float g_Sharpness;


//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

struct PostProc_VSOut
{
    float4 pos : POSITION0;
    float2 tex : TEXCOORD0;
};

//Vertex shader that generates a full screen quad with texcoords g_Rom vertIDs
//To use draw 3 vertices with primitive type triangle strip
PostProc_VSOut FullScreenQuadVS( VS_INPUT IN )
{
    PostProc_VSOut output = (PostProc_VSOut)0.0f;
    output.pos=IN.Pos;
    output.tex=IN.UV.xy;
	
    return output;
}

//-------------------------------------------------------------------------
float fetch_eye_z(float2 uv)
{
    return tex2Dlod(g_NormalDepthSamp,float4(uv,0,0)).w;
}

//-------------------------------------------------------------------------
float BlurFunction(float2 uv, float r, float center_c, float center_d, inout float w_total,float3 center_n)
{
    float c = tex2Dlod(g_AOSamp,float4(uv,0,0));
    float d = fetch_eye_z(uv);
    float3 N = normalize(tex2Dlod(g_NormalDepthSamp,float4(uv,0,0)).xyz);
    float w =0; 
    //We have clear the background z as 100000000.0f. The blur for BG is not needed.
	if(d>1e-10f)
	{
		float ddiff = d - center_d;
		if(dot(N,center_n)>=0.9f)
		{
			w=exp(-r*r*g_BlurFalloff - ddiff*ddiff*g_Sharpness);
		}
    }
    w_total += w;

    return w*c;
}

//-------------------------------------------------------------------------
float4 BlurY( PostProc_VSOut IN ): COLOR0
{
	float center_c = tex2Dlod(g_AOSamp,float4(IN.tex,0,0)).x;
    float w_total = 0.00000001f;
    float b = center_c*w_total;
    float center_d = fetch_eye_z(IN.tex);
    float3 N = normalize(tex2Dlod(g_NormalDepthSamp,float4(IN.tex,0,0)).xyz);
	for (float r = -g_BlurRadius; r <= g_BlurRadius; ++r)
	{
		float2 uv = IN.tex.xy + float2(0,r*g_InvResolution.y);
		b += BlurFunction(uv, r, center_c, center_d, w_total,N);	
	} 
    float4 output=b/w_total;
    return output;
}


//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique AORender
{
    pass P0
    {   
		VertexShader = compile vs_3_0 FullScreenQuadVS();
       	PixelShader = compile ps_3_0 BlurY();
	}
}
