//**************************************************************************/
// Copyright (c) 2013 Autodesk, Inc.
// All rights reserved.
//
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/
// DESCRIPTION: Tone Mapping mask effect.
// AUTHOR: Copy from ACAD
// CREATED: October 2013
//**************************************************************************/

// World-view-projection transformation.
// NOTE: For this effect, this contains the view-projection transformation from the
// perspective of the light of interest.
float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >;
// Depth priority, which shifts the model a bit forward in the z-buffer
float gDepthPriority : DepthPriority
<
    string UIName =  "Depth Priority";
    string UIWidget = "Slider";
    float UIMin = -16/1048576.0f;    // divide by 2^24/16 by default
    float UIMax = 16/1048576.0f;
    float UIStep = 1/1048576.0f;
> = 0.0f;

// Vertex shader input structure.
struct VS_INPUT
{
    float3 Pos : POSITION;
};

// Vertex shader output structure.
struct VS_TO_PS
{
    float4 HPos : SV_Position;
};

// Vertex shader.
VS_TO_PS VS_TONEMAPPINGMASK(VS_INPUT In)
{
    VS_TO_PS Out;
    
    // Transform the vertex from object space to clip space and world space.
    Out.HPos = mul(float4(In.Pos, 1.0f), gWVPXf);
	// modify the HPos a bit by biasing the Z a bit forward, based on depth priority
    Out.HPos.z -= Out.HPos.w*gDepthPriority;
    return Out;
}

// Pixel shader.
float4 PS_TONEMAPPINGMASK(VS_TO_PS In) : SV_Target
{
      return float4(1.0,0.0f, 0.0f ,0.0f);
}


// The main technique.
technique10 Main
{
    pass p0
    {
        SetVertexShader(CompileShader(vs_4_0, VS_TONEMAPPINGMASK()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS_TONEMAPPINGMASK()));
    }
}
