Texture2D<float>  g_AOMap;
Texture2D<float4> g_NormalDepthMap;

float2 g_Resolution;
float2 g_InvResolution;
float g_BlurRadius;
float g_BlurFalloff;
float g_Sharpness;

SamplerState samNearest
{
    Filter   = MIN_MAG_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

struct PostProc_VSOut
{
    float4 pos : SV_Position;
    float2 tex : TEXCOORD0;
};

//Vertex shader that generates a full screen quad with texcoords g_Rom vertIDs
//To use draw 3 vertices with primitive type triangle strip
PostProc_VSOut FullScreenQuadVS( VS_INPUT IN )
{
    PostProc_VSOut output = (PostProc_VSOut)0.0f;
    output.pos=IN.Pos;
    output.tex=IN.UV.xy;
	
    return output;
}

//-------------------------------------------------------------------------
float fetch_eye_z(float2 uv)
{
    float z = g_NormalDepthMap.Sample(samNearest, float3(uv, 0)).w;
    return z;
}

//-------------------------------------------------------------------------
float BlurFunction(float2 uv, float r, float center_c, float center_d, inout float w_total,float3 center_n)
{
    float c = g_AOMap.Sample( samNearest, uv );
    float d = fetch_eye_z(uv);
    float3 N = normalize(g_NormalDepthMap.SampleLevel(samNearest, float3(uv, 0), 0).xyz);
    float w =0; 
    //We have clear the background z as 0.0f. The blur for BG is not needed.
	if(d>1e-10f)
	{
		float ddiff = d - center_d;
		if(dot(N,center_n)>=0.9f)
		{
			w=exp(-r*r*g_BlurFalloff - ddiff*ddiff*g_Sharpness);
		}
    }
    w_total += w;

    return w*c;
}


//-------------------------------------------------------------------------
float4 BlurY(PostProc_VSOut IN): SV_TARGET
{
	float center_c = g_AOMap.Sample( samNearest, IN.tex, 0 );
    float w_total = 0.00000001f;
    float b = center_c*w_total;
    float center_d = fetch_eye_z(IN.tex);
    float3 N = normalize(g_NormalDepthMap.SampleLevel(samNearest, float3(IN.tex, 0), 0).xyz);
    //We have clear the background z as 0.0f
	for (float r = -g_BlurRadius; r <= g_BlurRadius; ++r)
	{
		float2 uv = IN.tex.xy + float2(0, r*g_InvResolution.y); 
		b += BlurFunction(uv, r, center_c, center_d, w_total,N);
	}

 
    return b/w_total;	
}

//-------------------------------------------------------------------------
technique10 BlurPass
{
    pass pY
    {
        SetVertexShader( CompileShader( vs_4_0, FullScreenQuadVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, BlurY() ) );
    }
}
