#define NONORMAL
#include "InventorBasicEffectDx9.fxh"

struct VSPos
{
	float3 Pos			: Position;
#ifdef COLOR
	float4 Col			: Color;
#endif
#ifdef DIFFUSE_TEXTURE
	float2 Tex			: TexCoord;
#endif	
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input,uniform float2 offset)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);

	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	if(Out.Pos.w > 0.0f)
	{
		//In orthographics mode, Out.Pos.w is always 1.0f, so this is not a problem.
		//But in perspective mode, if Out.Pos.w <= 0, that means we are out of the view frustum
		//and we can't do the following computation otherwise there will be some problem. see DID 1288930
		Out.Pos.xyz /= Out.Pos.w;
		Out.Pos.w = 1.0f;
		Out.Pos.xy += offset.xy;
	}
	
#ifdef COLOR
	Out.ColorD = Input.Col;
#else	
	Out.ColorD = g_Emissive;
	Out.ColorD.w = g_Misc.y;
#endif

#ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif
	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_Pos( PSInput Input ) : COLOR0
{
	if(Input.ColorD.a < g_Misc.w)
		discard;
	#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
	#endif
	float4 Color = saturate(Input.ColorD);
	return Color;
}

#ifdef TWO_PIXEL_WIDE
// wide line:2 pixels' width
//Actually 4 passes are needed: offset table is like this:(0,0),(0,1),(1,0),(1,1)
technique WideLine2pixels
{
    pass P0
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f,0.0f));
        PixelShader = compile ps_2_0 PS_Pos();   
    }
    pass P1
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f,-2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P2
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x,0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P3
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
}

#endif

#ifdef THREE_PIXEL_WIDE
// wide line:3 pixels' width
//Actually 5 passes are needed: offset table is like this:(0,-1),(-1,0),(0,0),(1,0),(0,1)
technique WideLine3pixels
{
    pass P0
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f, 2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P1
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(-2.0f/g_ViewPort.x, 0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P2
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f, 0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P3
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x,0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P4
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f, -2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
}

#endif

#ifdef FOUR_PIXEL_WIDE
// wide line:4 or more pixels' width
//Actually 13 passes are needed: offset table is like this:(0,-1),(1,-1),(-1,0),(0,0),(1,0),(2,0),(-1,1),(0,1),(1,1),(2,1),(0,2),(1,2)
technique WideLine4pixels
{
    pass P0
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f,2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P1
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x,2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P2
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(-2.0f/g_ViewPort.x, 0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P3
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f, 0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P4
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x, 0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P5
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2*2.0f/g_ViewPort.x, 0.0f));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P6
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(-2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P7
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f, -2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P8
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P9
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2*2.0f/g_ViewPort.x,-2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P10
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(0.0f,-2*2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
    pass P11
    {   
	VertexShader = compile vs_2_0 VS_Pos(float2(2.0f/g_ViewPort.x,-2*2.0f/g_ViewPort.y));
        PixelShader = compile ps_2_0 PS_Pos();
    }
}

#endif