#define LIGHTING
#define NONORMAL
#define DIFFUSE_TEXTURE
#include "InventorBasicEffectDx9.fxh"

struct VSPosTex
{
	float3 Pos		: Position;
	float2 Tex		: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosTex( VSPosTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
	//fog calculation
	if(g_fogEnabled)
	{
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}
	return Out;
}
float4 PS_PosTex( PSInput Input ) : COLOR0
{
	float4 texColor;
	texColor = tex2D(gDiffSamp, Input.Tex.xy);	
	Input.ColorD.w = texColor.w;
	
	if(Input.ColorD.w < 0.2f)
		discard;
		
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;
	
	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique PosTex
{
    pass P0
    {  
#ifdef SHADERMODEL2 
		VertexShader = compile vs_2_0 VS_PosTex();
		PixelShader = compile ps_2_0 PS_PosTex();
#else
		VertexShader = compile vs_2_a VS_PosTex();
		PixelShader = compile ps_2_a PS_PosTex();
#endif
    }
}