#define LIGHTING
#include "InventorBasicEffectDx9.fxh"

struct VSPosNorm
{
	float3 Pos		: Position;
	float3 Norm		: Normal;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNorm( VSPosNorm Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT); //normal in view space
	ViewNormal = normalize(ViewNormal);

#ifdef DIFFUSE_TEXTURE
	//automatic texture coordinate generation
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(Input.Norm*(g_texCoordType == TEX_COORD_NORMAL), 0);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex += float4(ViewNormal * (g_texCoordType == TEX_COORD_CAMERASPACENORMAL), 0);
	Out.Tex += float4((2.f * dot(Viewer,ViewNormal) * ViewNormal - Viewer) * (g_texCoordType == TEX_COORD_CAMERASPACEREFLECTIONVECTOR), 0);
#endif

#ifdef ENVIRONMENT_TEXTURE
	if (bEnvironmentMap2D)
	{			
		Out.EnvTex  = float4(ViewNormal, 1.0f);
	}
	else
	{
		float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
		float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));	
		Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
	}
#endif

	float Glossness = g_Misc.x;
	float Opacity = g_Misc.y;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, g_Emissive, g_Ambient, g_Diffuse, g_Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );
	Out.ColorD = Color.Diffuse;
	Out.ColorSAndFogFactor.xyz = Color.Specular.xyz; 	
		
#ifdef SHADOWS
    Out.ShadowPos = LocalPos;
#endif

	if(g_fogEnabled)
	{
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}
	
	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosNorm( PSInput Input ) : COLOR0
{
#ifdef SHADOWS
	Input.ShadowPos = mul(mul(Input.ShadowPos, g_matWorld), gShadowMapXf);
#ifdef SOFT_SHADOWS
	float shadowFactor = VarianceShadow(Input.ShadowPos);
#else 
	float shadowFactor = SampleShadowMap(Input.ShadowPos);
#endif 
    Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
    Input.ColorSAndFogFactor.xyz += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif

#ifdef DIFFUSE_TEXTURE
	Input.Tex = mul(Input.Tex, g_matDiffTex);
	CalcDiffuseTexture(Input);
#endif

#ifdef ENVIRONMENT_TEXTURE	
	Input.EnvTex = mul(Input.EnvTex, g_matEnvTex);
	CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;
				
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique PosNorm
{
    pass P0
    {  
#ifdef SHADERMODEL2 
		VertexShader = compile vs_2_0 VS_PosNorm();
		PixelShader = compile ps_2_0 PS_PosNorm();
#else
		VertexShader = compile vs_2_a VS_PosNorm();
		PixelShader = compile ps_2_a PS_PosNorm();
#endif
    }
}
