#define LIGHTING
#include "InventorBasicEffectDx10.fxh"


struct VSPosNormCol
{
	float3 Pos			: Position;
	float3 Norm			: Normal;
	float4 Col			: Color;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNormCol( VSPosNormCol Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);               //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT); //normal in view space
	ViewNormal = normalize(ViewNormal);

#ifdef DIFFUSE_TEXTURE
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(Input.Norm*(g_texCoordType == TEX_COORD_NORMAL), 0);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex += float4(ViewNormal * (g_texCoordType == TEX_COORD_CAMERASPACENORMAL), 0);
	Out.Tex += float4((2.f * dot(Viewer,ViewNormal) * ViewNormal - Viewer) * (g_texCoordType == TEX_COORD_CAMERASPACEREFLECTIONVECTOR), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

#ifndef IBL
	#ifdef ENVIRONMENT_TEXTURE
		if (bEnvironmentMap2D)
		{			
			Out.EnvTex  = float4(ViewNormal, 1.0f);
		}
		else
		{
			float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
			float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));	
			Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
			Out.EnvTex = mul(Out.EnvTex, g_matEnvTex);
		}
	#endif
#endif	
	float4 Emissive = float4(0,0,0,0);
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	float4 Ambient = Input.Col.zyxw;
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	float4 Diffuse = Input.Col.zyxw;
	float4 Specular = float4(0,0,0,0);
	float Glossness = 0;
	float Opacity = Input.Col.a;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, Emissive, Ambient, Diffuse, Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );

	Out.ColorD = Color.Diffuse;
	Out.ColorS = Color.Specular; 

	// Enable it to increase the weight of standard lights, this is necessary for case only Emissive color (no other material properties, IBL computing can not take effect) is specified
#ifdef INVTM
	Out.ColorD = CanonTM_InverseColor(Out.ColorD);
	Out.ColorS = CanonTM_InverseColor(Out.ColorS);
#endif

//Prepare the color for IBL lighting
#ifdef IBL
	Out.ColorD_IBL = Input.Col.zyxw;
	Out.ColorS_IBL = float4(0,0,0,0);
#endif //IBL
	
#ifdef SHADOWS
    Out.ShadowPos = mul(mul(LocalPos, g_matWorld), gShadowMapXf);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
	//Apply user specified clipping
	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
	if( g_bClippingEnable )
	{
		CalcClipping(LocalPos, Out);
	}
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
#ifdef WEIGHTEDAVERAGE
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_PosNormCol(VSOutput Input)
#else
float4 PS_PosNormCol(VSOutput Input) : SV_Target
#endif
{
#ifdef SHADOWS
#ifdef SOFT_SHADOWS
	float shadowFactor = VarianceShadow(Input.ShadowPos);
#else 
	float shadowFactor = SampleShadowMap(Input.ShadowPos);
#endif 
    Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
    Input.ColorS += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif

//When IBL is enabled, the normal environment reflection would be surpressed.
#ifdef IBL
	CalcIBLEnvTexture(Input,Input.ColorS_IBL,Input.ColorD_IBL, g_Misc.z, g_Misc.x, normalize(Input.Normal), Input.Viewer);
#endif //IBL

#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);

#ifdef INVTM
	if(g_texOpType == TEX_OP_DECAL)
	{
		Input.ColorD = CanonTM_InverseColor(Input.ColorD);
	}
#endif

#endif

#ifndef IBL //Not IBL
	#ifdef ENVIRONMENT_TEXTURE	
		CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
	#endif
#endif

if(Input.ColorD.a < g_Misc.w)
	discard;

#ifdef IBL
	float4 Color = Input.ColorD + Input.ColorS;
#else
	float4 Color = saturate(Input.ColorD + Input.ColorS);
#endif

if(g_fogEnabled)
	Color = Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;

#ifdef WEIGHTEDAVERAGE
pixelOutput output;
output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
output.oColor1 = 1.0;
return output;
#else
return Color;
#endif
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosNormCol
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS_PosNormCol()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosNormCol()) );
	}
}