#define NONORMAL
#include "InventorBasicEffectDx10.fxh"


struct VSPosColTex
{
	float3 Pos			: Position;
	float4 Col			: Color;
	float2 Tex			: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosColTex( VSPosColTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	Out.ColorD.xyzw = Input.Col.zyxw;

#ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
	  //Apply user specified clipping
    	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    	if( g_bClippingEnable )
    	{
		CalcClipping(LocalPos, Out);
    	}
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
#ifdef WEIGHTEDAVERAGE
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_PosColTex(VSOutput Input)
#else
float4 PS_PosColTex(VSOutput Input) : SV_Target
#endif
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;

#ifdef IBL
	float4 Color = Input.ColorD;

#ifdef INVTM
	if (gBackgroundBlendEnabled && Color.a<1.0)
	{
		float texW = 1.0f;
		float texH = 1.0f;
		gBackgroundTexture.GetDimensions(texW, texH);
		float sampleX = Input.Pos.x/texW;//(Input.Pos.x / Input.Pos.w + 1.0) / 2.0;
		float sampleY = Input.Pos.y/texH;//(1.0 - Input.Pos.y / Input.Pos.w) / 2.0;
		float4 BGColor = gBackgroundTexture.Sample(gBackgroundSamp2D, float2(sampleX, sampleY));
		BGColor = CanonTM_Color(BGColor);
		if (BGColor.r>0.8 && BGColor.g>0.8 && BGColor.b>0.8)
		{
			Color.r = BGColor.r*(1.0-Input.ColorD.a) + Color.r*Input.ColorD.a;
			Color.g = BGColor.g*(1.0-Input.ColorD.a) + Color.g*Input.ColorD.a;
			Color.b = BGColor.b*(1.0-Input.ColorD.a) + Color.b*Input.ColorD.a;
			Color.a = 1.0;
		}
	}
	Color = CanonTM_InverseColor(Color);
#endif

#else
	float4 Color = saturate(Input.ColorD);
#endif

if(g_fogEnabled)
	Color = Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;

#ifdef WEIGHTEDAVERAGE
pixelOutput output;
output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
output.oColor1 = 1.0;
return output;
#else
return Color;
#endif
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosColTex
{
    pass P0
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_PosColTex()) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosColTex()) );
    }
}