#define NONORMAL
#define LIGHTING
#include "InventorBasicEffectDx10.fxh"

struct VSPos
{
	float3 Pos			: Position;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);

	Out.Pos = mul(LocalPos, g_matWorldViewProj);

	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
#ifdef IBL
		if (Out.ColorD.r<0.001 && Out.ColorD.g<0.001 && Out.ColorD.b<0.001)
		{
			float4 fIBLAmbColor = float4(0.5, 0.5, 0.5, 1.0);
			Out.ColorD += fIBLAmbColor*g_Ambient;
		}
#endif
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.ColorD.w = g_Misc.y;

#ifdef DIFFUSE_TEXTURE
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	//Apply user specified clipping
   	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
   	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
   	if( g_bClippingEnable )
   	{
		CalcClipping(LocalPos, Out);
   	}

#ifdef FIX_Z
	Out.Pos.z = 0.205f;
#endif
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
#ifdef WEIGHTEDAVERAGE
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_Pos(VSOutput Input)
#else
float4 PS_Pos(VSOutput Input) : SV_Target
#endif
{

#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;

#ifdef IBL
	float4 Color = Input.ColorD + Input.ColorS;
#ifdef INVTM
	Color = CanonTM_InverseColor(Color);
#endif
	//float3 IBLAmb = CalcIBLEnvAmb(g_Ambient, normalize(Input.Normal));
	//Color += float4(IBLAmb, 0.0f);
#else
	float4 Color = saturate(Input.ColorD + Input.ColorS);
#endif

if(g_fogEnabled)
	Color = Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;

#ifdef WEIGHTEDAVERAGE
pixelOutput output;
output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
output.oColor1 = 1.0;
return output;
#else
return Color;
#endif
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 Pos
{
    pass P0
    {   
	SetVertexShader( CompileShader( vs_4_0, VS_Pos()) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_Pos()) );
    }
}