
struct VSPos
{
	float3 Pos		: Position;
	float2 offset		: TexCoord;
};

struct VSOutput
{
	float4 Pos		: SV_Position;
	float4 ColorD		: COLOR0;
	float4 ClipplaneDist0 	: SV_ClipDistance0;    //clip distance for 4 planes
	float4 ClipplaneDist1 	: SV_ClipDistance1;    //clip distance for 4 planes
};
cbuffer cbPerObject
{
	bool g_bClippingEnable	: ClippingEnabled = false;
	int g_numClipplane	: clippingplanecount = 0;
	float4 g_clipplanes[8]	: clippingplanes;
	float4 g_Emissive	: EmissiveColor;						
};
cbuffer cbPerFrame
{
	float4x4 g_matViewProjIT		: viewprojectioninversetranspose;
	//wvp transform
	float4x4 g_matWorldViewProj		: WorldViewProjection;
	float2		g_ViewPort			: viewportpixelsize;
};


#ifdef INVTM
float fExposure								: Exposure = 0.0;
float Mark_CanonTM_Tinv(float y)
{
	y = saturate(y);
	const float a = 1.0592;
	const float b = 1.0631;
	const float c = 4.5805;
	const float d = 1.5823;
	float tmp = (b / (a - y) - 1.0) / c;
	return pow(tmp, (1.0 / d));
}
float4 Mark_CanonTM_InverseColor(float4 reverseColor)
{
	// get luminance
	float3 revColor = reverseColor.rgb;
	float inLum = dot(float3(0.2126, 0.7152, 0.0722), revColor);

	if (inLum > 0.001) 
	{
		// Inverse of measured Canon sigmoid
		float outLum = Mark_CanonTM_Tinv(inLum);

		// scale the color, preserving channel ratios
		inLum = exp2(fExposure) * inLum;
		revColor = revColor * (outLum / inLum);
		reverseColor = float4(revColor, reverseColor.w);
	}
	else
	{
		revColor /= exp2(fExposure);
		reverseColor = float4(revColor, reverseColor.w);
	}
	return reverseColor;
}
#endif

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input)
{
	//Generate specific vertex data for marker
	VSOutput Out = (VSOutput) 0;
	
	//project vertex in model space to clipping space
	float4 LocalPos = float4(Input.Pos.xyz,1.0f);
	float4 outpos = mul(LocalPos,g_matWorldViewProj);
	
	//Perspective divide
	outpos.xyz /= outpos.w;
	outpos.w = 1.0f;
	
	//the vertex index is saved in alpha channel of each vertex
	outpos.xy += Input.offset/g_ViewPort;
	Out.Pos = outpos;
	
	Out.ColorD = g_Emissive;

	// Enable it to increase the weight of standard lights, this is necessary for case only Emissive color (no other material properties, IBL computing can not take effect) is specified
#ifdef INVTM
	Out.ColorD = Mark_CanonTM_InverseColor(Out.ColorD);
#endif
	 
	//Apply user specified clipping
	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
	if(g_bClippingEnable)
	{	
		float dist[8] = {1,1,1,1,1,1,1,1};
		for(int i=0;i<g_numClipplane;i++)
		{
			float4 clippingPlane=mul(g_clipplanes[i],g_matViewProjIT);
			float len=length(clippingPlane.xyz);
			if(len!=0)
			{
				float dlen=1.0f/len;
				float4 normalizeClippingPlane=clippingPlane*dlen;
				dist[i] = dot( LocalPos,normalizeClippingPlane);
			}
		}
		Out.ClipplaneDist0.x = dist[0];
		Out.ClipplaneDist0.y = dist[1];
		Out.ClipplaneDist0.z = dist[2];
		Out.ClipplaneDist0.w = dist[3];
		Out.ClipplaneDist1.x = dist[4];
		Out.ClipplaneDist1.y = dist[5];
		Out.ClipplaneDist1.z = dist[6];
		Out.ClipplaneDist1.w = dist[7];
	}
	return Out;
}

#ifdef WEIGHTEDAVERAGE
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_Pos(VSOutput Input)
#else
float4 PS_Pos(VSOutput Input) : SV_Target
#endif
{
#ifdef IBL
	float4 Color = Input.ColorD;
#else
	float4 Color = saturate(Input.ColorD);
#endif

#ifdef WEIGHTEDAVERAGE
	pixelOutput output;
	output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
	output.oColor1 = 1.0;
	return output;
#else
	return Color;
#endif
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosTex
{
    pass P0
    {   
	SetVertexShader(CompileShader(vs_4_0,VS_Pos()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_Pos()) );
    }
}