#ifdef SHADOWS
#include "ShadowMapDx10.fxh"
#ifdef SOFT_SHADOWS
float2 gExpFactor = { 20.000000, 5.000000 }; 
float threshold = 0.000000;
float VarianceShadow( float4 Plc) 
{ 
     float3 Pndc = Plc.xyz / Plc.w; 
    if (any(Pndc < -1.0f) || any(Pndc > 1.0f)) return 1.0f; 
    float2 uv = Pndc.xy * float2(0.5f, -0.5f) + float2(0.5f, 0.5f); 
    float texelSz = gTexelSize; 
    float4 moments = gShadowMapTex.Sample(gShadowMapSamp, uv); 
    float depth = exp(gExpFactor.x * Pndc.z); 
    float p = (depth <= moments.x); 
    float variance = moments.y - moments.x * moments.x; 
    variance = max(variance, 1.0e-3f*max(1.0f, depth*depth)); 
    float d = depth - moments.x; 
    float p_max = variance / (variance + d * d); 
    float posValue = max(p, p_max); 
    depth = -exp(-gExpFactor.y * Pndc.z); 
    p = (depth <= moments.z); 
    variance = moments.w - moments.z * moments.z; 
    variance = max(variance, 1.0e-3f*max(1.0f, depth*depth)); 
    d = depth - moments.z; 
    p_max = variance / (variance + d * d); 
    float negValue = max(p, p_max); 
    float light = min(negValue, posValue);
    return saturate((light-threshold) / (1.0f - threshold));
} 
#endif 
#endif

#define epsilon (10e-6)
#define E 2.71828
#define MAXLIGHTINGNUM 8

#define FOGMODE_LINEAR		0
#define FOGMODE_EXP		1
#define FOGMODE_EXP2		2

#ifdef INVTM
	float fExposure								: Exposure = 0.0;
#endif

struct TripleColor
{
	float4 Ambient;
	float4 Diffuse;
	float4 Specular;
};
struct VSOutput
{
	float4 Pos			: SV_Position;
#ifdef BUMP_TEXTURE
	// Diffuse tex coordinates and bump tex coordinates would be calculated at PS
	float4 Tex				: TEXCOORD0;
#else
	#ifdef DIFFUSE_TEXTURE
		float4 Tex				: TEXCOORD0;
	#endif
#endif //bump mapping

#ifndef IBL
	#ifdef ENVIRONMENT_TEXTURE
		float4 EnvTex		: TEXCOORD1;
	#endif
#endif


	float4 ColorD		: COLOR0;
	float4 ColorS		: COLOR1;

#ifdef BUMP_TEXTURE
	float3 Tangent		: COLOR2;
	float3 Binormal		: COLOR3;
	float3 Locpos		: COLOR4;
#endif

#ifdef IBL
	//Normal and viewer direction at world space
	#ifndef BUMP_TEXTURE
		float3 Normal		: COLOR5;
	#endif
	float3 Viewer		: COLOR6;
#endif

	float  FogFactor	: FOG;
	float4 ClipplaneDist0 	: SV_ClipDistance0;    //clip distance for 4 planes
	float4 ClipplaneDist1 	: SV_ClipDistance1;    //clip distance for 4 planes
	#ifdef SHADOWS
		float4 ShadowPos    	: TEXCOORD2;
		float4 ShadowD      	: TEXCOORD3;
		float4 ShadowS      	: TEXCOORD4;
	#endif

#ifdef IBL
	float4 ColorD_IBL		: COLOR7;
	float4 ColorS_IBL		: COLOR8;
#endif
};

#ifdef BUMP_TEXTURE
float		gBumpAmount				: BumpAmount=1.0f;
//Diffuse texture
Texture2D gBumpTex				: BumpTexture =NULL;
cbuffer cbBumpTextures
{
	float4x4 g_matBumpTex			: BumpTexCoordTransMatrix=	
	{
		{1.0f, 0.0f, 0.0f, 0.0f},
		{0.0f, 1.0f, 0.0f, 0.0f},
		{0.0f, 0.0f, 1.0f, 0.0f},
		{0.0f, 0.0f, 0.0f, 1.0f}
	} ; 
};
	
//sampler for various textures
SamplerState gBumpSamp:BumpSampler ;
#endif

#ifdef LIGHTING
struct Light
{
	float4 DiffColor;
	float4 AmbColor;
	float4 SpecColor;
	float3 Dir;
   	float3 Pos;
   	float4 Attenuation;	//1, D, D^2, Range;
   	float4 Spot;		//cos(theta/2), cos(phi/2), falloff
};
#endif


cbuffer cbPerObject
{
	//Material
	float4 g_Emissive			: EmissiveColor;
	float4 g_Ambient			: AmbientColor;
	float4 g_Diffuse			: DiffuseColor;
	float4 g_Specular			: SpecularColor;
	float4 g_Misc				: Miscellaneous = float4(1.0f, 1.0f, 0.0f, 0.0f);//SpecularPower, Opacity, ReflectionBlend, AlphaTestRef
	//Transform
	float4x4 g_matWorldViewProj		: WorldViewProjection;
	float4x4 g_matWorld			: World;
	float4x4 g_matWorldView			: WorldView;
#ifndef	NONORMAL
	float4x4 g_matWorldViewIT		: WorldViewInverseTranspose;
#endif
	bool g_bClippingEnable			:ClippingPlaneFlag = false;
	int g_numClipplane			:clippingplanecount = 0;
	float4 g_clipplanes[8]			:clippingplanes;
};

cbuffer cbPerFrame
{
#ifdef LIGHTING
	//Lights
	Light g_lights[8]			: LightArray;
	int g_numDirLight			: DirLightCount = 0;
	int g_numPointLight			: PointLightCount = 0;
	int g_numSpotLight			: SpotLightCount = 0;
	bool g_enabledLight			:LightEnable=true;
#endif

	//Fog
	bool		g_fogEnabled	: FogEnabled = false;
	int g_fogMode				: FogMode  = FOGMODE_LINEAR;
	float4 g_fogRange			: FogRange = float4(0.0f, 0.0f, 1.0f, 1.0f);//x for start, y for end, z for density
	float4 g_fogColor			: FogColor = float4(0, 0, 0, 0);
	//view transform perframe
	float4x4 g_matViewIT			: ViewInverseTranspose;
	float4x4 g_matView			: View;
	float2		g_ViewPort			: viewportpixelsize;
};

void CalcClipping(float4 LocalPos, inout VSOutput Out)
{
	//fixed function clipping is done in world space
	float4 WorldPos = mul(LocalPos,g_matWorld);
	WorldPos /= WorldPos.w;
	float dist[8] = {1,1,1,1,1,1,1,1};
	for(int i=0;i<g_numClipplane;i++)
	{
		dist[i] = dot( WorldPos, g_clipplanes[i]);
	}
	//calc the distance from the 8 clipping planes
	Out.ClipplaneDist0.x = dist[0];
	Out.ClipplaneDist0.y = dist[1];
	Out.ClipplaneDist0.z = dist[2];
	Out.ClipplaneDist0.w = dist[3];
	Out.ClipplaneDist1.x = dist[4];
	Out.ClipplaneDist1.y = dist[5];
	Out.ClipplaneDist1.z = dist[6];
	Out.ClipplaneDist1.w = dist[7];
}

// Vertex lighting calculation
// A vertex's color is the sum of the contribution from:
// 1. a material emission term, Em
// 2. global ambient lighting, Ag, and a material ambient term, Am
// 3. individual light's contributions L(i)

// VertexColor = Em + Ag*Am + sum(L(i)), where
// L(i) = Attenuation(i)*SpotlightFactor(i)*[Ai*Am + max(L.N, 0)*D(i)*Dm + pow(max(H.N, 0), shineness)*S(i)*Sm]

//-----------------------------------------------------------------------------
// Name: DoDirLight()
// Desc: Directional light computation (in eye space)
// N: Normal in eye space; V: Viewer in eye space; Index: Light Index
//-----------------------------------------------------------------------------

#ifdef LIGHTING
#ifdef NONORMAL
#ifdef ALLLIGHTTYPES
TripleColor DoSpotLightAmb(float4 P,int Index)
{
	TripleColor Out;
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Diffuse
	Out.Diffuse = 0;
	//Specular    
	Out.Specular = 0;
    
	float AttenSpot = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)
	{
		AttenSpot = 0.f;
	}
	else
	{
		AttenSpot *= 1.f/(g_lights[Index].Attenuation.x + g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	
	//spot cone computation
	float3 L = mul(normalize((g_lights[Index].Pos-(float3)mul(P, g_matWorld))), 
		(float3x3)g_matViewIT);
	float3 L2 = mul(g_lights[Index].Dir, (float3x3)g_matViewIT);
	float Rho = dot(L, L2);
	AttenSpot *= pow(saturate((Rho - g_lights[Index].Spot.y)/(g_lights[Index].Spot.x - g_lights[Index].Spot.y)), 1.0f);
		//g_lights[Index].Spot.z);
	Out.Ambient *= AttenSpot;
	Out.Diffuse *= AttenSpot;
	Out.Specular *= AttenSpot;
	return Out;
}
TripleColor DoPointLightAmb(float4 P, int Index)
{
	TripleColor Out;
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Diffuse
	Out.Diffuse = 0;
	//Specular
	Out.Specular = 0;
  
	//Attenuation
	float Atten = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)//Attenuation.w is Range
	{
		Atten = 0.f;
	}
	else
	{
		Atten *= 1.f/(g_lights[Index].Attenuation.x + 
			g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	Out.Ambient *= Atten;
	return Out;
}
#endif 

//For those case without normal, ambient color is just needed
TripleColor DoDirLightAmb(int Index)
{
   	TripleColor Out;
   	//Ambient
   	Out.Ambient = g_lights[Index].AmbColor;
   	//Diffuse
   	Out.Diffuse = 0;
   	//Specular
   	Out.Specular = 0;
   	return Out;
}

//For those cases without normal
TripleColor CalcLightingAmb(float3 Pos, float4 Emissive,float4 Ambient,float Opacity)
{
	TripleColor Color;
	//Emissive and Ambient lights
	Color.Diffuse = Emissive;

	Color.Specular = 0;
	//directional lights
	[loop] for(int i = 0; i < g_numDirLight; i++)
	{
//		if(i>=g_numDirLight) break;
	
		TripleColor ColOut = DoDirLightAmb(i);
		Color.Diffuse += ColOut.Ambient*Ambient;

	}

#ifdef ALLLIGHTTYPES
	float4 LocalPos = float4(Pos,1.0f);
	int Stride = g_numDirLight;
	//point lights
	[loop] for(int j = 0; j < g_numPointLight; j++)
	{
//		if(j>=g_numPointLight) break;

		TripleColor ColOut = DoPointLightAmb(LocalPos,j+Stride);
		Color.Diffuse += ColOut.Ambient*Ambient ;

	}
	Stride = g_numDirLight+g_numPointLight;
	//spot lights
	[loop] for(int k = 0; k < g_numSpotLight; k++)
	{
//		if(k>=g_numSpotLight) break;

		TripleColor ColOut = DoSpotLightAmb(LocalPos,k+Stride);
		Color.Diffuse += ColOut.Ambient*Ambient ;

	}
#endif 

	Color.Diffuse.w = Opacity;//Opacity
	Color.Specular.w = 0;
	return Color;
}

#else

TripleColor DoDirLight(float3 N, float3 V, int Index, float Glossness)
{
   	TripleColor Out;
   	float3 L = mul(g_lights[Index].Dir, (float3x3)g_matViewIT);
   	float NdotL = dot(N, L);
   	//Ambient
   	Out.Ambient = g_lights[Index].AmbColor;
   	//Diffuse
   	Out.Diffuse = max(NdotL, 0.0f) * g_lights[Index].DiffColor;
   	//Specular
   	float3 H = normalize(L + V);   //half vector
   	Out.Specular = 0;
   	if(NdotL>=0.0f)
   	{
      		Out.Specular += pow(max(0, dot(H, N)), Glossness) * g_lights[Index].SpecColor;
   	} 
   	return Out;
}

#ifdef ALLLIGHTTYPES
//-----------------------------------------------------------------------------
// Name: DoPointLight()
// Desc: Point light computation (in eye space)
// P: Position in local space; N: Normal in eye space; V: Viewer in eye space; Index: Light Index
//-----------------------------------------------------------------------------
TripleColor DoPointLight(float4 P, float3 N, float3 V, int Index, float Glossness)
{
	float3 L = mul(normalize((g_lights[Index].Pos-(float3)mul(P, g_matWorld))), (float3x3)g_matViewIT);
	TripleColor Out;
	float NdotL = dot(N, L);
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Diffuse
	Out.Diffuse = max(NdotL, 0.0f) * g_lights[Index].DiffColor;
	//Specular
	float3 H = normalize(L + V);   //half vector
	Out.Specular = 0;
    	if(NdotL>=0.0f)
    	{
		Out.Specular += pow(max(0, dot(H, N)), Glossness) * g_lights[Index].SpecColor;
	}
	//Attenuation
	float Atten = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)//Attenuation.w is Range
	{
		Atten = 0.f;
	}
	else
	{
		Atten *= 1.f/(g_lights[Index].Attenuation.x + 
			g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	Out.Ambient *= Atten;
	Out.Diffuse *= Atten;
	Out.Specular *= Atten;
	return Out;
}

//-----------------------------------------------------------------------------
// Name: DoSpotLight()
// Desc: Spot light computation (in eye space)
// P: Position in local space; N: Normal in eye space; V: Viewer in eye space; Index: Light Index
//-----------------------------------------------------------------------------
TripleColor DoSpotLight(float4 P, float3 N, float3 V, int Index, float Glossness)
{
	float3 L = mul(normalize((
		g_lights[Index].Pos-(float3)mul(P, g_matWorld))), 
		(float3x3)g_matViewIT);
	TripleColor Out;
	float NdotL = dot(N, L);
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Diffuse
	Out.Diffuse = max(NdotL, 0.0f) * g_lights[Index].DiffColor;
	//Specular    
	float3 H = normalize(L + V);   //half vector
	Out.Specular = 0;
    	if(NdotL>=0.0f)
    	{
		Out.Specular += pow(max(0, dot(H, N)), Glossness) * g_lights[Index].SpecColor;
	}
	float AttenSpot = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)
	{
		AttenSpot = 0.f;
	}
	else
	{
		AttenSpot *= 1.f/(g_lights[Index].Attenuation.x + g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	
	//spot cone computation
	float3 L2 = mul(g_lights[Index].Dir, (float3x3)g_matViewIT);
	float Rho = dot(L, L2);
	AttenSpot *= pow(saturate((Rho - g_lights[Index].Spot.y)/(g_lights[Index].Spot.x - g_lights[Index].Spot.y)), 1.0f);
		//g_lights[Index].Spot.z);
	Out.Ambient *= AttenSpot;
	Out.Diffuse *= AttenSpot;
	Out.Specular *= AttenSpot;
	return Out;
}
#endif 

//-----------------------------------------------------------------------------
// Name: CalcLighting
// Desc: Calculate the lighting for each vertex
//-----------------------------------------------------------------------------
TripleColor CalcLighting(float3 Pos, float3 Viewer, float3 ViewNormal, 
			float4 Emissive, float4 Ambient, float4 Diffuse, 
			float4 Specular, float Glossness, float Opacity
#ifdef SHADOWS
			,inout float4 shadowD, inout float4 shadowS
#endif
			)
{
	TripleColor Color;
	//Emissive and Ambient lights
	Color.Diffuse = Emissive;
	Color.Specular = 0;
	float4 LocalPos = float4(Pos,1.0f);
	//directional lights
	[loop] for(int i = 0; i < g_numDirLight; i++)
	{
//		if(i>=g_numDirLight) break;

		TripleColor ColOut = DoDirLight(ViewNormal, Viewer, i, Glossness);
		Color.Diffuse += ColOut.Ambient*Ambient +ColOut.Diffuse*Diffuse;
		Color.Specular += ColOut.Specular*Specular;
#ifdef SHADOWS
			if (i == 0)
			{
        		shadowD = ColOut.Diffuse*Diffuse;
        		shadowS = ColOut.Specular*Specular;
        		Color.Diffuse -= shadowD;
			Color.Specular -= shadowS;
			}
#endif

	}
	
#ifdef ALLLIGHTTYPES
	int Stride = g_numDirLight;
	//point lights
	[loop] for(int j = 0; j < g_numPointLight; j++)
	{
//		if(j>=g_numPointLight) break;

		TripleColor ColOut = DoPointLight(LocalPos, ViewNormal, Viewer, j+Stride, Glossness);
		Color.Diffuse += ColOut.Ambient*Ambient +ColOut.Diffuse*Diffuse;
		Color.Specular += ColOut.Specular*Specular;

	}
	Stride = g_numDirLight+g_numPointLight;
	//spot lights
	[loop] for(int k = 0; k < g_numSpotLight; k++)
	{
//		if(k>=g_numSpotLight) break;

		TripleColor ColOut = DoSpotLight(LocalPos, ViewNormal, Viewer, k+Stride, Glossness);
		Color.Diffuse += ColOut.Ambient*Ambient +ColOut.Diffuse*Diffuse;
		Color.Specular += ColOut.Specular*Specular;

	}
#endif 

	Color.Diffuse.w = Opacity;//Opacity
	Color.Specular.w = 0;
	return Color;
}
#endif //NONORMAL
#endif //LIGHTING

#ifdef INVTM
float CanonTM_Tinv(float y)
{
	y = saturate(y);
	const float a = 1.0592;
	const float b = 1.0631;
	const float c = 4.5805;
	const float d = 1.5823;
	float tmp = (b / (a - y) - 1.0) / c;
	return pow(tmp, (1.0 / d));
}

float4 CanonTM_InverseColor(float4 reverseColor)
{
	// get luminance
	float3 revColor = reverseColor.rgb;
	float inLum = dot(float3(0.2126, 0.7152, 0.0722), revColor);

	if (inLum > 0.001) 
	{
		// Inverse of measured Canon sigmoid
		float outLum = CanonTM_Tinv(inLum);

		// scale the color, preserving channel ratios
		inLum = exp2(fExposure) * inLum;
		revColor = revColor * (outLum / inLum);
		reverseColor = float4(revColor, reverseColor.w);
	}
	else
	{
		revColor /= exp2(fExposure);
		reverseColor = float4(revColor, reverseColor.w);
	}
	return reverseColor;
}

float CanonTM_T(float x)
{
    // this function fits the measured Canon sigmoid *without gamma correction*
    float tmp = 1.0592 - 1.0631 / (1.0 + 4.5805 * pow(x, 1.5823));
    return saturate(tmp);
}
float4 CanonTM_Color(float4 linColor)
{
    float3 outColor = linColor.rgb;
    // apply exposure scaling
    outColor = outColor * exp2(fExposure);

    // clamp the input to simulate finite sensor
    outColor = min(outColor, float3(3.0, 3.0, 3.0));

    // apply the curve to the luminance
    float inLum = dot(float3(0.2126, 0.7152, 0.0722), outColor);
	if (inLum > 0.001) 
	{
		float outLum = CanonTM_T(inLum);

		// scale the color, preserving channel ratios
		outColor = outColor * (outLum / inLum);
	}
    // clamp again
    outColor = saturate(outColor);
	return float4(outColor.r, outColor.g, outColor.b, linColor.a);
}

#endif

#ifdef DIFFUSE_TEXTURE
#define TEX_COORD_SPECIFY			0
#define TEX_COORD_POSITION			1
#define TEX_COORD_NORMAL			2
#define TEX_COORD_CAMERASPACEPOSITION		3
#define TEX_COORD_CAMERASPACENORMAL		4	
#define TEX_COORD_CAMERASPACEREFLECTIONVECTOR	5

#define TEX_OP_DISABLE				0
#define TEX_OP_DIFFUSE				1
#define TEX_OP_DECAL				2
#define TEX_OP_MODULATE				3
#define TEX_OP_MIX				4

//Diffuse texture
Texture2D gDiffTex				: DiffuseTexture =NULL;
cbuffer cbTextures
{
	int g_texOpType				: TexOpMode = TEX_OP_DISABLE;
	int g_texCoordType			: TexCoordMode = TEX_COORD_SPECIFY;
	float4x4 g_matDiffTex			: DiffuseTexCoordTransMatrix=	
	{
		{1.0f, 0.0f, 0.0f, 0.0f},
		{0.0f, 1.0f, 0.0f, 0.0f},
		{0.0f, 0.0f, 1.0f, 0.0f},
		{0.0f, 0.0f, 0.0f, 1.0f}
	} ; 
};

bool    gTextureOnOff : TextureOnOff = true;
float4  gAverageColor : AverageColor = float4(1.0f,1.0f,1.0f,1.0f);
	
//sampler for various textures
SamplerState gDiffSamp:DiffuseSampler 
//{
//	Filter   = MIN_MAG_MIP_LINEAR;
//	AddressU = Wrap;
//	AddressV = Wrap;
//}
;

void CalcDiffuseTexture(inout VSOutput Out)
{
	float4 diffuse;
    if (gTextureOnOff)             
	    diffuse = gDiffTex.Sample(gDiffSamp, Out.Tex.xy);
    else 
        diffuse = gAverageColor;
	if((g_texOpType == TEX_OP_DISABLE) || (g_texOpType == TEX_OP_DIFFUSE))
	{
		return;
	}
	
	if(g_texOpType == TEX_OP_DECAL)
	{
		Out.ColorD = diffuse;
		return;
	}
	
	if(g_texOpType == TEX_OP_MODULATE)
	{
		Out.ColorD *= diffuse;
		return;
	}
	
	if(g_texOpType == TEX_OP_MIX)
	{
		Out.ColorD.w = diffuse.w;
		return;
	}
}
#endif

SamplerState gEnvSamp:EnvSampler
//{
//    Filter = MIN_MAG_MIP_LINEAR;
//    AddressU = Wrap;
//    AddressV = Wrap;
//    AddressW = Wrap;
//}
;
SamplerState gEnvSamp2D : EnvSampler2D;

#ifdef IBL
bool			gBackgroundBlendEnabled		: BackgroundBlendEnabled = false;
Texture2D		gBackgroundTexture			: BackgroundTexture2D = NULL;
SamplerState	gBackgroundSamp2D			: Background2DSampler;

float3			gGlossGain          : glossgain =float3(1.0f,1.0f,1.0f);
float3			gSharpGain          : envgain =float3(1.0f,1.0f,1.0f);
float3			gAmbGain			: ambgain =float3(1.0f,1.0f,1.0f);

float4x4    g_matIBLMat			: IBLTransform = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};

// Shelby IBL implementation, to align with the new OGS IBL implementation(One environment map) and new Lat-Long map mode
// Ambient
Texture2D		gEnvIrradianceTex			: EnvIrradianceTexture = NULL;

// Glossy
Texture3D		gEnvGlossyTex				: EnvGlossyTexture =NULL;
// Sharp reflection
bool bEnvLatLongMap							: IsEnvLatLongMap = false;

// Lat-long map
Texture2D		gEnvRadianceLatLongTex		: EnvRadianceTexture =NULL;
// Cube map
TextureCube		gEnvRadianceCubeTex			: EnvRadianceTexture =NULL;

// Samplers
SamplerState gEnvIrradianceSamp2D : EnvIrradianceSampler2D;
SamplerState gEnvGlossySamp3D : EnvGlossySampler3D;
SamplerState gEnvRadianceSamp2D : EnvIrradianceSampler2D;
// Functions
float3 SampleLatLongNormal(texture2D tex, sampler samp, float4x4 transform, float3 normal)
{
   const float PI = 3.141592654;
   float3 dir = normalize(mul(float4(normal,0.0f), transform).xyz);
   float latitude = -asin(dir.y)/PI + 0.5f;
   latitude = clamp(latitude, 0.01, 0.99);
   float longitude = atan2(dir.x, -dir.z)/PI*0.5f+0.5f;
   return tex.Sample(samp, float2(longitude,latitude));
}
float3 SampleLatLongVolumeReflect( texture3D tex, sampler samp, float4x4 transform, float kr, float3 V, float3 N, float exponent, int minExponent, int maxExponent, int exponentCount )
{ 
    const float PI = 3.141592654;
    float3 reflDir = (2.0 * dot(V, N)) * N - V; 
    reflDir = mul(float4(reflDir,0.0f), transform); 
    float targetLog = log2(exponent); 
    float minLog = log2(minExponent); 
    float maxLog = log2(maxExponent); 
    float deltaLog = clamp(targetLog - minLog, 0.0, maxLog - minLog); 
    float level = (deltaLog + 0.5) / exponentCount; 
    float latitude = -asin(reflDir.y)/PI + 0.5f;
    latitude = clamp(latitude, 0.01, 0.99);
    float longitude = atan2(reflDir.x, -reflDir.z)/PI*0.5f+0.5f;
    return kr * tex.Sample(samp, float3(longitude,latitude,level)).xyz;
}
// Lat-long map
float3 SampleLatLongReflect( texture2D tex, sampler samp, float4x4 transform, float kr, float3 V, float3 N )
{ 
    const float PI = 3.141592654;
    float3 reflDir = (2.0 * dot(V, N)) * N - V; 
    reflDir = mul(float4(reflDir,0.0f), transform); 
    float latitude = -asin(reflDir.y)/PI + 0.5f;
    float longitude = atan2(reflDir.x, -reflDir.z)/PI*0.5f+0.5f;
    return kr * tex.Sample(samp, float2(longitude,latitude)).xyz;
}
// Cube map
float3 SampleCubeReflect(textureCUBE envCube, sampler envSampler, float4x4 transform, float kr, float3 V, float3 N)
{ 
    float3 reflDir = (2.0 * dot(V, N)) * N - V; 
    reflDir = mul(float4(reflDir,0.0f), transform); 
    return kr * envCube.Sample( envSampler, reflDir ).xyz; 
}
float3 blendGlossyAndRadianceEnvironment(float exponent, int maxExponent, float3 glossyEnv, float3 radianceEnv)
{ 
    float3 specEnv = glossyEnv; 
    float targetLog = log2(exponent); 
    float maxLog = log2((float)maxExponent); 
    if(targetLog > maxLog) 
    { 
        float blend = saturate(0.5 * (targetLog - maxLog)); 
        specEnv = lerp(specEnv, radianceEnv, blend); 
    } 
    return specEnv; 
}
void CalcIBLEnvTexture(inout VSOutput Out,float4 specCoef,float4 diffCoef, float reflectionBend, float glossy, float3 Nw, float3 Vw)
{
	 //Ambient
	 float3 amb=diffCoef.xyz*SampleLatLongNormal(gEnvIrradianceTex, gEnvIrradianceSamp2D, g_matIBLMat, Nw).xyz*gAmbGain;
	 
	 //Glossy
	 float3 envglossy = SampleLatLongVolumeReflect(gEnvGlossyTex, gEnvGlossySamp3D, g_matIBLMat, 1.0f, Vw, Nw, 3200.0 * pow(glossy, 5.0), 1, 512, 8).xyz*gGlossGain;
	 //Sharp reflection
	 float3 envRadiance = float3(0.0f, 0.0f, 0.0f);
	 if(bEnvLatLongMap)
		envRadiance = SampleLatLongReflect(gEnvRadianceLatLongTex, gEnvRadianceSamp2D, g_matIBLMat, 1.0f, Vw, Nw).xyz*gSharpGain*reflectionBend;
	 else
		envRadiance = SampleCubeReflect(gEnvRadianceCubeTex, gEnvRadianceSamp2D, g_matIBLMat, 1.0f, Vw, Nw).xyz*gSharpGain*reflectionBend;
	 float3 blendGlossyRadiance = blendGlossyAndRadianceEnvironment(3200.0 * pow(glossy, 5.0), 512, envglossy, envRadiance);
	 float3 specular = specCoef.xyz*blendGlossyRadiance;
	 Out.ColorD.xyz += amb;
	 Out.ColorD.xyz = Out.ColorD.xyz * (1.0f-reflectionBend);
	 Out.ColorS.xyz += specular;
}

float3 CalcIBLEnvAmb(float4 ambCoef, float3 Nw)
{
	 //Ambient
	 float3 amb = SampleLatLongNormal(gEnvIrradianceTex, gEnvIrradianceSamp2D, g_matIBLMat, Nw).xyz*gAmbGain;
	 return ambCoef*amb;
}
#endif // IBL

#ifndef IBL
#ifdef ENVIRONMENT_TEXTURE
cbuffer cbEnvTex
{
	//bool     g_EnvEnabled           :EnironmentTexEnabled=false;
	float4x4 g_matEnvTex			: EnvironmentTexCoordTransMatrix = 
	{
		{1.0f, 0.0f, 0.0f, 0.0f},
		{0.0f, 1.0f, 0.0f, 0.0f},
		{0.0f, 0.0f, 1.0f, 0.0f},
		{0.0f, 0.0f, 0.0f, 1.0f}
	};	
}
// Environment texture.
TextureCube		gEnvTex				: EnvironmentTexture =NULL;
Texture2D		gEnvTex2D			: EnvironmentTexture2D = NULL;
TextureCube	    gReflectionMap		: ReflectionMap = NULL;
bool bEnvironmentMap2D : EnvironmentMap2D = false;

float4x4    g_matReflectionMap			: ReflectionMapTransMatrix = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};	

#define M_PI 3.14159265f
void CalcEnvironmentTexture(inout VSOutput Out,float4 specCoef,float refBlend)
{
	float4 clrEnvTex;
#ifdef REFLECTIONMAP
	clrEnvTex = gReflectionMap.Sample(gEnvSamp, Out.EnvTex.xyz) * specCoef;
#else
	if (bEnvironmentMap2D)
		clrEnvTex = gEnvTex2D.Sample(gEnvSamp2D,  Out.EnvTex.xy*0.5f + 0.5f) * specCoef;
	else 
		clrEnvTex = gEnvTex.Sample(gEnvSamp, Out.EnvTex.xyz) * specCoef;
#endif
	Out.ColorD = lerp(Out.ColorD, clrEnvTex, refBlend);
}

#endif //Environment texture
#endif //IBL

//-----------------------------------------------------------------------------
// Name: CalcFogFactor
// Desc: Calculate the fog factor for one vertex
//-----------------------------------------------------------------------------
float CalcFogFactor(float FogDist)
{
	float FogFactor = 1.0f;
	if(g_fogMode == FOGMODE_LINEAR)
	{
		FogFactor = (g_fogRange.y - FogDist)/(g_fogRange.y - g_fogRange.x);
	}
	else if(g_fogMode == FOGMODE_EXP)
	{
		FogFactor = 1.f/exp(FogDist * g_fogRange.z);
	}
	else if(g_fogMode == FOGMODE_EXP2)
	{
		FogFactor = 1.f/exp(pow(FogDist * g_fogRange.z, 2));
	}
	return clamp( FogFactor, 0, 1 );
}
