# copy to .../python/Lib/.

import xml.etree.ElementTree as xml
from io import StringIO

def loadUiType(uiFile):
    import pyside2uic
    import PySide2
    """
    Pyside lacks the "loadUiType" command, so we have to convert the ui file to py code in-memory first
    and then execute it in a special frame to retrieve the form_class.
    """
    parsed = xml.parse(uiFile)
    widget_class = parsed.find('widget').get('class')
    form_class = parsed.find('class').text

    with open(uiFile, 'r') as f:
        o = StringIO()
        frame = {}
        pyside2uic.compileUi(f, o, indent=0)
        code = o.getvalue()
        #print "generated code:", code
        pyc = compile(code, '<string>', 'exec')
        exec(pyc, frame)
        
        #Fetch the base_class and form class based on their type in the xml from designer
        form_class = frame['Ui_%s'%form_class]
        base_class = eval('PySide2.QtWidgets.%s'%widget_class)
    return form_class, base_class
