;
;
;  This file creates the master 'enabled' file which lists each of the
;  functions in Alias.
;
;


(define (ui-functions-list-enabled file)
  (with-output-to-file file
	(lambda () 
	  (format #t ";;; To disable a function find its line and change the ~%")
	  (format #t ";;; trailing #t to #f~%~%")
	  (map (lambda (name) (format #t "(ui-function-enable ~s ~s)~%"
										   name (ui-function-enabled? name)))
					(ui-functions->list))
			(format #t "(ui-menu-level-reset)~%"))))

(define (ui-menu-list-enabled file)
  (let ((menu-list (ui-menu-entries->list)))

	; Loop through menus, adding one to counter each time entry is in menu
	(define (entry-occurs entry)
	  (let loop ((list menu-list)
				 (counter 0))
		(if (null? list)
			counter
			(if (member entry (cdar list))
				(loop (cdr list) (1+ counter))
				(loop (cdr list) counter)))))

	(define (output-entry entry)
	  (if (> (entry-occurs entry) 1)
		  (format #t "; duplicate (ui-function-enable ~s ~s)~%"
				  entry (ui-function-enabled? entry))
		  (format #t "(ui-function-enable ~s ~s)~%"
				  entry (ui-function-enabled? entry))))

	(define (output-menu menu)
	  (if (> (length menu) 1)
		  (begin
			(format #t "~%~%;;; Menu ~s ~%" (car menu))
			(map (lambda (entry) (output-entry entry))
				 (cdr menu))
			(set-cdr! menu '()))))

	(with-output-to-file file
	  (lambda () 
		(format #t "; To disable a function find its line and change the ~%")
		(format #t "; trailing #t to #f~%~%")

		(map (lambda (menu) (output-menu menu)) 
			 menu-list)

		(format #t "~%~%~%(ui-menu-level-reset)~%")))
	))

(format #t "~%Defined: ui-functions-list-enabled and ui-menu-list-enabled ~%")
(format #t "usage:  (ui-functions-list-enabled \"AliasShortMenu.scm\") ~%")
(format #t "usage:  (ui-menu-list-enabled \"AliasShortMenu.scm\") ~%")
