;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;    Purpose:    Scheme - Rendering level menu variables

(ui-symbol "rp_file"              (ui-symbol-reference "RP_STORE_SDL"      ))
(ui-symbol "rp_render"            (ui-symbol-reference "RP_GLOBALPARAMS"   ))
(ui-symbol "rp_light"             (ui-symbol-reference "RP_LIGHT_POINT"    ))
(ui-symbol "rp_shader"            (ui-symbol-reference "RP_SHADER_LISTALL" ))

; File

(ui-symbol "ro_store_mode"            (ui-symbol-reference "RP_RAYCAST"))
(ui-symbol "ro_store_active"          #f)
(ui-symbol "ro_sho_type"              (ui-symbol-reference "RO_SHO_PIX"))
(ui-symbol "ro_sho_scale"             #f)
(ui-symbol "ro_sho_xoffset"           0)
(ui-symbol "ro_sho_yoffset"           0)

; Render 

; note: following values must be matched in Shared/include/ar_ag_tessellator.h
;  ui-symbol "ro_L_surf_smooth"            0.5
;  ui-symbol "ro_L_disp_detail"            25
;  ui-symbol "ro_M_surf_smooth"            0.05
;  ui-symbol "ro_M_disp_detail"            40
;  ui-symbol "ro_H_surf_smooth"            0.005
;  ui-symbol "ro_H_disp_detail"            60

(ui-symbol "ro_quality"                  (ui-symbol-reference "RO_MED")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_anim_range_source"        1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_tess_type"              1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_surf_smooth"            0.5   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_disp_detail"            25    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_limit_edge_length"      #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_max_edge_length"        10.0  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_subdiv"              (ui-symbol-reference "RO_OBJECTS_SUBDIV")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_subdiv_adaptive"        #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_subdiv_min"             1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_subdiv_max"             2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_crv_thresh"             0.96  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_subdiv_u"               2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_subdiv_v"               2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_aa_minlevel"            0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_aa_maxlevel"            0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_aa_thresh"              0.5   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_aa_width"               1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_aa_reduced_samples"     #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_aa_cheapshade"          #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_max_reflections"        1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_max_refractions"        1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_max_shadow_level"       -1    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_L_preview"                #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_tess_type"              1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_surf_smooth"            0.05  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_disp_detail"            40    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_limit_edge_length"      #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_max_edge_length"        10.0  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_subdiv"              (ui-symbol-reference "RO_OBJECTS_SUBDIV")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_subdiv_adaptive"        #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_subdiv_min"             2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_subdiv_max"             4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_crv_thresh"             0.96  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_subdiv_u"               4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_subdiv_v"               4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_aa_minlevel"            2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_aa_maxlevel"            9     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_aa_thresh"              0.6   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_aa_width"               1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_aa_reduced_samples"     #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_aa_cheapshade"          #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_max_reflections"        4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_max_refractions"        4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_max_shadow_level"       4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_preview"                #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_tess_type"              1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_surf_smooth"            0.005 UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_disp_detail"            60    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_limit_edge_length"      #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_max_edge_length"        10.0  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_subdiv"              (ui-symbol-reference "RO_OBJECTS_SUBDIV")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_subdiv_adaptive"        #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_subdiv_min"             2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_subdiv_max"             8     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_crv_thresh"             0.96  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_subdiv_u"               6     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_subdiv_v"               6     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_aa_minlevel"            3     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_aa_maxlevel"            25    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_aa_thresh"              0.7   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_aa_width"               1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_aa_reduced_samples"     #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_aa_cheapshade"          #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_max_reflections"        7     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_max_refractions"        7     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_max_shadow_level"       7     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_H_preview"                #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_grid_cache"               4000  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_bbox_status"              1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_M_max_voxel_level"        2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_voxel_res_type"           2     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_voxel_topResX"            10    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_voxel_topResY"            10    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_voxel_topResZ"            10    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_voxel_NthRoot"            4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_texture_caching"          0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_texture_cache_size"       32    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_texture_cache_disk_limit" 1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_C_composite"              0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_C_threshold"              0.5   UI_SYMBOL_GROUP_RENDER_GLOBALS) 
(ui-symbol "ro_keep_noglow"              #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_spot_depth"               #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_spot_memory"              #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_ignore_filmgate"          #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_use_beere"                #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_invis_obj_cast"           #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_trans_depth"              #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_trans_percent"            1.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_gamma"                    1.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_restype"                  (ui-symbol-reference "RO_NTSC")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS) 
(ui-symbol "ro_xres"                     (ui-symbol-reference "NTSC_WIDTH")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_yres"                     (ui-symbol-reference "NTSC_HEIGHT")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_pixel_aspect"             1.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_rt_shadow_offset"         0.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_xy_ratio_lock"            #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_particles"                #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_particles_substeps"       1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_particles_frames_per_sec" 30    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_post_cent"                8     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_post_adj"                 1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_post_diag"                1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_animate"                  #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_anim_objects"             (ui-symbol-reference "AO_PLAYBACK_ALL")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_params"                   (ui-symbol-reference "AO_PLAYBACK_ALL")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hierarchy"                (ui-symbol-reference "AO_HIER_BOTH")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_fields"                   #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_odd_field_first"          1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_startframe"               1.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_endframe"                 1.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_byframe"                  1.0   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_startext"                 1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_byext"                    1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_sizeext"                  1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_formatext"                0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_useext"                   0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_pixout"                   #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_matteout"                 #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_record"                   #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_quality"                  (ui-symbol-reference "RO_MED")
                                               UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_active"                   #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_savegeom"                 #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_textures"                 #t    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_skeletons"                #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_imageformat"              4     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hidden_line_from_global"  #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_to_fill_color"            #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hl_fill_colorR"           255   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hl_fill_colorG"           255   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hl_fill_colorB"           255   UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hl_line_width"            1     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hl_line_ulines"           0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_hl_line_vlines"           0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_shutter_exposure"         144.0 UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_motion_blur_on"           #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_post_filter"              #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "ro_use_wavefront_depth"      0     UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "use_maya_renderer"           #f    UI_SYMBOL_GROUP_RENDER_GLOBALS)

(ui-string 'use_maya_renderer     "Use Maya Renderer" )


; Export Polygons 

(ui-symbol "ro_output_type"             (ui-symbol-reference "RO_TRIANGLES"))
(ui-symbol "ro_obj_separators"          #f)
(ui-symbol "ro_texture_subdivs"         16)


; Light 

; spot
(ui-symbol "ro_spot_intensity"      1.0)
(ui-symbol "ro_spot_red"            255.0)
(ui-symbol "ro_spot_green"          255.0)
(ui-symbol "ro_spot_blue"           255.0)
(ui-symbol "ro_spot_spread"         90.0)
(ui-symbol "ro_spot_dropoff"        0.0)
(ui-symbol "ro_spot_penumbra"       0.0)
(ui-symbol "ro_spot_shadows"        #f)
(ui-symbol "ro_spot_size"           512)
(ui-symbol "ro_spot_fogsamples"     50)
(ui-symbol "ro_spot_mult"           2.0)
(ui-symbol "ro_spot_offset"         0)
(ui-symbol "ro_spot_minbias"        0.05)
(ui-symbol "ro_spot_maxbias"        1.0)
(ui-symbol "ro_spot_decay"          1)
(ui-symbol "ro_spot_exclusive"      #f)

; linear 
(ui-symbol "ro_linear_intensity"    1.0)
(ui-symbol "ro_linear_red"          255.0)
(ui-symbol "ro_linear_green"        255.0)
(ui-symbol "ro_linear_blue"         255.0)
(ui-symbol "ro_linear_shadows"      #f)
(ui-symbol "ro_linear_decay"        1)
(ui-symbol "ro_linear_exclusive"    #f)

; ambient 
(ui-symbol "ro_ambient_red"         255.0)
(ui-symbol "ro_ambient_green"       255.0)
(ui-symbol "ro_ambient_blue"        255.0)
(ui-symbol "ro_ambient_ambientshade" 0.0)
(ui-symbol "ro_ambient_intensity"   0.40)
(ui-symbol "ro_ambient_exclusive"   #f)

; directional 
(ui-symbol "ro_direct_intensity"    1.0)
(ui-symbol "ro_direct_red"          255.0)
(ui-symbol "ro_direct_green"        255.0)
(ui-symbol "ro_direct_blue"         255.0)
(ui-symbol "ro_direct_dirx"         0)
(ui-symbol "ro_direct_diry"         0)
(ui-symbol "ro_direct_dirz"         -10000)
(ui-symbol "ro_direct_shadows"      #f)
(ui-symbol "ro_direct_exclusive"    #f)

; area 
(ui-symbol "ro_area_intensity"      1.0)
(ui-symbol "ro_area_red"            255.0)
(ui-symbol "ro_area_green"          255.0)
(ui-symbol "ro_area_blue"           255.0)
(ui-symbol "ro_area_shadows"        #f)
(ui-symbol "ro_area_decay"          1)
(ui-symbol "ro_area_exclusive"      #f)

; point
(ui-symbol "ro_point_intensity"     1.0)
(ui-symbol "ro_point_red"           255.0)
(ui-symbol "ro_point_green"         255.0)
(ui-symbol "ro_point_blue"          255.0)
(ui-symbol "ro_point_shadows"       #f)
(ui-symbol "ro_point_decay"         1)
(ui-symbol "ro_point_exclusive"     #f)

; default sun
(ui-symbol "ro_defdirect_intensity" 1.0)
(ui-symbol "ro_defdirect_red"       255.0)
(ui-symbol "ro_defdirect_green"     255.0)
(ui-symbol "ro_defdirect_blue"      255.0)

; This is right for z_up but wrong for y_up 
(ui-symbol "ro_defdirect_dirx"      0.6)
(ui-symbol "ro_defdirect_diry"      -0.529)
(ui-symbol "ro_defdirect_dirz"      0.6)
(ui-symbol "ro_defdirect_shadows"   #f)
(ui-symbol "ro_defdirect_exclusive" #f)

; default ambient
(ui-symbol "ro_defambient_intensity" 1.0)
(ui-symbol "ro_defambient_red"      100.0)
(ui-symbol "ro_defambient_green"    100.0)
(ui-symbol "ro_defambient_blue"     100.0)
(ui-symbol "ro_defambient_ambientshade" 0.5)
(ui-symbol "ro_defambient_exclusive" #f)

; volume
(ui-symbol "ro_volume_red"          255.0)
(ui-symbol "ro_volume_green"        255.0)
(ui-symbol "ro_volume_blue"         255.0)
(ui-symbol "ro_volume_intensity"    1.0)
(ui-symbol "ro_volume_shape"        (ui-symbol-reference "RO_VOLUME_SPHERE"))
(ui-symbol "ro_volume_exclusive"    #f)

; Filter 

(ui-symbol "ro_hl_line_colorR"         0)
(ui-symbol "ro_hl_line_colorG"         255)
(ui-symbol "ro_hl_line_colorB"         255)
(ui-symbol "ro_spot_dirx"              0)
(ui-symbol "ro_spot_diry"              0)
(ui-symbol "ro_spot_dirz"              -10000)

; Background 

(ui-symbol "ro_backgnd_r"               0)
(ui-symbol "ro_backgnd_g"               0)
(ui-symbol "ro_backgnd_b"               0)
(ui-symbol "ro_backgnd_b"               0)
(ui-symbol "ro_backgnd_by"              1)
(ui-symbol "ro_backgnd_start"           1)
(ui-symbol "ro_backgnd_end"             1)
(ui-symbol "ro_backgnd_sequence"        #f)

; New Show Render Option box **********************************************

(ui-symbol "show_zoom"  1.0  UI_SYMBOL_GROUP_RENDER_GLOBALS)
(ui-symbol "show_fill"  0    UI_SYMBOL_GROUP_RENDER_GLOBALS)

(ui-string 'show_opts  "Show Render Options")
(ui-string 'show_zoom  "Zoom Factor")
(ui-string 'show_fill  "Fill Screen")


; Render Option box *******************************************************
;
(ui-symbol "ro_render_command"       "RO_Renderer"                      )
(ui-symbol "batch_render_mode"       (ui-symbol-reference "RP_RAYCAST") )
(ui-symbol "renderer_choice1"        1                                  )
(ui-symbol "renderer_choice2"        2                                  )
(ui-symbol "renderer_choice3"        3                                  )
(ui-symbol "renderer_choice4"        4                                  )
(ui-symbol "renderer_choice5"        5                                  )
(ui-symbol "processors"              1                                  )
(ui-symbol "user_defined"            1                                  )
(ui-symbol "number_processors"       1                                  )

(ui-string 'batch_render_mode     "Renderer Type"     )
(ui-string 'renderer_choice1      "Raycaster"         )
(ui-string 'renderer_choice2      "Powercaster"       )
(ui-string 'renderer_choice3      "Raytracer"         )
(ui-string 'renderer_choice4      "Powertracer"       )
(ui-string 'renderer_choice5      "Hidden Line"       )
(ui-string 'processors            "Processors"        )
(ui-string 'all_processors        "All"               )
(ui-string 'user_defined          "User Defined"      )
(ui-string 'number_processors     "Num Processors"    )


; DirectRender Option box ***************************************************
;
(ui-symbol "direct_render_mode"      (ui-symbol-reference "RP_RAYCAST") )
(ui-symbol "dr_renderer_choice1"     1                                  )
(ui-symbol "dr_renderer_choice2"     2                                  )
(ui-symbol "dr_renderer_choice3"     3                                  )
(ui-symbol "dr_renderer_choice4"     4                                  )
(ui-symbol "dr_renderer_choice5"     5                                  )
(ui-symbol "dr_processors"           1                                  )
(ui-symbol "dr_user_defined"         1                                  )
(ui-symbol "dr_number_processors"    1                                  )

(ui-string 'direct_render_mode    "Renderer Type"     )
(ui-string 'dr_renderer_choice1   "Raycaster"         )
(ui-string 'dr_renderer_choice2   "Powercaster"       )
(ui-string 'dr_renderer_choice3   "Raytracer"         )
(ui-string 'dr_renderer_choice4   "Powertracer"       )
(ui-string 'dr_renderer_choice5   "Hidden Line"       )
(ui-string 'dr_processors         "Processors"        )
(ui-string 'dr_user_defined       "User Defined"      )
(ui-string 'dr_number_processors  "Num Processors"    )

(ui-symbol 'test_render			#f)
(ui-string 'test_render			"Test Render")
(ui-string 'test_res            "Test Resolution")
(ui-symbol 'test_res            0.5)

; New AG Tessellator Controls *************************************

(ui-symbol "sketch_choice"       1)
(ui-symbol "sketch_choice1"      1)
(ui-symbol "sketch_choice2"      2)

(ui-string 'sketch_choice          "Render")
(ui-string 'sketch_choice1         "Active Objects")
(ui-string 'sketch_choice2         "All Objects")

(ui-symbol "sketch_window"       1)
(ui-symbol "sketch_window1"      1)
(ui-symbol "sketch_window2"      2)

(ui-string 'sketch_window          "Project from")
(ui-string 'sketch_window1         "Active Canvas")
(ui-string 'sketch_window2         "All Canvases")

(ui-symbol "clear_sketch_window"       1)
(ui-symbol "clear_sketch_window1"      1)
(ui-symbol "clear_sketch_window2"      2)

(ui-string 'clear_sketch_window          "Delete Project from")
(ui-string 'clear_sketch_window1         "Active Canvas")
(ui-string 'clear_sketch_window2         "All Canvases")

; Bake Occlusion Controls ************************************

(ui-symbol "BakeOcclusion"       "RO_BakeOcclusion"   )
(ui-symbol "DeleteOcclusion"     "RO_DelOcclusion"    )
(ui-symbol "ToggleOcclusion"     "RO_TglOcclusion"    )

(ui-symbol "occlusion_processors"     1)
(ui-symbol "occlusion_all_processors" 1)
(ui-symbol "occlusion_user_defined"   2)

(ui-symbol "occlusion_scope"          1)
(ui-symbol "occlusion_scope_all"      1)
(ui-symbol "occlusion_scope_pick"     2)
(ui-symbol "occlusion_num_processors" 1)

(ui-symbol "rays_per_sample"     256   )
(ui-symbol "normalized_res"      1.0   )
(ui-symbol "use_ao_falloff"       #f   )
(ui-symbol "ao_falloff_dist"   100.0   )
(ui-symbol "self_shadow_correction" 1.0  )
(ui-symbol "filter_radius"        2 )
(ui-symbol "chord_length_occlusion" #t   )
;(ui-symbol "transparency_threshold" 1.0 )
;(ui-symbol "power_of_two"        #t    )

(ui-symbol 'use_ambient_occlusion #t )
(ui-symbol 're_shadereditor_filter_mode 0 )

; QuickTime VR Options **************************************

(ui-symbol "rp_qt_coverage"     (ui-symbol-reference "RP_QT_COVERAGE_TURNTABLE"))
(ui-symbol "rp_qt_centreofinterest"   (ui-symbol-reference "RP_QT_CENTER_GRID"))
(ui-symbol "rp_qt_smoothness"   40)
(ui-symbol "rp_qt_saveframes"   #f)
(ui-symbol "rp_qt_wrap"			#t)
(ui-symbol "rp_qt_use_max"		#f)
(ui-symbol "rp_qt_ratio"        #f)
(ui-symbol "rp_qt_lights"        #f)
(ui-symbol "rp_qt_codec"        0)
(ui-symbol "rp_qt_quality"      75)
(ui-symbol "rp_qt_graphics"     (ui-symbol-reference "RP_QT_GRAPHICS_HI"))
(ui-symbol "rp_qt_rendersource" (ui-symbol-reference "RP_QT_SCREENGRAB"))
(ui-symbol "rp_qt_renderer"     (ui-symbol-reference "RP_RAYCAST"))
(ui-symbol "rp_qt_res"          (ui-symbol-reference "RP_QT_RES_CUSTOM"))
(ui-symbol "rp_qt_xres"         645)
(ui-symbol "rp_qt_yres"         486)
(ui-symbol "rp_qt_frames"       "40")
(ui-symbol "rp_qt_viewingdir"   (ui-symbol-reference "RP_QT_VIEWINWARDS"))
(ui-symbol "rp_qt_viewangle"    (ui-symbol-reference "RP_QT_ANGLE_360"))
(ui-symbol "rp_qt_max"           40)

(ui-symbol "rp_mv_output"       (ui-symbol-reference "RP_MV_AVI"))
(ui-symbol "rp_mv_codec"        0)
(ui-symbol "rp_mv_qtcodec"      0)
(ui-symbol "rp_mv_quality"      10000)
(ui-symbol "rp_mv_maxf"			1000)
(ui-symbol "rp_mv_fps"          30)
(ui-symbol "rp_mv_keyframes"    8)
(ui-symbol "rp_mv_datarate"     128)
(ui-symbol "rp_mv_qtcodec"      0)
(ui-symbol "rp_mv_usedatarate"  #f)
(ui-symbol "rp_mv_usekeyframes" #f)
(ui-symbol "rp_mv_usemax"		#f)
(ui-symbol "rp_mv_qtquality"    75)
(ui-symbol "rp_mv_qtgraphics"   (ui-symbol-reference "RP_QT_GRAPHICS_HI"))
