;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; Spot Light Options
;;;

(ui-string "spot.name"                  "Spot Light Options")
(ui-string "ro_spot_red"                "Color")
(ui-string "ro_spot_intensity"          "Intensity")
(ui-string "ro_spot_decay"              "Decay")
(ui-string "ro_spot_spread"             "Spread")
(ui-string "ro_spot_dropoff"            "Dropoff")
(ui-string "ro_spot_penumbra"           "Penumbra")
(ui-string "ro_spot_shadows"            "Shadows")
(ui-string "ro_spot_exclusive"          "Exclusive")
(ui-string "ro_spot_mult"               "Edge Quality")
(ui-string "ro_spot_size"               "Resolution")
(ui-string "ro_spot_fogsamples"         "Fog Samples")
(ui-string "ro_spot_minbias"            "Min Depth")
(ui-string "ro_spot_maxbias"            "Blend Offset")

(ui-editor "spot.options"

	(list 'title 'spot.name)

	(list 'symbols 	'ro_spot_red			'ro_spot_green
					'ro_spot_blue			'ro_spot_intensity
					'ro_spot_decay			'ro_spot_spread
					'ro_spot_dropoff		'ro_spot_penumbra
					'ro_spot_shadows		'ro_spot_exclusive
					'ro_spot_mult			'ro_spot_size
					'ro_spot_minbias		'ro_spot_maxbias
					'ro_spot_fogsamples
	)

	(list 'buttons 'Reset 'Save 'Exit 'Go)

	(ui-wdltriple-widget "ro_spot_red"  'ro_spot_green 'ro_spot_blue
		(list 'precision "%f9.4")
		(list 'range 0.0 255.0)
	)

	(ui-double-widget "ro_spot_intensity"
		(list 'precision "%f9.4")
		(list 'slider_range 0.0 100.0)
	)

	(ui-integer-widget "ro_spot_decay"
		(list 'range 0 3)
	)

	(ui-angle-widget "ro_spot_spread"
		(list 'precision "%f9.4")
		(list 'range 2.0 179.0)
	)

	(ui-double-widget "ro_spot_dropoff"
		(list 'precision "%f9.4")
		(list 'range 'min 0)
	)

	(ui-angle-widget "ro_spot_penumbra"
		(list 'precision "%f9.4")
		(list 'range -90.0 90.0)
	)

	(ui-double-widget "ro_spot_mult"
		(list 'precision "%f9.0")
		(list 'range 1 10)
	)

	(ui-integer-widget "ro_spot_size"
		(list 'range 2 4096)
	)

	(ui-integer-widget "ro_spot_fogsamples"
		(list 'range 4 4096)
	)

	(ui-double-widget "ro_spot_minbias"
		(list 'precision "%f9.4")
		(list 'range 'min 0)
	)

	(ui-double-widget "ro_spot_maxbias"
		(list 'precision "%f9.4")
		(list 'range 'min 0)
	)

	(ui-tick-left-widget "ro_spot_shadows" )

	(ui-tick-right-widget "ro_spot_exclusive" )
)
