(ui-editor 'renderselect_options
    (list 'symbols     
          'batch_render_mode
          'processors
          'number_processors
          'test_render
          'test_res
          'ro_render_command
    )

    (list 'title "Rendering Options")

;;; Which renderer?
    (ui-radio-widget 'batch_render_mode
        (list 'rebuild #t)
        (ui-choice 'renderer_choice1        'RP_RAYCAST
            (list 'assign 'ro_render_command "RO_Renderer")
        )
        (ui-choice 'renderer_choice2        'RP_MP_RAYCAST
            (list 'assign 'ro_render_command "RO_Powercaster") )
        (ui-choice 'renderer_choice3        'RP_RAYTRACE
            (list 'assign 'ro_render_command "RO_Raytracer")
        )
        (ui-choice 'renderer_choice4        'RP_MP_RAYTRACE
            (list 'assign 'ro_render_command "RO_Powertracer") )
        (ui-choice 'renderer_choice5        'RP_HIDDENLINE
;;            (list 'assign 'ro_render_command "RO_HiddenLine")
        )
    )

;;; If multi-processing is possible, how many processors to use? All or N
    (ui-radio-widget 'processors
        (list 'enabled
            (ui-or 
                (ui-eq 'batch_render_mode `RP_MP_RAYCAST  )
                (ui-eq 'batch_render_mode `RP_MP_RAYTRACE )
            )
        )
        (list 'rebuild #t)
        (ui-choice 'all_processors      1)
        (ui-choice 'user_defined        2)
    )

;;; If multi-processing && user-specified-num-procs, how many?
    (ui-integer-widget 'number_processors
        (list 'enabled 
            (ui-and
                (ui-or 
                    (ui-eq 'batch_render_mode `RP_MP_RAYCAST  )
                    (ui-eq 'batch_render_mode `RP_MP_RAYTRACE )
                )
                (ui-eq 'processors 2)
            )
        )
        (list 'range 1 'maxRenderProcessors)
    )

    (ui-separator-widget)

	(ui-tick-widget	'test_render 
		(list 'rebuild #t)
	)

	(ui-double-widget 'test_res
		(list 'enabled (ui-eq 'test_render #t))
		(list 'range 0.1 1.0)
	)
)
