;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
;            Copyright (C) 1994, Alias Research, Inc.                        ;
;                                                                            ;
;    These coded instructions,  statements and  computer programs contain    ;
;    unpublished information proprietary to Alias Research, Inc.  and are    ;
;    protected by the Canadian and US Federal copyright law. They may not    ;
;    be disclosed to third parties  or copied  or duplicated, in whole or    ;
;    in part,  without the prior written consent of Alias Research,  Inc.    ;
;                                                                            ;
; Unpublished-rights reserved under the Copyright Laws of the United States. ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Render Menu
;;;

(ui-string "rp_global_str"             	"globals...")
(ui-string "rp_global_attr_str"        	"globals")
(ui-string "rp_direct_render_str"      	"Direct Render")
(ui-string "rp_direct_attr_str"        	"dirnd")
(ui-string "rp_sketch_render_str"      	"Project Sketch")
(ui-string "rp_sketch_attr_str"        	"pjskch")
(ui-string "rp_clear_sketch_str"       	"Delete Sketch Projection")
(ui-string "rp_clear_sketch_attr_str"  	"dskpj")
(ui-string "rp_render_str"             	"render")
(ui-string "rp_render_attr_str"        	"rendr")
(ui-string "rp_bake_occlusion_str"     	"Compute")
(ui-string "rp_bake_occlusion_attr_str"	"cmput")
(ui-string "rp_del_occlusion_str"      	"Delete")
(ui-string "rp_del_occlusion_attr_str" 	"docc")
(ui-string "rp_tgl_occlusion_str"      	"Toggle Display")
(ui-string "rp_tgl_occlusion_attr_str" 	"tgocc")
(ui-string "rp_pop_str"       			"pop monitor windows")
(ui-string "rp_pop_attr_str"           	"pop monitor windows")
(ui-string "rp_quicktimevr_str"        	"Render to QuickTimeVR")
(ui-string "rp_quicktimevr_attr_str"   	"qtvr")
(ui-string "rp_movie_str"				"Convert Frames to Movie")
(ui-string "rp_movie_attr_str"			"movie")

(ui-string "rp_apply_shader_str"	   	"Apply Shaders")
(ui-string "rp_apply_shader_attr_str"	"apshd")
(ui-string "rp_vred_str"      	    	"VRED Render")
(ui-string "rp_vred_attr_str" 		    "VRED")

(ui-function "rp_render_global"         
	(list 'select			'rp_render 'RP_GLOBALPARAMS)
	(list 'command			"Globals")
	(list 'label_string		'rp_global_str)
	(list 'attribute_string	'rp_global_attr_str)
	; PROBLEM - A lot of checking needed
)

(ui-function "rp_direct_render"         
	(list 'command			"DirectRender")
	(list 'label_string		'rp_direct_render_str)
	(list 'attribute_string	'rp_direct_attr_str)
	(list 'option_editor    "Render/re_direct_render.o.scm"
		  					'directrender_options)
)

(ui-function "rp_render_render"
	 ; Note: this option varies according to the option box
	(list 'select           'rp_render 'RP_RENDER)
    (list 'command          'ro_render_command
							"RO_Renderer" "RO_Powercaster" "RO_Raytracer"
							"RO_Powertracer" "RO_HiddenLine")
	(list 'label_string     'rp_render_str)
	(list 'attribute_string 'rp_render_attr_str)
	(list 'option_editor    "Render/ro_render_options.o.scm"
		  					'renderselect_options)
)

(ui-function "rp_bake_occlusion"         
	(list 'command			"BakeOcclusion")
	(list 'label_string		'rp_bake_occlusion_str)
	(list 'attribute_string	'rp_bake_occlusion_attr_str)
	(list 'option_editor    "Render/ro_occlusion_options.o.scm"
		  					'compute_occlusion_options)
)

(ui-function "rp_del_occlusion"         
	(list 'command			"DeleteOcclusion")
	(list 'label_string		'rp_del_occlusion_str)
	(list 'attribute_string	'rp_del_occlusion_attr_str)
	(list 'option_editor    "Render/ro_occlusion_options.o.scm"
		  					'del_occlusion_options)
)

(ui-function "rp_tgl_occlusion"         
	(list 'command			"ToggleOcclusion")
	(list 'label_string		'rp_tgl_occlusion_str)
	(list 'attribute_string	'rp_tgl_occlusion_attr_str)
    (list 'tick             (ui-eq 'use_ambient_occlusion #t ))
)

(ui-function "rp_render_qtvr"
    (list 'command          "QuickTimeVR")
    (list 'label_string     'rp_quicktimevr_str)
    (list 'attribute_string 'rp_quicktimevr_attr_str)
    (list 'option_function  "QuickTimeVRControls")
    (list 'symbols          'rp_qt_coverage
                            'rp_qt_saveframes
                            'rp_qt_smoothness
                            'rp_qt_centreofinterest
                            'rp_qt_rendersource
                            'rp_qt_renderer
                            'rp_qt_codec
                            'rp_qt_quality
                            'rp_qt_graphics
                            'rp_qt_res
                            'rp_qt_xres
                            'rp_qt_yres
							'rp_qt_ratio                            
                            'rp_qt_frames
                            'rp_qt_viewingdir
                            'rp_qt_viewangle
                            'rp_qt_max
                            'rp_qt_wrap
                            'rp_qt_use_max
                            'rp_qt_lights
    )
)

(ui-function "rp_render_movie"
    (list 'command          "MovieRender")
    (list 'label_string     'rp_movie_str)
    (list 'attribute_string 'rp_movie_attr_str)
    (list 'option_function  "MovieRenderControls")
    (list 'symbols          'rp_mv_codec
							'rp_mv_qtcodec
		        			'rp_mv_output
                            'rp_mv_quality
                            'rp_mv_fps
                            'rp_mv_maxf
                            'rp_mv_keyframes
                            'rp_mv_datarate
                            'rp_mv_qtquality
                            'rp_mv_qtgraphics
                            'rp_mv_usedatarate
                            'rp_mv_usekeyframes
                            'rp_mv_usemax
    )
)

(ui-function "rp_render_sketch"
    (list 'command          "ProjectSketch")
	(list 'label_string     'rp_sketch_render_str)
	(list 'attribute_string 'rp_sketch_attr_str)
	(list 'option_editor    "Render/ro_render_sketch.o.scm"
		  					'sketch_render_options)
)

(ui-function "rp_clear_sketch"
    (list 'command          "ClearSketch")
	(list 'label_string     'rp_clear_sketch_str)
	(list 'attribute_string 'rp_clear_sketch_attr_str)
	(list 'option_editor    "Render/ro_clear_render_sketch.o.scm"
	                        'clear_sketch_render_options)
)

(ui-function "rp_render_ptrace"         
	(list 'select			'rp_render 'RP_MP_RAYTRACE)
	(list 'command			"Powertrace")
	(list 'label_string		'rp_ptrace_str)
	(list 'attribute_string	'rp_ptrace_attr_str)
)

(ui-function "rp_render_raytrace"       
	(list 'select			'rp_render 'RP_RAYTRACE)
	(list 'command			"Raytrace")
	(list 'label_string		'rp_raytrace_str)
	(list 'attribute_string	'rp_raytrace_attr_str)
)

(ui-function "rp_render_pcast"          
	(list 'select			'rp_render 'RP_MP_RAYCAST)
	(list 'command			"Powercast")
	(list 'label_string		'rp_pcast_str)
	(list 'attribute_string	'rp_pcast_attr_str)
)

(ui-function "rp_render_raycast"        
	(list 'select			'rp_render 'RP_RAYCAST)
	(list 'command			"Raycast")
	(list 'label_string		'rp_raycast_str)
	(list 'attribute_string	'rp_raycast_attr_str)
)

(ui-function "rp_render_hidden"         
	(list 'select			'rp_render 'RP_HIDDENLINE)
	(list 'command			"HiddenLine")
	(list 'label_string		'rp_hidden_str)
	(list 'attribute_string	'rp_hidden_attr_str)
)

(ui-function "rp_render_shading_control"        
	(list 'command				"ApplyShaders")
	(list 'label_string        	'rp_apply_shader_str)
	(list 'attribute_string   	'rp_apply_shader_attr_str)
	(list 'option_editor        "Modeling/mo_shade_control_options.o.scm"
								'mo_shade_control_options)
)

(ui-function "rp_vred_live_link"
	(list 'command				"rp_vred_live_link")
	(list 'label_string			'rp_vred_str)
	(list 'attribute_string		'rp_vred_attr_str)
	(list 'option_function		'rp_vred_live_link_options)
)

