; Ambient Occlusion Controls **************************************

(ui-string 'occlusion_processors      "Processors")
(ui-string 'occlusion_all_processors  "All")
(ui-string 'occlusion_user_defined    "User Defined")
(ui-string 'occlusion_num_processors  "Num Processors")

(ui-string 'occlusion_scope			"Object Scope")
(ui-string 'occlusion_scope_all		"All")
(ui-string 'occlusion_scope_pick	"Selected")

(ui-string 'rays_per_sample			"Smoothness (rays/sample)")
(ui-string 'normalized_res			"Detail (resolution)")
(ui-string 'use_ao_falloff          "Use Decay")
(ui-string 'ao_falloff_dist         "Decay Distance")
(ui-string 'self_shadow_correction  "Self-Shadow Correction")
(ui-string 'filter_radius           "Filter Radius")
(ui-string 'chord_length_occlusion  "Chord-Length Parameterization")

;(ui-string 'power_of_two			"Power of two")
;(ui-string 'packed_textures		"Packed Textures")
;(ui-string 'transparency_threshold	"Transparency Threshold")


(ui-editor 'compute_occlusion_options

    (list 'symbols  
          'occlusion_scope   
          'rays_per_sample
          'normalized_res
          'use_ao_falloff
          'ao_falloff_dist
          'self_shadow_correction
          'filter_radius
          'chord_length_occlusion
          'BakeOcclusion
    )

    (list 'title "Ambient Occlusion Options")

	(ui-radio-widget 'occlusion_scope
		(ui-choice 'occlusion_scope_all   1)
		(ui-choice 'occlusion_scope_pick  2)
	)

    (ui-separator-widget)

    (ui-double-widget 'normalized_res
        (list 'slider_range 0.2 6.0)
        (list 'range 0.01 100.0 )
    )

    (ui-integer-widget 'rays_per_sample
        (list 'slider_range 128 512)
        (list 'range 16 1024 )
    )

    (ui-integer-widget 'filter_radius
        (list 'slider_range 1 4)
        (list 'range 0 7 )
    )
    
;	(ui-boolean-widget 'use_ao_falloff )
	(ui-tick-widget	'use_ao_falloff 
		(list 'rebuild #t)
	)
	
    (ui-double-widget 'ao_falloff_dist
		(list 'enabled (ui-eq 'use_ao_falloff #t))
        (list 'slider_range 1.0 1000.0)
    )

    (ui-separator-widget)

    (ui-double-widget 'self_shadow_correction
        (list 'slider_range 0.1 10.0)
        (list 'range 0.0 100.0 )
    )

	(ui-boolean-widget 'chord_length_occlusion )

;    (ui-double-widget 'transparency_threshold
;        (list 'range 0.0 1.0 )
;    )

;	(ui-boolean-widget 'power_of_two )

;	(ui-boolean-widget 'packed_textures )

;    (ui-separator-widget)

;    (ui-radio-widget 'occlusion_processors
;        (ui-choice 'occlusion_all_processors      1)
;        (ui-choice 'occlusion_user_defined        2)
;    )

;    (ui-integer-widget 'occlusion_num_processors
;        (list 'range 1 32)
;    )

)

(ui-editor 'del_occlusion_options
    (list 'title "Delete Ambient Occlusion Options")
	(ui-radio-widget 'occlusion_scope
		(ui-choice 'occlusion_scope_all   1)
		(ui-choice 'occlusion_scope_pick  2)
	)
)

