(ui-editor "directrender_options"
    (list 'symbols     
          'direct_render_mode
          'dr_processors
          'dr_number_processors
    )

    (list 'title "Direct Rendering Options")

;;; Which renderer?
    (ui-radio-widget 'direct_render_mode
        (list 'rebuild #t)
        (ui-choice 'dr_renderer_choice1     'RP_RAYCAST     )

        (ui-choice 'dr_renderer_choice2     'RP_MP_RAYCAST  )	

        (ui-choice 'dr_renderer_choice3     'RP_RAYTRACE    )
        (ui-choice 'dr_renderer_choice4     'RP_MP_RAYTRACE )

        (ui-choice 'dr_renderer_choice5     'RP_HIDDENLINE  )
    )

;;; If multi-processing is possible, how many processors to use? All or N
    (ui-radio-widget 'dr_processors
        (list 'enabled
            (ui-or
                (ui-eq 'direct_render_mode `RP_MP_RAYCAST )
                (ui-eq 'direct_render_mode `RP_MP_RAYTRACE )
            )
        )
        (list 'rebuild #t)
        (ui-choice 'all_processors      1 )
        (ui-choice 'dr_user_defined     2 )
    )

;;; If multi-processing && user-specified-num-procs, how many?
    (ui-integer-widget 'dr_number_processors
        (list 'enabled
            (ui-and
                (ui-or
                    (ui-eq 'direct_render_mode `RP_MP_RAYCAST )
                    (ui-eq 'direct_render_mode `RP_MP_RAYTRACE )
                )
                (ui-eq 'dr_processors 2)
            )
        )
        (list 'range 1 'maxRenderProcessors)
    )
)
